/* FILE sac */
     /* Find saccades */

#include "deffs.h"
#include "ad.h"

float SacPeakVelocity_H = 0.;		/* Set by Get_Saccade_Peak_Velocity */
float SacPeakVelocity_V = 0.;
int   SacPeakVelocity_T = 0;		/* Time */

float SacPosition_H = 0.;		/* Set by Get_Saccade_Time, too	*/
float SacPosition_V = 0.;
int   SacPosition_T = 0;		/* Time */

/* ********************************************************************	*/
 /* PUBLIC
   Get_Saccade_Time	Return sac closest to passed time (look forward or back)
   Get_Saccade_Peak_Velocity	Return time, and set variables
  * PRIVATE
   Velocity		Return veloc at a point in time
   Position		Return posit at a point in time
 * ********************************************************************	*/

#define DEBUG		0	/* 0 (off), 1/2/3/4 (various levels of on)*/

#define LOOK_ONLY_THIS_FAR	850	/* ms to look after start? (750)*/
					/* if Get_Saccade_Limited 	*/

	/* Find saccade middle: (set to >=sac size/2; miss smaller sacs)*/
#define PositionCriteria	(DEGtoAD((stringent)?2:6))
	/* 2nd value (non-stringent) used to be 4; works better this way*/

	/* Find sac begin/end:  simple veloc threshhold in d/s		*/
#define VelocBeginCriteria	(DEGtoAD((stringent)?20.:30.))
#define VelocEndCriteria	(DEGtoAD((stringent)?16.:24.))
#define	MID_TO_BOUND_LIMIT	80			/* In ms	*/
	/* Changed on Dec 17 from 350 ms, and changed from 'Exit' to Warn'! */
#define POINTS		         (((stringent)? 5:3))
	/* WARNING: THIS CODE IS SENSITIVE TO ms_per_frame !	*/

static float Velocity(short *ptr, int channels);
static float Position(short *ptr, int align, int channels);
/* ********************************************************************	*/
/* Set using 'extern':	*/
int Get_Saccade_Stringent = 0;	/* Initial setting (see note)		*/
int Get_Saccade_Limited = 1;	/* Look for ~750 ms, or til trial ends?	*/
int Get_Saccade_Quietly = 0;	/* Don't complain if you can't find it	*/
/* ********************************************************************	*/
/* Get_Saccade_Stringent only affects the INITIAL setting.  Even if it's
   zero (relaxed), if you do not find a saccade, you will become stringent.
   So why bother?  Because relaxed will return a large saccade, even if
   it comes after a small one; stringent will return the small one.
   You may want to specify which behavior you want.
 */

static short *BEGIN;		/* Get_Peak_Veloc needs pointer to data	*/
static int stringent = 0;	/* Find only the largest, or all sacs?	*/

/* FUNCTION Get_Saccade_Time */
	 /* Time of sac starting/stopping forward/behind the nth eye acq*/
	 /* WANTS A TIME FROM THE STACK, NOT FROM THE INTERVALS!	*/
	 /* (also returns stack times, not interval times)		*/
	 /*  (Default direction is to look *behind* the acq event	*/
int Get_Saccade_Time(int FindSacStart, int forward, int begin, int InitialAlignment) {
   /* FindSacStart:		Find 1:start (vs 0:end) of saccades	*/
   /* forward:			Look 1:forward (vs 0:backward) in time	*/
   /* begin:			Starting from this time (re: TAPE_ON)	*/
   /* InitialAlignment:		Almost always 0 (1 for time.c calls)	*/

	short *TOP, *END, *X, *Y, *LIMIT;
	int channels = ChannelCount_Header();
	int MID_SAC;			/* (ms): save for err report	*/
	short *MID_SAC_X;		/* (ptr): save for try again	*/
	int X_Start, Y_Start;		/* Initial position value	*/
	int X_Current, Y_Current;	/* Current position value	*/
	float VelocCriteria;
	int NegativeVeloc_X;
	int NegativeVeloc_Y;
	int ms = MsPerFrame_Header();
	int return_time;

	SacPosition_H = SacPosition_V = SacPosition_T = FAIL;
	if (begin == FAIL)
	    return(FAIL);

	if (InitialAlignment) {		/* Special case: read all data	*/
	   Force_Zero_SkipTime(ON);
	   BEGIN = TOP = Read_Skipped_Data();	/* Get analog data	*/
	   Force_Zero_SkipTime(OFF);
	} else {
	   extern short Data[MAX_FRAMES*MAX_CHANNELS];
	   BEGIN = TOP = Data;
	   begin -= SkipSpikeTime();
	   } /* Subtract time between TAPE_ON and the start of the trial*/
	     /* This puts 'begin' at the right spot in the data stream	*/
	     /* (If TAPE_ON == 1000 ms, then aligning on TAPE_ON time
	      *  requires begin = 0, not begin = 1000)			*/

	stringent = Get_Saccade_Stringent;

   FIND_SACCADE_MIDDLE:		/* If at first you don't succeed	*/

	END = TOP + (channels * FrameCount_Header());	/* Find end	*/
	TOP += (POINTS+1)*channels;		/* Leave safe margin	*/
	END -= (POINTS+1)*channels;

	if (begin < 0) {  /* Is approx location of sac in data stream?	*/
	   if (InitialAlignment) {
	      Warning("Get_Saccade_Time: align on an earlier event (1)");
	      return(FAIL);
	    } else
	      begin = 0;
	   }
	if ((begin+POINTS+4) >= FrameCount_Header() * ms) {
	   if (DEBUG)
	      fprintf(stderr,"Begin - %d is %d; framecount * ms is %d\n",
		SkipSpikeTime(),begin,FrameCount_Header() * ms);
	   if (Get_Saccade_Limited || InitialAlignment)
	      Warning("Get_Saccade_Time: align on a later event (1)");
	   return(FAIL);
	   }

	if (DEBUG) fprintf(stderr, "Sac:look %s from %d ms\n",
		(forward) ? "forward" : "backward", begin);

				/* Point to acquire event + margin	*/
	X = TOP + H_EYE + channels * (begin / ms);
	Y = TOP + V_EYE + channels * (begin / ms);

				/* Find sac middle (avg of N points):	*/
	X_Current = X_Start = (*X + *(X-channels) + *(X+channels)
				  + *(X-2*channels) + *(X+2*channels)) / 5;
	Y_Current = Y_Start = (*Y + *(Y-channels) + *(Y+channels)
				  + *(Y-2*channels) + *(Y+2*channels)) / 5;

	if (DEBUG==2) fprintf(stderr, "Start at %.2f,%.2f\n",
		ADtoDEG(X_Start), ADtoDEG(Y_Start));

	if (DEBUG)
	   fprintf(stderr, "Search %sward\n", (forward) ? "for" : "back");

        while (1) {		/* Find large change in posiiton	*/
	   if (forward) {
	      X += channels;
	      Y += channels;
	      if (X >= END)
	         break;
	    } else {
	      X -= channels;
	      Y -= channels;
	      if (X <= TOP)
	         break;
	      }

	   /* Exponential filter on current position */
	   X_Current = 0.67 * X_Current + 0.33 * *X;
	   Y_Current = 0.67 * Y_Current + 0.33 * *Y;

	   if (DEBUG==2) fprintf(stderr, "At %d ms, pos is %.2f,%.2f\n",
	                         (int)((X-(BEGIN+H_EYE))/channels)*ms,
				ADtoDEG(X_Current), ADtoDEG(Y_Current));

	   if ((abs(X_Current-X_Start) + abs(Y_Current-Y_Start))
	      	     > PositionCriteria)	/* Add absolute change	*/
		 break;
	   }

	MID_SAC_X = X;					/* For Stringent*/
	MID_SAC = ((X-(BEGIN+H_EYE))/channels)*ms;	/* Err report	*/

        if (	/* if didn't find saccade (went to far, or to one end):	*/
	  (Get_Saccade_Limited && (abs(begin-MID_SAC)>LOOK_ONLY_THIS_FAR))
		|| (MID_SAC_X - TOP < 5)		/* At start?	*/
		|| (MID_SAC_X > END - 5)) {		/* At end ?	*/
	   if (stringent==1) {
	      if (DEBUG) fprintf(stderr,
	       "Sac: Far from begin (%d vs < %d ms) or at start/end\n",
	       			MID_SAC, begin);
	      if ((Get_Saccade_Limited || InitialAlignment) &&
		  (Get_Saccade_Quietly == 0))
	         Warning("Get_Saccade_Time: Can't find saccade");
	      return(FAIL);
	   } else {			/* Did we just miss it?	*/
	      stringent = 1;
	      if (DEBUG) fprintf(stderr,
		 "Sac: Can't find sac middle; try harder\n");
	      if (forward)
	         begin -= 50;		/* Try starting 50 ms earlier	*/
	      else /* backwards */
	         begin += 50;		/* Try starting 50 ms later	*/
	      goto FIND_SACCADE_MIDDLE;
	      }
	   }
	if (DEBUG) fprintf(stderr, "Sac:middle of sac at %d ms%s\n",
		MID_SAC, (stringent)? " (found on second try":"");

/* ********************************************************************	*/
/* ****************  Have saccade middle; now find bounds *************	*/
/* ********************************************************************	*/

        stringent = Get_Saccade_Stringent;
        FIND_SACCADE_BOUND:

	NegativeVeloc_X = (Velocity(X,channels) < 0.);
	NegativeVeloc_Y = (Velocity(Y,channels) < 0.);

	if (!FindSacStart) {	/* Find saccade END: walk -> til low vel*/

	   VelocCriteria = (VelocEndCriteria * ms)/1000;
	   if (DEBUG)fprintf(stderr,"End vel criterion =%.2f\n",VelocCriteria);
	   LIMIT = X + MID_TO_BOUND_LIMIT*channels/ms;
	   if (LIMIT > END)
	       LIMIT = END;
	   while ((X+=channels) < LIMIT) {  /* Walk forward til low veloc*/
	      float vel_x, vel_y;

	      Y += channels;

	      vel_x = Velocity(X, channels);
	      if (NegativeVeloc_X)		/* If WAS <0, invert	*/
	         vel_x = -vel_x;
	      vel_y = Velocity(Y, channels);
	      if (NegativeVeloc_Y)
	         vel_y = -vel_y;

			/* Large veloc in opp. direction meets crit	*/
	      if (vel_x<VelocCriteria && vel_y<VelocCriteria)
		  break;
	      }
	} else {  		/* Find sac START: walk <- til low vel	*/
	   VelocCriteria = (VelocBeginCriteria * ms)/1000;
	   if (DEBUG)fprintf(stderr,"Begin vel criteria =%.2f\n",VelocCriteria);
	   LIMIT = X - MID_TO_BOUND_LIMIT*channels/ms;
	   if (LIMIT < TOP)
	       LIMIT = TOP;
	   while ((X-=channels) > LIMIT) {
	      float vel_x, vel_y;

	      Y -= channels;

	      vel_x = Velocity(X, channels);
	      if (NegativeVeloc_X)		/* If WAS <0, invert	*/
	         vel_x = -vel_x;
	      vel_y = Velocity(Y, channels);
	      if (NegativeVeloc_Y)
	         vel_y = -vel_y;

	      if (DEBUG==2)
	        fprintf(stderr, "  At %d, veloc %.2f %.2f (pos %.2f %.2f)\n",
	           (int) ((X-(BEGIN+H_EYE))/channels)*ms,Velocity(X,channels),Velocity(Y,channels),
		   ADtoDEG(*X),ADtoDEG(*Y));
	      else if (DEBUG==4)
	        fprintf(stderr, "  At %d, pos is %.2f:\n",
			(int) ((X-(BEGIN+H_EYE))/channels)*ms, ADtoDEG(*X));

			/* Large veloc in opp. direction meets crit	*/
	      if (vel_x<VelocCriteria && vel_y<VelocCriteria)
		  break;		/* Exit when past peak veloc	*/
	      }
	   if (DEBUG==2) {
	     fprintf(stderr, "   At %d, veloc would be %.2f %.2f\n",
	           (int) (((X-channels)-(BEGIN+H_EYE))/channels)*ms,
		   Velocity(X-channels,channels),Velocity(Y-channels,channels));
	     fprintf(stderr, "  At %d, veloc would be %.2f %.2f\n",
	           (int) (((X-2*channels)-(BEGIN+H_EYE))/channels)*ms,
		   Velocity(X-2*channels,channels),
		   Velocity(Y-2*channels,channels));
	     }
	   }
        if (abs(((X-(BEGIN+H_EYE))/channels)*ms -MID_SAC) >MID_TO_BOUND_LIMIT) {
	   if (stringent == 0) {
	       stringent++;
	       X = MID_SAC_X;
	       Y = X - H_EYE + V_EYE;
	       if (DEBUG) fprintf(stderr,"Look for sac begin/end again\n");
	       goto FIND_SACCADE_BOUND;
	       }
	   fprintf(stderr, "    Bound: %d    Mid: %d    Begin search: %d\n", 
			(int) ((X-(BEGIN+H_EYE))/channels)*ms, MID_SAC, begin);
	   Warning("Get_Saccade_Time: Sac boundary too far from sac middle - CALL LARRY!");
	   }

	if (DEBUG) fprintf(stderr, "Sac: sac %s at %d ms\n",
	    (FindSacStart)? "begins":"ends",
	    (int)((X-(BEGIN+H_EYE))/channels)*ms);

	return_time = ((X - (BEGIN+H_EYE)) / channels) * ms;

	SacPosition_H = Position(X, FindSacStart, channels);
	SacPosition_V = Position(Y, FindSacStart, channels);
	SacPosition_T = return_time;

	if (InitialAlignment)		/* Special case: raw time	*/
	   return(return_time + Get_TapeOnTime());
	else				/* Covert back to stack times	*/
	   return(return_time + SkipSpikeTime());
	}
/* ********************************************************************	*/

/* FUNCTION Velocity */
	 /* Return velocity in AD-units/frame about the time of the ptr */
static float Velocity(short *ptr, int channels) {
    int i;
    float sum = 0.;

    for (i=1; i<=POINTS; i++)
       sum += (*(ptr+i*channels) - *(ptr-i*channels)) / (float)(2*i);

    if (DEBUG==3)
      fprintf(stderr, "veloc = %d\n", (int)(sum/POINTS));

    if (DEBUG==4) {
      fprintf(stderr, "  %.0f/%d=%.0f: ", sum, POINTS, sum/POINTS);
      for (i=-POINTS*channels; i<=POINTS*channels; i+=channels)
	 fprintf(stderr, "%s%d ", (i)?"":"*", *(ptr+i));
      fprintf(stderr, "\n   0");
      sum = 0.;
      for (i=1; i<=POINTS; i++) {
         sum += (*(ptr+i*channels) - *(ptr-i*channels)) / (float)(2*i);
	 fprintf(stderr, "+%d/%d=%.0f ",
		*(ptr+i*channels) - *(ptr-i*channels), 2*i, sum);
	 }
      fprintf(stderr, "\n");
      }

    return(sum/POINTS);
    }
/* ********************************************************************	*/

#define SMOOTH_VEL_POINTS 6	/* Differentiate using this many points	*/
#define INTERVAL_POINTS   5	/* Average over this many pts: 5-->10 ms*/

/* FUNCTION SmoothVelocity */
	 /* Return velocity in AD-units/frame about the time of the ptr */
static float SmoothVelocity(short *ptr, int channels) {
    float Sum = 0.;
    int j;

    for (j=-INTERVAL_POINTS/2; j<INTERVAL_POINTS/2+1; j++) {
       float sum = 0.;
       int i;
       for (i=1; i<=SMOOTH_VEL_POINTS; i++)
          sum += (*(ptr+i*channels+j*channels) -
	          *(ptr-i*channels+j*channels)) / (float)(2*i);
       Sum += sum/SMOOTH_VEL_POINTS;
       }

    return(Sum/INTERVAL_POINTS);
    }
/* ********************************************************************	*/
#define MS_TO_LOOK	150		/* Look in 1st 150 ms after sac	*/
		/* Was 200 ms (7-18-2014) */

/* FUNCTION Get_Saccade_Peak_Velocity */
	 /* First call Get_Saccade_Time, then look for max veloc	*/
	 /* Should be bundled into Find_Saccade_Time */
int Get_Saccade_Peak_Velocity(int forward, int begin, int InitialAlignment) {
	short *END, *X, *LIMIT;
	int channels = ChannelCount_Header();
	int ms = MsPerFrame_Header();
	double max_vel = 0;
	short *max_at;

	SacPeakVelocity_H = SacPeakVelocity_V = (float) FAIL;
	SacPeakVelocity_T = SacPosition_H=SacPosition_V=SacPosition_T = FAIL;

	if (begin == FAIL)
	    return(FAIL);

					/* Find start of 1st saccade	*/
	begin = Get_Saccade_Time(1, forward, begin, InitialAlignment);

	if (begin == FAIL)
           return(FAIL);

	if (InitialAlignment)
	   begin -= Get_TapeOnTime();
	 else				/* Not tested (3-99, LHS)	*/
	   begin -= SkipSpikeTime();

	END = BEGIN + (channels * (FrameCount_Header()-POINTS-1));

	if (begin <= 0) {  /* Is approx location of sac in data stream?	*/
	   Warning("Get_Saccade_Time: align on an earlier event (2)");
	   return(FAIL);
	   }
	if ((begin+POINTS+4) >= FrameCount_Header() * ms) {
	   Warning("Get_Saccade_Time: align on a later event (2)");
	   return(FAIL);
	   }

				/* Point to acquire event + margin	*/
	max_at =
	     X = BEGIN + H_EYE + channels * (begin / ms);

	LIMIT = X + MS_TO_LOOK/ms*channels;	/* Always look forwards	*/
	if (LIMIT > END)
	    LIMIT = END;

	while (1) {				/* Find max velocity	*/
	   double
	   xv = SmoothVelocity(X+H_EYE,channels),
	   yv = SmoothVelocity(X+V_EYE,channels);
	   double vv = sqrt(xv*xv + yv*yv);

	   if (vv > max_vel) {
              max_at = X;
	      max_vel = vv;
	      }
	   X += channels;
	   if (X>LIMIT)
	      break;
	   }

	SacPeakVelocity_T = 
		SkipAnalogTime()+((max_at-(BEGIN+H_EYE))/channels)*ms;
	SacPeakVelocity_H = 	/* Convert from AD/frame to deg/s	*/
		ADtoDEG(SmoothVelocity(max_at+H_EYE, channels)) * (1000 / ms);
	SacPeakVelocity_V = 
		ADtoDEG(SmoothVelocity(max_at+V_EYE, channels)) * (1000 / ms);

	SacPosition_H = Position(max_at+H_EYE, 2, channels);
	SacPosition_V = Position(max_at+V_EYE, 2, channels);
	SacPosition_T = SacPeakVelocity_T;

	if (InitialAlignment)
	   return(((max_at-(BEGIN+H_EYE)) / channels) * ms + Get_TapeOnTime());
	else
	   return(SkipSpikeTime()+(((max_at-(BEGIN+H_EYE))/channels)*ms));
	}
/* ******************************************************************	*/

/* FUNCTION Position */
         /* Smoothed. Align=1:look backward  0:forward   else:symmetric	*/
static float Position(short *ptr, int align, int channels) {
	int i;
	int sum = 0;
#	define SMOOTH_POINTS 5

        if (align == 1)				/* FindSacStart is T	*/
	   ptr -= channels * (SMOOTH_POINTS-1); /* Look backwards	*/
	else if (align != 0)			/* FindSac not F, either*/
	   ptr -= channels * ((SMOOTH_POINTS-1)/2); /* peak,so look symetric*/

	for (i=0; i<SMOOTH_POINTS; i++) {
	   sum += *ptr;
	   ptr += channels;
	   }

	return(ADtoDEG(((float)sum)/SMOOTH_POINTS));
	}
/* ******************************************************************	*/
