/* FILE picture.c */
/* ********************************************************************	*/

/* FROM head.c: 	EVENT *Stack_Ptr_Header();	*/
/* ********************************************************************	*/

#define MAX_TARGS	18
#define SPACING		40		/* LED lines this many pix apart*/

#define BROWN		6
#define LIGHT_BLUE_GREEN 8		/* Is this right? */
#define GREEN		10
#define BLUE		11
#define RED		12
#define PINK		32002
#define PURPLE		32003
#define WHITE		15


#define SHOW_TIMING_MARKS	0

/* ********************************************************************	*/
/* CHANGES FROM reach's version:
 *    Change main function (Picture)
 	(Many changes)
 *    Remove functions LabelDimension(), MarkTime(), DrawTimeTics()
 *    Add functions Set_Color(), display_horizontal()
 *    Make ShowNonTargetBehaviors a config (not set by a function)
 *    Remove references to DelayTime
 *    In GetTargetLine(), don't label the line
 *    ProcessOneEvent():
 *       don't put in labels
 *       remove special case of REWARD_IF release-arm
 *    Remove 'TOP_PIX' and 'TOP_MS_TO_PIX' (display_horizontal() accepts ms)
 *    Don't translate yellow to black ("Too hard to see")
 *    DrawLines():
         remove code dealing with CALL_STACK
	 remove code dealing with !RunStack
	 remove code dealing with MarkTime
	 remove set_color()
 *    DrawTarget():  (and also PURSUIT: and DELAY: cases in Process_One_Event
         add checks of time<BeginTime, and of T->last_time<BeginTime
	 add check of T->last_time + ElapasedTime > EndTime
 *    All calls to display_horizontal:
 	 remove 'width' argument,
	 sometimes change y value (depending on PICTURE_ configs)
 * ********************************************************************	*/
/* FILE picture.c */
     /* Show version of experiment on upper 1/4 of screen	*/
     /* NOTE: DrawLines() is essentially main()			*/
/* ********************************************************************	*/

#include "deffs.h"
#include "event.h"
#include "config.h"

/* ********************************************************************	*/

#define MAX_OLD_TARGETS	25

#define NON_TARGET_BEHAVIORS	(MAX_BEHAV - MAX_WINDOWS)
 	/* Some behaviors don't use a target; keep track of them, too	*/
#define TOTAL_TARGETS	(MAX_TARGETS + NON_TARGET_BEHAVIORS)
#define NON_TARGET_BEHAVIOR_ADJUSTMENT  (MAX_TARGETS-MAX_WINDOWS)

static struct TARG {
   int line;					/* Pixel location	*/
   int color;					/* Actual color		*/
   int old_color;				/* Color BEFORE redraw	*/
   int H;					/* Target position	*/
   int V;
   int last_pixel;				/* Drawn to here	*/
   int exists;					/* Currently used?	*/
   unsigned int blank  : 1;			/*  On or off		*/
   unsigned int required: 1;			/*  Must acquire targ?	*/
   unsigned int option : 1;			/*  Reward if for targ?	*/
   } Targ[TOTAL_TARGETS], *T;
   	/* One slot for each target AND one for each non-target behavior */

static struct OLD_TARG {
   int line;					/* Pixel location	*/
   int H;					/* Target position	*/
   int V;
   int type;					/* Target type		*/
   } OldTarg[MAX_OLD_TARGETS], *O;

static int BeginTime, EndTime;
static int LineWidth = 1;

static int NextAvailableLine;

static int BehaviorToTypeMap[MAX_WINDOWS];  /* Targ or non-targ behav #	*/

static void Initialize(void);
static void Process_One_Event(EVENT *E);
static void DrawLines(EVENT *E);
static int  GetTargetLine(int horiz, int vert, int type);
static void DrawTarget(int type, int time);
static void Set_Color(int color);
static void display_horizontal(int x0, int y0, int length, int color);

#define PICTURE_HEIGHT  /* Ranges from 0 to 9 */			\
 	(								\
	(PICTURE_EVERY_TARGET || PICTURE_NONTARGET_BEHAVS) ? 		\
	    (5*PICTURE_EVERY_TARGET + 3*PICTURE_NONTARGET_BEHAVS) :	\
	    (								\
            PICTURE_TARGET_0 + PICTURE_TARGET_1 + PICTURE_TARGET_2 +	\
	    PICTURE_TARGET_3 + PICTURE_TARGET_4 + PICTURE_TARGET_5 + 	\
	    PICTURE_TARGET_6 + PICTURE_TARGET_7 + PICTURE_TARGET_8 + 	\
	    PICTURE_TARGET_9						\
	    )								\
	)
	 
/* ********************************************************************	*/
#define SAVE_WINDOW	48  		/* Preserve area on far left	*/

/* FUNCTION Picture */
	 /* Plot graph describing a stack */
void Picture() {
     extern EVENT *Stack_Ptr_Header();

     BeginTime = SkipSpikeTime();
     EndTime =  BeginTime + DurationTime();
     Initialize();
     LineWidth = 3 - PICTURE_HEIGHT/2;		/* Save for later	*/
     if (LineWidth < 1)
         LineWidth = 1;
     SetLineWidth(LineWidth);
     DrawLines(Stack_Ptr_Header());
     SetLineWidth(1);				/* Insurance		*/
     Set_Color(0);
     }
/* ********************************************************************	*/

/* FUNCTION Initialize */
	 /* Zero out the structure */
static void Initialize() {
     int i;

     for (i=0; i<MAX_OLD_TARGETS; i++)
	OldTarg[i].line = 0;
     for (i=0; i<TOTAL_TARGETS; i++) {
        T = Targ + i;
	T->exists = T->line = T->last_pixel = T->option = T->blank
	   = T->required = 0;
	}
     Targ[0].color = GREEN;
     Targ[1].color = RED;
     Targ[2].color = BLUE;
     Targ[3].color = WHITE;

     Targ[MAX_TARGETS+MOVE_ARM-MAX_WINDOWS].color = PINK;
     Targ[MAX_TARGETS+MOVE_EYE-MAX_WINDOWS].color = PURPLE;
     Targ[MAX_TARGETS+RELEASE_ARM-MAX_WINDOWS].color = PURPLE;
     Targ[MAX_TARGETS+BUTTON_AND-MAX_WINDOWS].color = PURPLE;
     Targ[MAX_TARGETS+BUTTON_OR-MAX_WINDOWS].color = PURPLE;
     Targ[MAX_TARGETS+WIGGLE-MAX_WINDOWS].color = PURPLE;

     NextAvailableLine = 0;
     }
/* ********************************************************************	*/

/* FUNCTION GetTargetLine */
	 /* Check for old target here; if not, return next empty slot	*/
	 /* Note: will picture blanked targets, too			*/
static int GetTargetLine(int horiz, int vert, int type) {
	int i;

	for (O=OldTarg, i=0; i<MAX_OLD_TARGETS; i++, O++) {
	   if (O->line == 0)		/* No more entries	*/
	      break;
	   if (O->H == horiz && O->V == vert && O->type == type)
	      return(O->line);		/* Used before: use old	*/
	   }

	O->line = (2+NextAvailableLine++) * SPACING;
	O->H = horiz;
	O->V = vert;
	O->type = type;


	if ((PICTURE_NONTARGET_BEHAVS==0) && (type>=MAX_TARGETS))
	   NextAvailableLine--;			/* Re-use the line	*/

	if (!PICTURE_EVERY_TARGET)
	   if ((PICTURE_TARGET_0==0 && type==0) ||
	       (PICTURE_TARGET_1==0 && type==1) ||
	       (PICTURE_TARGET_2==0 && type==2) ||
	       (PICTURE_TARGET_3==0 && type==3) ||
	       (PICTURE_TARGET_4==0 && type==4) ||
	       (PICTURE_TARGET_5==0 && type==5) ||
	       (PICTURE_TARGET_6==0 && type==6) ||
	       (PICTURE_TARGET_7==0 && type==7) ||
	       (PICTURE_TARGET_8==0 && type==8) ||
	       (PICTURE_TARGET_9==0 && type==9))
	     NextAvailableLine--;		/* Re-use the line	*/

	return(O->line);
	}
/* ********************************************************************	*/

/* FUNCTION Process_One_Event */
	 /* Act on single event */
static void Process_One_Event(EVENT *E) {
	int type = 0;

	switch (E->type) {
	   case TARGET_SAC:
	   case TARGET_SAC_POLAR:
	   case TARGET_RE_0:
	   case TARGET_RE_0_POLAR:
	   case TARGET_RE_1:
	   case TARGET_RE_1_POLAR:
	   case TARGET_RE_2:
	   case TARGET_RE_2_POLAR:
	   case TARGET_RE_3:
	   case TARGET_RE_3_POLAR:
	   case TARGET_RE_4:
	   case TARGET_RE_4_POLAR:
	   case TARGET_ON_POLAR:
	   case TARGET_ON:
	        type = E->one;
	   	T = Targ + type;
		if (T->exists)		/* Used to test last_pixel 	*/
		   DrawTarget(type, E->time);
	/* Line of old target at this position, or next empty line:	*/
		T->line = GetTargetLine(E->two, E->three, type);
		T->H = E->two;
		T->V = E->three;
		T->required = 0;
		T->option = 0;
		T->exists = 1;
		T->last_pixel = E->time;
		break;

	   case TARGET_OFF:
	        type = E->one;
	   	T = Targ + type;
		DrawTarget(type, E->time);
		T->exists = 0;
		break;

	   case TARGET_OFF_IN:
	   	T = Targ + E->one;
		DrawTarget(E->one, E->time+E->two);
		T->exists = 0;
		break;

	   case TARGET_BLANK:
	        type = E->one;
	   	T = Targ + type;
		if (T->exists)				/* Turned on?	*/
		   DrawTarget(type, E->time);
		T->blank = E->two;
		break;


	   case ACQUIRE:		/* one:behavior  two:target#	*/
	        if (E->one < MAX_WINDOWS) {	/* Target-assoc'd behav	*/
		   type = E->two;		/*  type is target #	*/
	   	   T = Targ + type;
		   BehaviorToTypeMap[E->one] = type;
	         } else {			/* Nontarg behav:special*/ 
	   	   type = E->one + NON_TARGET_BEHAVIOR_ADJUSTMENT;
		   T->H = T->V = 0;			/* Unused	*/
		   T->line = GetTargetLine(T->H, T->V, type);
		   T->exists = 1;		/* Pseudo-target is on	*/
		   T->last_pixel = E->time;
		   }

		if (T->option) {		/* Was IF_RWD on?	*/
		   DrawTarget(type, E->time - abs(E->three));
		   T->option = 0;		/* Update, then turn off*/
		   }				/* Ready for normal acq	*/
		DrawTarget(type, E->time);	/* Acq period	*/
		T->required = 1;
		T->option = 0;
		break;

	   case ACQUIRE_OFF:
	   	E->one = (E->one<MAX_WINDOWS) ?	/* Targ assoc'd behav?	*/
		      BehaviorToTypeMap[E->one] : E->one;

	   	T = Targ + type;
		DrawTarget(type, E->time);
		T->required = 0;

		if (type >= MAX_WINDOWS)
		   T->exists = 0;		/* 'target' now off	*/
		break;

	   case REWARD_WHILE_ON:
	   case REWARD_OPTIONAL:
	   	type = (E->type==REWARD_WHILE_ON) ? E->one : E->two;
		DrawTarget(type, E->time);
		Targ[type].option = E->two;
		break;

	   case ARM_WINDOW:
	   case EYE_WINDOW:
	   case TAPE_ON: case TAPE_OFF:
	   case EYE_STEP_RAMP:
	   case REWARD:
	   	break;

	   case TARGET_PURSUIT:		/* Draw bar over pursuit time	*/
		if (E->two || E->three) {	/* If pursuit starting	*/
	   	   EVENT *End = E+1;
		   int begin, duration;

		   while (End->type != E->type) {
		      if (End->type == END_STACK)
		         break;	/* No PURSUIT off -- err during pursuit? */
		      End++;	/* Assume pursuit continues to end of stack*/
		      }

		   begin = E->time;
		   duration = End->time - begin;
		   if (begin < BeginTime)
		       begin = BeginTime;
		   if (begin + duration > EndTime)
		       duration = EndTime - begin; 
     		   SetLineWidth(LineWidth/3);
		   display_horizontal(begin, 36, 
				      duration,
				      Targ[E->one].color);
     		   SetLineWidth(LineWidth);
		   }
		break;

	   case TARGET_COLOR:
		if (Targ[E->one].exists) 	/* Currently on?	*/
		    Targ[E->one].old_color = Targ[E->one].color; /* Save*/
	   	Targ[E->one].color = E->two;
		break;

	   case TARGET_REDRAW:
	   	for (type=0; type<MAX_TARGETS; type++) {
		   T = Targ + type;		/* Color change?	*/
		   if (T->exists && T->old_color) {	/* Happens now!	*/
		      int save_new = T->color;		/* Don't use yet*/
		      T->color = T->old_color;		/* Draw in old	*/
		      DrawTarget(type, E->time); /* Up to now	*/
		      T->color = save_new;	/* From now on,new color*/
		      T->old_color = 0;			/* Clear flag	*/
		      }
		   }
	        break;

	   case DELAY: {
	   	int begin = E->time;
		int duration = E->two;

     		if (begin < BeginTime)
		    begin = BeginTime;
     		if (begin + duration > EndTime)
		    duration = EndTime - begin; 
     		SetLineWidth(LineWidth/2);
	 	display_horizontal(begin, 48, duration, BROWN);
     		SetLineWidth(LineWidth);
		break;
		}

	   default: 
		goto NO_MARK;
           }
       NO_MARK:
       return;
       }
/* ********************************************************************	*/

/* FUNCTION DrawLines */
	 /* Locate relevant instructions, call Process_One_Event on each*/
static void DrawLines(EVENT *E) {
   int i;

   E--;
   while ((++E)->type != END_STACK) {
      if (E->time > EndTime && E->time != (unsigned)0xFFFF)
          break;
      Process_One_Event(E);
      }

   for (i=0; i<TOTAL_TARGETS; i++)
      if (Targ[i].exists)
         DrawTarget(i, EndTime);
   }
/* ********************************************************************	*/

/* FUNCTION DrawTarget */
	 /* Indicate target lights and behavior status:			*/
	 /* Draw target from last_pixel to now; update last_pixel	*/
	 /* Thick line for acqusition of target				*/
	 /*    Missing middle line if target is blanked			*/
static void DrawTarget(int type, int time) {
     int ElapsedTime;

     if ((type>=MAX_TARGETS) && (PICTURE_NONTARGET_BEHAVS==0))
        return;

     if (!PICTURE_EVERY_TARGET) {
	if ((PICTURE_TARGET_0==0 && type==0) ||
	    (PICTURE_TARGET_1==0 && type==1) ||
	    (PICTURE_TARGET_2==0 && type==2) ||
	    (PICTURE_TARGET_3==0 && type==3) ||
	    (PICTURE_TARGET_4==0 && type==4) ||
	    (PICTURE_TARGET_5==0 && type==5) ||
	    (PICTURE_TARGET_6==0 && type==6) ||
	    (PICTURE_TARGET_7==0 && type==7) ||
	    (PICTURE_TARGET_8==0 && type==8) ||
	    (PICTURE_TARGET_9==0 && type==9))
        return;
	}

     T = Targ + type;

     if (time > EndTime)
         time = EndTime;
     if (time < BeginTime)
         time = BeginTime;
     if (T->last_pixel < BeginTime)
         T->last_pixel = BeginTime;

     ElapsedTime = time - T->last_pixel;

     if (ElapsedTime <= 0)				/* Nothing doing*/
        return;
     if (T->last_pixel + ElapsedTime > EndTime) {
         fprintf(stderr, "Last + elapse > end (never happens)\n");
         T->last_pixel = EndTime;
	 }

     if (T->required) {			/* Required: top & bottom lines	*/ 
	display_horizontal(T->last_pixel,T->line,  ElapsedTime,T->color);
	display_horizontal(T->last_pixel,T->line-12,ElapsedTime,T->color);
	}
     if (T->option) {			/* Rwd_if:flank lines, top=blue	*/ 
	display_horizontal(T->last_pixel,T->line,ElapsedTime,T->color);
        display_horizontal(T->last_pixel,T->line-12,ElapsedTime,
							LIGHT_BLUE_GREEN);
	}
     if (!(T->blank))			/* On or off: middle line	*/
	display_horizontal(T->last_pixel,T->line-6,ElapsedTime,T->color);

     T->last_pixel = time;
     }
/* ********************************************************************	*/

static void display_horizontal(int x0, int y0, int length, int color) {
	Set_Color(color);

	if (PICTURE_HEIGHT > 2)			/* Adjust y value	*/
	   y0 *= 2;
	y0 = HEIGHT + 20 - y0;

	x0 -= BeginTime;
	move(x0,        y0);
	cont(x0+length, y0);
	}
/* ********************************************************************	*/

static void Set_Color(int color) {
	switch (color) {
	   case GREEN:	Color(0,8,0); break;
	   case RED:	Color(8,0,0); break;
	   case BLUE:	Color(2,3,5); break;
	   case BROWN:  Color(8,5,2); break;
	   case WHITE:  Color(0,0,0); break;
	   case PINK:   Color(8,6,6); break;
	   case PURPLE: Color(8,0,8); break;
	   case 0:	Color(0,0,0); break;
	   default:	Color(0,0,0); break;
	   }
	}
/* ********************************************************************	*/
