/* FILE pic.c */
     /* Show version of experiment on upper 1/4 of screen	*/
     /* Doesn't know about V_SYNC: will get timing wrong!	*/
     /* Doesn't know that rewards are now cumulative		*/
/* ********************************************************************	*/

#define	DEBUG	0

#include "deffs.h"
#include "event.h"
#include "ad.h"					/* #def TENTHtoAD	*/
#include "graph.h"				/* Graphics scaling	*/
#include "time.h"				/* MS_PER_TIC		*/
#include "function/display.f"
#include "function/dma.f"			/* Smooth_DMA_DataCount()*/
#include "function/head.f"			/* Get_Header_ErrorTime	*/
#include "function/int.f"			/* Get_Interrrupt_Time()*/
#include "function/lookup.f"
#include "function/pic.f"
#include "function/run.f"			/* Get_RunStatus()	*/
#include "function/stack.f"			/* Pointer_To_Stack	*/
#include "function/target.f"
/* ********************************************************************	*/

/* PUBLIC FUNCTIONS *
 *    Picture			Main: Init & call DrawLines, TimeTics
 *    Set_ShowNonTargetBehaviorsInPicture

/* PRIVATE FUNCTIONS *
 *    Initialize		Initialize
 *    DrawLines			Guts of the process
 *    Process_One_Event		Do whatever for each event
 *    DrawTarget		Draw one target line
 *     LabelDimension		 Help to label targets
 *    GetTargetLine		Return height of target line
 *    MarkTime			Make marks at particular times (eg, Tape on)
 *    DrawTimeTics		Draw time axis
 */
/* ********************************************************************	*/

#define MAX_OLD_TARGETS	 7
#define SPACING		16		/* LED lines this many pix apart*/

/* Keep track of all targets, and also keep track of 'non-target behaviors' *
 *    There are MAX_TARGET targets, and there are MAX_BEHAV behaviors.
 * Some targets and behaviors have similar names; however, this is a red
 * herring.  Targets and behaviors have no fixed relationship with each other.
 * (Though by convention, the EYE target is often used for the EYE behavior.
 *  Also, EYE pursuit MUST use the EYE target, and ARM pursuit must use ARM.)
 *
 * Of the MAX_BEHAV behaviors, MAX_WINDOW_BEHAVS require a target, e.g., ARM;
 *  and MAX_BEHAV-MAX_WINDOW_BEHAVS do not, e.g., RELEASE_ARM.
 * 
 * We call the behaviors without associated targets 'NON_TARGET_BEHAVIORS'.
 * We track MAX_TARGETS + NON_TARGET_BEHAVIORS.
 * To convert from a non-target behavior to a pseudo-target number, we add
 *  NON_TARGET_BEHAVIOR_ADJUSTMENT, which maps the first non-target behavior
 *  onto the first number greater than MAX_TARGETS (well, since target numbers
 *  start at zero, the first non-target behavior actually equals MAX_TARGETS).
 */

#define NON_TARGET_BEHAVIORS	(MAX_BEHAV - MAX_WINDOW_BEHAVS)
 	/* Some behaviors don't use a target; keep track of them, too	*/
#define TOTAL_TARGETS	(MAX_TARGETS + NON_TARGET_BEHAVIORS)
#define NON_TARGET_BEHAVIOR_ADJUSTMENT  (MAX_TARGETS-MAX_WINDOW_BEHAVS)

static struct TARG {
   int line;					/* Pixel location	*/
   int color;					/* Actual color		*/
   int old_color;				/* Color BEFORE redraw	*/
   int H;					/* Target position	*/
   int V;
   int last_pixel;				/* Drawn to here	*/
   int exists;					/* Currently used?	*/
   unsigned int blank  : 1;			/*  On or off		*/
   unsigned int required: 1;			/*  Must acquire targ?	*/
   unsigned int option : 1;			/*  Reward if for targ?	*/
   } Targ[TOTAL_TARGETS], *T;
   	/* One slot for each target AND one for each non-target behavior */

static struct OLD_TARG {
   int line;					/* Pixel location	*/
   int H;					/* Target position	*/
   int V;
   int type;					/* Target type		*/
   } OldTarg[MAX_OLD_TARGETS], *O;

static int RunStack;

static int DelayTime;				/* Cumulative max delay	*/
static int EndTime;

static int NextAvailableLine;

static int ShowNonTargetBehaviors = 0;		/* Inherit from graph.c	*/

static int BehaviorToTypeMap[MAX_WINDOW_BEHAVS]; /*Targ or non-t behav#	*/
static char *BehaviorName[MAX_BEHAV] =
   { "Arm", "Eye", "arm", "eye", "Let go", "Button &", "Button |", "Wiggle" };


static void Initialize(void);
static void Process_One_Event(EVENT *E);
static void DrawLines(int stack);
static int  GetTargetLine(int horiz, int vert, int type);
static void DrawTarget(int type, int time);
static void LabelDimension(int value, int y, int x, int color);
static void MarkTime(EVENT *E);
static void DrawTimeTics();

/* ********************************************************************	*/
#define SAVE_WINDOW	48  		/* Preserve area on far left	*/
					/* Where Hz and interval are	*/

/* FUNCTION Picture */
	 /* Plot graph describing a stack */
void Picture(int stack) {
     RunStack = (stack == HEADER_STACK);	/* Set flag		*/
     if (RunStack) {				/* Just ran this stack	*/
     	EndTime = Smooth_DMA_DataCount() * MS_PER_TIC;
        if (EndTime > TOP_LAST_TIME)		/* Truncate if needed	*/
            EndTime = TOP_LAST_TIME;
        if (Get_RunStatus() != SUCCESS)
            EndTime -= Get_Header_ErrorTime();
     } else
        EndTime = TOP_LAST_TIME;		/* As much as have room	*/

     display_rectangle(TOP_PIX_OFFSET, 0,	/* Clear most of old	*/
     	TOP_LAST_PIX-1-TOP_PIX_OFFSET, HEIGHT-1, ERASE_COLOR);
     display_rectangle(0, 0,			/* Leave window(hist.c)	*/
     	TOP_PIX_OFFSET, HEIGHT-SAVE_WINDOW, ERASE_COLOR);
     Initialize();

     if (DEBUG) Move_To(0, 10);
     DrawLines(stack);
     DrawTimeTics();

     if (Get_RunStatus() != SUCCESS)
	display_vertical(TOP_PIX(EndTime), 24, 100, 4, 1);
     }
/* ********************************************************************	*/

/* FUNCTION Initialize */
	 /* Zero out the structure */
static void Initialize() {
     int i;

     for (i=0; i<MAX_OLD_TARGETS; i++)
	OldTarg[i].line = 0;
     for (i=0; i<TOTAL_TARGETS; i++) {
        T = Targ + i;
	T->exists = T->line = T->last_pixel = T->option
	  = T->blank = T->required = T->color = 0;
	}

     for (i=0; i<MAX_TARGETS; i++)
         Targ[i].color = (i==0) ? LIGHT_GREEN: (	/* Targ 0 (usu arm)*/
	 		 (i==1) ? LIGHT_RED: (		/* Targ 1 (usu eye)*/
			 (i==2) ? LIGHT_BLUE: WHITE));

     { int TempColor[MAX_WINDOW_BEHAVS] = {
     					BLUE_GREEN, PURPLE, RED, RED };
       for (i=0; i<MAX_WINDOW_BEHAVS; i++)
         Targ[MAX_TARGETS+1+i].color = TempColor[i];
     }

     DelayTime = 0;
     NextAvailableLine = 0;
     }
/* ********************************************************************	*/

/* FUNCTION GetTargetLine */
	 /* Check for old target here; if not, return next empty slot	*/
static int GetTargetLine(int horiz, int vert, int type) {
	int i;
	int Y;

	for (O=OldTarg, i=0; i<MAX_OLD_TARGETS; i++, O++) {
	   if (O->line == 0)		/* No more entries	*/
	      break;
	   if (O->H == horiz && O->V == vert && O->type == type)
	      return(O->line);		/* Used before: use old	*/
	   }

	O->line = (2 + NextAvailableLine) * SPACING;	  /* Last line	*/
	if ((i < MAX_OLD_TARGETS) &&		/* Not too many?	*/
	   ((ShowNonTargetBehaviors!=0) || (type<MAX_TARGETS)))
	   NextAvailableLine++;

	O->H = horiz;
	O->V = vert;
	O->type = type;

	Y = O->line - 8;			/* A bit above line	*/
	if (type < MAX_TARGETS) {		/* Standard target?	*/
	   LabelDimension(horiz, Y, 18, T->color);/* Label new target	*/
	   LabelDimension(vert,  Y, 48, T->color);/* Use H x V notation	*/
	   display_string(ToString(type), 2, Y, 0);  /* Target #	*/
	   display_string(":", 10, Y, 0);	    /* Target #	*/
	 } else					/* Non-targ behavior	*/
	   if (ShowNonTargetBehaviors)	 	/* If showing them:	*/
	     display_string(BehaviorName[
	     		     type-NON_TARGET_BEHAVIOR_ADJUSTMENT], 2, Y, 0);

	return(O->line);
	}
/* ********************************************************************	*/

/* FUNCTION Process_One_Event */
	 /* Act on single event */
static void Process_One_Event(EVENT *E) {
	int type;

	switch (E->type) {
	   case TARGET_SAC:
	   case TARGET_SAC_POLAR:
	   case TARGET_RE_0:
	   case TARGET_RE_0_POLAR:
	   case TARGET_RE_1:
	   case TARGET_RE_1_POLAR:
	   case TARGET_RE_2:
	   case TARGET_RE_2_POLAR:
	   case TARGET_RE_3:
	   case TARGET_RE_3_POLAR:
	   case TARGET_RE_4:
	   case TARGET_RE_4_POLAR:
	   case TARGET_ON_POLAR:
	   case TARGET_ON:
	        type = E->one;
	   	T = Targ + type;
		if (T->exists)		/* Used to test last_pixel 	*/
		   DrawTarget(type, DelayTime+E->time);
	/* Line of old target at this position, or next empty line:	*/
		T->line = GetTargetLine(E->two, E->three, type);
		T->H = E->two;
		T->V = E->three;
		T->required = 0;
		T->option = 0;
		T->exists = 1;
		T->last_pixel = TOP_PIX(DelayTime + E->time);
		break;

	   case TARGET_OFF:
	        type = E->one;
	   	T = Targ + type;
		DrawTarget(type, DelayTime+E->time);
		T->exists = 0;
		break;

	   case TARGET_OFF_IN:
	   	T = Targ + E->one;
		DrawTarget(E->one, DelayTime+E->time+E->two);
		T->exists = 0;
		break;

	   case TARGET_BLANK:
	        type = E->one;
	   	T = Targ + type;
		if (T->exists)				/* Turned on?	*/
		   DrawTarget(type, DelayTime+E->time);
		T->blank = E->two;
		break;

	   case REWARD_OPTIONAL_BUTTON_AND:
	   case REWARD_OPTIONAL_BUTTON_OR:
	        if (RunStack & (E->three > 0))		/* In run & pos?*/
		   break;	/* If gets rwd, 3rd param is set neg	*/
		goto SKIP_DELAY;

	   case BUTTON_ACQUIRE_AND:
	   case BUTTON_ACQUIRE_OR:
		if (!RunStack)
		   DelayTime += (E->three/2>500) ? 500 :
		      	            E->three/2;	/* 1/2 acq time && <500	*/
		SKIP_DELAY:
		display_string(ToString(E->two),
		  	TOP_PIX(DelayTime+E->time), 10, 0);
		break;

	   case ACQUIRE:		/* one:behavior  two:target#	*/
	        if (E->one < MAX_WINDOW_BEHAVS) { /* Target-assc'd behav*/
		   type = E->two;		/*  type is target #	*/
	   	   T = Targ + type;
		   if (!RunStack)
		      DelayTime += (E->three/2>500) ? 500 :
		      	            E->three/2;	/* 1/2 acq time && <500	*/
		   display_string(BehaviorName[E->one],	/* - below line	*/
		  	TOP_PIX(DelayTime+E->time), T->line, 0);
		   BehaviorToTypeMap[E->one] = type;	/* Save for OFF	*/
	         } else {			/* Nontarg behav:special*/ 
	   	   type = E->one + NON_TARGET_BEHAVIOR_ADJUSTMENT;
		   T = Targ + type;		/* Was missing!10-10 LHS*/
		   T->H = T->V = 0;			/* Unused	*/
		   T->line = GetTargetLine(T->H, T->V, type);
		   T->exists = 1;		/* Pseudo-target is on	*/
		   T->last_pixel = TOP_PIX(DelayTime + E->time);
		   if (ShowNonTargetBehaviors)	/* Show: extend time	*/
		      DelayTime += (E->three/2>500) ?
		      	    500: E->three/2;	/* 1/2 acq time && <500	*/
		   else	{			/* No show:label picture*/
		      display_vertical(TOP_PIX(DelayTime+E->time),
		                 20, 64, 3, 5);
		      display_string(BehaviorName[E->one],
		      		TOP_PIX(DelayTime+E->time), 10, 5);
		      }
		   }

		if (T->option) {		/* REWARD_OPTIONAL on?	*/
		   if (RunStack)
		      DrawTarget(type, DelayTime+E->time-abs(E->three));
		   else	  /* Runstack: uses only half of the delay time	*/
		      DrawTarget(type, DelayTime+E->time-abs(E->three)/2);
		   T->option = 0;		/* Update, then turn off*/
		   }				/* Ready for normal acq	*/
		DrawTarget(type, DelayTime+E->time);	/* Acq period	*/
		T->required = 1;
		T->option = 0;
		break;

	   case ACQUIRE_OFF:	/* Target not specified; use saved info	*/
	   	type = (E->one<MAX_WINDOW_BEHAVS) ? /*Targ assc'd behav?*/
		      BehaviorToTypeMap[E->one] :	/* Saved info	*/
		            NON_TARGET_BEHAVIOR_ADJUSTMENT + E->one;

	   	T = Targ + type;
		DrawTarget(type, DelayTime+E->time);
		T->required = 0;

		if (type >= MAX_WINDOW_BEHAVS)
		   T->exists = 0;		/* 'target' now off	*/
		break;

	   case REWARD_WHILE_ON:
	   case REWARD_OPTIONAL_OFF:
	   case REWARD_OPTIONAL:
	   	type = (E->one<MAX_WINDOW_BEHAVS) ? /*Targ assoc'd behav?*/
	 	   ((E->type==REWARD_WHILE_ON)? E->one:E->two): /* Targ#*/
		   NON_TARGET_BEHAVIOR_ADJUSTMENT + E->one;  /* Special	*/
		DrawTarget(type, DelayTime+E->time);
		Targ[type].option = (E->type != REWARD_OPTIONAL_OFF);
		break;

	   case ARM_WINDOW:
	   case EYE_WINDOW:
	   case TAPE_ON: case TAPE_OFF:
	   case EYE_STEP_RAMP:
	   case REWARD:
	   	break;

	   case TARGET_PURSUIT:		/* Draw bar over pursuit time	*/
		if (E->two || E->three) {	/* If pursuit starting	*/
	   	   EVENT *End = E+1;

		   while (End->type != E->type)
		      End++;
		   display_horizontal(
			TOP_PIX(DelayTime + E->time), 14, 
			TOP_MS_TO_PIX(End->time - E->time), 5,
			Targ[E->one].color);
		   }
		break;

	   case TARGET_COLOR:
	        if (E->two==YELLOW || E->two==WHITE)    /* Hard to see	*/
		    E->two = BLACK;
		if (Targ[E->one].exists) 	/* Currently on?	*/
		   Targ[E->one].old_color = Targ[E->one].color;	/* Save	*/
	   	Targ[E->one].color = E->two;
		break;

	   case TARGET_REDRAW:
	   	for (type=0; type<MAX_TARGETS; type++) {
		   T = Targ + type;		/* Color change?	*/
		   if (T->exists && T->old_color) {	/* Happens now!	*/
		      int save_new = T->color;		/* Don't use yet*/
		      T->color = T->old_color;		/* Draw in old	*/
		      DrawTarget(type, DelayTime+E->time); /* Up to now	*/
		      T->color = save_new;	/* From now on,new color*/
		      T->old_color = 0;			/* Clear flag	*/
		      }
		   }
	        break;

	   case DELAY:
	 	display_horizontal(TOP_PIX(DelayTime+E->time), 18,
			  	      TOP_MS_TO_PIX(E->two), 5, BROWN);
		if (!RunStack)
		   DelayTime += E->two;		/* Tally	*/
		break;

	   default: 
		goto NO_MARK;
           }
       MarkTime(E);				/* Most events*/
       NO_MARK:
       return;
       }
/* ********************************************************************	*/

/* FUNCTION DrawLines */
	 /* Locate relevant instructions, call Process_One_Event on each*/
static void DrawLines(int stack) {
   EVENT *E = Pointer_To_Stack(stack);
   int i;

   E--;
   while ((++E)->type != END_STACK) {
      if (DelayTime+E->time > EndTime)
          break;
      if (E->type == CALL_STACK) {
      	 int save = E - Pointer_To_Stack(stack);
      	 E = Pointer_To_Stack(E->one) - 1;
         while ((++E)->type != END_STACK)
            Process_One_Event(E);
	 E = Pointer_To_Stack(stack) + save;
         }
      Process_One_Event(E);
      }

   if (!RunStack)				/* EndTime is full page	*/
      if (DelayTime + E->time < EndTime)	/* If smaller, then	*/
          EndTime = DelayTime + E->time;	/* Set to correct value	*/

   if (E->type == END_STACK)
      MarkTime(E);			/* Could be wrong! 		*/

   for (i=0; i<TOTAL_TARGETS; i++)	/* Usu all targs off by now	*/
      if (Targ[i].exists)		/*  Unless an error trial	*/
         DrawTarget(i, EndTime);

   set_color(1);
   display_string("Targets", 1, 6, 1);
   display_line(4,23, TOP_PIX_OFFSET-14, 23); 
   }
/* ********************************************************************	*/

/* FUNCTION LabelDimension */
	 /* Print value or lookup (e.g., $1). */
static void LabelDimension(int value, int y, int x, int color) {
   if (is_lookup(value)) {
      char String[100];
      sscanf(String, "%c%d", get_lookup_char(value), get_lookup_value(value));
      /* display_char(get_lookup_char(value), x, y, color);	/* OLD */
      /* display_string(ToString(get_lookup_value(value)),x+8,y,color);/*OLD*/
   } else {
      if (value >= 0)				/* No '-' sign?		*/
         x += 8;				/* Leave a space	*/
      display_string(ToString(value/10), x, y,color); /* deg,not tenths	*/
      }
   }
/* ********************************************************************	*/

/* FUNCTION DrawTarget */
	 /* Indicate target lights and behavioral status:		*/
	 /* Draw target from last_pixel to now; update last_pixel	*/
	 /* Thick line when target is acquired				*/
	 /*    Missing middle line if target is blanked			*/
static void DrawTarget(int type, int time) {
     int ElapsedTime;

     if ((type>=MAX_TARGETS) && (ShowNonTargetBehaviors==0))
        return;

     T = Targ + type;

     if (time > EndTime)	/* If we run out of room to show it	*/
         time = EndTime;

     ElapsedTime = TOP_PIX(time) - T->last_pixel;	/* In pixels	*/

     if (DEBUG)
         Printf("target %d x %d,   %d to %d: %d %d  \n",
	 	T->H, T->V, T->last_pixel, TOP_PIX(time),
		T->blank, T->required);
     if (ElapsedTime <= 0)				/* Nothing doing*/
        return;

     if (T->color == 15)			/* If white, make black	*/
         T->color = 1;
     if (T->required) {			/* Required: top & bottom lines	*/ 
	display_horizontal(T->last_pixel,T->line,  ElapsedTime,3,T->color);
	display_horizontal(T->last_pixel,T->line-6,ElapsedTime,3,T->color);
	}
     if (T->option) {			/* Rwd_if:flank lines, top=blue	*/ 
	display_horizontal(T->last_pixel,T->line,ElapsedTime,3,T->color);
        display_horizontal(T->last_pixel,T->line-6,ElapsedTime,3,
							LIGHT_BLUE_GREEN);
        display_horizontal(T->last_pixel,T->line-11,ElapsedTime,5, BLUE_GREEN);
	}
     if (!(T->blank))			/* On or off: middle line	*/
	display_horizontal(T->last_pixel,T->line-3,ElapsedTime,3,T->color);

     T->last_pixel = TOP_PIX(time);
     }
/* ********************************************************************	*/

/* FUNCTION MarkTime */
static void MarkTime(EVENT *E) {
     int time = TOP_PIX(E->time + DelayTime);
     if (time > EndTime)
        return;
     switch (E->type) {
	case REWARD_WHILE_ON:			/* Reward:		*/
	case REWARD_OPTIONAL:			/* Purple rectangle	*/
        case REWARD:				/* Length = duration	*/
		if (!RunStack) {
		   display_horizontal(time, 16,
		   	E->three ? TOP_MS_TO_PIX(E->three) : 6, 6, 13);
		 } else if (E->three < 0) {		/* Got reward	*/
                  display_horizontal(time, 16, TOP_MS_TO_PIX(-E->three), 6, 13);
		 } else if (E->three > 0) {		/* No rwd (0,1)	*/
                   display_horizontal(time, 16, 4, 4, 0);	/* Black*/
		 } else {		/* Duration set by hardware	*/
                   display_horizontal(time, 16, 6, 6, 13);
		   }
	   break;

	case EYE_STEP_RAMP:		/* Swelling of pursuit line	*/
	   display_horizontal(time-10/2, 14+10/4, 10,-10, 4);
	   break;

	case TAPE_ON:
	case TAPE_OFF:	  display_vertical(time, 20, 64, 1, 4);	break;
	case EYE_WINDOW:  display_vertical(time, 19, 3, 3, 4);	break;
	case ARM_WINDOW:  display_vertical(time, 19, 3, 3, 5);	break;
	case END_STACK:   display_vertical(time, 24, 100, 1, 1);break;

	case TARGET_PURSUIT:			/* Mark already made	*/
	case DELAY:
		break;

	default:				/* All else: align mark	*/
	   display_vertical(time, 24, HEIGHT-64, 1,
	   	(ERASE_COLOR==WHITE)? 8 : WHITE);	/* 8: light grey*/
	}
     }
/* ********************************************************************	*/

/* FUNCTION DrawTimeTics */
	 /* Draw grid of 1 s lines; call only once */
static void DrawTimeTics() {
        int EndPix = TOP_PIX(EndTime);		/* Convert to pixels	*/
	int x = TOP_PIX(-1000);

	while ((x+=TOP_MS_TO_PIX(1000)) <= EndPix) {
	    display_vertical(x, 1, 15, 1, 0);	/* Top: Medium 1 s lines*/
	    display_vertical(x, HEIGHT, -7, 1, 0);	/* Below: ditto	*/
	    }

        x = TOP_PIX(0);
	while ((x+=TOP_MS_TO_PIX(100)) <= EndPix) {
	    display_vertical(x, 1, 7, 1, 0);	/* Top: Short .1 s lines*/
	    display_vertical(x, HEIGHT, -4, 1, 0);	/* Below: ditto	*/
	    }
	}
/* ********************************************************************	*/

/* FUNCTION Set_ShowNonTargetBehaviorsInPicture */
	 /* Parameter, currently set in graphics.c */
int Set_ShowNonTargetBehaviorsInPicture(int change) {
     if (change)
	ShowNonTargetBehaviors = ! ShowNonTargetBehaviors;
     return(ShowNonTargetBehaviors);
     }
/* ********************************************************************	*/

