/* FILE output.c */
     /* Write data to file.a; apply -x -m -X & limit trial numbers	*/

#include "deffs.h"
#include <fcntl.h>					/* Open/close	*/
#include <string.h>					/* strcpy()	*/
#include <sys/types.h>					/* write()	*/
#include <sys/stat.h>					/* chmod()	*/
#include <unistd.h>					/* lseek arg's	*/
#include <libgen.h>                                     /* basename()   */

/* ********************************************************************	*/

/* PUBLIC:
 *	Open_OutputFile			Open a file, S555.3 -> S555.3.a
 *	Set_OutputFile_TrialLimit	Limit max # trials written per type
 *	Set_OutputFile_ShiftTime
 *	Write_OutputFile		Hdr+data, unless skip(-x) or chg(-m)
 *	Close_OutputFile		Close it.
 *
 * PRIVATE:
 *	Calibrate_And_Write_Analog_Data
 * ********************************************************************	*/
static void Calibrate_And_Write_Analog_Data(
	int File, int LocalOutputFile, short *Data, int channels, int frames);

static int OutputFile;
static int TrialLimit = 0;		/* Only n trials per type	*/
static int ShiftTime = 0;		/* Positive time shift		*/
static int TrialCounts[MAX_TYPES];
/* ********************************************************************	*/

/* FUNCTION Open_OutputFile */
void Open_OutputFile(char *inputname, char *suffix) {
   char OutputName[80];
   int  i;

   sprintf(OutputName, "%s%s", basename(inputname), suffix);

   OutputFile = open(OutputName, O_TRUNC|/* O_EXCL| */ O_CREAT|O_WRONLY,
		   		S_IREAD|S_IWRITE|S_IRGRP|S_IWGRP);
   if (OutputFile == -1) {				/* O_EXCL flag	*/
      sprintf(OutputName, "Cannot open %s%s", inputname, suffix);
      perror("Cannot open file:");
      Exit(OutputName, "output.c:Open_OutputFile");
      }
   chmod(OutputName, 0666);

   if (TrialLimit > 0)				/* Limit # trials/type?	*/
      for (i=0; i<MAX_TYPES; i++)
         TrialCounts[i] = 0;
   }

/* ********************************************************************	*/

/* FUNCTION Set_OutputFile_ShiftTime */
void Set_OutputFile_ShiftTime(int time) {
	/* if (time < 0)
	   Exit("Shift time must be positive", "Set_OutputFile_ShiftTime");
	*/
	ShiftTime = time;
	}
/* ********************************************************************	*/

/* FUNCTION Set_OutputFile_TrialLimit */
void Set_OutputFile_TrialLimit(int limit) {
	TrialLimit = limit;
	}
/* ********************************************************************	*/

/* FUNCTION Write_OutputFile */
	 /* For use with 'w' flag: write data out with alterations:	*
	  *   -x, -m, -X flags; also converts events and calibrates	*
	  *   analog data; can also shift data by a constant amount	*/
void Write_OutputFile() {
   int channels = ChannelCount_Header();	/* # channels in data	*/
   int frames = FrameCount_Header();
   int File = Get_InputFile();			/* Get file descriptor	*/
   short oData[MAX_FRAMES*MAX_CHANNELS];	/* Like Data of input.c	*/
   int ReplaceUnitsWith = Get_UnitChannel_Header();   	/* "-w -u#"?	*/
   int Orig_Spike_Count = SpikeCount_Header(0);   /* For "-u1"	*/
   int New_Spike_Count = SpikeCount_Header(ReplaceUnitsWith);
   /* -w -u1: Swap out channel 0 units; put new channel in their place	*/
   int ButtonCount = ButtonCount_Header();	/* Bug fix (1-2010)	*/
   int i;

   if (ReplaceUnitsWith > 1)			/* Add this later??	*/
      Exit("Sorry, cannot use -u2 or -u3!", "Write_OutputFile");

   if ((TrialLimit>0) &&			/* Limit # trials/type?	*/
       (++(TrialCounts[Get_TrialType()]) > TrialLimit)) {
      return;					/* At the limit?	*/
      }

   if (ShiftTime) {
      Shift_Time_In_Event_Stack(ShiftTime);
      Increment_StackNumber_In_Header(100);	/* Mark shifted trials	*/
      }

   if (ReplaceUnitsWith) {			/* "-u#" on cmd line?	*/
      Set_UnitChannel_Header(0);  /* Make Set_SpikeCount access singles	*/
      Set_SpikeCount_Header(SpikeCount_Header(ReplaceUnitsWith));
      Set_UnitChannel_Header(ReplaceUnitsWith);
      Set_SpikeCount_Header(0);	  /* Set multi SpikeCount to 0 (none)	*/
      Set_UnitChannel_Header(0);  /* Set to 0; restore before leaving! 	*/
      }			           

   if (ButtonCount < 0) {		/* Errs in data, 1-2010		*/
      ButtonCount += 65536;		/* Add 2^16 to correct		*/
      Set_ButtonCount_Header(0);        /* Throw out bad data		*/
      }

   Clear_CalibFile_Header();	/* Flag as already cal'd (on disk)	*/
   Write_Header_To_File(OutputFile);		/* Write current header	*/
   Restore_CalibFile_Header();	/* About to read data; DO calibrate!	*/

   Calibrate_And_Write_Analog_Data(File,OutputFile,oData, channels, frames);

   if (ReplaceUnitsWith == 0) {                 /* No "-u1" on cmd line */
      for (i=0; i<4; i++) {
         read(File,        oData, SpikeCount_Header(i) * sizeof(short));
	 write(OutputFile, oData, SpikeCount_Header(i) * sizeof(short));
	 }
    } else {
      read(File, oData, Orig_Spike_Count * sizeof(short));  /* or lseek */
      read(File, oData, New_Spike_Count * sizeof(short));   /* get chan1*/
      write(OutputFile, oData, New_Spike_Count * sizeof(short));
      for (i=2; i<4; i++) {			/* copy chans 2+3*/
         read(File,        oData, SpikeCount_Header(i) * sizeof(short));
	 write(OutputFile, oData, SpikeCount_Header(i) * sizeof(short));
	 }
      }

   read(File, oData, TouchCount_Header(1)*sizeof(ARMDATA));
   write(OutputFile, oData, TouchCount_Header(1) * sizeof(ARMDATA));
   read(File, oData, TouchCount_Header(2)*sizeof(ARMDATA));
   write(OutputFile, oData, TouchCount_Header(2) * sizeof(ARMDATA));
   if (ButtonCount > 32768) {			/* Bad data; skip it!	*/
      lseek(File, (long)ButtonCount * sizeof(BUTTONS), SEEK_CUR);
     } else {
      read(File, oData, ButtonCount_Header()*sizeof(BUTTONS));
      write(OutputFile, oData, ButtonCount_Header() * sizeof(BUTTONS));
      }
   Set_UnitChannel_Header(ReplaceUnitsWith);	/* Restore for next iter*/
   }
/* ********************************************************************	*/

/* FUNCTION Close_OutputFile */
void Close_OutputFile() {
   close(OutputFile);
   }
/* ********************************************************************	*/
# define STRIP(x)	x				/* see input.c	*/

/* FUNCTION Calibrate_And_Write_Analog_Data */
	 /* Don't use this!!!! Only here, and very select macros!	*/
static void Calibrate_And_Write_Analog_Data(
	int File, int LocalOutputFile, short *Data, int channels, int frames) {
	short *now = Data;			/* WRITE ptr: this frame*/
	int i,j;

	if (frames <= 0)
	   return;

	if (channels > MAX_CHANNELS)
	   Exit("Increase MAX_CHANNELS", "Read_Analog()");

	if (frames >= MAX_FRAMES) {
	   fprintf(stderr, "%d frames\n", frames);
	   Exit("Increase MAX_FRAMES", "Read_Analog()");
	   }
	   
	Read_CalibFile(CalibFile_Header());

	if (Flag_Header(DELTA_WRITE) == 0) {	/* NOT DELTA WRITE	*/
	 read(File, now, frames*channels*sizeof(short));

	 for (i=0; i<FrameCount_Header()*channels; i++)	/* To make calib work */
	    *(Data+i) -= 2048;		/* Added 5-13-2013 */

	 for (j=0; j<frames; j++) {
	    Do_Calibration(now, channels, j);	/* Expects data-2048 !	*/
	    now += channels;
	    }

	 for (i=0; i<FrameCount_Header()*channels; i++) /* Restore from above*/
	    *(Data+i) += 2048;		/* Added 5-13-2013 */

         write(LocalOutputFile, Data, frames*channels*sizeof(short));
	} else {				/* DELTA_WRITE		*/
	 short FrameZero[MAX_CHANNELS];		/* frame  0:   ints	*/
	 char  RawAnalog[MAX_FRAMES * MAX_CHANNELS];
	 char *raw = RawAnalog;			/* READ  ptr: this frame*/
	 short *prev = Data;			/* READ  ptr: last frame*/

	 read(File, FrameZero, channels*sizeof(short));	/* Read ints	*/
	 read(File, RawAnalog, (frames-1)*channels);	/* Read chars	*/

	 for (i=0; i<channels; i++)		/* Get frame       1	*/
	    *(now+i) = STRIP(FrameZero[i]) - 2048;

	 now += channels;			/* Move to frame 2	*/
	 for (j=2; j<=frames; j++)		/* Get/calc frames 2-$	*/
	   for (i=0; i<channels; i++)
	      *(now++) = *(prev++) + STRIP(*(raw++));

	 now = Data;				/* Reset pointer	*/
	 for (j=0; j<frames; j++) {		/* Walk thru frames	*/
	    Do_Calibration(now, channels, j);
	    now += channels;
	    }

	/* Data is now all correctly read in */
	/* Now write the data back out again, in the original format */

	 {
	 short FirstFrame[MAX_CHANNELS];
	 for (i=0; i<channels; i++)
	    FirstFrame[i] = *(Data+i) + 2048;
         write(LocalOutputFile, FirstFrame, channels * sizeof(short));
	 }
	
	 raw = RawAnalog;
	 for (j=1; j<frames-1; j++)			/* Recalc diffs	*/
	   for (i=0; i<channels; i++)
	     *(raw++) = (char)
	     	     (*(Data+j*channels+i) - *(Data+(j-1)*channels+i));
         write(LocalOutputFile, RawAnalog, (frames-1)*channels);
        }
	}
/* ********************************************************************	*/
