/* FILE merge.c */
     /* Merge stacks and/or tables together.  (Use also to renumber 'm)	*/
#include <stdio.h>			 /* For diagnostic statements	*/
#include <stdlib.h>					/* atoi()	*/

extern void Warning(char *string);
extern void Exit(char *string, char *name);
/* ********************************************************************	*/
#define MAX_MERGE	161
#define MAX_SETS	25
int  MergeStacks[MAX_MERGE+1];			/* Merge up to ~ stacks	*/
int  MergeStackIndex[MAX_SETS+1];
int  MergeStackCount = 0;
int  MergeAllStacks = 0;			/* Make all a single one*/

#define DEBUG	0

/* FUNCTION Set_MergeStacks */
	 /* Set merge-stack structures from command line	*/
	 /* Can have up to 25 sets of stacks to merge together,	*/
	 /*  involving up to 50 different stacks		*/
void Set_MergeStacks(char *CmdLine) {
	int set = 0;
	int RangeFrom = 0;

	MergeAllStacks = MergeAllStacks || (*CmdLine == 0);
			/* True if no other arg, or if previously set	*/

        if (MergeStackCount)		/* Else is set == 0 (first one)	*/
	   while (++set < MAX_SETS)
	      if (MergeStackIndex[set] == 0)
	         break;
	if (set == MAX_SETS)
	   Exit("Merged too many stack sets", "Set_MergeStacks");

	MergeStackIndex[set] = MergeStackCount;
			/* Index of set #0 is always 0 -- don't test it!*/	   
	while (*CmdLine) {
	  MergeStacks[MergeStackCount++] = atoi(CmdLine);   /* Get #	*/
	  if (RangeFrom) {
	     int RangeTo = atoi(CmdLine); 		/* Last one	*/
	     while (RangeFrom < RangeTo) {
		MergeStacks[MergeStackCount] = ++RangeFrom;
		MergeStackCount++;
	        }
	     RangeFrom = 0;
	     }
	  if (MergeStackCount > MAX_MERGE)
	      Exit("Merged too many stacks", "Set_MergeStacks");
	  while (*CmdLine && (*CmdLine != ',' && *CmdLine != ':'))
	     CmdLine++;			/* Get the next stack #, or ,:	*/
	  if (*CmdLine == ',')		/* Fine; move past it		*/
	     CmdLine++;
	  else if (*CmdLine==':') {	/* Remember start & move past	*/
	     RangeFrom = MergeStacks[MergeStackCount-1];
	     if (RangeFrom == 0)
	        Exit("Cannot merge range starting with zero","Set_MergeStacks");
	     CmdLine++;
	     }
	  }
#if DEBUG
	int i;
	fprintf(stderr, "MergeStacks: ");

	i = -1;
	while (++i < MergeStackCount)
	 fprintf(stderr, "%5d", MergeStacks[i]);

	fprintf(stderr, "\n MgStkIndex: ");
	i = 0;
	while (MergeStackIndex[++i])
	 fprintf(stderr, "%5d", MergeStackIndex[i]);
	fprintf(stderr, "\n");
#endif
	}
/* ********************************************************************	*/

/* FUNCTION MergeStack */
	 /* Given stack #, return it OR # of stack to merge it with	*/
int MergeStack(int stack) {
	int i = -1;
	int set = 0;

	if (MergeAllStacks)
	   return(1);				/* Call'm all 'stack 1'	*/

	while (++i < MergeStackCount)		/* Walk thru all merges	*/
	   if (stack == MergeStacks[i]) {	/* Found a match?	*/
#if DEBUG
  	      fprintf(stderr, "Stack %d: merge[%d] is %d ...",
			      	stack, i, MergeStacks[i]);
#endif
	      while (++set < MAX_SETS && MergeStackIndex[set])
	         if (i <= MergeStackIndex[set])
		    break;	/* Walk thru each set index til find it	*/
	      if (i != MergeStackIndex[set])	/* Overshot, so back up	*/
	         set--;		/* Back up one				*/
#if DEBUG
	      fprintf(stderr, "index[%d] is %d ==> %d\n",
		  set, MergeStackIndex[set], MergeStacks[MergeStackIndex[set]]);
#endif
              return(MergeStacks[MergeStackIndex[set]]);
	      }			/* Not in the list of stacks to merge	*/
	return(stack);		/* Return raw stack #			*/
	}
/* ********************************************************************	*/
/* *****  MERGE TABLES ************************************************	*/
/* ********************************************************************	*/
int  MergeTables[MAX_MERGE+1];			/* Limits		*/
int  MergeTableIndex[MAX_SETS+1];
int  MergeTableCount = 0;
int  MergeAllTables = 0;			/* Call all by 1st tbl#	*/

/* FUNCTION Init_Merge */
	 /* For stacks AND classes */
void Init_Merge() {
   int set = -1;

   while (++set <= MAX_SETS) {
      MergeStackIndex[set] = 0;
      MergeTableIndex[set] = 0;
      }
   MergeStackCount = MergeAllStacks =
   MergeTableCount = MergeAllTables = 0;
   }
/* ********************************************************************	*/

/* FUNCTION Set_MergeTables */
	 /* Set merge-table structures from command line	*/
	 /* Can have up to MAX_SETS sets of tables to merge together,	*/
	 /*  involving up to MAX_MERGE tables			*/
void Set_MergeTables(char *CmdLine) {
	int set = 0;
	int RangeFrom = 0;

	MergeAllTables = MergeAllTables || (*CmdLine == 0);
			/* True if no other arg, or if previously set	*/

        if (MergeTableCount)		/* Else is set == 0 (first one)	*/
	   while (++set < MAX_SETS)	/* Find next open set		*/
	      if (MergeTableIndex[set] == 0)
	         break;
	if (set == MAX_SETS)
	   Exit("Merged too many table sets", "Set_MergeTables");

	MergeTableIndex[set] = MergeTableCount;
			/* Index of set #0 is always 0 -- don't test it!*/	   
	while (*CmdLine) {
	  MergeTables[MergeTableCount++] = atoi(CmdLine);   /* Get #	*/
	  if (RangeFrom) {
	     int RangeTo = atoi(CmdLine); 		/* Last one	*/
	     while (RangeFrom < RangeTo) {
		MergeTables[MergeTableCount++] = ++RangeFrom;
	        }
	     RangeFrom = 0;
	     }
	  if (MergeTableCount > MAX_MERGE)
	      Exit("Merged too many tables", "Set_MergeTables");
	  while (*CmdLine && (*CmdLine != ',' && *CmdLine != ':'))
	     CmdLine++;			/* Get the next table #, or ,:	*/
	  if (*CmdLine == ',')		/* Fine; move past it		*/
	     CmdLine++;
	  else if (*CmdLine==':') {	/* Remember start & move past	*/
	     RangeFrom = MergeTables[MergeTableCount-1];
	     if (RangeFrom == 0)
	        Exit("Cannot merge range starting with zero","Set_MergeTables");
	     CmdLine++;
	     }
	  }
#if DEBUG
	int i;
	fprintf(stderr, "MergeTables: ");

	i = -1;
	while (++i < MergeTableCount)
	 fprintf(stderr, "%5d", MergeTables[i]);

	fprintf(stderr, "\n MgTblIndex: ");
	i = 0;
	while (MergeTableIndex[++i])
	 fprintf(stderr, "%5d", MergeTableIndex[i]);
	fprintf(stderr, "\n");
#endif
	}
/* ********************************************************************	*/

/* FUNCTION MergeTable */
	 /* Given table #, return it OR # of table to merge it with	*/
int MergeTable(int table) {
	int i = -1;
	int set = 0;

	if (MergeAllTables)
	   return(1);				/* Call'm all 'stack 1'	*/

	while (++i < MergeTableCount)		/* Walk thru all merges	*/
	   if (table == MergeTables[i]) {	/* Found a match?	*/
#if DEBUG
  	      fprintf(stderr, "Table %d: merge[%d] is %d ...",
			      	table, i, MergeTables[i]);
#endif
	      while (++set < MAX_SETS && MergeTableIndex[set])
	         if (i <= MergeTableIndex[set])
		    break;	/* Walk thru each set index til find it	*/
	      if (i != MergeTableIndex[set])	/* Overshot, so back up	*/
	         set--;		/* Back up one				*/
#if DEBUG
	      fprintf(stderr, "index[%d] is %d ==> %d\n",
		  set, MergeTableIndex[set], MergeTables[MergeTableIndex[set]]);
#endif
              return(MergeTables[MergeTableIndex[set]]);
	      }			/* Not in the list of tables to merge	*/
	return(table);
	}
/* ********************************************************************	*/
