/* FILE macro */
     /* Ascii output macros */
     /* TO ADD A MACRO:   						*/
     /*		1) Add to Do_Macro and Print_Macro switches		*/
     /*		     If graphics, return 1 from Do_Macro()		*/
     /*		  2) Add file to appropriate _macro/subdirectory	*/
     /*		  3) Add file name to approp ./Makefile macro list	*/
     /*		  4) If graphics output, add to Set_Macro_Output	*/
     /*		  5) touch appropriate _macro/subd/_objects/~.o		*/

#include "deffs.h"
#include "config.h"
#include <fcntl.h>					/* Open/close	*/
#include <ctype.h>					/* isupper()	*/
#include <sys/types.h>					/* stat()	*/
#include <sys/stat.h>					/* stat()	*/
#include <string.h>					/* strncpy	*/

/* ********************************************************************	*/

/* PUBLIC:
 *	Set_Macro_Output			Set which macro to do
 *	Get_Macro_Number			Tell which macro to do
 *	Print_Macro_Numbers			Print macro & assoc'd #
 *	Do_Macro				Do requested macro
 *	Set_dataValue_From_CmdLine		-d flag, used by macros
 *	Get_dataValue_From_CmdLine		-d flag, used by macros
 *	Set_DataValue_From_CmdLine		-D flag, used by macros
 *	Get_DataValue_From_CmdLine		-D flag, used by macros
 *	Clear_oValues
 *	Get_oValue				-oa3:2:1
 *	Set_oValue
 *	Open_Macro_Output			Standardized naming
 */
/* ********************************************************************	*/

static int MacroNumber = 0;
static int Graphics_Output = 0;		/* Don't redirect stdout if set	*/
/* ********************************************************************	*/

/* FUNCTION Set_Macro_Output */
	 /* And return 1 if graphics output */
int Set_Macro_Output(int number) {
	MacroNumber = number;
	switch (number) {
	  case 70:
	  case 71:
	  case 60:
		Graphics_Output = 1;
	  	return(SPECIAL_GRAPHICS_MACRO);	/* Let us do layout	*/

	                   	/* Macros which generate graphics output*/
	  case 87: case 88:	/* All ROC pictures			*/
		Graphics_Output = 1;
		return(GRAPHICS_MACRO);

	  default:		/* All others (text only) 		*/
		return(TEXT_MACRO);
	  }
	}
/* ********************************************************************	*/
/* FUNCTION Get_Macro_Number */
int Get_Macro_Number() { return(MacroNumber); }
/* ********************************************************************	*/
# define SAY(this)	fprintf(stderr, "  %s\n", this);

/* FUNCTION Print_Macro_Numbers */
	 /* Print macro numbers & description in range */
void Print_Macro_Numbers(int decade) {
 switch (decade) {
    case  0:
    	SAY("Generic macros:");
    	SAY(" 0	print		Write mean firing rates in interval (verbose)");
    	SAY(" 1	print		Write mean firing rates in interval (brief)");
	SAY(" 2 print		Spike counts in interval to file");
	SAY(" 3	print		Test embedded (special!) macro");
	SAY(" 4	ttest		Student's T test on SPIKES");
	SAY(" 5	behav		Mean eye and arm position in interval (brief)");
	SAY(" 6	ttest		Student's T test on BEHAVIOR");
	SAY(" 7	interval	Print spikes in interval");
	SAY(" 8	targets		Print times & locations of targets");
	SAY(" 9	behav		Individual eye & arm posits");
	/* Fall thru */

    case 14:
	SAY("140's: More generics");
	SAY("140  print.c             Trial by trial spike count (whole trial)");
	SAY("141  print.c             Trial by trial spike times");
	SAY("1411  print.c            Trial by trial spike times (more header info)");
	SAY("142  print.c             Spike stats to file");
	SAY("143  print.c             Trial by trial trial#,stack,class");
	SAY("144  anova.c             Anova on spikes");
	SAY("145  print.c             EventExtract(-T:tag,-d:param,-D:#)");
	SAY("146  anova.c             Two-way anova on spikes");
	SAY("147  print.c             Extract whole event (-T:tag, -D:#)");
	SAY("148  print.c             Extract all events (-T:tag)");
	/* Fall thru */

    case 15:
	SAY("150's: Still more generics");
	SAY("150  bounds.c            Which trials don't include -i?");
	SAY("152  print.c             Spikes in interval (by stack/class)");
	SAY("155  saccades.c          List saccades in trial");
	SAY("156  print.c             Analog data dump");
	/* Fall thru */

    case 16:
	SAY("160's: Touch panel generics");
	SAY("161  touch2.c               Print touches on either board");
	SAY("162  touch2.c               Print just the traj (Matt's matlab)");
	break;

    case 1:
     SAY("10's: LFP macros:");
     SAY("10  lfp.c      LFP-LFP: Phase-ampitude coupling");
     SAY("11  lfp.c      LFP: Power spectrograms");
     SAY("12  lfp.c      Spike-LFP: Time domain spike trig'd LFP avg"); 
     SAY("13  lfp.c      Spike-LFP: Wavelet coherence analysis");
     SAY("14  lfp.c      Spike-LFP: Pairwise phase consistency (vs coherence)");
     SAY("15  lfp.c      LFP: Single trial power.");
     SAY("16  lfp.c      LFP: Write aligned data in time (-i & -ot full span)");
     SAY("17  lfp.c      LFP-LFP: Pairwise phase consistency");
     SAY("18  lfp.c      LFP-LFP: Correlation");
     SAY("19  lfp.c      LFP-LFP: Coherence across trials");
    case 21:
     SAY("210's: more LFP macros:");
     SAY("211 lfp.c      LFP: Single trial power bursts");
     SAY("311 lfp.c      LFP: Matched pursuit spectrograms (power)");
     SAY("212 lfp.c      LFP: Trial by Trial lfp power in band");
     SAY("213 lfp.c      Spike-LFP: Spike-LFP coheragrams");
     SAY("215 lfp.c      LFP-LFP: Granger causality");
     SAY("216 lfp.c      LFP: Evoked LFP by trial type");
     break;

    case 2:
	SAY("20's: Coordinate frame macros");
	SAY("20 reference.c             Analysis for reference frame");
	break;
   
    case 3:
        SAY("30's: Reward:");
	SAY("30	basics	   unit run trial target history targ-h targ-v reward");
	SAY("31 recode     with '-w-': set class = class + 100*prev_class");
	break;
    case 4:
        SAY("40's: Memory:");
	SAY("40	extract	   pull out specific values from stack");
	SAY("41	extract	   show when > criterion (-d CRIT m/s -D ms)");
	SAY("42	times	   compute on/off times (-obinsize, -oprobability)");
	SAY("43	tuning	   get preferred direction (von Mises)");
	SAY("44	sort	 set class by target (-ot/f ordinal targ/fixation #");
	SAY("		   -oT/F targ/fix # (identity)  -oC number of classes");
	break;
    case 5:
        SAY("50's:  Cue");
	SAY("50	success	   stack, class, RT and delay time");
	SAY("51	failure	   stack,class,targ-on/delay/err time,targ/eye pos");
	SAY("52	success	   version of 50 for distractor data");
	break;

    case 6:
        SAY("60's:	 Behavior");
	SAY("60	sac_endpts	Show saccadic endpoints for flash experiment");
	SAY("63	movement	RT's; **align on 'go'**; see file for flags");
	SAY("64	movement	Like 63, but get a 2nd limb time, too");
	SAY("65	movement	eye and arm timing & position (touch panel)");
	break;
    case 7:
        SAY("70's:	 Receptive fields");
	SAY("70	flash		RF: grab -at2 [-ax] -i#:# [-xs10] -o70");
	SAY("71	frame		Responses as function of vectors, etc");
	break;
    case 8:
	SAY("80's:  Frames of reference");
	SAY("80	vest_sensory	Redo stacks.classes to test sensory response");
	SAY("81	vest_motor	Redo stacks.classes to test motor response");
	SAY("82	frame		Vestib: Did updating occur?  Task effect?");
	SAY("83	frame pursue	82, for pursuit");
	SAY("84	write_sac	Write avg eye position to file");
	SAY("85	write_spikecounts Write corresponding spike count (see 84)");
	SAY("86	write_sacDuration Write how long saccade took (see 84)");
	SAY("87	cumulative roc	 Ditto, across many cells");
	SAY("88	roc		 Discriminablity as a function of time");
	SAY("89	roc-value	 ROC value at single point in time");
	SAY("801 all-info	Write trial-by-trial info plus spikes to file");
	break;

    case 9:
	SAY("90's: Bimanual arm task (_macros/arm)");
	SAY("90 latency		Simple version of latency code (also 997:999)");
	break;

    case 10:
	SAY("100's: Jeff's eye-arm experiments");
	SAY("100	ArmVsEye	Test arm v eye activity (t test)");
	SAY("            -D200: 200 stacks (default); -D210,-D220,-D230");
	SAY("		 -d3: use class 3 as the best direction (-1:file)");
	SAY("101	Jeff's Data Export");
	SAY("102	directional:  	Cmp best & worst directions (t test)");
	SAY("103	test_yes:	T-test all pairs, report if sig");
	SAY("104	test_no:	T-test all pairs, report if not sig");
	SAY("105	GetBestClass:	Write best class (direction) to file");
	SAY("106	SplitByEffector:Split by diff/= effector;hdr+=1000");
	SAY("107	SplitByClass:   Split by diff/= class;   hdr+=1000");
	SAY("108	SplitByTrialType: ditto");
	SAY("1061	SplitByEffector:Split by prev effector (hdr+=1000)");
	SAY("1071	SplitByClass:   Split by prev class (header+=1000)");
	SAY("1081	SplitByTrialType:Split by prev trialtype (+=1000,2000)");
	break;

    case 11:
	SAY("110's: Novelty experiments");
	SAY("110  novelty/write_sac.c    Eye position plus delay time");
	SAY("111  novelty/write_sac.c    Arm position plus delay time");
	SAY("1110 novelty/write_sac.c    Eye pos re:start plus delay time");
	break;
   
    case 12:
	SAY("120's: Stimulation experiments");
	SAY("120  stimulate/printbehav.c    Say where the eye lands");
	SAY("121  stimulate/printstim.c     Unit, stim bits, break ct (-d:thresh)");
	SAY("123  stimulate/movement.c	    Data on saccade latency etc");
	SAY("125  stimulate/getbestclass.c  Return unit#, best&null class");
	SAY("127  stimulate/interval.c	    Trial-by-trial spikes on 1 line");
	SAY("128  stimulate/interval.c	    Trial-by-trial spikes in interval");
	SAY("129  stimulate/findsac.c	    Find saccades during interval");
	break;

    case 13:
	SAY("130  muscimol/timing.c         Timing for muscimol"); 
	SAY("131  muscimol/target.c         Target for muscimol"); 
	SAY("132  muscimol/sactime.c        Sactime for muscimol"); 
	SAY("133  muscimol/sacbehave.c      SactimePosi for muscimol"); 
	SAY("134  muscimol/errtype.c        Error trial analysis"); 
	break;

    case 40:
	SAY("400's: MRI macros");
	SAY("400  write_times.c          Write cumulative trial times");
	SAY("401  write_times.c          Write trial, sync, button times");
	SAY("402  write_times.c          trial, sync, button times monk fMR saccades");
	SAY("405  write_times.c          Cue & targ times (cue-targ trials)");
	SAY("406  write_times.c          Eventfile w/ targ times, type, duration");
	SAY("407  write_times.c          Monkey fMR saccades eventfile");
	SAY("408  write_times.c          Generic MR eventfile generator");
	SAY("409  write_times.c          Generic MR eventfile generator with saccades");
	SAY("410  blinks         	Report blink times (event.c)");
	SAY("411  saccades       	Report saccade times (event.c)");
	SAY("412  pulses       		Report pulse times (event.c)");
	SAY("420  sort.c		Recode class# re: posit & direction");
	SAY("430  MemorySaccade		Events for memory saccades");
	SAY("431  FileStartTime		Start time for file, Leg 2009");
	SAY("432  EventFileForMemory	Events for mem sacs, Leg 2009");
	SAY("433  MemorySaccade		Human readable version of 430");
	SAY("440  Strabismus		Event file for strab exps");
	SAY("450  MemSac		Start time for file, 2011");
	SAY("451  MemSac		Event file, table format, 2011");
	SAY("452  MemSac		Event file, line by line, 2011");
	SAY("453  MemSac		Accuracy file, line by line, 2011");
	break;
   
    default:
	SAY("   MACRO CATEGORIES:");
        SAY("0:		Generic (also 14, 15 and 16)");
        SAY("1:		LFP macros");
	SAY("2:		Coord frame macros");
        SAY("3:		Reward macros (Jan) ");
        SAY("4:		Memory ");
        SAY("5:		Cue macros (?)");
        SAY("6:		Behavior");
        SAY("7:		Receptive fields");
	SAY("8,80:\t	Frames of reference");
	SAY("9:		Arm task");
	SAY("10:\t	Jeff's eye-arm experiments");
        SAY("11:\t	Novelty");
        SAY("12:\t	Stimulate (perturb memory)");
        SAY("13:\t	Muscimol (inactivation)");
        SAY("14,15,16:	More generics");
        SAY("16:\t	Generics re: touch panel");
	SAY("30:\t	Select trials in -w- call (e.g., for later lfp macro)");
        SAY("40-42:	fMRI macros");
	SAY("");
	SAY("For individual macros, use 'grab -M3', for example");
	break;
    }
 }
/* ********************************************************************	*/
/* FUNCTION Do_Macro */
	/* Pass in a character filename (some macros want it)		*/
	/* Return is used by sort macros with -w-: keep this trial?	*/

int Do_Macro(char *file) {
	int MatlabRedirectFlag = 0;

	/* For matlab calls, redirect stdout to 'matlab.stdout.logfile'	*/
	/*  There is a "-logfile" option for matlab, but it only COPIES */
	/*  the standard output; garbage still goes to the screen	*/
	/*  To do in lfp.c, need to pass 'file' to every lfp call  - ugh*/
	switch (MacroNumber) {
	   case  10: /* lfp.c	*/
	   case  11: /* lfp.c	*/
	   case  12: /* lfp.c	*/
	   case  13: /* lfp.c	*/
	   case  14: /* lfp.c	*/
	   case	 15: /* lfp.c	*/
	   case  16: /* lfp.c	*/
	   case  17: /* lfp.c	*/
	   case  18: /* lfp.c	*/
	   case  19: /* lfp.c	*/
	   case 211: /* lfp.c	*/
	   case 212: /* lfp.c	*/
	   case 213: /* lfp.c   */
	   case 215: /* lfp.c   */
	   case 311: /* lfp.c   */
	   case 216: /* lfp.c	*/
           {
	   char LogfileName[200];

	   if (strchr(file, '/'))		/* Complex path?	*/
	      sprintf(LogfileName, "matlab.stdout");
	    else				/* Local path           */
	      sprintf(LogfileName, "matlab.stdout.%s", file);
	   freopen(LogfileName, "w", stdout);	/* Redirect stdout      */
	   MatlabRedirectFlag = 1;
	   break;
	   }
	  }

	switch (MacroNumber) {
	   case -1:	/* Default value (invoked with -o, no number)	*/
	   case 0:  Write_OutputFiles0();	break;	/* print.c 	*/
	   case 1:  Write_OutputFiles1();	break;	/* print.c 	*/
	   case 2:  Write_OutputFiles2();	break;  /* print.c	*/
	   case 3:  Write_OutputFiles3();	break;  /* print.c	*/
	   case 4:  Ttest_macro4();		break;  /* ttest.c	*/
	   case 5:  Print_Behav5();		break;  /* printbehav.c	*/
	   case 6:  Ttest_macro6();		break;  /* ttest.c	*/
	   case 7:  Interval7();		break;  /* interval.c	*/
	   case 8:  Write_Targets8();		break;  /* targets.c	*/
	   case 9:  Print_Behav9();		break;  /* printbehav.c	*/

	   case  10: CoupleLFP10();		break;	/* lfp.c	*/    
	   case  11: PowerLFP11();		break;	/* lfp.c	*/
	   case  12: TimeSpikeLFP12();		break;	/* lfp.c	*/
	   case  13: CohSpikeLFP13();		break;	/* lfp.c	*/
	   case  14: PhasePairSpikeLFP14();	break;	/* lfp.c	*/
	   case	 15: PowerTrialsLFP15();	break;	/* lfp.c	*/
	   case  16: TimeLFP16();		break;	/* lfp.c	*/
	   case  17: PhasePairLFP17();		break;	/* lfp.c	*/
	   case  18: CorLFP18();		break;	/* lfp.c	*/
	   case  19: CohLFP19();		break;	/* lfp.c	*/
	   case 211: PowBurstLFP211();		break;	/* lfp.c	*/
	   case 212: PowTraceLFP212();		break;	/* lfp.c	*/
	   case 213: CohgramSpikeLFP213();	break;	/* lfp.c	*/
	   case 215: GrangerLFP215();          	break;  /* lfp.c	*/
	   case 311: MatchPursuitLFP311();	break;	/* lfp.c	*/
	   case 216: EvokedLFP216();		break;	/* lfp.c	*/
		/* See previous switch statement for more lfp stuff ...	 */

           case 20: Reference20();		break;	 /* reference.c	*/

           case 30: RewardBasics30();		break;	 /* basic.c	*/
           case 31: CodeByPrevAndCurrentClass31(); break; /* basic.c	*/

           case 40: MemoryExtract40();		break;	 /* extract.c	*/
           case 41: MemoryOnOff41();		break;	 /* extract.c	*/
           case 42: MemoryTimes42();		break;	 /* times.c	*/
           case 43: GetTuning43();		break;	 /* tuning.c	*/
           case 44: SortByTarget44();		break;	 /* memory/sort.c	*/

	   case 50: Success50();		break;	/* success.c	*/
	   case 51: Failure51();		break;	/* failure.c	*/
	   case 52: Success52();		break;	/* success.c	*/
		    
	   case 60: SacEndPoints60();		break;	/* sac_endpt.c	*/
	   case 63: Movement_times63(0);	break;	/* movement.c	*/
	   case 64: Movement_times63(1);	break;	/* movement.c	*/
	   case 65: Movement_times65();		break;	/* movement.c	*/

		    /* two graphics macros */
	   case 70: FlashFields70();		break;	/* flash.c	*/
	   case 71: Frame71();			break;	/* flash.c	*/

	   case 80: VestSensory80(file);	break;	/* frame.c	*/
	   case 81: VestMotor81(file);		break;	/* frame.c	*/
	   case 82: Frame82();			break;	/* frame.c	*/
	   case 83: FramePursue83();		break;	/* pursue.c	*/
	   case 84: Write_SacEndpts84(file);	break;  /* write_sac.c	*/
	   case 85: Write_SpikeCounts85(file);	break;  /* write_sac.c	*/
	   case 86: Write_SacDuration86(file);	break;  /* write_sac.c	*/
		    /* two (not 89?) graphics macros */
	   case 87: ROC87();			break;	/* roc.c	*/
	   case 88: ROC88();			break;	/* roc.c	*/
	   case 89: ROC89();			break;	/* roc.c	*/
	   case 801: Trial_Info801();		break;  /* trialinfo.c	*/

	   case 999:
   	   case 90:  BimanualTimes90(0);        break;   /* latency.c    */
   	   case 998: BimanualTimes90(1);        break;   /* latency.c    */
   	   case 997: BimanualTimes997(1);        break;   /* latency.c    */

	   case 100: TestArmVsEye100();		break;	/* intent.c	*/
	   case 101: JeffExportData101();	break;  /* exportdata.c */
	   case 102: TestDirections102();	break;  /* direction.c	*/
	   case 103: Test_yes103();		break;	/* test.c	*/
	   case 104: Test_no104();		break;	/* test.c	*/
	   case 105: GetBestClass105();		break;	/* getbestclass	*/
	   case 106: SplitByEffector106(file);	break;	/* split.c	*/
	   case 107: SplitByClass107(file);	break;	/* split.c	*/
	   case 108: SplitByTrialType108(file);	break;	/* split.c	*/
	   case 1061: SplitByEffector106(file);	break;	/* split.c	*/
	   case 1071: SplitByClass1071(file);	break;	/* split.c	*/
	   case 1081: SplitByTrialType1081(file); break; /* split.c	*/

	   case 110: Write_SacEndpts110(file);	break;	/* write_sac.c	*/
	   case 111: Write_SacEndpts111(file);	break;	/* write_sac.c	*/
	   case 1110: Write_SacEndpts1110(file);break;	/* write_sac.c	*/

	   case 120: Print_Behav120();		break;	/* printbehav.c	*/
	   case 121: Print_Stim121();		break;	/* printstim.c	*/
	   case 123: Movement_Times123();	break;	/* movement.c	*/
	   case 125: GetBestClass125();		break;	/* getbestclass.c   */
	   case 127: Interval127();		break;	/* interval.c   */
	   case 128: Print_Spikes128();		break;	/* interval.c   */
	   case 129: FindSaccades129();		break;	/* findsacs.c   */

	   case 130: Timing130();               break;  /* timing.c	*/  
	   case 131: Target131();               break;  /* target.c	*/  
	   case 132: SacTime132();              break;  /* sactime.c	*/  
	   case 133: SacBehave133();            break;  /* sacbehave.c	*/  
	   case 134: Errortype134();            break;  /* errortype.c	*/  

	   case 140: Print_Spikes140();		break;	/* print.c	*/
	   case 141: Print_SpikeTimes141(0);	break;	/* print.c	*/
	   case 1411: Print_SpikeTimes141(1);	break;	/* print.c	*/
	   case 142: Stats142();		break;	/* print.c	*/
	   case 152: CountSpikes152();		break;	/* print.c	*/
	   case 143: Print_Info143();		break;	/* print.c	*/
	   case 144: fprintf(stderr, "MAY NOT WORK - SEE 2018 CODE\n");
		     Anova_macro144();		break;	/* anova.c	*/
	   case 146: fprintf(stderr, "MAY NOT WORK - SEE 2018 CODE\n");
		     TwoWayAnova_macro146();	break;	/* anova.c	*/
	   case 145: Print_EventExtract145();	break;	/* print.c	*/
	   case 147: Print_EventExtract147();	break;	/* print.c	*/
	   case 148: Print_EventExtractAll148();break;	/* print.c	*/
	   case 150: Check_Bounds150();		break;	/* bounds.c	*/
	   case 155: Saccades155();		break;	/* saccade.c	*/
	   case 156: AnalogDataDump156();	break;	/* print.c	*/
	   case 161: PrintTouches161();		break;	/* touch2.c	*/
	   case 162: GetTrajectory162();	break;	/* touch2.c	*/


	   case 400: Write_Times400();		break;	/* write_times.c*/
 	   case 401: Write_Times_tpj401();      break;  /* write_times.c*/
	   case 402: Write_Times_monk402();     break;  /* write_times.c*/
	   case 405: CueTarg_Times405();	break;	/* write_times.c*/
	   case 406: Targ_Times_tpj406();	break;  /* write_times.c*/
	   case 407: Targ_Times_monk407();      break;  /* write_times.c*/
	   case 408: MR_Event_File408();  	break;  /* write_times.c*/
	   case 409: PSEvents_409();  		break;  /* write_times.c*/
	   case 410: Blink410();  		break;  /* events.c */
	   case 411: Saccade411();  		break;  /* events.c */
	   case 412: Pulse412();  		break;  /* events.c */
	   case 420: Sort420();  		break;  /* sort.c*/
	   case 430: MemorySaccades430();	break;  /* memsac2009.c*/
	   case 431: RunStartTime431();		break;  /* memsac2009.c*/
	   case 432: EventFileForMemory432();	break;  /* memsac2009.c*/
	   case 433: MemorySaccades433();	break;  /* memsac2009.c*/
	   case 440: Strabismus440();		break;  /* strabismus.c*/
	   case 450: RunStartTime450();		break;  /* memsac2011.c*/
	   case 451: MemoryEvents451();		break;  /* memsac2011.c*/
	   case 452: MemoryEvents452();		break;  /* memsac2011.c*/
	   case 453: MemoryAccuracy453();	break;  /* memsac2011.c*/
	   default:
		fprintf(stderr, "Cannot find macro %d\n", MacroNumber);
	   }

	if (MatlabRedirectFlag == 1)
	   fclose(stdout);        

	return(1);		/* Return value only used by 300 macros	*/
	}

/* ********************************************************************	*/


/* ********************************************************************	*/
/* ********************************************************************	*/
/* Common functions */

int CmdLine_Best_Direction = 0;		/* For CmdLine selection*/

/* FUNCTION Set_dataValue_From_CmdLine */
	/* Set particular class using -d option (usu is a direction)	*/
void Set_dataValue_From_CmdLine(int direction) {
	CmdLine_Best_Direction = direction;
	}
int Get_dataValue_From_CmdLine() {
	return(CmdLine_Best_Direction);
	}
/* ********************************************************************	*/

int CmdLine_DataValue = 0;			/* For CmdLine selection*/

/* FUNCTION Set_DataValue_From_CmdLine */
	/* Set particular class using -D option				*/
void Set_DataValue_From_CmdLine(int DataValue) {
	CmdLine_DataValue = DataValue;
	}
int Get_DataValue_From_CmdLine() {
	return(CmdLine_DataValue);
	}
/* ********************************************************************	*/

static int oValue[3][52];

void Clear_oValues() {
	int i, j;
	for (i=0; i<3; i++)
	  for (j=0; j<52; j++)
	    oValue[i][j] = FAIL;
	}
void Set_oValue(int number, char ch, int DataValue) {
	int code = (isupper(ch)!=0)*26 + tolower(ch)-'a';

	if (number < 1 || number > 3) 
           Exit("onumber requests must be 'tween 1 and 3", "Set_oValues");

        if (code < 0 || code > 52)
           Exit("CALL LARRY - oValue error!", "Set_oValues");

	oValue[number-1][code-1] = DataValue;
	}
int Get_oValue(int number, char ch, int Default) {
	int code = (isupper(ch)!=0)*26 + tolower(ch)-'a';

	if (number < 1 || number > 3) 
           Exit("onumber requests must be 'tween 1 and 3", "Set_oValues");

        if (code < 0 || code > 52)
           Exit("CALL LARRY - oValue error!", "Get_oValues");

	if (oValue[number-1][code-1] == FAIL)
	   return(Default);
	else
	   return(oValue[number-1][code-1]);
	}
/* ********************************************************************	*/

/* FUNCTION Open_Macro_Output */
	 /* Rationalize, or at least centralize, macro outputs. */
	/*   name: base name.  Null means stdout.
	 *   AddUnitRun: 
	 *     1: append unit & run
	 *     2: append 's' or 'f' followed by unit & run
	 *     0: do not append.
	 *    -1: use global setting
	 * GLOBAL SETTINGS:
	 *   MACRO_NAME_UNITRUN:  Same as AddUnitRun, except no -1
	 *   MACRO_APPENDS:
	 *     0: write a new file
	 *     1: append
	 *     2: stdout
	 */
FILE *Open_Macro_Output(char *name, int AddUnitRun) {
	FILE *file;
	char Name[180];

	if (name == NULL || MACRO_APPENDS==2) {
	   if (Graphics_Output) {		/* Whoops - can't do it	*/
	      file = fopen((name==NULL) ? "macro_output" : Name, "w");
	      fprintf(stderr,
		 "Cannot send macro output to stdout with graphical macro\n");
	      return(file);
	      }
	   return(stdout);
	   }

	if (AddUnitRun==0)
	   strncpy(Name, name, 180);
	else if (AddUnitRun==1 || MACRO_NAME_UNITRUN==1)
           sprintf(Name, "%s.%d.%d", 
			name, UnitNumber_Header(), RunNumber_Header());
	else if (AddUnitRun==2 || MACRO_NAME_UNITRUN==2)
           sprintf(Name, "%s.%c%d.%d", 
		   name,
		   (RunStatus_Header()==SUCCESS) ? 's' : 'f',
		   UnitNumber_Header(),
		   RunNumber_Header());
	else					/* Default is use name	*/
	   strncpy(Name, name, 180);

	file = fopen(Name, (MACRO_APPENDS)?"a":"w");

	if (file==NULL) {
	   fprintf(stderr, "Err opening %s", Name);
	   Exit("", "OpenMacroOutput");
	   }
	return(file);
	}
/* ********************************************************************	*/

