/* FILE list */
     /* Keep track of variables */
#include "deffs.h"

/* ********************************************************************	*/
/* FUNCTIONS:
     Init_Lists
     List_Ptr			Return pointer to sorted list
     List_Length		Return length of list
     List_Element		Return n-th element of stack i
     List_Append		Add 1 to each list
     List_Index			Look up things in sorted list
     Sort_Lists			Sort lists (called once by TrialTypes)
     Match_List			Does trialtype match list element?
 */


/* ********************************************************************	*/
#define MAX_LIST_LENGTH 200	/* [20] Max elements per stack; 10 enuf	*/
				/* increased from 24 12/10/03 RW */
				/* increased from 40 12/12/12 DK */
   /* Can drop back to 40 once we stop using the crazy new KD stacks */
static int List[MAX_LISTS][MAX_LIST_LENGTH];	/* See anal.h for which	*/
static int Length[MAX_LISTS];

/* ********************************************************************	*/

/* FUNCTION List_Length */
/* FUNCTION List_Element */
	 /* Return pointer or length or element of specified list	*/
int  List_Length (int list)       { return(Length[list]); }
int  List_Element(int n, int list) { return(List[list][n]); }
/* ********************************************************************	*/

/* FUNCTION Init_Lists */
void Init_Lists() {
        int i = -1;
	while (++i < MAX_LISTS) {
	   int j;
	   for (j=0; j<MAX_LIST_LENGTH; j++)
	       List[i][j] = 0;	/* Shouldn't need this, but if do multiple
				   files, get odd results without it!	*/
	   Length[i] = 0;
	   }
	}
/* ********************************************************************	*/

/* FUNCTION List_Append */
	 /* Given ptr to MAX_LIST ints, append each to each list	*/
void List_Append(int new[]) {
	int j;
	for (j=0; j<MAX_LISTS; j++)
	   if (List_Index(new[j], j) == 0) {
	      if (Length[j] < MAX_LIST_LENGTH-1)
	       List[j][Length[j]++] = new[j];
	      else if (j != ORDER)
	       fprintf(stderr, "Oh no! Make 'MAX_LIST_LENGTH' larger (list %d)!\n", j);
	      }
	}
/* ********************************************************************	*/

/* FUNCTION Sort_Lists */
	/* Local: sorts lists of variables so can lookup fig location	*/
void Sort_Lists() {
       int i, j, k;

       for (k=0; k<MAX_LISTS; k++) {
	  i = -1;
          while (++i < Length[k] - 1)
	    for (j=i+1; j<Length[k]; j++)
		if (List[k][i] > List[k][j]) {
		    int temp = List[k][i];
		    List[k][i] = List[k][j];
		    List[k][j] = temp;
		    }
          }
       }
/* ********************************************************************	*/

/* FUNCTION List_Index */
	 /* Return location (1:limit) or, if not found, 0	*/
int List_Index(int find, int list) {
   int i = -1;

   while (++i < Length[list])
      if (List[list][i] == find)
	  return(1+i);
   return(0);
   }
/* ********************************************************************	*/

/* FUNCTION Match_List */
int Match_List(int trialtype, int list, int n) {
	return( Get_TrialType_Info(trialtype, list) == List_Element(n, list));
	}
/* ********************************************************************	*/
