/* FILE input */
     /* Input data for analysis, fill header, Data(analog),Spikes,Touches*/
     /* NOTE: Throw away data that won't be used, ie, before start time,
	      after DurationTime().  (Bad idea: get edge effects!)	*/

#include "deffs.h"
#include "ad.h"						/* DEGtoAD	*/
#include <fcntl.h>					/* Open/close	*/
#include <string.h>					/* strcpy()	*/
#include <stdlib.h>					/* system()abs()*/
#include <unistd.h>					/* lseek arg's	*/
#include "config.h"					/* FITLER_EYES	*/
#include "filter.c"					/* Filter code	*/
/* ********************************************************************	*/
/* PUBLIC:
	Rewind_InputFile	Back to beginning
	TrialNumber_Input	Not counting fails and no-starts
	FileName_Input		Copy of the file name
	Open_InputFile		Open file
	Get_InputFile		Returns descriptor (for output.c)
	Read_Next_Trial		Read next header, read or skip data
	Read_Next_Trial_Absolute  Read next header, read or skip data
	Read_Skipped_Data	Having just skipped over it!
	Close_InputFile		Close file
	Exit			Exit program
	Read_Trial		Go directly to absolute trial number
	UnRead_Data
	Skip_Over_Data		Having read header, skip over data
	Keep_All_Data		Do not truncate to same duration at end
 * PRIVATE:
	Read_Analog
	Read_Spikes
	Read_Touches		Just time of touch/release (analog screen)
	Read_Buttons		Actuators other than the touch screen
	Read_Final		Anything to do after ALL is read in?
 */
/* ********************************************************************	*/

#define DEBUG		0			/* -1: lseek in ReadNext*/
						/*  1: std (print stuff)*/
						/*  2: lseek in Skip_Ovr*/
						/* -3: print raw touches*/

short Data[MAX_FRAMES*MAX_CHANNELS];		/* Recent analog data	*/
short Touch1[MAX_FRAMES*2];			/* H and V arm data	*/
short TouchWidth1[MAX_FRAMES*2];		/* H and V arm data	*/
short Touch2[MAX_FRAMES*2];			/* H and V arm data	*/
short TouchWidth2[MAX_FRAMES*2];		/* H and V arm data	*/
short Spikes[MAX_SPIKES];			/* Recent spike times	*/
ARMDATA ArmData1[MAX_SWITCHES];			/* Arm position data	*/
ARMDATA ArmData2[MAX_SWITCHES];			/* Arm position data	*/
BUTTONS Buttons[MAX_BUTTONS];			/* Button presses	*/

int KEEP_ALL_DATA = 0;				/* See call		*/

static int File;				/* INPUT FILE DESCRIPTOR*/
static int TrialNumber;
static int SkippedData = 0;			/* Boolean		*/

static long LastDataAddress;

static	int HaveNotWarned = 1;

static char SaveFileName[181];

static void Read_Analog();
static void Read_Spikes();
static void Read_Touches();
static void Read_Buttons();
static void Read_Final();
/* ********************************************************************	*/

/* FUNCTION Rewind_InputFile */
void Rewind_InputFile() {
    TrialNumber = 0;
    lseek(File, 0, SEEK_SET);
    }
/* ********************************************************************	*/

/* FUNCTION TrialNumber_Input */
int TrialNumber_Input() { return(TrialNumber); }
/* FUNCTION FileName_Input */
char *FileName_Input() { return(SaveFileName); }
/* ********************************************************************	*/

/* FUNCTION Open_InputFile */
	 /* And maybe read first header	*/
int Open_InputFile(char *inputfile) {
   strncpy(SaveFileName, inputfile, 180);
   if (*inputfile == '-') {
      fprintf(stderr, "Trying to open file <%s>\n", inputfile);
      Exit("Try reordering options, e.g., none after -R\n", "Open_InputFile");
      }
   TrialNumber = 0;
   HaveNotWarned = 1;
   File = open(inputfile, O_RDONLY);
   if (File == -1) {				/* Perhaps compressed?	*/
      char CmdLine[120];
      int unused;
      sprintf(CmdLine, "gunzip %s", inputfile);
      unused = system(CmdLine);
      if (unused == 2 * unused) unused = 0;	/* block an error	*/
      File = open(inputfile, O_RDONLY);
      }
      
   if (File == -1) {
      fprintf(stderr, "Cannot open <%s>\n", inputfile);
      return(-1);
      }
   /* Read_Header(File);			* Read 1st header	*/
   /* Rewind_InputFile();			*			*/

   Init_CalibFile(inputfile);			/* Force it to read anew*/
   return(File);				/* Tests for -1		*/
   }
/* ********************************************************************	*/

/* FUNCTION Get_InputFile */
int Get_InputFile() { return(File); }

/* FUNCTION Keep_All_Data */
	 /* Not really: just analog data past the common end point	*/
void Keep_All_Data() {
     KEEP_ALL_DATA = 1;
     }
/* ********************************************************************	*/

/* FUNCTION Read_Analog */
	 /* All but 1st frame are (char) deltas; 1st frame is ints	*/
	 /* First sample stored is at time of latest TapeOn, re: align	*/
	 /* Convert to absolute AD values 				*/
	 /* Leave space for arm data					*/
static void Read_Analog() {
	short *now = Data;			/* WRITE ptr: this frame*/
	short *prev = Data;			/* READ  ptr: last frame*/
	int i,j;
	int channels = ChannelCount_Header();		/* Read # chans	*/
	int FramesRecorded = FrameCount_Header();
	int SkipFrames = SkipAnalogTime() / MsPerFrame_Header();
	int KeepFrames = DurationTime() / MsPerFrame_Header();
	 /* Extra frames will be there, but the header says they aren't	*/

	if (KEEP_ALL_DATA)
	   KeepFrames = FramesRecorded-SkipFrames; /* dangerous!	*/

	if (DEBUG > 0)
	  fprintf(stderr,"%d:  Duration %d; frames %d (was %d)\n",
	   TrialNumber,DurationTime(),FrameCount_Header(), FramesRecorded);

	if (FramesRecorded <= 0) {
	   if (FramesRecorded < -3 && HaveNotWarned) {
	      Warning("Negative frames recorded (wrapped!)");
	      HaveNotWarned = 0;
	      }
	   return;
	   }
	if (channels > MAX_CHANNELS)
	   Exit("Increase MAX_CHANNELS", "Read_Analog()");
	if (FramesRecorded >= MAX_FRAMES) {
	   fprintf(stderr, "%d frames\n", FramesRecorded);
	   Exit("Increase MAX_FRAMES", "Read_Analog()");
	   }

	if (SkipFrames < 0) {
	   static int Warned = 0;
	   for (i=0; i<channels; i++)   /* Skip<0 --> unskip, or ADD!   */
	       *(now++) = -100;          /* Add null data to stream      */
	   if (Warned == 0) {                   /* Just once per session*/
	       Warning("data frame begins before analog data");
	       fprintf(stderr, "   (SkipAnalogTime is %d)\n", SkipAnalogTime());
	       Warned = 1;
	       if (Flag_Header(DELTA_WRITE) == 0)
	          Exit("Not yet written to handle\n", "Read_Analog()");
	       }
	   }

	Read_CalibFile(CalibFile_Header());
	Set_FrameCount_Header(KeepFrames);		/* Update header*/

	LastDataAddress = lseek(File, 0, SEEK_CUR);	/* Store current*/

	if (Flag_Header(DELTA_WRITE)) {
	   short FrameZero[MAX_CHANNELS];	/* frame  1:   ints	*/
	   char RawAnalog[MAX_FRAMES*MAX_CHANNELS]; /*frames 2-$:chars	*/
	   char *raw = RawAnalog;		/* READ  ptr: this frame*/

	   read(File, FrameZero, channels*sizeof(short)); /* Read ints	*/
	   read(File, RawAnalog, (FramesRecorded-1)*channels); /*chars	*/

	   for (i=0; i<channels; i++)			/* Get frame 1	*/
	        *(now+i) = FrameZero[i] - 2048;

	   now += channels;			/* Move to frame 2	*/
	   for (j=2; j<=FramesRecorded; j++)	/* Get/calc frames 2-$	*/
	      for (i=0; i<channels; i++)
	         *(now++) = *(prev++) + *(raw++);
	 } else {				/* abs value (vs deltas)*/
	   read(File, now, FramesRecorded*channels*sizeof(short));
	   for (i=0; i<FramesRecorded*channels; i++)
	        *(now+i) -= 2048;
	   }

	if (FILTER_EYES)
	   Filter(Data, FramesRecorded, channels);

	if (SkipFrames > 0) {
	   now = Data;
	   for (i=0; i<FramesRecorded*channels; i++)
	      *(now+i) = *(now+i+SkipFrames*channels);
	   }

	now = Data;				/* Reset pointer	*/
	for (i=0; i<KeepFrames; i++) {		/* Walk thru frames	*/
	    Do_Calibration(now, channels, i);
	    now += channels;
	    }
	if (REMOVE_BLINKS==1)			/* Rm by checking trace	*/
	   RemoveBlinks1();	
	}
/* ********************************************************************	*/
/* FUNCTION Read_Final */
	 /* After reading everything, is there more to do?		*/
static void Read_Final() {
	if (REMOVE_BLINKS > 1)
	   RemoveBlinks2();	/* Needs analog & buttons, so do LAST!	*/
	if (REMOVE_BLINKS==3)	/* Remove BOTH based on TTL7 and trace	*/
	   RemoveBlinks1();	
	}
/* ********************************************************************	*/
#define CUMULATE_SPIKES			0
	/* Deltas, units of 0.4096, versus absolute timing	*/

short RawSpikes[MAX_SPIKES];

# if CUMULATE_SPIKES
#   define MS(raw_time)	 ((short) ((raw_time) * 0.4096 + .5))	/* Rounded*/
#   define INVERSE(time) ((short) (((time) + .2) / .4096))	/* Rounded*/
# else
#   define MS(raw_time) raw_time
#   define INVERSE(time) time
# endif

/* FUNCTION Read_Spikes */
	 /* Convert to cumulative spike time in ms, minus begin	*/
static void Read_Spikes() {
	int UnitChannel = Get_UnitChannel_Header();
        int spikes = SpikeCount_Header(0);
	int SkipTime = SkipSpikeTime();		/* Align data	*/
	int SkipUnits = INVERSE(SkipTime);		/* In units	*/
	int EndOfTrial = INVERSE(SkipTime+DurationTime());  /* units	*/

	short *raw = RawSpikes;			/* Pt to RawSpikes[] */
	short *cooked = Spikes;			/* Pt to Spikes[]    */
	int i,j;


	for (i=0; i<=UnitChannel; i++) {
           spikes = SpikeCount_Header(i);
           j = read(File,(char *)raw, spikes * sizeof(short)); /* Read raw*/
	   if (j != spikes * sizeof(short))
	      Exit("Unexpected EOF 2","Read_Spikes()");	/* Never happens*/
	   }

	if (spikes == 0)
	   goto END;				/* Zero spikes, really	*/

# 	if (CUMULATE_SPIKES)
	   for (i=1; i<spikes; i++, raw++)	/* Cumulate		*/
	       *(raw+1) += *raw;
# 	endif

	raw = RawSpikes - 1;			/* Find 1st spike> Begin*/
	for (i=0; i<spikes; i++)
	    if (*(++raw) > SkipUnits)
		break;
	Set_SpikeCount_Header(spikes -= i);	/* Ignore if not taped	*/
	if (spikes == 0)			/* Any spikes left?	*/
	   goto END;				/* Zero spikes, really	*/

	for (i=0; i<spikes; i++) {
	     if (*raw > EndOfTrial)
		break;
	     *(cooked++) = MS(*(raw++)) - SkipTime; /* Save aligned time*/
	     }

	END:
	if (i < spikes)			/* Spikes at end skipped?	*/
	    Set_SpikeCount_Header(i);		/* OK, let us know	*/

        while (++UnitChannel < 4)	/* Skip over all the others	*/
	  lseek(File, SpikeCount_Header(UnitChannel) * sizeof(short), SEEK_CUR);
	    
        return;
	}
/* ********************************************************************	*/
# define RADStoAD(x)	((short)rint(x*360 / (2*3.14159) * 20))

#	define H_CENTER		(2*48)
#	define V_CENTER		(2*48)
#	define H_CALIB(x) RADStoAD(atan((double) x * (6.75/4) / dist))
#	define V_CALIB(x) RADStoAD(atan((double) x * (6.75/4) / dist))


/* FUNCTION Read_Touches */
   /* Optical touch screen: offset by SkipSpikeTime() & fill structure	*/ 
static void Read_Touches(int board) {
     short touches  = TouchCount_Header(board);
     int MsPerFrame = MsPerFrame_Header();
     int SkipTime   = SkipSpikeTime();		/* Align data		*/
     int EndTime    = FrameCount_Header() * MsPerFrame;
     int PrevTime   = 1;
     ARMDATA *In = (board==1) ? ArmData1 : ArmData2;	/* Read pointer	*/
     short  *Out = (board==1) ? Touch1   : Touch2;	/* Write pointer*/
     short *WidthOut= (board==1) ? TouchWidth1:TouchWidth2; /* Write ptr*/
     int Touching; 				/* Touch or release?	*/
     int Time = -1;
     int i,j;
     int dist = Get_ViewingDistance_Header();

     if (touches > MAX_SWITCHES) {
	fprintf(stderr, "%d touches on board %d, trial %d\n",
		       				touches, board, TrialNumber);
        Exit("Too many touches", "Read_Touches()");
        }

     if (touches < 1) {			/* No touches: arm not recorded	*/
     /* Exit("Missing 1st (fake) touch", "Read_Touches()");     * Never	*/
	return;
        }

     if (read(File, In, touches*sizeof(ARMDATA)) !=
	   touches*sizeof(ARMDATA))		/* Read remaining data	*/
	 Exit("Unexpected EOF (1)", "Read_Touches()");    /* Never	*/
     if (DEBUG==-3) 
       for (i=0; i<touches; i++)
         fprintf(stderr, "DEBUG:  %d:  %d %d   %d ms\n",
            i, (In+i)->h, (In+i)->v, (In+i)->time);

     if (dist == 0) {	/* If long stack name, could be non-0 nonsense!	*/
			/* Check for unterminated name or check date?	*/
	if (Get_SetupNumber_Header() == 1)
           dist = 160;
	 else
	   dist = 300;
        }

     if (In->h != -1 || In->v != -1)
	Exit("Unexpected touch data", "Read_Touches()");    /* Never	*/

     if (touches > 1) {		/* More than just 1st fake touch?	*/
        In->h = (In+1)->h;	/* Make 1st same as 2nd		*/
        In->v = (In+1)->v;	/* Since 1st wasn't real ("-1")	*/
      } else
        In->h = In->v = 0;   /* Make 1st a 'no touch'	*/

     for (; touches > 0; touches--, In++) {
        Touching = In->h != 0 && In->v != 0;	/* Touch or release?	*/
	Time = (touches == 1) ?			/* Last touch event?	*/
	   EndTime : (In+1)->time - SkipTime;	/* Time of next event	*/

	if (Time < 0)
	   continue;

	if (Time > EndTime)			/* To end of trial	*/
	    Time = EndTime;

	if (Touching) {
	   In->h = abs(In->h) - H_CENTER;	/* abs: wide touch: <0	*/
	   In->v = abs(In->v) - V_CENTER;
	 } else {
	   In->h = In->v = NO_TOUCH;	/* Short so can't use FAIL	*/
	   In->h_width = In->v_width = 0;
	   }
	while (Time > PrevTime) {
	   if (Touching) {
	      *(Out++) = H_CALIB(In->h);
	      *(Out++) = V_CALIB(In->v);
	      *(WidthOut++) = H_CALIB(In->h_width);
	      *(WidthOut++) = V_CALIB(In->v_width);
	    } else {
	      *(Out++) = (short) NO_TOUCH;
	      *(Out++) = (short) NO_TOUCH;
	      *(WidthOut++) = 0; /* (short) NO_TOUCH; */
	      *(WidthOut++) = 0; /* (short) NO_TOUCH; */
	      }
	   PrevTime += MsPerFrame;
	   }
        }

     	/* Limited it to board 1 on 3-31-09 */
     if (SkipTime && board==1) {		/* Else don't bother	*/
        In = (board==1) ? ArmData1 : ArmData2;	/* Read pointer	*/
        touches = TouchCount_Header(board) - 1;
        for (i=0; i<touches; i++)
	    if ((In+i)->time >= SkipTime)
	       break;
	*In = *(In+i-1);
	In->time = 0;
        for (j=1; i<touches; j++,i++) {	/* Shift over & correct time	*/
	    *(In+j) = *(In+i);
	    (In+j)->time -= SkipTime;
	    }
        Set_TouchCount_Header(board, j);	/* At least one less	*/
        }

     return;
     }
/* ********************************************************************	*/

/* FUNCTION Read_Buttons */
	 /* NOT the touch screen. Ought to offset by SkipSpikeTime()?	*/
static void Read_Buttons() {
   int buttons = ButtonCount_Header();
   long int count = 0;				/* For diagnostics	*/

   if (buttons < 0) {
      fprintf(stderr, "Correcting button count in trial %d: %d", 
		      	TrialNumber_Input(), buttons);
      buttons += 65536;			/* correct wrap by adding 2^16	*/
      fprintf(stderr, "--> %d\n", buttons);
      lseek(File, (long) buttons * sizeof(BUTTONS), SEEK_CUR);	/* Skip bad*/
      buttons = 0;
      Set_ButtonCount_Header(buttons);
      fprintf(stderr, "Advise 'grab -w-' to correct button count err\n");
      }

   if (buttons >= MAX_BUTTONS-2) {
       fprintf(stderr, "Too many 'buttons' (%d)\n", buttons);
       Exit("Overflow", "Read_Buttons");
       }

   if ((count = read(File, Buttons, buttons*sizeof(BUTTONS))) !=
	   buttons*sizeof(BUTTONS)) {
	fprintf(stderr, 
	   "Unexpected EOF in Read_Buttons (%d*%d=%d, got %ld): try repair!\n",
	    buttons, sizeof(BUTTONS), buttons * sizeof(BUTTONS), count);

# define  REPAIR_BY_ELIMINATING  0
#       if (REPAIR_BY_ELIMINATING)
        lseek(File, count - (long) buttons * sizeof(BUTTONS), SEEK_CUR);
        Set_ButtonCount_Header(0);
#	endif
	}

#ifndef NEEDED_FOR_ERIC_2012_BUTTON_PROBLEM
   if (Get_SetupNumber_Header() == 7 &&
       Year_From_Header() == 2012 &&
       Month_From_Header() >= 10 &&
       Month_From_Header() <= 11) {
      int i;
      for (i=0; i<buttons; i++)
          if (Buttons[i].value == 0xFFFF)
              Buttons[i].value = 0;
           else
              Buttons[i].value &= 0x3FFF;
      }
#endif 

#ifdef CAUSES_TROUBLE
   /* If we throw out out-of-range button presses, then the fMRI timing
      of machine pulses gets messed up. */
   int SkipTime = SkipSpikeTime();		/* Align data		*/
   if (SkipTime) {
        int i,j;

	for (i=0; i<buttons; i++)
	   if (Buttons[i].time > SkipTime)
	      break;
	for (j=0; i<buttons; j++,i++) {	/* Shift over & correct time	*/
	   /* fprintf(stderr, "DEBUG: %d -> ", Buttons[i].time); */
	   Buttons[j].time = Buttons[i].time - SkipTime; /* Adjust time	*/
	   Buttons[j].value= Buttons[i].value;
	   }

	if (j != buttons)			/* Out of range touches?*/
	    Set_ButtonCount_Header(j);		/* OK, let us know	*/
	}
#endif
   }
/* ********************************************************************	*/

/* FUNCTION Read_Next_Trial */
	 /* Read header and data; fill data structures for export	*/
int Read_Next_Trial(int SkipDataFlag) {
   if (Read_Header(File) == 0)
      return(0);

   while (SkipTrial(++TrialNumber)) {
      Skip_Over_Data();		/* Must read header before call!*/
      if (Read_Header(File) == 0)
         return(0);
      }

   if (SkipDataFlag) {
       Skip_Over_Data();
       SkippedData = 1;
   } else {
       if (DEBUG==-1) fprintf(stderr, "end header: %ld\n", lseek(File,0L,1));
       Read_Analog();
       if (DEBUG==-1) fprintf(stderr, "end analog: %ld\n", lseek(File,0L,1));
       Read_Spikes();			/* Reconcile with AD data timing*/
       if (DEBUG==-1) fprintf(stderr, "end spikes: %ld\n", lseek(File,0L,1));
       Read_Touches(1);			/* Reconcile with AD data timing*/
       if (DEBUG==-1) fprintf(stderr, "end touches1: %ld\n", lseek(File,0L,1));
       Read_Touches(2);			/* Reconcile with AD data timing*/
       if (DEBUG==-1) fprintf(stderr, "end touches2: %ld\n", lseek(File,0L,1));
       Read_Buttons();			/* Reconcile with AD data timing*/
       Read_Final();
       if (DEBUG==-1) fprintf(stderr, "end buttons: %ld\n", lseek(File,0L,1));
       SkippedData = 0;
       }
   return(TrialNumber);
   }
/* ********************************************************************	*/

/* FUNCTION SizeOfTouch */
static int SizeofTouch() { 
	return(sizeof(ARMDATA));
	}
/* ********************************************************************	*/

/* FUNCTION Skip_Over_Data */
	 /* Faster than reading it in.  Must already have read header.	*/
	 /*  (Used locally and by main.c, with write file and macro)	*/
void Skip_Over_Data() {
	int channels = ChannelCount_Header();
	int ButtonCount = ButtonCount_Header();	/* err: wrapped count	*/
	int i;

	if (ButtonCount < 0) {
	    fprintf(stderr, "Correcting wrapped button count: %d", ButtonCount);
	    ButtonCount += 65536;	/* correct wrap by adding 2^16	*/
	    fprintf(stderr, "--> %d\n", ButtonCount);
	    }

	LastDataAddress = lseek(File, 0, SEEK_CUR);	/* Store current*/

	if (DEBUG > 0) {
	 fprintf(stderr,
" Skip %d chnnls, %d frms, %d+%d+%d+%d spkes, %d+%d touches, %d bttns = %d bytes\n",
	  channels, FrameCount_Header(), SpikeCount_Header(0),
	SpikeCount_Header(1), SpikeCount_Header(2), SpikeCount_Header(3), 
	TouchCount_Header(1), TouchCount_Header(2),
	ButtonCount_Header(),
	 ((FrameCount_Header() > 0) ? 
	     ((Flag_Header(DELTA_WRITE)) ?   
	            channels*(sizeof(short) + (FrameCount_Header()-1))
	            : channels*sizeof(short)*FrameCount_Header())
		 : 0) +
	     SpikeCount_Header(0) * sizeof(short) +
	     SpikeCount_Header(1) * sizeof(short) +
	     SpikeCount_Header(2) * sizeof(short) +
	     SpikeCount_Header(3) * sizeof(short) +
	     TouchCount_Header(1) * SizeofTouch() +
	     TouchCount_Header(2) * SizeofTouch() +
	     ButtonCount * sizeof(BUTTONS));
	 }

	if (DEBUG==2)
           fprintf(stderr, "   About to read analog; at %ld\n",
	   					lseek(File, 0, 1));
	if (FrameCount_Header() > 0) {
	   if (Flag_Header(DELTA_WRITE)) {
	      lseek(File, channels*sizeof(short), SEEK_CUR); /*1st frame*/
	      lseek(File, (FrameCount_Header()-1)*channels, SEEK_CUR);
	    } else
	      lseek(File, FrameCount_Header()*channels*sizeof(short), SEEK_CUR);
	   }

	if (DEBUG==2)
	   fprintf(stderr, "   read analog; at %ld\n", lseek(File, 0, 1));

	for (i=0; i<4; i++) {
  	   lseek(File, SpikeCount_Header(i) * sizeof(short), SEEK_CUR);
	   if (DEBUG==2)
	      fprintf(stderr, "   read spikes%d; at %ld\n",
			      			i, lseek(File, 0, 1));
	   }

	lseek(File, TouchCount_Header(1) * SizeofTouch(), SEEK_CUR);
	if (DEBUG==2)
	   fprintf(stderr, "   read switches; at %ld\n", lseek(File, 0, 1));

	lseek(File, TouchCount_Header(2) * SizeofTouch(), SEEK_CUR);
	if (DEBUG==2)
	   fprintf(stderr, "   read switches2; at %ld\n", lseek(File, 0, 1));

	lseek(File, ButtonCount * sizeof(BUTTONS), SEEK_CUR);
	if (DEBUG==2)
	   fprintf(stderr, "   read buttons; at %ld\n", lseek(File, 0, 1));
	}
/* ********************************************************************	*/

/* FUNCTION Read_Skipped_Data */
	 /* Rare event: want skipped analog data!  Back up and read!	*/
short *Read_Skipped_Data() {
        if (SkippedData == 0)			/* Didn't skip it!	*/
	   return(Data);
	UnRead_Data();				/* Back up first	*/
        Read_Analog();				/* Now reread (& calib)	*/
        Read_Spikes();			/* Reconcile with AD data timing*/
        Read_Touches(1);		/* Reconcile with AD data timing*/
        Read_Touches(2);
	Read_Buttons();			/* */
	SkippedData = 0;
	Read_Final();
	return(Data);
	}
/* ********************************************************************	*/

/* FUNCTION UnRead_Data */
void UnRead_Data() {
	lseek(File, LastDataAddress, SEEK_SET);
	UnRead_Header(File);	/* Reading data changes header values	*/
	Read_Header(File);	/* Restore original values!		*/
	}
/* ********************************************************************	*/

/* FUNCTION Close_InputFile */
void Close_InputFile() {
	close(File);
	}
/* ********************************************************************	*/

/* FUNCTION Exit */
void Exit(char *string, char *name) {
	Warning("");
	fprintf(stderr, "FATAL ERR: %s (in %s)\n", string, name);
	/* closepl(); */
	_exit(0);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Read_Trial */
	 /* Go directly to trial # (COUNTING excluded trials!) */
int Read_Trial(int number) {
   Rewind_InputFile();

   TrialNumber = number;		/* This is what it WILL be	*/
   while (--number >= 1) {		/* Stop just wanted trial	*/
      if (Read_Header(File) == 0)
         return(FAIL);
       Skip_Over_Data();		/* Must read header before call!*/
       }

   if (Read_Header(File) == 0)		/* Read wanted header		*/
      return(FAIL);

   Read_Analog();			/* Read wanted data		*/
   Read_Spikes();
   Read_Touches(1);
   Read_Touches(2);
   Read_Buttons();			/* */
   /* NOTE: could do while loop thru '>= 0', then "Read_Skipped_Data()",
      but this has subtle screw-up on data timing/aligment		*/

   return(0);
   }
/* ********************************************************************	*/
/* ********************************************************************	*/
