/* FILE help.c */
     /* Print out short or long help */
#include "deffs.h"
#include "config.h"

# define SAY(this)	{ fputs(this, stdout); fputc('\n', stdout); }
/* ********************************************************************	*/

/* FUNCTION Print_Usage */
void Print_Usage() {
   SAY("USAGE: grab -options file_name(s)       < to analyze >");
   SAY("       grab -H{option}			< for help >");
   fprintf(stdout,
      "       %d types, %sshow details, %sshow singles, height=%d\n\n",
      MAX_TYPES,(FAST_FIGURE)?"do not":"",(SHOW_SINGLES)?"":"do not ", HEIGHT);

   SAY("Graphics options:");
   SAY("    Indi trials         g#		Title			T");
   SAY("    Alignment		a		Histogram scaling	h");
   SAY("    Time interval	t		Layout			L");
   SAY("    Summary plot (variance, or polar)	G#");
   SAY("                         	        Interval to sum over	I i");
   SAY("                         	        Do not fill histos	f");
   SAY("    Rasters/switches	r/s		Draw vertical line	l");
   SAY("    Each single trial	e               Zoom (sort of)		z");
   SAY("    Open own window	W");
   SAY("Text options:");
   SAY("    Macro ascii ouput	o d		Info on each trial	R");
   SAY("    Print switch times	s		Header config/stack     c/C/S");
   SAY("    Set unit/run number C");
   SAY("Misc options:");
   SAY("    Use command file	b		Exclude/include trials	x/X");
   SAY("    Detailed help	H		Merge stuff		m");
   SAY("    Print config params	C		Write out data		w O");
   SAY("    Print macros	M		Unit channel #		u");
   SAY("");
   }
/* ********************************************************************	*/

/* FUNCTION Print_Help */
void Print_Help(char what) {

if (what >= 'A' && what <= 'Z')
    what = what - 'A' + 'a';

switch (what) {

case 'a':
   SAY("-a[#*]EVENT.[OCCUR]               N-th occurrence of specific event");
   SAY("-a[#*]EVENT[OCCUR]                Short-hand, same as previous");
   SAY("-a[#*]EVENT t [TARGET][.OCCUR#]   N-th event with specific target");
   SAY("-a[#*]a [at][BEHAV][.OCCUR]           BEHAV is 'a' or 'e'");
   SAY("-a[#*]RESPONSE t/T/b/B/a/o/O/u [TARGET] [. OCCUR]");
   SAY("           Align on specific response, occurring before/after the nth");
   SAY("        event, assoc'd with particular target (or, for 'o', TTL line)");
   SAY("  For RESPONSE == K or k, can append '_4' for bit pattern 4");
   SAY("-a [Xx]  On err, abort (X:default) or just exclude the trial (x)");
   SAY("                 (-ax is implied by a -w argument)");
   SAY("");
   SAY("'#': Applies to just one stack (-a#200t2: align stack 200 on 2nd targ");
   SAY("");
SAY(" *** EVENTS ***");
SAY("a   Acquire event          b/B  Blank on/off         d/D  Delay begin/end");
SAY("e/E Electrical micro stim    G  ARM_PATTERN_ACQ      H/I  BUTTONACQ_AND/OR");
SAY("N   New background color   o/O  TTL on/off           p/P  Pursuit on/off");
SAY("q/Q Bitmap on/off          r/R  Record (Tape) on/off t/T  Target on/off");
SAY("w/W  Whole-body rotate       u   Redraw");
SAY(" *** RESPONSES ***");
SAY("c/C  Contact on/off      m  Start of arm movement   k/K key press/release");
SAY("s/S  Saccade begin/end   v  Peak saccade velocity   y/Y You name it!");
   SAY("");
   SAY("TARGET #: 0 thru MAX_TARGS-1");
   SAY("OCCUR  #: 1-20   Occurrence number for specified event <default: 1>");
   SAY("          $      Last occurrence");
   SAY("          \\$-1   Second to last occurrence (protect '$')");
   SAY("");
   SAY(" -ab2	  Align on 2nd blank on event");
   SAY(" -abt3	       first blanking of target 3");
   SAY(" -abt3.2       2nd blanking of target 3");
   SAY(" -avt3    Align on peak veloc of 1st sac - after 1st target 3 on");
   SAY(" -avt3.2      - after 2nd target 3 on");
   SAY(" -avt.2       - after 2nd target on (any)");
   SAY(" -avB3.2      - after 2nd targ 3 blank off");
   SAY(" -ava1.2      - BEFORE 2nd acq of target 1");
   SAY(" -ava.2       - BEFORE 2nd acq of ANY target");
   SAY(" -ava.$       - BEFORE last acq of ANY target - does not work");
   SAY(" -ava.\\$-1    - BEFORE 2nd to last acq of ANY target - does not work");
   SAY(" -ava3.2      - BEFORE 2nd acq of target 3");
   SAY("-a RESPONSE [+-] [tTbBa] TARGET . [OCCUR#]");
   SAY("   -   Look BACKWARDS from specified event (default for all but a)");
   SAY("   +   Look FORWARDS from n-th acq for next sac (default for a)");
   SAY(" -av-t3.2     peak vel of sac BEFORE 2nd targ 3 onset");
   SAY(" -av+a3.2     peak vel of sac AFTER  2nd acq of targ 3");
   SAY(" -ao3.2       turning on of TTL line 3 on the second time");
   SAY(" -avo3.2      peak vel of sac after 2nd onset of TTL line 3");
   SAY(" -aYReward.2  2nd reward event");
   SAY(" -aKb2.3_4    key release, bit pattern 4, after 3rd occur of targ 2");
   SAY("");
   SAY(" Possible bug: -ae or -as can't PRECEED a '-t' argument?");
   SAY(" -a behaves differently when combined with -w; see -w");
   break;
case 'b':
   SAY("BATCH FILE:");
   SAY("-bfilename	   Command line contains file of list of files to do");
   SAY("                    File may be followed by local arguments");
   SAY("		    e.g.,     'S62.1  -x33:35'");
   SAY("-b		   Use 'FileList'");
   SAY("   notes:  Can put comments AFTER files & options in batchfiles");
   SAY("           but not alone on a line.  No blank lines, but can have");
   SAY("	   comment lines (first char of line is '#'). (Last line");
   SAY("	   cannot be a comment - add an empty line at the end.");
   SAY("	   Generates warning but runs.)");
   SAY("	      If use '-mf', cannot have options (or any white space)");
   SAY("	   in the batch file.");
   SAY("              Most options reset (especially -x, -m), but layout,");
   SAY("           alignment, interval, and times are NOT reset.  You");
   SAY("	   can explicitly reset them yourself on the next line");
   SAY("           but this is not recommended.");
   SAY("");
   SAY("BACKGROUND:");
   SAY("-B  Subtract away a bg rate.  SINGLE time argument sets the");
   SAY("    *ending* time of the interval; the duration is set to be");
   SAY("    *equal to the regular interval duration* ('i')");
   SAY("    NOTE: Get_Interval_*(..., 1) returns interval minus bg");
   break;
case 'c':
   SAY("-C	Print out .grabconfig values");
   SAY("-CMACRO_APPENDS=1    Set this config value for this analysis");

   SAY("-c#	Detailed configuation (values in header #) ");
   SAY("-c	Detailed configuation (values in 1st header) ");
   SAY("");
   SAY("-cs#	Add # to all trial stamps (obselete in 2018");
   SAY("");
   SAY("-cU#	Override the unit number given in the header");
   SAY("-cU#:#	Override unit and run number given in the header");
   SAY("-cU0:#	Override just the run number given in the header");
   break;
case 'd':
   SAY("     Direction:");
   SAY("-d	   'Preferred' direction for use by output (type 3)");
   break;
case 'e':
   SAY("-e	   Show each trial, one at a time, in small ghostview window");
   SAY("-ep	   	Portrait orientation");
   SAY("-el	   	Landscape orientation");
   break;
case 'f':
   SAY("     Fill graphics:");
   SAY("-f	   Do not fill histograms (Useful for -L, -Lo)");
case 'g':
   SAY("     Graphics:");
   SAY("-g -G	   Individual/summary graphics to stdout");
   SAY("	   Can modify with '=' (this only) or '~' (not this)");
   SAY("           -G details may depend on presence/absence of -g");
   SAY("");
   SAY("    -g    Standard indis: Individual data versus time");
   SAY("    -g1   Non-std:     	Individual data versus space");
   SAY("                Shows time within -i bounds [NOT -t!]");
   SAY("                If -i#:# [end=start], show whole trial");
   SAY("                If DENSITY from .grab_config is 0, show just one point");
   SAY("");
   SAY("    -G    Standard summary: avg plot plus mean histogram"); 
   SAY("    -G1   Non-std:     Graph average plus variance histogram");
   SAY("    -G2   Non-std:     Graph average response + polar plot");
   SAY("          Looks different depending on presence/absence of -g");
   SAY("          Can force # of classes using -d or -D flags");
   break;
case 'h':
   SAY("-H   Detailed help:");
   SAY("        If you're reading this, you know how to use it (-Hh)");
   SAY("     Histo height:");
   SAY("-h50	Positive value: Specify Full-scale of histogram (e.g. 50 sp/s)");
   SAY("-h-50	Negative value: Scale as usual, then multiply by % (e.g, halve)");
   break;
case 'i':
   SAY("     Intervals:");
   SAY("-i10:40	      Data from interval 10-40 ms (re: aligntime)");
   SAY("                This is interval 1!");
   SAY("-I200:300     Output data fom this interval AS INTERVAL 2!!!");
   SAY("              INTERVAL 3 (DIFFERENCE BETWEEN 2 and 1) IS NOT CALC'D!!");
   SAY("              INTERVAL 3 only calc'd when 2nd interval set with '-B'!");
   SAY("-w -a... -i10:40    Write out only if interval was recorded");
   break;
case 'l':
   SAY("     vertical Lines:");
   SAY("-l355	   	   Draw vertical line in each plot at 355 ms");
   SAY("");
   SAY("     Layout:");
   SAY("-L	   	   Layout as described in stacks");
   SAY("-Ls3:5	   	   Stacks m thru n on rows 1 thru (n-m)");
   SAY("-Ls3,1	           Stack 3 on row 1, stack 1 on row 2");
   SAY("-Lc1:8	           Class 1 thru 8 on cols 1 thru 8");
   SAY("-Lc5,3,2,1	           classes 5,3,2 and 1 on cols 1 thru 4"); 
   SAY("-Ls3,1 -Lc19,0,5	   stacks 3 & 1, class 5, in column 3");
   SAY("       		   For blanks, be unique: -Lc20:23,4 NOT -Lc0,0,0,0,4");
   SAY("");
   SAY("-Lo	OVERLAY");
   SAY("-Los	    Overlay all stacks of each class (uses only 1 row)");
   SAY("-Loc	    Overlay all classes of each stack (uses only 1 column)");
   SAY("-Lo	    Synonym for -Los");
   SAY("          Note: -Lo? is often paired with -f");
   SAY("");
   SAY("-Lr		   Rotate layout (swap rows and columns)");
   break;
case 'm':
   SAY("-ms3,5,8,2	Merge stacks 5,8 and 2 into stack 3");
   SAY("-mc3,5,8,2	Merge tables 5,8 and 2 into classes 3");
   SAY("-m3,5,8,2	No argument: default to merge *stacks*");
   SAY("-ms		Merge ALL stacks");
   SAY("-mc		Merge ALL classes");
   SAY("-mf		Merge FILES together before running");
   SAY("-m=		Merge before ex/including (must be first; see notes)");
   SAY("");
   SAY("  Can merge up to 25 sets of stacks & tables");
   SAY("   Within each set, up to 50 classes or stacks can be merged together");
   SAY("    (FEWER FOR EARLIER VERSIONS OF GRAB!)");
   SAY("  eg,  '-mc7,8 -mc3:4 -mc1,5:7 -ms1:4 -ms5,6 -ms7,8'");
   SAY("       Will rename classes 1:8 into 1,3 and 7; stacks 1:8 into 1,5 and 7");
   SAY("");
   SAY("  t is a synonym for 'c' (tables)");
   SAY("");
   SAY("Does ALL merges or ALL skips first, depending on which it sees first");
   SAY(" eg '-xc3 -ms2,3,4,5 -xs5:  Will exclude stack 5 before merging");
   SAY("   '-ms2,3,4,5 -xc3 -xs5:  Will merge 3 and 5 to 2 (so no exclusions)");
   SAY("  note: doesn't distinguish class vs stack vs 'both' operators!");
   SAY("        (but -xt# and -mf do NOT call Seen_Skip or Seen_Merge");
   SAY("        (can use -m= or -x= to set the order without doing anything else");
   SAY("	 but must precede all other calls to -m, -x or -X)");
   SAY("");
   SAY("-M   Print out macros");
   SAY("-M	Print out all macros");
   SAY("-M1	Print out the macros 10-19");
   SAY("-M4	Print out the macros 40-49");
   SAY("	(For macro execution, see -o");	
   break;
case 'o':
   SAY("-o4	Macro #3: grab -M or grab -M# to list macros (see -HM)");
   SAY("        Most macros generate text only; some (those returning 1 from");
   SAY("        Do_Macro()), generate graphics.  If macro generates graphics,");
   SAY("        beware of also requesting other graphical output (e.g., -g)");
   SAY("");
   SAY("-ot100:30:5   Pass (up to 3) values to macro,");
   SAY("              keyed by a (case-sensitive) letter");
   SAY("");
   SAY("-O	See -w");
   break;
case 'r':
   SAY("-r#	Show ~ rasters per trial type");
   SAY("          If no number, will show all rasters.");
   SAY("          See code for raster tic height and line spacing.");
   SAY("-R#	Print one line for each trial: number, stack, class");
   SAY("         #==1:  prepend unit and run number");
   SAY("         #==2:  monk name, stacks, classes, 3 lines/file-see 4,12,13");
   SAY("          102:    prepend unit & run #");
   SAY("         #==3:  each trial: stack.class number trial# (1 line/trial)");
   SAY("         #==4:  file name stacks (1 line/file) - see 2+12+13");
   SAY("         #==5:  start time (trial # hour minute sec)");
   SAY("         #==6:  trial number delay-time pause-time");
   SAY("         #==7:  error type");
   SAY("         #==8:  grab -S# for EVERY trial (ugh!)");
   SAY("         #==9:  touchbounds for every trial");
   SAY("         #==10: Like 1 but only numbers (no characters)");
   SAY("         #==11: Year, month, day, time");
   SAY("         #==12: Stack# class# 'N'");
   SAY("         #==13: Matrix of stacks and classes ('n' for @)-see 12,2+4");
   SAY("         #==14: Time stamp");
   SAY("         #==20: time stamp, trial #, stack, class, trial time");
   SAY("         #==30: available off-line unit sorts");
   SAY("         #==41: number of stacks");
   SAY("         #==42: number of classes");
   SAY("         #==43: number of stacks, number of classes");
   SAY("         Note: options after -R will be interpreted as files");
   break;
case 's':
   SAY("-S13	Print out stack for trial 13");
   SAY("-s13	Print out touch coords and times for trial 13");
   SAY("-ss13	Print out BOARD 2 touches, coords and times");
   break;
case 't':
   SAY("-t-200:800	Show trial times from -200 to 800 (re: align)");
   SAY("                Must come BEFORE '-ae' or '-as'");
   SAY("                If equal e.g. -t5:5, then show whole trial");
   SAY("                If DENSITY from .grab_config is 0, show just one point");
   SAY("");
   SAY("");
   SAY("-TThis_title	Use new title (replacing underbars with spaces)");
   fprintf(stdout, "  -T%cTitle	Add above existing title (vs. replacing)\n",
   	ADD_TITLE_CHAR);
   break;
case 'u':
   SAY("-u#	Specify unit channel (usu 0==single, 1==multi");
   SAY("-u1 -w  Multi data REPLACES single data in new file (see -w)");
   break;
case 'v':
   SAY("-v1:   Use interval with most variation");
   SAY("       UNPREDICTABLE RESULTS with -B or -I flags!! AVOID!");
   SAY("-v2:   Assign trials randomly to a trial-type (MONTE CARLO)");
   break;
case 'x':
   SAY("-XeDELAY_0:100,1  Show only if param 1 of delay is from 0 to 100");
   SAY("       -[xX]EventType[_from[:to][,which]][.occurrence][#stack]");
   SAY("              		          which: 0=time, 1:3=params 1:3");
   SAY("       (if the event is not found, skip the trial)");
   SAY("-xi		Skip trials which do not contain '-i'");
   SAY("-xi500		Skip if missing -i interval plus 500 ms");
   SAY("")
   SAY("-[xX]ns 	Exclude or show exclusively no start errs");
   SAY("                 (Makes sense only for 'fail' files");
   SAY("-x=		Ex/include before merging (must be first; see notes)");
   SAY("-----------------------------------------------------------")
   SAY("-x4:8  -x13	Exclude (skip) trials 4 thru 8 and 13");
   SAY("-xs1:2 -xs4	Exclude stacks 1 thru 2 and 4");
   SAY("-xc4:8 -xc1	Exclude columns/tables 4 thru 8 and 1");
   SAY("-xb4.8 		Exclude stack 4, column 8 ONLY");
   SAY("-X5		Show ONLY trial 5");
   SAY("-Xs3:4		Show only stacks 3 and 4");
   SAY("-Xb4.8 		Show only stack 4, column 8; SKIP ALL ELSE");
   SAY("-xu304		Skip unit 304");
   SAY("-Xr1 		Use only run=1; Skip all else");
   SAY("-XU304.1	Use only file '304.1'; Skip all else");
   SAY("")
   SAY("  Commas not allowed (-xs3,8); do this instead: -xs3 -xs8");
   SAY("  Max of only one 'X' per category (else excludes ALL");
   SAY("");
   SAY("Does ALL merges or ALL skips first, depending on which it sees first");
   SAY(" eg '-x3 -ms2,3,4,5 -x5:  Will exclude BOTH 3 and 5 before merging");
   SAY("    '-ms2,3,4,5 -x3 -x5:  Will merge 3 and 5 to 2, and so won't skip");
   SAY("   NOTE: -x[tne] (e.g.,'-xt3') do NOT set the order");
   SAY("        (can use -m= or -x= to set the order without doing anything else");
   SAY("	 but must precede all other calls to -m, -x or -X)");
   break;
case 'w':
   SAY("-W	       Pipe directly to a small ghostview window");
   SAY("-Wl	          Open small ghostview window as landscape (default)");
   SAY("-Wp	          Open small ghostview window as portrait");
   SAY("");
   SAY("-w         Write out file, using any -x -m -X -O flags to transform");
   SAY("                   the input to the output, naming it 'inputfile+'.");
   SAY("-w-        Write out file, using any -x -m -X flags to transform;");
   SAY("                   no align, no changes in data! (to 'inputfile+')");
   SAY("-w--       NO write file; use -x -m -X flags to transform; and run");
   SAY("                   a macro with Force_Zero_AlignTime()");
   SAY("                   e.g., 'grab -o141 -i-15000:15000 -w-- filename");
   SAY("-w#8	          As above, but write no more than 8 trials per type");
   SAY("-wSuffix          As above, but name output 'inputfileSuffix'.");
   SAY("-w#8 -wsuffix     Set # trials AND suffix (can also add -w-).");
   SAY("-w -u1     In new file, old multi data will be new single unit data,");
   SAY("            and old single unit data will be gone. (-u0 does nothing)");
   SAY("");
   SAY("-w implies -a: if there's an error in alignment, just skip that trial");
   SAY("   '-w -i...': Accept only trials that contain the specified interval");
   SAY("");
   SAY("");
   SAY("-Oxxx 	Used only with -w.  Offset the trial times before writing.");
   SAY("Positive values only.  Useful for overlying data with data from the");
   SAY("same trial, that is, shift the data by a certain amount, write it");
   SAY("out as a new file, concatenate it with the original file and then");
   SAY("analyze them together with the -Lo -f flags.");
   SAY(" CRITICAL POINT: when -O option is used, stack number is incremented");
   SAY("by 100 (else wouldn't distinguish shifted and unshifted data.");
   SAY("");
   SAY(" Note: the -w process results in the analog data being read in,");
   SAY(" transformed according to the specified calib file, and then being");
   SAY(" written out, properly calibrated.  A flag is set in the header");
   SAY(" to indicate that calibration has already occurred.");
   break;
case 'z':
   SAY("-z#      Magnifies X axis.  Default is 1; -z is -z2");
   SAY("         Line width expands too, so not ideal!");
   SAY("         Accepts fractions (-z2.5) and values less than 1 (z.5)");
   break;
default:
   if (what != 0)
      fprintf(stdout, "No help for <%c>\n", what);
   Print_Usage();
   }
   fprintf(stdout, "\n");
   }
/* ********************************************************************	*/
