/* FILE head.c */

#define DEBUG	0

int extra_frames;

#include "deffs.h"
#define int short
#include "head.h"
#undef int
#include <fcntl.h>					/* Open/close	*/
#include <string.h>					/* strcpy()	*/
#include <unistd.h>					/* lseek arg's	*/

/* 
  UnRead_Header
  Read_Header
  Write_Header_To_File(int out) {
FrameCount_Header
SpikeCount_Header
TouchCount_Header
ButtonCount_Header
ChannelCount_Header
MsPerFrame_Header
TableNumber_Header
StackNumber_Header
RawTableNumber_Header
RawStackNumber_Header
TrialNumber_Header
StackName_Header
UnitNumber_Header
RunNumber_Header
MonkChar_Header
MonkName_Header
ChairAt_Header
CailbFile_Header
RunStatus_Header
ErrType_Header
Punish_Header
Flag_Header
Set_Flag_Header
Clear_Flag_Header
Set_FrameCount_Header
Set_SpikeCount_Header
Set_TouchCount_Header
Set_ButtonCount_Header
Set_TrialNumber_Header
Set_StackNumber_Header
Set_ClassNumber_Header
Set_StackName_Header
Stack_Ptr_Header
Date_From_Header
Time_From_Header
PrintHeader
Warning
Version
Get_UnitChannel_Header
Set_UnitChannel_Header
Get_TouchBound_Header
Get_ViewingDistance_Header
 */

static int OverrideUnitNumber = 0;
static int OverrideRunNumber = 0;
static int OverrideAddToTrialStamp = 0;
static int UnitChannel = 0;
 
#define Pad(x)  (x < 10) ? "0" : "", x

/* ********************************************************************	*/

/* FUNCTION UnRead_Header */
void UnRead_Header(int File) {
 	lseek(File, (off_t) -h.event_count * sizeof(EVENT), SEEK_CUR);
        lseek(File, (off_t) -sizeof(struct HEADER), SEEK_CUR);
	}
/* ********************************************************************	*/

/* FUNCTION Read_Header */
	 /* Read header in from File */
	 /* NOTE: call only from Read_Next_Trial or output.c	*/
int Read_Header(int File) {
	static int WildMsg = 0;

	if (DEBUG)
	   fprintf(stderr, "Start looking for header at byte %ld\n", 
							lseek(File, 0L, 1));

	if (read(File, &h, (size_t) sizeof(struct HEADER)) != 
				    sizeof(struct HEADER)) {
	    if (DEBUG)
	       fprintf(stderr, "\n *** END OF FILE ***\n");
	    return(0);
	    }

	/* CHANGES TO THE HEADER CAN GO HERE (e.g., change unit number)	*/
	/* For example, h.id.unit = 7; h.id.run = 1; */
	/* And then call with -w, to write the file back out again */

#define REPAIR_FILES 0

# if REPAIR_FILES
	strcpy(h.tag, "Header!");
# endif
# if EXAMPLES
	 if (h.frame_count == -1)
	    h.frame_count = 0xEFFF + 1;
	fprintf(stderr, "DIAG: count = %d\n", h.frame_count);

	strcpy(h.tag, "Header!");
	 h.date.month = 11;
	 h.date.day = 10;
	 h.date.year = 2008;
	 h.id.version = 3;
	if (h.h_touch_bound == 30)
	    h.h_touch_bound = 130;
	 if (h.calib_file < -1) h.calib_file = 1;
	 h.id.monk[0] = 'i';
	 h.id.monk[1] = 'v';
	 h.id.monk[2] = 'n';
	 h.id.monk[3] = 0;
	 if (strcmp(h.tag, "ader!") == 0)
	     strcpy(h.tag, "Header!");
	 h.ms_per_frame = 2;
	 h.id.unit = 532;
	 h.id.run = 1;
#endif
	/* END OF CHANGES */
	

	if (strcmp(h.tag, "Header!") != 0) {	/* Not a header?	*/
	    int i;
	    char *p = (char *) &h;

	    for (i=0; i<sizeof(struct HEADER); i++)	/* Try locally	*/
	       if (*(p+i  ) == 'H' &&	/* Walk thru, look for tag	*/
	           *(p+i+1) == 'e' &&
	           *(p+i+2) == 'a' &&
	           *(p+i+3) == 'd' &&
	           *(p+i+4) == 'e' &&
	           *(p+i+5) == 'r')
		 break;
	    if (i<sizeof(struct HEADER)) {	/* Found 'Header'?	*/
	       fprintf(stderr, "Slightly off (%d extra bytes)\t", i);
	       lseek(File, i-sizeof(struct HEADER), 1); /* Ready to read*/
	     } else {
#		define CHUNK	4000
#		define BACKUP	 500L
	       char LookHere[CHUNK];
	       lseek(File, -128L, 1);		/* Back over header	*/
	       lseek(File, -BACKUP, 1);		/* Back up ~ bytes	*/
	       read(File, LookHere, CHUNK);	/* Read CHUNK bytes	*/
	       p = LookHere;
	       for (i=0; i<CHUNK; i++)
	         if (*(p+i  ) == 'H' &&
	             *(p+i+1) == 'e' &&
	             *(p+i+2) == 'a' &&
	             *(p+i+3) == 'd' &&
	             *(p+i+4) == 'e' &&
	             *(p+i+5) == 'r')
		 break;
	       if (i < CHUNK) {				/* WAY OFF!	*/
	          if (++WildMsg < 5) {
	             if (i-BACKUP < 20)
	              fprintf(stderr, "Slightly off (%ld bytes missing)\t",
				      				i-BACKUP);
		     else
		      fprintf(stderr,"Wildly off (%ld extra bytes)\t",i-BACKUP);
		     }
	          lseek(File, i - CHUNK, 1);
	        } else
	          Exit("Error in finding header", "Read_Header");
	       }
	    if (read(File, &h, sizeof(struct HEADER)) !=
	       					sizeof(struct HEADER))
	          return(0);
	    fprintf(stderr, "  %d.%d.%d (%d)\n", 
			    h.id.unit, h.id.run, h.trial, TrialNumber_Input());
	    }

	if (DEBUG) {
	 static int count = -1;	/* Not reset on subsequent Files! */
	 fprintf(stderr,"  %.20s %d.%d.%d (%d): Stack %2d <%.20s> (%d-%d-%s%d %d:%.20s%d)\n",
		h.id.monk, h.id.unit, h.id.run, h.trial, ++count,
		h.stacknumber, h.stackname,
		h.date.month, h.date.day,
			(h.date.year%100<10)?"0":"", h.date.year%100,
		h.time.hour, (h.time.minute<10) ? "0":"",
			h.time.minute);
	    }

	if (h.event_count > MAX_EVENTS)
	   Exit("Make MAX_EVENTS in deffs.h larger", "Read_Header()");

	read(File, header_stack, h.event_count * sizeof(EVENT));

	if (DEBUG)
	   PrintHeader();

# ifdef REPAIR_CLASS_NUMBER
	{
#	include "event.h"
	if (h.stacknumber  >= 70 && h.stacknumber  <= 80) {
	    h.column_number  = 1 + round(57.3 *
		   atan2(EventExtract(TARGET_ON_POLAR, THREE, 1),
		         EventExtract(TARGET_ON_POLAR, TWO, 1)) / 45.);
	   fprintf(stderr, "%3d   %3d %3d   ",
		   h.column_number,
		   EventExtract(TARGET_ON_POLAR, TWO, 1),
		   EventExtract(TARGET_ON_POLAR, THREE, 1));
	   if (h.column_number < 1)
	       h.column_number += 8;
	   fprintf(stderr, "%3d\n", h.column_number);
	   }
	}
#endif

	if (h.run_status != SUCCESS)
           CheckLengthOfEventStack(h.frame_count * h.ms_per_frame);	

	if (DEBUG)
	   fprintf(stderr, "   Read %d bytes of stack + %d bytes of header\n",
		h.event_count * sizeof(EVENT), sizeof(struct HEADER));

	if (h.date.year < 1980)
	    h.date.year += 1900;		/* Y2K correction!	*/
	Adjust_Events(header_stack);		/* Various fixes	*/

	if (OverrideUnitNumber)
	    h.id.unit = OverrideUnitNumber;	/* Command line override*/
	if (OverrideRunNumber)
	    h.id.run = OverrideRunNumber;	/* Command line override*/
	if (OverrideAddToTrialStamp)
	   EventAddTrialStamp(OverrideAddToTrialStamp);	/* Mv into hdr!	*/ 
		/* Happens when Read_Header is called	*/
	return(1);
	}
/* ********************************************************************	*/

/* FUNCTION Write_Header_To_File */
	 /* First adjusting table & stack numbers */
	 /* Will fail if older than 10-20-95 */
void Write_Header_To_File(int out) {
	h.stacknumber = MergeStack(h.stacknumber);
	h.column_number = MergeTable(h.column_number);
	write(out, &h, 128);
	write(out, header_stack, h.event_count * sizeof(EVENT));
	}
/* ********************************************************************	*/

/* FUNCTION Set_UnitNumber */
/* FUNCTION Set_RunNumber */
	 /* From the command line */
void Set_UnitNumber(int unit) { OverrideUnitNumber = unit; }
void Set_RunNumber(int run)   { OverrideRunNumber = run; }
void AddToTrialStamp(int add) { OverrideAddToTrialStamp = add; }
/* ********************************************************************	*/

/* FUNCTION FrameCount_Header */
/* FUNCTION SpikeCount_Header */
/* FUNCTION TouchCount_Header */
/* FUNCTION ButtonCount_Header */
/* FUNCTION ChannelCount_Header */
/* FUNCTION MsPerFrame_Header */
/* FUNCTION TableNumber_Header */
/* FUNCTION StackNumber_Header */
/* FUNCTION RawTableNumber_Header */
/* FUNCTION RawStackNumber_Header */
/* FUNCTION TrialNumber_Header */
/* FUNCTION StackName_Header */
/* FUNCTION UnitNumber_Header */
/* FUNCTION RunNumber_Header */
/* FUNCTION MonkChar_Header */
/* FUNCTION MonkName_Header */
/* FUNCTION ChairAt_Header */
/* FUNCTION CailbFile_Header */
/* FUNCTION RunStatus_Header */
/* FUNCTION ExtraTimeOnError_Header */
/* FUNCTION ErrType_Header */

int FrameCount_Header()    { return((int)h.frame_count); }
int SpikeCount_Header(int channel) {	/* Specify, or use UnitChannel*/
	if (channel == -1)
	    channel = UnitChannel;
       	switch (channel) {
	   case 0: return((int)h.spike_count);
	   case 1: return((int)h.multi_count);
	   case 2: return((int)h.id.spike_count3);
	   case 3: return((int)h.id.spike_count4);
	   default:  Exit("Illegal channel number", "SpikeCount_Header");
	   }
	return(FAIL);		/* Never reaches this	*/
	}
int TouchCount_Header(int board)   
	{ return((int) ((board==1) ? h.touch_count1 : h.touch_count2)); }
int ButtonCount_Header()   { return((int)h.button_count); }
int ChannelCount_Header()  { return((int)h.channel_count); }
int MsPerFrame_Header()    { return((int)h.ms_per_frame); }
int TableNumber_Header()   { return(MergeTable((int)h.column_number)); }
int StackNumber_Header()   { return(MergeStack((int)h.stacknumber)); }
int RawTableNumber_Header(){ return((int)h.column_number); }
int RawStackNumber_Header(){ return((int)h.stacknumber); }
int TrialNumber_Header()   { return((int)h.trial); }
char *StackName_Header()   { return(h.stackname); }
int UnitNumber_Header()    { return((int)h.id.unit); } 
int RunNumber_Header()     { return((int)h.id.run); } 
char MonkChar_Header()	   { return(h.id.monk[0]); }
char *MonkName_Header()	   { return(h.id.monk); }
int  ChairAt_Header()	   { return(h.chair_at); }
int  CalibFile_Header()	   { return(h.calib_file); }
int  RunStatus_Header()	   { return(h.run_status); }
int  ExtraTimeOnError_Header()	   { return(h.extra_time_on_err); }
int  ErrType_Header()	   { return(h.err_type); }	/* Eye or arm	*/
int  Punish_Header(int which)	   { return(h.punishtimes[which]); }
/* 0:runtime punish, 1:starttime punish; 2-4: type,errs,time,enable*/
int  Flag_Header(int MASK) { 
	if (MASK == DELTA_WRITE &&	/* Special case (err)	*/
	    (h.date.year%100 <= 03 ||
	      (h.date.year%100 == 04 && h.date.month <= 5) ||
	      (h.date.year%100 == 04 && h.date.month == 6 && h.date.day<=9)))
	   return(1);	/* Always delta before this (but flag doesn't exist)*/
	return(h.flags & MASK);
	}
void Clear_Flag_Header(int MASK)  { h.flags &= ~MASK; }
void Set_Flag_Header(int MASK)  { h.flags |= MASK; }
char *Time_Header()	   {
	static char string[40];
	sprintf(string, "%d %d %d.%s%d",
		h.time.hour, h.time.minute, h.time.second,
		(h.time_hsecond < 10) ? "0" : "",
	         h.time_hsecond);
	return(string);
	}
/* ********************************************************************	*/
static int SaveCalibFileNumber;		/* For -w (see output.c)	*/
void Clear_CalibFile_Header() { 
	SaveCalibFileNumber = h.calib_file;
	h.calib_file = ALREADY_CALIBRATED;
	}
void Restore_CalibFile_Header() { 
	h.calib_file = SaveCalibFileNumber;
	}
/* ********************************************************************	*/
/* FUNCTION Set_ButtonCount_Header */
void Set_ButtonCount_Header(int i) { 
	h.button_count = i;
	}
/* ********************************************************************	*/

/* FUNCTION Set_FrameCount_Header */
/* FUNCTION Set_SpikeCount_Header */
/* FUNCTION Set_TouchCount_Header */
/* FUNCTION Set_TrialNumber_Header */
/* FUNCTION Set_StackNumber_Header */
/* FUNCTION Set_ClassNumber_Header */

void Set_FrameCount_Header(int i) { h.frame_count = i; }
void Set_SpikeCount_Header(int i) {
	switch (UnitChannel) {
	   case 0: h.spike_count = i; break;
	   case 1: h.multi_count = i; break;
	   case 2: h.id.spike_count3 = i; break;
	   case 3: h.id.spike_count4 = i; break;
	   default:
	   	Exit("Illegal unit channel", "Set_SpikeCount_Header");
	   }
	}
void Set_TouchCount_Header(int board, int i) {
	if (board==1)
	   h.touch_count1 = i;
	 else
	   h.touch_count2 = i;
	}
void Set_TrialNumber_Header(int i) { h.trial = i; }
void Increment_StackNumber_In_Header(int i) { h.stacknumber += i; }
void Set_StackNumber_Header(int i) { h.stacknumber = i; }
void Set_ClassNumber_Header(int i) { h.column_number = i; }
void Set_StackName_Header(char *new) { strncpy(h.stackname, new, 17); }
/* ********************************************************************	*/

/* FUNCTION Stack_Ptr_Header */
EVENT *Stack_Ptr_Header() {
	return(header_stack);
	}
/* ********************************************************************	*/

/* FUNCTION Date_From_Header */
/* FUNCTION Year_From_Header */
/* FUNCTION Month_From_Header */
/* FUNCTION Day_From_Header */
	 /* Return string of date, or integer */
char *Date_From_Header() {
	static char Date[20];

	Date[0] = 0;					/* Insurance	*/
	sprintf(Date, "%d-%d-%s%d", h.date.month, h.date.day, 
		(h.date.year%100<10)?"0":"", h.date.year%100);
	return(Date);
	}
int Year_From_Header() { return(h.date.year); }
int Month_From_Header() { return(h.date.month); }
int Day_From_Header() { return(h.date.day); }
/* ********************************************************************	*/

/* FUNCTION Time_From_Header */
	 /* Return time in seconds */
float Time_From_Header() {
	return(h.time.hour*3600 + h.time.minute*60 + h.time.second +
			                             h.time_hsecond / 100.);
	}
/* ********************************************************************	*/

/* FUNCTION Version */
int Version() { 
	if (h.date.year <= 1998)
	   return(-2);				/* very old		*/
	else if (h.date.year <= 2000)
	   return(-1);
	else
	   return(h.id.version);
	}
/* ********************************************************************	*/
/* FUNCTION PrintDetailedHeader */
	 /* No stack */
void PrintDetailedHeader() {
	fprintf(stdout,
	     "\n%d.%d:  %c%s%c  (%s %d.%d.%d) (%d-%d-%s%d %d:%s%d:%s%d.%s%d) [%.3f]\n",
		h.stacknumber, h.column_number,
		'"', h.stackname, '"',
		h.id.monk, h.id.unit, h.id.run, h.trial,
		h.date.month, h.date.day, 
		   (h.date.year%100<10)?"0":"", h.date.year%100,
		h.time.hour, Pad(h.time.minute), Pad(h.time.second),
		(h.time_hsecond < 10) ? "0" : "",
	         h.time_hsecond,
		 Time_From_Header()
		);
	fprintf(stdout, "\treach version %d, calib file %d\n", 
				h.id.version, h.calib_file);
	if (h.err_type) fprintf(stdout, " Error type %d\n", h.err_type);
	fprintf(stdout, "   %d frames, %d channels, %d ms/frame (delta=%d)\n",
		h.frame_count, h.channel_count, h.ms_per_frame,
							h.flags & DELTA_WRITE);
	fprintf(stdout,
	    "   %d %d %d %d spikes, multis %d+%d touches, %d buttons\n",
	    h.spike_count, h.multi_count, h.id.spike_count3, h.id.spike_count4,
	    h.touch_count1, h.touch_count2, h.button_count);
	fprintf(stdout, "   Window relax: %d,%d  RunStatus: %d   ChairAt: %d\n",
		h.relax_windows[0],h.relax_windows[1],h.run_status,h.chair_at);
	fprintf(stdout, "   Run punish: %d  Start punish: %d\n\tLong punish:",
				h.punishtimes[0], h.punishtimes[1]);
        if (h.punishtimes[5] == 0)
	     fprintf(stdout, " off\n");
          else
	     fprintf(stdout, " type: %d  errs: %d  time: %d\n",
			h.punishtimes[2], h.punishtimes[3], h.punishtimes[4]);
	fprintf(stdout, "Setup %d\n", h.setup);
	fprintf(stdout, "delta write: %d\n", Flag_Header(DELTA_WRITE));
	}
/* ********************************************************************	*/

/* FUNCTION PrintHeader */
	 /* Print current stack and header info */
void PrintHeader() {
	fprintf(stdout,
	     "\n%d.%d:  %c%s%c  (%s %d.%d.%d) (%d-%d-%s%d %d:%d:%d.%s%d) [%.3f]\n",
		h.stacknumber, h.column_number,
		'"', h.stackname, '"',
		h.id.monk, h.id.unit, h.id.run, h.trial,
		h.date.month, h.date.day, 
		   (h.date.year%100<10)?"0":"", h.date.year%100,
		h.time.hour, h.time.minute, h.time.second,
		(h.time_hsecond < 10) ? "0" : "",
	         h.time_hsecond,
		 Time_From_Header()
		);
	fprintf(stdout, "    %d frames, %d channels, %d ms/frame\n",
		h.frame_count, h.channel_count, h.ms_per_frame);
	fprintf(stdout, "    %d %d %d %d spikes, %d touches, %d buttons\n",
		h.spike_count, h.multi_count, h.id.spike_count3,
		h.id.spike_count4, h.touch_count1, h.button_count);
	Print_Events();

#if (SEE_RAW_NUMBERS_TOO)
	{
	int j;
	EVENT *E = header_stack;
	for (j=0; E->type!=END_STACK; E++, j++)
	    fprintf(stderr, "%2d  %5d     %4d     %5d %5d %5d\n",
			j, E->time, E->type, E->one, E->two, E->three);
	}
#endif
	}
/* ********************************************************************	*/

/* FUNCTION Warning */
	 /* Print date, unit/run/trial numbers */
void Warning(char *string) {
     if (*string)
        fprintf(stderr, "%s   ", string);
     if (h.date.month)
        fprintf(stderr, "%2d-%s%d-%s%d  %.3s %s %3d.%1d.%2d  Trial %2d",
	h.date.month, 
	(h.date.day < 10)?"0":"", h.date.day, 
	(h.date.year%100<10)?"0":"", h.date.year%100,
        h.id.monk, 
	FileName_Input(), h.id.unit, h.id.run, h.trial,
	TrialNumber_Input());
     fprintf(stderr, "\n");
     }
/* ********************************************************************	*/

/* FUNCTION Get_UnitChannel_Header */
/* FUNCTION Set_UnitChannel_Header */
int  Get_UnitChannel_Header() { return(UnitChannel); }
void Set_UnitChannel_Header(int channel) {
	UnitChannel = channel;
	}
/* ********************************************************************	*/
/* FUNCTION Get_TouchBound_Header */
int Get_TouchBound_Header(int horiz) { 
	return((horiz==1) ? h.h_touch_bound : h.v_touch_bound); }
/* ********************************************************************	*/
/* FUNCTION Get_ViewingDistance_Header */
int Get_ViewingDistance_Header() { 
	return(h.viewing_distance); }
/* ********************************************************************	*/
/* FUNCTION Get_SetupNumber_Header */
int Get_SetupNumber_Header() { 
	return(h.setup); }
/* ********************************************************************	*/
