/* FILE graph */
     /* Graphical output of analysis program */

#include "config.h"

#define RASTER_SPACE	1500	/* Relevant only with -Los or -Loc	*/
     /* Each stack's rasters get written into a virtual "graphics box",
      * so whether there is 1 raster per stack or 50, the first raster
      * always appears at the same spot (at the top of the 'box').  If
      * the number of rasters per stack times the vertical space per row
      * exceeds the height of the 'box', then the rasters of adjacent
      * stacks overlie one another.					*/
#define PERCENT_BETWEEN_RASTER_ROWS 33 	   /* As % row height; usu ~33	*/
     /* If percent is 0, then there's only a tiny difference between the
	start and stop height values.  This ends up being the same pixel,
	so with PERCENT set to 0, there is an overlap of 1 pixel!!	*/
     /* This number doesn't work as advertised: pixelation rounding?	*/
#define RASTER_WIDTH	1		/* Currently must be an 'int'	*/	
     /* Linewidth for raster (doubled if height greater than 39)	*/
     /* In the future, could make this a float				*/
#define SHOW_EVERY_NTH_SPIKE_IN_RASTER 1   /* Usually 1			*/

#define SHOW_SINGLE_TOUCHES	0	/* Circles on top of the trace	*/
#define DEBUG_MOVE_ARM		0	/* Show Get_Move_Arm_Time() call*/

#include "deffs.h"
#include "ad.h"
#include <fcntl.h>					/* Open/close	*/
#include <string.h>					/* strchr()	*/
/* ********************************************************************	*/

/* PUBLIC:
 *  Set_Show_Raster_FromCmdLine
 *  Do_Graphics
 *  Init_Graphics
 *  End_Graphics
 *  Begin_Graphics
 *
 *  Graph_Analog_Data
 *  Graph_TimeLine
 *  Add_Vertical_Lines_On_Graph
 *  Init_Vertical_Lines_On_Graph
 *  Do_Vertical_Lines_On_Graph
 * PRIVATE:
 *  Do_Graph
 *  Graph_Analog_Zero
 *  Graph_Raster
 *  Graph_Target_Appearance
 *  Graph_ScaleBars
 *  Graph_DrawBox
 */

static int Counts[MAX_TYPES];				/* For rasters	*/
#define MAX_STACKS_PER_FIG	5		/* No more than 5!	*/
static int SpecialCounts[MAX_TYPES][MAX_STACKS_PER_FIG];
			/* To group rasters of diff types in single fig	*/
static int First;					/* Boolean	*/

int SHOW_RASTER = 0;		/* Can set on cmdline;export to histo.c	*/

#define DELUXE	ON
#define NOT_DELUXE OFF

static void Do_Graph(int type, int deluxe);
static void Graph_Analog_Zero();
static void Graph_Raster(int type);
static void Graph_Target_Appearance();
static void Graph_ScaleBars();
static void Graph_DrawBox();
static int  ADtoPIX(int advalue);
/* ********************************************************************	*/

/* FUNCION Set_Show_Raster_FromCmdLine */
void Set_Show_Raster_FromCmdLine(int count) {
	if (count==-1)				/* No value passed	*/
	   SHOW_RASTER = 10000;
	else
	   SHOW_RASTER = count;
	}
/* ********************************************************************	*/

/* FUNCTION Do_Graphics */
void Do_Graphics() {
	int i = Get_TrialType();

	if (Setup_Coords_For_TrialType(i) == -1)	/* Don't draw it*/
	   return;

	if (First) {
	   if (SHOW_ANALOG)
	      Graph_ScaleBars();
	   First = 0;
	   Setup_Coords_For_TrialType(i);		/* Reset coords	*/
	   }

	Counts[i]++;					/* Tally trial	*/
	if (Counts[i] == 1) {
	   Graph_TimeLine();
	   Graph_DrawBox();
	   }

	if (SHOW_ANALOG) {
	 if (SINGLE_ANALOG) {
	   if (Counts[i] == 1 && Get_TrialType_Info(i,COL)==1) {
	      Do_Graph(i, NOT_DELUXE);
	      }
	 } else if (FAST_FIGURE) {
	   if (Counts[i] == 1) {			/* Show firsts	*/
	      Do_Graph(i, NOT_DELUXE);
	      }
	 } else if (SEMI_FAST_FIGURE) {
	   if (Counts[i] <= SEMI_FAST_FIGURE) {
	      Do_Graph(i, DELUXE);
	      }
	 } else {
	      Do_Graph(i, DELUXE);
	   }
	 }						/* End SHOW_ANA	*/

	if (Counts[i] < PICTURE_TRIAL_COUNT)
	   Picture();
	if (Counts[i] < SHOW_RASTER)
	   Graph_Raster(i);		/* Spikes in B/W unless -L flag	*/

	if (RunStatus_Header() != SUCCESS) {	/* Draw line at EOT	*/
	   int ErrAt = EventExtractErrorBegin();

	   if (ErrAt == FAIL)
	       ErrAt = FrameCount_Header() * MsPerFrame_Header() +
	       		ExtraTimeOnError_Header();
	   Color(0,0,0);			/* Set the color	*/
	   move(ErrAt, 0);
	   cont(ErrAt, HEIGHT);
	   }

	SetLineWidth(0);			/* Reset to fine line	*/
	}

/* ********************************************************************	*/

/* FUNCTION Do_Graph */
	 /* Plot individual figure (analog stuff) */
static void Do_Graph(int trialtype, int deluxe) {
	SetColorByTrialType(trialtype);
	SetLineWidth((deluxe==DELUXE)? 1:3);	/* Spare -> heavy lines	*/
	Graph_Analog_Data();
	SetColorByTrialType(trialtype);		/* Reset -analog may chg*/
	if (deluxe==DELUXE) {
	   SetLineWidth(0);			/* Reset to fine line	*/
	   Graph_Analog_Zero();
	   Graph_Target_Appearance();
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Init_Graphics */
void Init_Graphics() {
	int i,j;
	for (i=0; i<MAX_TYPES; i++) {		/* Init local counts	*/
	   Counts[i] = 0;
	   for (j=0; j<MAX_STACKS_PER_FIG; j++)
	      SpecialCounts[i][j] = 0;
	   }
	First = 1;
	}
/* ********************************************************************	*/

/* FUNCTION End_Graphics */
/* FUNCTION Begin_Graphics */
	 /* Plot package writes to stdout: redirect it to file		*/
	 /*  */
void End_Graphics() {
	closepl();					/* Library call	*/
	fclose(stdout);
    	}

void Begin_Graphics(char *file, FILE *stream) {
	char GraphOut[200];
	static char Helvetica[] = "helvetica-bold";

	if (stream == NULL) {			/* -W ? (Opened own?)	*/
	   if (strchr(file, '/'))		/* Complex path?	*/
	      sprintf(GraphOut, "ps");		/* Put graphics here	*/
	   else					/* Local path		*/
	      sprintf(GraphOut, "ps%s", file+1);/* Strip 1st letter	*/
	   freopen(GraphOut, "w", stdout);	/* Redirect stdout	*/
	   stream = stdout;
	   }

	openpl(stream);					/* Library call	*/
	fill(0);				/* Insurance (required)	*/
	/* gcc doesn't like this: fontname("helvetica-bold");  		*/
	fontname(Helvetica);
	fontsize(100);		/* Kludge:absurd size so forced to reset*/
    	}
/* ********************************************************************	*/
/* ********************************************************************	*/
/* ad.h: 1 AD unit is 1/20 of a deg.  AD has 2048 offset.		*/
/* Map +/- 50 degrees of analog display into HISTO_OFFSET pixels	*/
/*	   if ZOOM_AD_RANGE_UNITS, then scale:  
 *			zoom > 1:   50 / (zoom-1)
 *			zoom < 1:   50 * -zoom
 *  Only plot every AVG-th data point
 */

/* Shorter version: */
#define ZM ZOOM_AD_RANGE_UNITS

/* FUNCTION ADtoPIX */
	 /* Vertical placement of analog traces	*/
static int ADtoPIX(int advalue) {
   int value = advalue * HISTO_OFFSET / (DEGtoAD(1) * 2 * 50);
   
   if (ZM < 0)				      /* Shrink?	*/
      value /= -ZM;
   else if (ZM > 1)
      value *=  ZM;

   value += HISTO_OFFSET / 3;		/* Not quite halfway up	*/

#ifdef LHS_JULY_05
   if (ZM < -1) {				/* Shrink?	*/
      value /= -ZM;
    } else if (ZOOM_AD_RANGE_UNITS > 2) {	/* Zoom		*/
      value *=  ZM;
      value += HISTO_OFFSET/4; 		/* Slight upward offset	*/
      }
#endif
   return(value);
   }
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Graph_Analog_Data */
	/* Plot AD samples, averaging over every AVG samples	*/
	/* Plotting space is (0,0 to duration,HEIGHT)		*/
void Graph_Analog_Data() {
	extern short Data[MAX_FRAMES*MAX_CHANNELS];	/* Eye data	*/
	extern short Touch1[MAX_FRAMES*2];		/* Arm data	*/
	int i;
	int AVG = ANALOG_GRAPH_DENSITY;		/* Look up value once	*/
	int MsPerFrame = MsPerFrame_Header() * AVG;
	int channels = ChannelCount_Header();
	int frames_out;
	int remainder;

	if (AVG==0)	/* For -g1, this says to show just avg point	*/
	   AVG = 1;	/* But AVG=0 would be meaningless here.		*/

	frames_out = FrameCount_Header() / AVG;
	remainder  = FrameCount_Header() % AVG; /* Frames in end smp*/
	
	if (frames_out == 0 && remainder) {	/* Rare err condition	*/
	   Warning("Odd analog data condition (Graph_Analog_Data)");
	   return;
	   }

	fill(0);				/* Insurance (required)	*/

	/* Do the eye and perhaps chair traces	*/
	if (GRAPH_EYES || GRAPH_CHAIR)
	 for (i=0; i<channels; i++) {		/* For each channel	*/
	   int frame = 0;
	   int ms = MsPerFrame/2 - MsPerFrame;	/* Plot at center of bin*/
	   register short *ad =				/* Pt to analog	*/
	        Data + i - channels;			/* 1 frame back	*/
	   int upward = (i==V_EYE) ? OFFSET_V_EYE_TRACE : 0;

	   if (i==H_EYE && !(GRAPH_EYES & 01))
	      continue;
	   if (i==V_EYE && !(GRAPH_EYES & 02))
	      continue;
	   if (i==CHAIR_VELOCITY && !(GRAPH_CHAIR & 01))
	      continue;
	   if (i==CHAIR_POSITION && !(GRAPH_CHAIR & 02))
	      continue;

	   while (++frame <= frames_out) {	/* Accounts for AVG	*/
	        int sum = 0;
		int j;

	        for (j=0; j<AVG; j++) {
		   ad += channels;
		   sum += *ad;
		   }
	        ms += MsPerFrame;		/* Accounts for AVG	*/
		if (frame == 1)
		   move( ms, ADtoPIX(sum/AVG) + upward);
	        else
		   cont( ms, ADtoPIX(sum/AVG) + upward);
		}
	   if (remainder) {			/* End frame: incomplete*/
	        int sum = 0;
		int j;
	        for (j=0; j<remainder; j++)
		   sum += *(ad+=channels);
		cont( ms+=MsPerFrame, ADtoPIX(sum/remainder) + upward);
		}
	   }


	/* Now graph arms */
	if (GRAPH_ARMS != 0 && TouchCount_Header(1) != FAIL)
	 for (i=0; i<2; i++) {			/* For each channel	*/
	   int frame = 0;
	   int ms = MsPerFrame/2 - MsPerFrame;	/* Plot at center of bin*/
	   register short *ad =				/* Pt to analog	*/
	        Touch1 + i - 2;				/* 1 frame back	*/
	   int upward = (i==V_ARM) ? OFFSET_V_EYE_TRACE : 0;
	   int WasInBreak = 1;		/* True: not in 'cont' stream	*/

	   if (GRAPH_ARMS==2 && i==H_ARM)
	      continue;
	   if (GRAPH_ARMS==1 && i==V_ARM)
	      continue;					/* break	*/

	   if (i == H_ARM)
	      Color(0,7,0);
	   else if (i==V_ARM)
	      Color(0,0,7);

	   while (++frame <= frames_out) {	/* Accounts for AVG	*/
	        int sum = 0;
		int j;
		int DataPresent = 1;

	        for (j=0; j<AVG; j++) {
		   ad += 2;
		   if (*ad == NO_TOUCH)		/* Could break out	*/
		      DataPresent = 0;		/* but need to shift ad	*/
		   sum += *ad;
		   }
	        ms += MsPerFrame;		/* Accounts for AVG	*/

	        if (WasInBreak && DataPresent) {	/* End of break	*/
	   	   move( ms, ADtoPIX(sum/AVG) + upward);
		   WasInBreak = 0;
		 } else if (DataPresent)		/* NOT in break	*/
		   cont( ms, ADtoPIX(sum/AVG) + upward);
		 else	/* Regardless of previous value of WasInBreak,	*/
		   WasInBreak = 1;	/* WasInBreak is now true	*/
		}

	   if (remainder) {			/* End frame: incomplete*/
	        int sum = 0;
		int all_ok = 1;
		int j;
	        for (j=0; j<remainder; j++) {
		   sum += *(ad+=2);
		   if (*ad == NO_TOUCH) {
		      all_ok = 0;
		      break;
		      }
		   }
		if (all_ok)
		   cont( ms+=MsPerFrame, ADtoPIX(sum/remainder) + upward);
		}
	   }

	/* fill(0);				* Insurance		*/
	}
/* ********************************************************************	*/

/* FUNCTION Graph_Analog_Zero */
	 /* Mark analog zero	*/
static void Graph_Analog_Zero() {
	int Zero = ADtoPIX(DEGtoAD(0));
	int End  = DurationTime();

   	/* Color(0,0,0); */

        SetLineWidth(0);

	move(0, Zero+50);
	move(0, Zero+50);
	cont(100, Zero);
	cont(0, Zero-50);
	cont(0, Zero+50);
	fill(1);

#	if WANT_ANALOG_ZERO_LINE
	  move(0,   Zero);
	  cont(End, Zero);
#	endif

	if (OFFSET_V_EYE_TRACE) {
	    move(0,   Zero + OFFSET_V_EYE_TRACE);
	    cont(End, Zero + OFFSET_V_EYE_TRACE);
	    }
	}
/* ********************************************************************	*/

/* FUNCTION Graph_Raster */
	/* Note: tic size doesn't scale.	*/
static void Graph_Raster(int type) {
	extern short Spikes[MAX_SPIKES];		/* Spike data	*/
	short *spikes = Spikes;
	int y = HEIGHT - 5 - ((PICTURE_NONTARGET_BEHAVS) ? 350:150);
	int SpikeCount = SpikeCount_Header(-1);
	extern int if_overlay_stacks(), if_overlay_classes();

	if (if_layout_from_stack()|| if_overlay_stacks()|| if_overlay_classes()) {
	   int stack = List_Index(Get_TrialType_Info(type,STACK),STACK)-1;
	   int count =		/* n-th raster for this type stack/class */
	        ++(SpecialCounts[Get_TrialType_Info(type,CELL)-1][stack]);

	   if (if_overlay_classes()) {
	      stack = List_Index(Get_TrialType_Info(type,CLASS),CLASS)-1;
	      }  	/* Count is still correct; no need to redo it	*/
		   
		
	   SetColorByTrialType(type);
	   y -= ((int)(RASTER_TIC_HEIGHT*(1+PERCENT_BETWEEN_RASTER_ROWS/100.)
			* count)) +	/* First part float, 2nd is int	*/
		     RASTER_SPACE*stack / 
		          List_Length( (if_overlay_classes()) ? CLASS : STACK);
	} else {
	   Color(0,0,0);
	   y -= ((int)(RASTER_TIC_HEIGHT*(1+PERCENT_BETWEEN_RASTER_ROWS/100.)
			* Counts[type]));
	   }
	SetLineWidth(RASTER_WIDTH * (1 + (RASTER_TIC_HEIGHT>=40)));
	while ((SpikeCount-=SHOW_EVERY_NTH_SPIKE_IN_RASTER) >= 0) {
	    move(*spikes, y);
	    cont(*spikes, y-RASTER_TIC_HEIGHT);
	    spikes += SHOW_EVERY_NTH_SPIKE_IN_RASTER;	/* Push pointer	*/
	    }
	}	
/* ********************************************************************	*/

/* FUNCTION Mark_Time */
	 /* Used only by Graph_Target_Appearance */
static void Mark_Time(int when, int offset) {
	   if ((when>0) && (when<DurationTime())) {
	      move(when, HISTO_OFFSET-offset);
	      label("|");
	      }
	   }
/* ********************************************************************	*/

/* FUNCTION Graph_Target_Appearance */
	/* Mark just below time line where 2nd, 3rd & 4th targets appear*/
	/* Could also put mark into the raster line itself ...		*/
	/*   Also including disappearing targets */
	/* NOTE: doing blank & off for every target is misguided.  Best *
	 * case, the 'on' and 'off' marks are vertically adjacent.  But *
	 * that will generally fail (since not one 'blank' per targ).	*/
static void Graph_Target_Appearance() {
	int when;
	int blank = 0;
	int off = 0;
	int offset = 50;
	int i = 0;

	fontsize(4);

	if (((when=Get_TargetTime(2)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(3)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(4)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(4)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(5)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(6)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(7)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	if (((when=Get_TargetTime(8)) != FAIL) ||
	    ((when=Get_TargetBlankTime(++blank)) != FAIL) ||
	    ((when=Get_TargetOffTime(++off)) != FAIL))
	   Mark_Time(when, offset+=25);

	while ((when=Get_RedrawTime(++i)) != FAIL)
	   Mark_Time(when, offset+=25);
	}	
/* ********************************************************************	*/

/* FUNCTION Graph_TimeLine */
	 /* Show time tics						*/
void Graph_TimeLine() {
	int Zero = Get_ZeroTime();		/* Time zero in ms	*/
	int time;

	Color(8,0,0);				/* Zero line is red	*/
	SetLineWidth(2);
	move(Zero, HISTO_OFFSET);
	cont(Zero, HISTO_OFFSET-150);

	Color(0,0,0);				/* All else is black	*/
	for (time=Zero+100; time<=DurationTime(); time+=100) {
	    move(time, HISTO_OFFSET);
	    cont(time, HISTO_OFFSET-30);
	    if ((time-Zero)%1000 == 0)
	       cont(time, HISTO_OFFSET-80);
	    }
	for (time=(Zero-100); time>=0; time-=100) {
	    move(time, HISTO_OFFSET);
	    cont(time, HISTO_OFFSET-30);
	    if ((time-Zero)%1000 == 0)
	       cont(time, HISTO_OFFSET-80);
	    }
	}
/* ********************************************************************	*/
#  define BAR_SIZE   ((ZM>2) ? "12" : "60")
#  define BAR_HEIGHT ((ZM>2) ?  6   :  30)

/* FUNCTION Graph_ScaleBars */
	 /* Scale bars */
static void Graph_ScaleBars() {
	int total = RightEdgeCoord();		/* # of horiz pixels	*/
	/* int BarHeight = (ZM>0) ? 30/ZM : (ZM<-0) ? 30 * (-ZM) : 30;	*/
	/* char BarSize[10]; */

	/* sprintf(BarSize, "±%d", BarHeight); */

	Setup_Coords_For_TrialType(TOP_LEFT_CELL);
	SetLineWidth(2);
   	fontsize(14);
	Color(0,0,0);

	move(-total/35,  ADtoPIX(DEGtoAD(0)));
   	alabel('r', 'c', BAR_SIZE);
	move(-total/35,  ADtoPIX(DEGtoAD(0))-500);
   	alabel('r', 'c', "deg");
	move(-total/50, ADtoPIX(DEGtoAD( BAR_HEIGHT)));
	cont(-total/40, ADtoPIX(DEGtoAD( BAR_HEIGHT)));
	cont(-total/40, ADtoPIX(DEGtoAD(-BAR_HEIGHT)));
	cont(-total/50, ADtoPIX(DEGtoAD(-BAR_HEIGHT)));
	move(-total/50, ADtoPIX(DEGtoAD(  0)));
	cont(-total/40, ADtoPIX(DEGtoAD(  0)));
	}
/* ********************************************************************	*/

/*  VERTICAL LINES ON PLOT */
static int VerticalLineCount = 0;
static int LinesAt[20];					/* Max 20 lines	*/

/* FUNCTION Add_Vertical_Lines_On_Graph */
void Add_Vertical_Lines_On_Graph(int ms) {
   LinesAt[VerticalLineCount++] = ms;
    
   }
/* FUNCTION Init_Vertical_Lines_On_Graph */
void Init_Vertical_Lines_On_Graph() {
   VerticalLineCount = 0;
   }
/* FUNCTION Do_Vertical_Lines_On_Graph */
void Do_Vertical_Lines_On_Graph() {
   int line = VerticalLineCount;
   int type;
   int zero = Get_ZeroTime();
    
   SetLineWidth(2);
   Color(0,0,0);
   while (line-- > 0)
      for (type=0; type < Count_TrialTypes(); type++) {
	 Setup_Coords_For_TrialType(type);
	 move(LinesAt[line] + zero, 0);
	 cont(LinesAt[line] + zero, HEIGHT);
         }
   }

/* FUNCTION Do_Vertical_Lines_On_One_Graph */
	 /* Don't set the coordinates; just write blindly */
void Do_Vertical_Lines_On_One_Graph() {
   int line = VerticalLineCount;
   int zero = Get_ZeroTime();

   SetLineWidth(0);
   Color(0,0,0);
   while (line-- > 0) {
      move(LinesAt[line] + zero, 0);
      cont(LinesAt[line] + zero, HEIGHT);
      }
   }
/* ********************************************************************	*/

/* FUNCTION Graph_DrawBox */
static void Graph_DrawBox() {
   if (DRAW_BOX) {
     SetLineWidth(2);			/* Double thick	*/
     move(0,0);				/* Draw box	*/
     cont(0,HEIGHT);
     cont(DurationTime(), HEIGHT);
     cont(DurationTime(), 0);
     cont(0, 0);
    }
   }
/* ********************************************************************	*/
