/* FILE functions.h */
     /*  Public function declarations */
     /* WARNING: Install new functions in macros/Function.h, too!	*/

#include <stdlib.h>					/* abs.h	*/

/* clude "macro.h"		* macro prototypes (included below)	*/

/* align.c */	void InitAlignTimes();
/* align.c */	void Init_Align();
/* align.c */	int  Set_AlignTime();
/* align.c */	int  Get_AlignTime();
/* align.c */	char *AlignTime_String();
/* align.c */	char *Get_AlignmentTime();
/* align.c */	void Set_Alignment_From_CmdLine(char *CmdLine);
/* align.c */   int  UseVSYNC(int at);

/* anova.c */	double *anova(double **data, int rows, int cols);
/* anova.c */	double **dmatrix(int rows, int cols);
#ifdef NOT_ACTUALLY_CALLED
/* anova.c */	void init_dmatrix(double **mat, int rows, int cols);
/* anova.c */	void free_dmatrix(double **m, int rows, int cols);
#endif

/* arm.c */	void PrintArm();
/* arm.c */	int  Is_Arm_Touching(int time);
/* arm.c */	int  Get_Arm_Time(int OnOff, int forward, int time,
						int InitialAlignment);
/* arm.c */	int  Get_Arm_Move_Time(int time, int InitialAlignment);
/* arm.c */	int  Get_Arm_Stop_Time(int time, int InitialAlignment);
/* arm.c */	int  Get_Arm_Times(int time);

/* batch.c */	int   Is_Batch();
/* batch.c */	void  Open_BatchFile();
/* batch.c */	char *Next_BatchFile_Entry();
/* batch.c */	void  Set_BatchFile_Name(char *name);

/* behav.c */	void Get_EyePosition(int begin, int end, float *h, float *v);
/* behav.c */	void Get_ArmPosition(int begin, int end, float *h, float *v);
/* behav.c */	void Get_ArmWidth(int begin, int end, float *h, float *v);
/* behav.c */	int  TimeNotRecorded(int begin, int end);
/* behav.c */	int  TimeRecorded(int begin, int end);

/* blink.c*/	void RemoveBlinks1();
/* blink.c*/	void RemoveBlinks2();

/* button.c*/	void PrintButtons(int diag);
/* button.c*/	int  Get_Button_Time(int OnOff, int bit, int occurrence,
					    int from, int InitialAlignment);

/* calib.c */	void Init_CalibFile(char *inputfile);
/* calib.c */	void Read_CalibFile(int number);
/* calib.c */	void Do_Calibration(short *data, int channels, int frame);

/* config.c */	void Read_User_Config_File();
/* config.c */	void Print_Config_Parameters(char *OneOnly);
/* config.c */	int function_SHOW_ANALOG();
/* config.c */	int function_SINGLE_ANALOG();
/* config.c */	int function_FAST_FIGURE();
/* config.c */	int function_SEMI_FAST_FIGURE();
/* config.c */	int function_FULL_FIGURE();
/* config.c */	int function_GRAPH_EYES();
/* config.c */	int function_GRAPH_ARMS();
/* config.c */	int function_GRAPH_CHAIR();
/* config.c */	int function_FILTER_EYES();
/* config.c */	int function_SHOW_PICTURES();
/* config.c */	int function_SHOW_ONE_PICTURE();
/* config.c */	int function_SHOW_CUE_ONLY();
/* config.c */	int function_RASTER_TIC_HEIGHT();
/* config.c */	int function_DRAW_BOX();
/* config.c */	int function_ZOOM_AD_RANGE_UNITS();
/* config.c */	int function_SHOW_SINGLES();
/* config.c */	int function_STATS_ON_SUM_FIG();
/* config.c */	int function_EXPAND_TIME_AXIS();
/* config.c */	int function_HEIGHT();
/* config.c */	int function_HISTO_OFFSET();
/* config.c */	int function_REAL_BIN_SIZE();
/* config.c */	int function_ASH();
/* config.c */	int function_SMOOTH();
/* config.c */	float function_P_CRITERIA();
/* config.c */	int function_PREF_MINUS_NULL();
/* config.c */	int function_SPECIAL_FIGURE_TITLES();
/* config.c */  int function_ANALOG_GRAPH_DENSITY();
/* config.c */  int function_OFFSET_V_EYE_TRACE();
/* config.c */  int function_SHRINK_PAGE_BORDERS();
/* config.c */	int function_ZOOM_AD_RANGE_BEHAV();
/* config.c */	int function_PICTURE_EVERY_TARGET();
/* config.c */	int function_PICTURE_TARGET_0();
/* config.c */	int function_PICTURE_TARGET_1();
/* config.c */	int function_PICTURE_TARGET_2();
/* config.c */	int function_PICTURE_TARGET_3();
/* config.c */	int function_PICTURE_TARGET_4();
/* config.c */	int function_PICTURE_TARGET_5();
/* config.c */	int function_PICTURE_TARGET_6();
/* config.c */	int function_PICTURE_TARGET_7();
/* config.c */	int function_PICTURE_TARGET_8();
/* config.c */	int function_PICTURE_TARGET_9();
/* config.c */	int function_PICTURE_NONTARGET_BEHAVS();
/* config.c */	int function_PICTURE_TRIAL_COUNT();
/* config.c */	int function_ALIGN_USING_ACQUIRE();
/* config.c */	int function_REMOVE_BLINKS();
/* config.c */	int function_SMOOTH_SD();
/* config.c */	int function_BIN_SIZE_MS();
/* config.c */	int function_MACRO_APPENDS();
/* config.c */	int function_MACRO_NAME_UNITRUN();
/* ********************************************************************	*/

/* coord.c */	void Set_Dimensions_For_Coords(int row, int col);
/* coord.c */	int  TopCoord(int percent);
/* coord.c */	int  Test_Coords_For_TrialType(int type);
/* coord.c */	int  Setup_Coords_For_TrialType(int type);
/* coord.c */	int  RightEdgeCoord();
/* coord.c */	int  LeftEdgeCoord();

/* event.c */	int  EventExtract(int type, int which, int occurrence);
/* event.c */	int  MultiEventExtract(int types[], int which, int occurrence);
/* event.c */   int  EventExtractTapeOn();
/* event.c */   int  EventExtractTapeOff();
/* event.c */   int  EventExtractErrorBegin();
/* event.c */   int  EventExtractTrialStamp();
/* event.c */   void EventAddTrialStamp(int add);
/* event.c */   int AcquireEventExtract(int behav, int target, int which,
								int occurrence);
/* event.c */	int WindowAcquireEventExtract(int which, int occurrence);
/* event.c */   int TargetEventExtract(int target, int which, int occurrence);
/* event.c */   int AnyTargetEventExtract(int which, int occurrence);
/* event.c */   int TargetOffEventExtract(int target,int which,int occurrence);
/* event.c */   int AnyTargetOffEventExtract(int which, int occurrence);
/* event.c */	void Shift_Time_In_Event_Stack(int time);
/* event.c */	void Print_Events();
/* event.c */	void Show_Events_For_XY_Plot();
/* event.c */	void Adjust_Events(EVENT *header_stack);
/* event.c */	void CheckLengthOfEventStack(int data_length);
/* event.c */   int  EventNameToNumber(char *name);

/* graph.c */	void Do_Graphics();
/* graph.c */	void Set_Show_Raster_FromCmdLine(int count);
/* graph.c */	void Init_Graphics();
/* graph.c */	void End_Graphics();
/* graph.c */	void Begin_Graphics(char *file, FILE *stream);
/* graph.c */	void Graph_Analog_Data();
/* graph.c */	void Graph_TimeLine();
/* graph.c */	void Add_Vertical_Lines_On_Graph(int ms);
/* graph.c */	void Init_Vertical_Lines_On_Graph();
/* graph.c */	void Do_Vertical_Lines_On_Graph();
/* graph.c */	void Do_Vertical_Lines_On_One_Graph();

/* head.c */	void   UnRead_Header(int File);
/* head.c */	int    Read_Header(int File);
/* head.c */	void   Write_Header_To_File(int out);
/* head.c */    void   Set_UnitNumber(int unit);
/* head.c */    void   Set_RunNumber(int run);
/* head.c */    void   AddToTrialStamp(int add);
/* head.c */	int    FrameCount_Header();
/* head.c */	int    SpikeCount_Header(int channel);
/* head.c */	int    TouchCount_Header(int board);
/* head.c */	int    ButtonCount_Header();
/* head.c */	int    ChannelCount_Header();
/* head.c */	int    MsPerFrame_Header();
/* head.c */	int    TableNumber_Header();
/* head.c */	int    StackNumber_Header();
/* head.c */	int    TrialNumber_Header();
/* head.c */	int    RawTableNumber_Header();
/* head.c */	int    RawStackNumber_Header();
/* head.c */	char  *StackName_Header();
/* head.c */	int    UnitNumber_Header();
/* head.c */	int    RunNumber_Header();
/* head.c */	char   MonkChar_Header();
/* head.c */	char  *MonkName_Header();
/* head.c */	int    ChairAt_Header();
/* head.c */	int    ErrType_Header();
/* head.c */	int    Punish_Header(int which);
/* head.c */	int    Flag_Header(int MASK);
/* head.c */	void   Clear_Flag_Header(int MASK);
/* head.c */	void   Set_Flag_Header(int MASK);
/* head.c */	void   Set_FrameCount_Header(int i);
/* head.c */	void   Set_SpikeCount_Header(int i);
/* head.c */	void   Set_TouchCount_Header(int board, int i);
/* head.c */	void   Set_TrialNumber_Header(int i);
/* head.c */	void   Set_StackNumber_Header(int i);
/* head.c */	void   Set_StackName_Header(char *new);
/* head.c */	void   Set_ClassNumber_Header(int i);
/* head.c */	void   Set_ButtonCount_Header(int i);
/* head.c */	void   Increment_StackNumber_In_Header(int i);
/* head.c */	void   Shift_Time_In_header(int time);
/* head.c */	EVENT *Stack_Ptr_Header();
/* head.c */	char  *Date_From_Header();
/* head.c */	int    Year_From_Header();
/* head.c */	int    Month_From_Header();
/* head.c */	int    Day_From_Header();
/* head.c */	float  Time_From_Header();
/* head.c */	char  *Time_Header();
/* head.c */	void   PrintHeader();
/* head.c */	void   PrintDetailedHeader();
/* head.c */	void   Warning(char *string);
/* head.c */	int    Version();
/* head.c */	int    CalibFile_Header();
/* head.c */	int    RunStatus_Header();
/* head.c */	int    ExtraTimeOnError_Header();
/* head.c */	void   Clear_CalibFile_Header();
/* head.c */	void   Restore_CalibFile_Header();
/* head.c */	int    Get_UnitChannel_Header();
/* head.c */	void   Set_UnitChannel_Header(int multi);
/* head.c */	int    Get_TouchBound_Header(int horiz);
/* head.c */	int    Get_ViewingDistance_Header();
/* head.c */	int    Get_SetupNumber_Header();


/* help.c */	void  Print_Help(char what);
/* help.c */	void  Print_Usage();

/* histo.c */	void  Do_Histograms(int Output);
/* histo.c */	void  Init_Histogram();
/* histo.c */	void  Cumulate_Interval_And_Histogram();
/* histo.c */	void  Set_Histo_Scale_From_CmdLine(int x);
/* histo.c */	int   Get_Histo_Scale_From_CmdLine();
/* histo.c */	void  Set_Unfilled_Histos_From_CmdLine();
/* histo.c */	int   Get_Histo_BinSize();
/* histo.c */	void  Show_Histogram(int type);
/* histo.c */	char *Report_Histo_Info();
/* histo.c */	void  Set_Interval_By_Peak_Variance();

/* input.c */	void   Rewind_InputFile();
/* input.c */	int    TrialNumber_Input();
/* input.c */	char  *FileName_Input();
/* input.c */	int    Open_InputFile(char *inputfile);
/* input.c */	int    Get_InputFile();
/* input.c */	int    Read_Next_Trial(int SkipDataFlag);
/* input.c */	short *Read_Skipped_Data();
/* input.c */	void   Close_InputFile();
/* input.c */	int    Read_Trial(int number);
/* input.c */	void   UnRead_Data();
/* input.c */	void   Skip_Over_Data();
/* input.c */	void   Exit(char *string, char *name);
/* input.c */	void   Keep_All_Data();


/* interval.c*/	void  Init_Intervals();
/* interval.c*/ void  Reset_Intervals();
/* interval.c*/ int   Spikes_In_Interval(int interval);
/* interval.c*/	void  Cumulate_Interval(int spikes1, int spikes2, int type);
/* interval.c*/	void  Calc_Spikes_Per_Interval();
/* interval.c*/	int   Get_Interval_Type();
/* interval.c*/	int   Get_Interval_Begin(int which_interval);
/* interval.c*/	int   Get_Interval_End  (int which_interval);
/* interval.c*/	float Get_Interval_Mean (int type, int which_interval);
/* interval.c*/	float Get_Interval_SEM  (int type, int which_interval);
/* interval.c*/	float Get_Interval_SD   (int type, int which_interval);
/* interval.c*/	int   Get_Interval_Count(int type, int which_interval);
/* interval.c*/	int  *Get_Interval_Data (int type, int which_interval);
/* interval.c*/	int  *Get_Interval_TrialNumber (int type);
/* interval.c*/	void  Set_Interval_From_CmdLine(int b,int e,int which_interval);
/* interval.c*/	void  Set_bg_Interval_From_CmdLine(int e);
/* interval.c*/	void  Show_Interval();
/* interval.c*/	void  Set_Interval_By_Bin(int b, int e);
/* interval.c*/ int   Bad_Interval(int align, int extra);
/*interval.c*/float Ttest_On_Interval(int interval,int type1,int type2,int sides);
/*interval.c*/float Ttest_On_Two_Intervals(int type, int sides);
/*interval.c*/float Ttest_Vs_Zero_On_Interval(int interval,int type,int sides);
/*interval.c*/float Anova_On_Interval();

/* layout.c */	int  List_Length (int list);
/* layout.c */	int  List_Element(int list,int n);
/* layout.c */	void Init_Lists();
/* layout.c */	void List_Append(int new[]);
/* layout.c */	void Sort_Lists();
/* layout.c */	int  List_Index(int find, int list);
/* layout.c */	int  Match_List(int trialtype, int list, int n);
/* layout.c */  int  if_layout_from_stack();
/* layout.c */  int  Class_Column(int class);
/* layout.c */  int  Stack_Row(int stack);
/* layout.c */  void Layout_Trials(int Output);
/* layout.c */  void Set_Layout_From_CmdLine(char *Cmdline);
/* layout.c */  void Layout_Single_Trial();

/* macro.c */   int  Get_Macro_Number();
/* macro.c */	void Set_dataValue_From_CmdLine(int dataValue);
/* macro.c */	int  Get_dataValue_From_CmdLine();
/* macro.c */	void Set_DataValue_From_CmdLine(int DataValue);
/* macro.c */	int  Get_DataValue_From_CmdLine();
/* macro.c */	void Clear_oValues();
/* macro.c */	void Set_oValue(int number, char ch, int DataValue);
/* macro.c */	int  Get_oValue(int number, char ch, int Default);
/* macro.c */	int  Do_Macro(char *file);
/* macro.c */	void Print_Macro_Numbers(int decade);
/* macro.c */	int  Set_Macro_Output(int number);
/* macro.c */	FILE *Open_Macro_Output(char *name, int AddNameUnitRun);
#include "macro.h"	/* The rest of the macro definitions */

/* main.c *	int  main(int argc, char **argv);	*/
/* main.c */	char *Get_CallCommand();
/* main.c */	char *Report_Anal_Header_Info(int line);

/* merge.c */	void Set_MergeStacks(char *CmdLine);
/* merge.c */	int  MergeStack(int stack);
/* merge.c */	void Init_Merge();
/* merge.c */	void Set_MergeTables(char *CmdLine);
/* merge.c */	int  MergeTable(int table);

/* output.c */	void  Open_OutputFile(char *inputname, char *suffix);
/* output.c */	void  Set_OutputFile_TrialLimit(int limit);
/* output.c */	void  Set_OutputFile_ShiftTime(int time);
/* output.c */	void  Write_OutputFile();
/* output.c */	void  Close_OutputFile();

/* picture.c */	void Picture();

/* ps.c */	void openpl(FILE *stream);
/* ps.c */	void closepl(void);
/* ps.c */	void space(int x00, int y00, int x01, int y01);
/* ps.c */	void move(int x, int y);
/* ps.c */	void cont(int x, int y);
/* ps.c */	void box(int x00, int y00, int x01, int y01);
/* ps.c */	void filledbox(int x00, int y00, int x01, int y01);
/* ps.c */	void erase(void);
/* ps.c */	void arc(int xc, int yc, int x00, int y00, int x01, int y01);
/* ps.c */	void circle(int x, int y, int r);
/* ps.c */	void point(int x, int y);
/* ps.c */	void SetColor(int red, int green, int blue);
/* ps.c */	void SetLineWidth(int width);
/* ps.c */	void linemod(char *s);
/* ps.c */	void fill(int level);
/* ps.c */	void label(char *s);
/* ps.c */	void fontsize(int size);
/* ps.c */	void fontname (char *s);
/* ps.c */	void rotate (int w, int h, int angle);
/* ps.c */	void alabel (int x_justify, int y_justify, char *s);
/* ps.c */	int  Is_PlotOpen(void);

/* sac.c */	int  Get_Saccade_Time(int SacStart,
			int forward, int begin, int InitialAlignment);
/* sac.c */	int Get_Saccade_Peak_Velocity(
			int forward, int begin, int InitialAlignment);

/* skip.c */	void Init_Skip();
/* skip.c */	void Store_Skip(char type, int from, int to);
/* skip.c */	void UnStore_NoSkip(char type);
/* skip.c */	void Store_No_Skip(char type, int from, int to);
/* skip.c */	void Store_EventSkip(char x, int event, int from, int to,
					int which, int occur, int stack);
/* skip.c */	int  SkipTrial(int trial);
/* skip.c */	void Seen_Merge();
/* skip.c */	void Seen_Skip();

/* time.c */	void Init_Times();
/* time.c */	void Set_TrialTiming();
/* time.c */	int  DurationTime();
/* time.c */	void Force_Zero_SkipAnalogTime(int value);
/* time.c */	void Force_Zero_SkipTime(int value);
/* time.c */	int  SkipAnalogTime();
/* time.c */	int  SkipSpikeTime();
/* time.c */	int  Get_ZeroTime();
/* time.c */	int  Get_TargetTime(int i);
/* time.c */	int  Get_RedrawTime(int i);
/* time.c */	int  Get_TargetOffTime(int i);
/* time.c */	int  Get_TargetBlankTime(int i);
/* time.c */	int  Get_TapeOnTime();
/* time.c */	void Set_Times_From_CmdLine(int start, int finish);
/* time.c */	void Unset_Times_From_CmdLine();
/* time.c */	int  Get_Times_From_CmdLine();
/* time.c */	int  Interval_To_Stack_Time(int interval_time);
/* time.c */	int  Stack_To_Interval_Time(int stack_time);

/* title.c */	void  Set_Title_From_CmdLine(char *title);
/* title.c */	char *Get_Title_From_CmdLine();
/* title.c */	void  Do_Class_Titles(int Output);
/* title.c */	void  Do_Single_Trial_Title();
/* title.c */	void  Do_Header_Title();

/* trial.c */	int  Get_TrialType_Info(int type, int what);
/* trial.c */	void Set_TrialType_Info(int type, int what, int to);
/* trial.c */	void Set_TrialTypes();
/* trial.c */	void Set_TrialTypes_For_Single_Trial();
/* trial.c */	int  Count_TrialTypes();
/* trial.c */	int  Get_StackClass_TrialType(int stack, int table);
/* trial.c */	int  Get_TrialType();
/* trial.c */	void Set_MonteCarlo_TrialType();

/* ttest.c */	float Ttest(int *data1, int count1,
				int *data2, int count2, int sides);
/* ttest.c */	float Ttest_short(float mean1, int count1, float sem1,
				  float mean2, int count2, float sem2,
				  int sides);
/* ttest.c */	float Ttest_vs_zero(int *data, int count, int sides);

/* util.c */	void SetColorByTrialType(int type);
/* util.c */	void SetColorByStackIndex(int stackindex);
/* util.c */	void SetColorByStackNumber(int stacknumber);
/* util.c */	void Color(int a, int b, int c);
/* util.c */	int  TargetLocation(int targ);
/* util.c */	int  Coord_To_TargetCode(int x, int y);
/* util.c */	void SayWhere(char *msg);

/* xyplot.c */	void Init_XY_Plot();
/* xyplot.c */	void Do_Individual_XY_Plot();
/* xyplot.c */  void XY_Plot_Vector(int H, int V, int time, int which);
/* xyplot.c */  void XY_Plot_Target(int H, int V, int which);
/* xyplot.c */  void XY_Plot_Pursuit(int H1, int V1, int H2, int V2);


/* reach/util.c */	int MinAndReportDiff(int a, int b);
/* reach/util.c */	int Check_Class();
/* reach/util.c */	int Opposite_Class();

/* muscimol */  void EventTime130( void );
/* muscimol */  void TargetPosi131( void );
/* muscimol */  void SacTime132( void );
