/* FILE filter.c */
   /* Gets included into input.c */

/* ********************************************************************	*/
	/* Either our old filters (Lowpass) or new ones (Matlab)	*/
static float FilterCoefs64[] = { /* # of points, transition band freqs	*/
#		include "/data/code/byter/washu/_filters/L80_64.fil"
		};
static float FilterCoefs32[] = {
#		include "/data/code/byter/washu/_filters/L80_32.fil"
		};
static float FilterCoefs16[] = {
#		include "/data/code/byter/washu/_filters/L125_16.fil"
		};
static float FilterCoefs8[] = {
#		include "/data/code/byter/washu/_filters/L250_8.fil"
		};
static float FilterCoefs4[] = {
#		include "/data/code/byter/washu/_filters/L400_4.fil"
		};
static float FilterCoefs2[] = {
#		include "/data/code/byter/washu/_filters/L800_2.fil"
		};
static float FilterCoefs1[] = {
#		include "/data/code/byter/washu/_filters/L1500_1.fil"
		};


static float *FilterCoefs() {
   switch (FILTER_EYES) {
      case 64:   return(FilterCoefs64);
      case 32:   return(FilterCoefs32);
      case 16:   return(FilterCoefs16);
      case  8:   return(FilterCoefs8);
      case  4:   return(FilterCoefs4);
      case  2:   return(FilterCoefs2);
      case  1:   return(FilterCoefs1);
      default:   return(FilterCoefs64);		/* Never happens!	*/
      }				/* (but this line stops a warning!)	*/
   }

static int FilterLength() {
   switch (FILTER_EYES) {
      case 64: return(sizeof(FilterCoefs64) / sizeof(float));
      case 32: return(sizeof(FilterCoefs32)  / sizeof(float));
      case 16: return(sizeof(FilterCoefs16)  / sizeof(float));
      case  8: return(sizeof(FilterCoefs8)  / sizeof(float));
      case  4: return(sizeof(FilterCoefs4)  / sizeof(float));
      case  2: return(sizeof(FilterCoefs2)  / sizeof(float));
      case  1: return(sizeof(FilterCoefs1)  / sizeof(float));
      default: return(1);		/* Never happens!	*/
      }				/* (but this line stops a warning!)	*/
   }
/* ********************************************************************	*/
#define Edge 	    (FilterLength() - 1)

short Temp[MAX_FRAMES * MAX_CHANNELS];
/* ********************************************************************	*/

/* FUNCTION Multiply */
static int Multiply(short *data, float *weight, int stepsize) {
   short *left  = data-(Edge*stepsize);	/* Data before center	*/
   short *right = data+(Edge*stepsize);	/* Data after center	*/
   float sum = 0.;
   int i;

   for (i=1; i<FilterLength(); i++) {	/* All but center point	*/
      sum += *(weight++) * (*left + *right);	/* weight flanks*/
      left += stepsize;
      right -= stepsize;
      }
   sum += *weight * *left;			/* Center point	*/

   if (sum > 0.)
      return( (int) (sum+0.5) );
   else
      return( (int) (sum-0.5) );
   }
/* ********************************************************************	*/

/* FUNCTION Filter */
static void Filter(short *data, int frames, int channels) {
   int i;

   for (i=(0+Edge)*channels; i<(frames-Edge)*channels; i++)
      *(Temp+i) = Multiply(data+i,FilterCoefs(),channels);

   for (i=(0+Edge)*channels; i<(frames-Edge)*channels; i++)
      *(data+i) = *(Temp+i);
   }
/* ********************************************************************	*/
