/* FILE event.i */
     /* Prompts for entering events, text for main type, and description */
     /* (Text for printing events is in edit.c) */
     /* Sorted by priority and numeric value; can split in 2 pages      */
     /* WARNING: tag lines cannot have same name as event tag!  */
     /* Note: no tags smaller than 3 characters - see MemoryCorrupt()   */

     /* FORMAT:  %1 == value of E->one
      *          %b1 == BehavName[E->one]
      *		 %B3 == "%b3" if PrintEventsByTargetName; else "%3"
      *          %o2 == OffOrOn[E->two]
      *          %C3 == ChannelName[E->three]
      *          %c3 == ColorName[E->three]
      *          %v3 == ValueName[E->three]
      *          %t3 == TargetName[E->three]	# suppress print-by-name (%T)
      *		 %T3 == "%t3" if PrintEventsByTargetName; else "%3"
      *          %r3 == RGB_Name[E->three]
      *          %O2 == if (E->two) continue; else Puts("Off"), don't continue
      *          %X2 == if (E->two) continue; else don't continue
      *          %S2 == Get_Experiment_Name(E->2)
      */

#define TAG_LINE        8888                    /* Not a real entry     */

struct EVENT_INFO {
	int  type;
	char *tag;                              /* Up to 19 letters     */
	char *one;                              /* Param prompt-string  */
	char *two;                              /* For parameter 2      */
	char *three;                            /* For parameter 3      */
	char *describe;                         /* Help string          */
	char *format;                           /* On-line print format */
	} Event_Info[] = {

/* ORDER BY FREQUENCY/IMPORTANCE AND BY CATEGORY */

{TAG_LINE,      "DATA", "", "", "", "", ""},

{DISPLAY,       "Display",      "cell",         "of",           "color",
   "Display analog &/or spike data in 'cell' (1-12)",
   "%1%C2%c3" },
{ALIGN,         "Align",        "",             "at (%)",       "scale",
   "This event X% thru window of corresponding DISPLAY event",
   "%2%% scale:%3" },
{SUMMARY,       "Summary",      "cell",         "type",         "where",
   "Summary figure type %2 in cell %1. See event.i for details",
   /* If type is 1, puts entries in order of table/column number, using 8 slots
   		 5, Like 8, but classes > 8 wrap back around (diff color?)
      If type is 2, puts entries in order of 3rd argument, using 8 slots
      If type is 3, 3rd argument specifies percentages through the cell */
   /* If DISPLAY (not SUMMARY) cell is greater than MAX_CELLS, shows summary
      but doesn't plot any histo, raster, etc. */
   SPECIAL_FORMAT_STRING },
{STORE_EYE,     "Store Eye",    "cell(0=off)",  "color",        "scale",
   "Storage scope: scale<0:center on chair=0; cell==0:turn off; 2=full size",
   "%O1cell:%1%c2scale:%3" },
/* Color: if 15 (white), then color code targets */

/* BEHAVIOR/ STIMULI */
{TAG_LINE,      "\nBEHAVE", "", "", "", "", "" },

{EYE_STEP_RAMP, "StepRamp",     "",             "",             "",
   "Step target & shift window, opp but proportional to prev pursuit",
	 /* Exact amount is written into header stack by
	  *  Do_Initial_Events, and is read only. 
	  * Note: linked cue does not follow a step ramp. 
	  */
   "%2X %3(read only)" },

{EYE_SINE_H, "EYE Sine H",      "Size(off)",    "period",       "phase",
   "Move H eye targ sinusoidally (size(d);period(ms);phase(d; usu 0)",
   "%O1 %1d %2ms %X3%3d" },
{EYE_SINE_V, "EYE Sine V",      "Size(off)",    "period",       "phase",
   "Move V eye targ sinusoidally (size(d);period(ms);phase(d; usu 0)",
   "%O1 %1d %2ms %X3%3d" },

{TAG_LINE,      "\nCUES", "", "", "", "", "" },

{LINK_CUE_TO_PURSUIT, "Link cue (E)",   "to",   "enable",       "",
   "Move cue along with eye/arm/both base target",
   "to %b1%o2" },

{TAG_LINE,      "\nWINDOWS", "", "", "", "", "" },
{EYE_WINDOW,    "Eye Window",   "ellipse",              "H",            "V",
   "Eye window size in deg/10 for 'acquire' events; rectangle or ellipse",
   "%2X %3 %X1round" },
{EYE_WINDOW_SHIFT, "Mv eye wndw",       "",             "H",            "V",
   "Shift window by H,V (deg/10) [NOTE: NOT CUMULATIVE]",
   "%2X %3" },
{LIMIT_DRIFT,   "Limit drift",          "which",        "less than",    "",
  "Stay +/-~ 10ths of current position (rwd_if ignores). OFF:~2=0 or SAC event",
   "%b1%O2< %2" },
{EYE_WINDOW_CHANGE, "EyeWindow+=",      "",     "H",            "V",
   "Open or close eye window by ~ tenths",
   "%2X %3" },
{CHANGE_WINDOW_BY_EYE_PURSUIT, "Wnd+=Eye mv",   "which",        "tenth relax per deg pursuit (H)", "V",
   "Open (eye or arm) windows ~tenth degs per deg of EYE movement",
   "%b1%2X %3" },
{TAG_LINE,      "\nSTIMULI", "", "", "", "", "" },
{LITE_OFF,      "LiteOff",      "",             "",             "",
   "Room lites off",
   "" },
{CHAIR_TO,      "Chair to",     "tenths",       "",             "",
   "Move turntable to ~ tenths of degrees, wait till there",
   "%1 d" },
{CHAIR_TO_RUNTIME,  "Chair To", "tenths",       "",             "",
   "Move turntable to ~ tenths of degrees, don't wait till there",
   "%1 d (no pause)" },
{CHAIR_AT,      "Chair at",     "tenth/sec",    "",             "",
   "Move turntable at constant rate of  ~ tenths of degrees/sec",
   "%1/10 d/s" },

{TAG_LINE,      "\nFLOW ", "", "", "", "", "" },
{DELAY,         "Delay",        "lines",        "max",          "steps",
   "Delay next ~ lines, 0 to ~ ms (default:10)",
   SPECIAL_FORMAT_STRING },
{START_AT,      "Start",        "# acquires",   "",             "",
"# acquires before change from start to run errs",
   SPECIAL_FORMAT_STRING },
{START_HERE,    "Start here",   "",             "",             "",
"Change from start to run err right now!",
   "" },
{ERROR_STACK,   "Err stack",    "stack#",       "",             "",
"Run this stack on error (can change midway through stack) {0==off}",
   "%O1%1 %S1"},
{CALL_STACK,    "Call stack",   "stack#",       "",             "",
"Insert a stack here (only -1 events)",
   "%1 %S1" },
{NEXT_STACK,    "Next stack",   "on err?",       "stack#",      "",
"If success/err, do this stack next.  If stack=0, pick at random.",
   "%2 %S2%X1on err" },

/* ************************** */
/* ****** SECOND PAGE ******* */
/* ************************** */

{TAG_LINE,      "\nREWARDS", "", "", "", "", "" },
{REWARD,        "Reward",       "",             "",             "ms",
   "Reward (unconditional) (0==global value; >0==ms; <0==% of global value)",
   "%X3%3" },
{REWARD_OPTIONAL,  "Rwd if",       "by",           "#",       "ms",
   "No abort if out. Write time in value3. TargOff, Acq or RwdIfOff to end.",
   "%b1%T2%X3 %3 ms" },
{REWARD_OPTIONAL_OFF,  "Rwd if off",       "by",           "",       "",
   "Kill the optional reward",
   "%b1" },
{REWARD_WHILE_ON,"Rwd while",   "#/by",           "interval",     "ms",
   "Periodic rwds; disable by int=0, targ off or acq; write last time in val3. Targ# must == behav",
   "%b1%O2%2 ms %X3%3" },

{REWARD_OPTIONAL_BUTTON_AND,  "RwdIf button&", "bit pattern", "Buttons", "ms",
   "No abort if out. Write time in value3. TargOff, Acq or RwdIfOff to end.",
   "Bits %1 (buttons %2)%X3 %3 ms" },

{REWARD_OPTIONAL_BUTTON_OR,  "RwdIf button||", "bit pattern", "Buttons", "ms",
   "No abort if out. Write time in value3. TargOff, Acq or RwdIfOff to end.",
   "Bits %1 (buttons %2)%X3 %3 ms" },

{REWARD_SCHEDULE, "Rwd sched",  "#",            "per",          "ms",
   "Reward one in two times (run a counter)",
   "%1 in %2 %X3%3" },
{REWARD_INCREMENT, "Rwd incr",  "on/off",	"override global",	"",
   "Reward increments ('R' cmd) on/off.  Precedence over global?",
   "%o1%X2(override)" },

{TAG_LINE,      "\nBEHAV:ARM", "", "", "", "", "" },
{STORE_ARM,     "Store Arm",    "cell(0=off)",  "color",        "scale",
   "Storage scope: scale<0:center on chair=0; cell==0:turn off; 2=full size)",
   "%O1cell:%1%c2scale:%3" },

{BUTTON_ACQUIRE_AND, "Button acq &", "bit pattern",  "Buttons",	"max wait",
   "Has ~ms to match ~1 using buttons in ~2; 'Acq off 3' to cancel",
   "Bits %1 (buttons %2) %3ms" },
{BUTTON_ACQUIRE_OR, "Button acq ||",  "bit pattern",  "Buttons", "max wait",
   "Has ~ms to match ~1 using buttons in ~2; 'Acq off 4' to cancel",
   "Bits %1 (buttons %2) %3ms" },

{ACQUIRE_ARM, "Acq arm",      "#",           "wait 1",     "wait 2",
   "Touch screen w/in ~2 m; targ ~1 within ~3 ms of 1st touch" ,
   "%T1 wait1:%2 wait2:%3"},

{ARM_WINDOW,    "Arm Window",   "ellipse",              "H",            "V",
   "Arm window size in deg/10 for 'acquire' events; rectangle or ellipse",
   "%2X %3 %X1round" },
{ARM_WINDOW_SHIFT, "Mv arm wndw",       "",             "H",            "V",
   "Shift window by H,V (deg/10) [NOTE: NOT CUMULATIVE]",
   "%2X %3" },
{ARM_PURSUIT_GRACE, "ArmPursGrace", "value",    "",             "",
  "Allow ~ tics (20 ms) of no contact during pursuit",
  "%1" },
{ARM_WINDOW_CHANGE, "ArmWindow+=",      "",     "H",            "V",
   "Open or close arm window by ~ tenths",
   "%2X %3" },
{CHANGE_WINDOW_BY_ARM_PURSUIT, "Wnd+=Arm mv",   "which",        "tenth relax per deg pursuit (H)", "V",
   "Open (eye or arm) windows ~tenth degs per deg of ARM movement",
   "%b1%2X %3" },
{ARM_TOUCH_WIDTH, "ArmWidth",      "",     "width",            "",
   "Touch width can't exceed ~ (units=beam spacing?)",
   "%2" },
{ARM_TOUCH_WIDTH_CHANGE, "ArmWidth+",      "",     "width",            "",
   "Open or close touch width window",
   "%2" },

{TAG_LINE,      "\nSTIMULI", "", "", "", "", "" },
{LITE_ON,       "LiteOn",       "",             "",             "",
   "Room lites on",
   "" },
{LITE_FOR,      "LiteFor",      "",             "",             "ms",
   "Lites on for ~ ms",
   "%3 ms" },
{TTL_LINE,      "TTL Line",     "line",         "state",        "",
   "Digital IO line on/off",
   "%1%o2" },
{TTL_ON,        "TTL On",       "line",         "",             "",
   "Digital IO line on",
   "%1" }, 
{TTL_OFF,       "TTL Off",      "line",         "",             "",
   "Digital IO line off",
   "%1" }, 
{V_SYNC,       "V sync",        "on/off",     "",             "",
   "Display between 'on' and 'off' all at once, & send pulse back to spike board",
   "%o1" }, 
{TTL_LEAVE, "TTL leave",  	"",     "",     "",
   "Don't change TTL (digital IO) status at end of successful trial",
   "" },
{TARGET_LEAVE, "Targ leave",  	"",     "",     "",
   "Don't change video display at end of successful trial",
   "" },
{STIMULATE,	"Stimulate",	"duration",	"ISI",	"OnFor",
   /* "Turn on speaker for ~ ms at 1000/~ hz, on for ~ ms", */
   "Stimulate for %1 ms, pulses every %2 ms, 0 < %3 < %2",
   "%1ms ISI=%2ms (%3ms)" },
{STIM_AMPLITUDE,"Stim amp",	"(0-31):", "", "",
   "Set 5 TTL lines to tell stim box the pulse amplitude",
   "%1" },
{TRIAL_STAMP,   "Trial stamp",	"Trial", "", "",
   "Sent trial # to the plexon via digital line (data, maybe plus clock)",
   "%1" },

{TAG_LINE,      "\nDATA", "", "", "", "", "" },
{TAPE_ON,       "TapeOn",       "",             "",             "",
   "Start taking data", ""},
{TAPE_OFF,      "TapeOff",      "",             "",             "",
   "Stop taking data", ""},


{TAG_LINE,      "\nDISPLAY", "", "", "", "", "" },
{MARK_DISPLAY,  "Mark time",    "cell",         "",             "color",
   "Mark current time in associated cell",
   "%1%c3" },
{STORE_XY,      "Store XY",     "on/off",       "",             "",
   "Store positions on main XY display",
   "%o1"},
{STORE_SHOW_TARGET,     "Store Targ",   "color",        "H",            "V",
   "Show a target on storage screen",
   "%c1 %2x%3"},

{TAG_LINE,      "\n GENERICS", "", "", "", "", ""},

{ACQUIRE,       "Acquire",      "by",           "#",            "max  wait",
   "Get (arm/eye/head) in window w/in ~ms" ,
   SPECIAL_FORMAT_STRING },
{ACQUIRE_OFF,	"Acq off",	"by",           "",             "",
   "Disable acquire of behavior ~",
   "%B1" },
   /* "Turn on speaker for ~ ms at 1000/~ hz, on for ~ ms", */
{TARGET_ON,     "On ",		"#",            "H",            "V",
   "Turn target ~ on at ~ x ~",
   "%T1%2X %3" },
{TARGET_OFF,    "Off",		"#",            "",             "",
   "Turn target ~ off",
   "%T1" },
{TARGET_ON_POLAR, "(r,<)",	"#",		"radius",	"theta",
   "Turn target ~ on at location  r,theta",
   "%T1%2x %3" },
{TARGET_SAC,	"Sac",		"#",		"+H",		"+V",
   "Jump target to this relative location",
   "%T1%2X %3" },
{TARGET_SAC_POLAR, "Sac (r,<)",   "targ", 	"+radius",       "+theta",
   "Targ ~ to r,theta relative to current location",
   "%T1 %2x %3" },
{TARGET_DIM,    "Dim",          "#",            "intensity",    "",
   "Target ~ dimmed to ~%",
   "%T1%2%%" },
{TARGET_BLANK,  "Blank",        "#",            "on/off",       "",
   "Blank target ~ (but retain any acquire require)",
   "%T1%o2" },
{TARGET_SINUSOID_SETUP,	/* SINES */
		"Sine setup",	"period(ms)",	"phase (deg)",	"",
   "Prepare for sinusoidally moving target(will not all fit in 1 event)",
   "%1 ms %X2%2 deg" },
{TARGET_SINUSOID,	/* SINES */
		"Sinusoid",	"targ",	   "H=1 or V=0", "size (deg)",
   "Move target sinusoidally (see SETUP, too)",
   "%T1 H or V:%2 %3 deg" },
{TARGET_PURSUIT, "Pursue",      "#/behavior",	"H",            "V",
   "Drift target ~ at H x V d/s. NOTE: Targ # must correspond to behavior!",
   "%T1%2X %3" },
{TARGET_WITH_ARM, "Targ w/ arm", "targ",    "on/off",	"",
   "Move target ~1 with the arm",
   "%T1 %o2"},
{TARGET_WITH_ARM_OFFSET, "Targ/arm offset", "targ",    "H",	"V",
   "Set up to move target ~1 with the arm, but shifted by (~2,~3)",
   "%T1 %2X %3"},
{TARGET_OFF_IN,  "Off in",	"#",        "ms",             "",
   "Turn target ~ off ~ ms from now",
   "%T1%2ms" },
{TARGET_RAMP_INTENSITY,"Dim at",   "#",   "PartsPer10000",     "step at",
   "Ramp by ~ PartsPer10,000 (intensity) per ms (<0: dim; >0:brighten); enlg at ~3",
   "%T1%210000ths%X3 for %3 ms" },
{TARGET_SIZE,   "Size",		"targ #",       "H",            "V",
   "Change target size, deferred til next ON, SAC, UNBLANK, REDRAW",
   "%T1%2X %3" },
{TARGET_COLOR,  "Color",	"targ #",       "color",        "",
   "Change target color, deferred til next ON, SAC, UNBLANK,REDRAW",
   "%T1%c2" },
{TARGET_RGB,  "RGB",		"targ #",       "color(1-3)",  "value(0-63)",
   "Change to a new target color, specified by R/G/B (does not save the color)",
   "%T1%r2%3"},
{NEW_COLOR, "New color", "#(16-31)", "color(1-3)","value(0-63)",
   "Assign RGB values to a new (saved) color",
   SPECIAL_FORMAT_STRING },
{NEW_BACKGROUND_COLOR, "BG color", "red",	"green",	"blue",
   "Set a new background color",
   "R:%1G:%2B:%3" },
{TARGET_SHAPE,  "Shape",	"targ #",       "shape/#sides", "orientation",
   "Number sides (1==line, 2==cross), oriented ~ deg re 3 oclock (deferred)",
   "%T1%2sides%X3 %3deg" },
   /* On setup 4, 1 is also a cross, and size <= 10 is not right!  */
{TARGET_REDRAW, "Redraw",  	"",     "",     "",
   "Implement any deferred changes in (all) target size/shape/color",
   "" },

{TARGET_RE_0,    "Re:0",   "targ", 	"+H",            "+V",
   "Targ ~ to ~ x ~ relative to targ 0",
   "%T1%2X %3" },
{TARGET_RE_1,    "Re:1",   "targ", 	"+H",            "+V",
   "Targ ~ to ~ x ~ relative to targ 1",
   "%T1%2X %3" },
{TARGET_RE_2,    "Re:2",   "targ", 	"+H",            "+V",
   "Targ ~ to ~ x ~ relative to targ 2",
   "%T1%2X %3" },
{TARGET_RE_3,    "Re:3",   "targ", 	"+H",            "+V",
   "Targ ~ to ~ x ~ relative to targ 3",
   "%T1%2X %3" },
{TARGET_RE_4,    "Re:4",   "targ", 	"+H",            "+V",
   "Targ ~ to ~ x ~ relative to targ 4",
   "%T1%2X %3" },
{TARGET_RE_0_POLAR, "Re:0 polar",     "targ", 	"+radius",       "+theta",
   "Targ ~ to (~,~) relative to targ 0",
   "%t1 %2x %3" },
{TARGET_RE_1_POLAR, "Re:1 polar",      "targ", 	"+radius",       "+theta",
   "Targ ~ to (~,~) relative to targ 1",
   "%t1 %2x %3" },
{TARGET_RE_2_POLAR, "Re:2 polar",      "targ", 	"+radius",       "+theta",
   "Targ ~ to (~,~) relative to targ 2",
   "%t1 %2x %3" },
{TARGET_RE_3_POLAR, "Re:3 polar",      "targ", 	"+radius",       "+theta",
   "Targ ~ to (~,~) relative to targ 3",
   "%t1 %2x %3" },
{TARGET_RE_4_POLAR, "Re:4 polar",      "targ", 	"+radius",       "+theta",
   "Targ ~ to (~,~) relative to targ 4",
   "%t1 %2x %3" },
{TARGET_MOVIE, "Movie",   "targ",       "#",       "",                        
   "Targ ~1 is movie ~2",                                                       
   "%T1 %2" },                                                                  
{TARGET_BITMAP, "Bitmap",   "targ",     "#",       "",                        
   "Targ ~1 is bitmap ~2",                                                    
   "%T1 %2" },

{TAG_LINE,      "\n MISC", "", "", "", "", ""},

{EYE_CALIB,     "Eye cal",      "on/off",       "",             "",
  "Begin a snapshot of eye position to send to calibration routines",
  "%o1" },
{SET_GROUPING,  "Group",        "trials",       "",             "",
   "Group trials in blocks of this size",
   "%1trials" },
{SET_HDR_CLASS, "Class+=",      "increment",    "",             "",
   "Increment header's record of class number",
   "%1" },
{SET_HDR_STACK, "Stack+=",      "increment",    "",             "",
   "Increment header's record of stack number",
   "%1" },
{PICK_TWO_COLUMNS,"Pick 2 cols",    "Sort on",          "unique",         "",
"Pick '*' col independent of # done (uniq from $?), & sort on '*' or '$'",
/*    Imagine that you've done 1 repetition of columns 1-5, and no reps of
   column 6.  Both '*' and '$' will select column 6. To avoid this, and
   have the selection of the '*' column ignore the number of trials you've
   done, use 'pick two columns'.  Specify which selector to name/sort trials.
   That is, if you pick column 1 for '*' and column 2 for '$', is that a
   table 1 or table 2 type trial?  Finally, do you want UNIQUE columns?
  */
  "sort on %1%X2; unique cols" },
/*  Note: '*' is always chosen first.  If '$' appears first in the stack,
    then trials are tallied according to '$'.  This can lead to a problem
    if there are only 2 columns in the table.  Consider what happens when
    you've already run as many trials of one column as requested.  When
    the '*' column is selected, it ignores that information.  Imagine that
    the OTHER column is selected.  Now the '$' column is FORCED to be the
    column that you already have enough trials for!   To avoid this, put
    the '*' first in the stack.                                         */

{ SAVE_VALUE,   "Save value",   "code",         "",             "",
   "Save a particular value (into param 2 and 3) (Diff from SET, etc!)",
   /* Put parameter values into format so that looking at 0th stack we see
      what values were just run. */
   /* Although no direct connection with GET_VALUE, etc., you can use
    *  SAVE_VALUE to get some particular parameter, and then use GET_VALUE
    *  and APPLY_VALUE to apply that same parameter elsewhere.		*/
   "%v1  (%2 %3)" },

{ MACRO_CALL,	"Macro call", 	"#",	"param2",	"param3",
   "Call macro ~1 with parameters ~2 and ~3 (before clock starts)",
   SPECIAL_FORMAT_STRING },
{ MACRO_END,	"Macro end",	"",	"",	"",
   "Optional marker inserted by macro code",
   "" },
{ MACRO_DATA,	"Macro data",	"Param 1",	"2",	"3",
   "Additional data for a macro",
   "%1 %2 %3" },
{ RUNTIME_MACRO,"Run macro", 	"#",	"param2",	"param3",
   "Call macro ~1 with parameters ~2 and ~3 (during normal execution)",
   SPECIAL_FORMAT_STRING },

{ SET_VALUE,	"Set value",	"#",	"value",	"",
   "Value ~1 = ~2",
   "%1 = %2" },
{ SET_VALUE_FROM_RANGE,	"Value range",	"#",	"from",	"to",
   "Value ~1 = (from ~2) (to ~3) (step 1)",
   "%1 = %2:%3" },
{ SET_VALUE_WITH_STEP,	"Value step",	"#",	"to",	"step",
   "Value ~1 = (from 0) (to ~2) (step ~3)",
   "%1 = 0:%2 by %3" },
{ SET_UNIQUE_VALUE,	"Value uniq",	"#",	"as #",	"to",
   "Value ~1 = ~2",
   "%1 != %2, 0:%3" },
{ SET_SAME_VALUE,	"Value same",	"#",	"as #",	"",
   "Value ~1 = ~2",
   "%1 = %2" },
{ GET_VALUE,	"Get value",	"#",	"from param",	"from line",
   "Value ~1 = ~2-th param of current line +/- ~3 (or next line)",
   "%1 = slot%2%X3of line +%3, " },
{ ADD_TO_VALUE,	"Add value",	"#",		"add",		"",
   "Add ~2 to saved value ~1",
   "%1 += %2" },
{ MULTIPLY_VALUE,"Mult value",	"#",		"mult",		"div",
   "Mult saved value ~1 by ~2/~3",
   "%1 *= %2/%3" },
{ APPLY_VALUE,"Apply value",	"#",		"param",	"",
   "Add value ~1 to ~2-th param of next line",
   "%1 to param%2" },
{ VALUES_BEFORE_FLOW_CONTROL,	"DoValuesEarly", "", "", "",
   "Generate, do math on and apply (random) variables BEFORE flow control",
   /* Applies to entire stack, even events that occur BEFORE this event */
   "" },
{ LIMIT_VALUE,	"Limit value",	"#",		"floor",	"ceiling",
   "if value ~1 < ~2 set to ~2; if > ~3 set to ~3",
   "%1 <=%2 >=%3" },

{ERROR_STACK_BEGIN,  "Error Begin",     "stack#",       "",             "",
"Never inserted by user, only by program: marks begin of err stack",
   "%1" },
{DISPLAY_ERROR,      "Display err",     "dim",	"",             "",
"Show error pattern on video (dim==0 is default brightness (30%?)",
   "%X1%1%%"},				/* Print only if non-zero */

{TAG_LINE,      "\n FLOW", "", "", "", "", ""},

{PAUSE,         "Pause",        "",             "",             "ms",
   "Pause (delay) for ~ ms (used with lookup, or in -1 period)",
   "%3 ms" },
{RESTART,       "Restart",      "",             "",             "",
   "Reset clocks to 0 (use for >6s stacks)",
   "" },
{DO_IF_FIRST,   "Do Once",      "",             "lines",        "",
   "Do next ~ lines on 1st trial of group (do not repeat if err)",
   "%2 lines" },
/* Note: on all subsequent "DO" events, if there is an error on trial
   "n", then trial count remains "n" and so the exact stack is repeated.
   On DO_IF_FIRST, trial count goes from 0 to 1 after an error, so
   the stack will not be the same on the second repetition. */
{DO_IF_TRIAL,   "Do If =",      "if trial=",    "lines",        "",
   "Do next ~ lines if n-th trial of group (repeats if err)",
   "trial %1  %2lines" },
{DO_IF_NOT_TRIAL,"DoIf!=",      "if trial!=",   "lines",        "",
   "Do next ~ lines if NOT n-th trial of group",
   "trial %1  %2lines" },
{DO_IF_PAST,    "IfPast",       "past trial",   "lines",        "",
   "Do next ~ lines if PAST n-th trial of group",
   "trial %1  %2lines" },
{DO_IF_NOT_PAST,"If!Past",      "! past trial", "lines",        "",
   "Do next ~ lines only if NOT PAST n-th trial of group",
   "trial %1  %2lines" },
{DO_IF_LAST,   "Do if last",      "",             "lines",        "",
   "Do next ~ lines if last trial of group",
   "%2 lines" },
{DO_IF_NOT_LAST,   "Do if!last",      "",             "lines",        "",
   "Do next ~ lines if NOT last trial of group",
   "%2 lines" },

{SKIP_IF_EQUAL,     "Do  ",     "lookup",  "lines",        "cmp",
   "Do ~ subsequent lines if two values are NOT equal",
   "%2 lines if %1!= %3" },
{SKIP_IF_NOT_EQUAL, "Skip",     "lookup",  "lines",        "cmp",
   "Skip ~ subsequent lines if two values are NOT equal",
   "%2 lines if %1!= %3" },

{DO_IF_CONSECUTIVE_SUCCESSES,
	"DoIfDid", "operator(?)", "lines",  "count(<0:errs)",	
  "Do if # consecutive success (errs) !=(0) or =(1) 'count' ('?'for more info)",
  /* Successes if > 0, errs if < 0 */
   SPECIAL_FORMAT_STRING },


{END_STACK,     "End",          "",             "",             "",
   "End of stack",
   "" },
{ -1,           "Unknown",      "1",            "2",            "3",
   "Never used",
   SPECIAL_FORMAT_STRING },
};

typedef struct EVENT_INFO EVENT_INFO_TYPE;      /* Short-hand declare   */


/* USEFUL STRINGS: */
static char *BehavName[MAX_BEHAV] = {
  "Arm.0", "Eye.1", "Move.arm.2", "Move.eye.3", "ReleaseArm.4",
  "Button&.5", "Button|.6", "Wiggle.7" };
static char *OffOrOn[2] = {
  "Off",    "On "                                                       };
static char *ChannelName[] = {
  "Units.0", "Arm+U.1", "Eye+U.2", "A+E+U.3", "zip.4","Eye+Multi.5","E+Chair.6",
  "Unit2.7"
  };

static char *ColorName[16+MAX_CUSTOM_COLORS] = {
  "Black.0","Blue.1","Green.2", "Cyan.3", "Red.4", "Purp.5", "Brown.6","Grey.7",
  "grey.8", "blue.9","green.10","cyan.11","red.12","purp.13","ylw.14", "wh.15",
  "custom.16", "custom.17", "custom.18", "custom.19", "custom.20" };

static char *RGB_Name[] = { "vga.0", "red.1", "green.2", "blue.3" };

/* For SaveValue events: */
static char *ValueName[] = {
  "none.0", "ArmTarg.0", "EyeTarg.1", "CueTarg.2"
									};
/* Behaviors with same numbers as targets: */
   /* Danger: you need the padding, else strncpy causes trouble */
static char *NamedTargets[MAX_TARGETS] = {
	"ARM\000padding",
	"EYE\000padding",
	"E+A\000padding",
	"CUE\000padding",
	"CU2\000padding",
	"5\000padding..",
	"6\000padding..",
	"7\000padding..",
	"8\000padding.." };

#ifdef OBSELETE_EVENTS

{CHANNEL_COUNT, "Channels",     "#",            "",             "",
   "Number channels to record (0, 1, 2, 4 or 8)",
   "%1"},
 {ARM_RELEASE,   "ARM release",  "",             "",             "max wait",
   "Acquire condition: do not press screen (ARM rlse off  to end requirement)",
   "%3ms" },
 {ARM_RELEASE_OFF, "ARM rlse off",  "",  "",             "",
   "Disable arm release requirement)",
   "" },
{UNIQUE_COLUMNS,"Unique cols",  "Sort on",      "",             "",
"Choose different '$' and '*' cols; sort on one or other",
  "sort on %1" },
{ RANDOM_VALUE_0,	"Rand value 0",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_1,	"Rand value 1",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_2,	"Rand value 2",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_3,	"Rand value 3",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_4,	"Rand value 4",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_5,	"Rand value 5",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_6,	"Rand value 6",	"from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{ RANDOM_VALUE_20,	"Rand value 20","from",		"to",		"step",
   "Set/save a random value",
   "%1to %2by %3" },
{TARGET_INTERIOR,   "Interior",     "targ#", 	"%size(0=off)",   "color",
   "Targ ~ has an interior of size ~2 & color ~3 (disable by size=0)",
   "%T1%O2 %2%% %c3" },
{TARGET_INTERIOR_COMMANDS, "Interior Cmds",   "Targ#",	"on/off", "",
   "Lines w/in brackets refer to target interior",
   "%O2%T1%o2" },
{TARGET_RSVP, "RSVP",   "on/off",     "",       "",                        
   "Turn RSVP on or off (set up using macro call)",
   "%o1" }
#endif
