/* FILE event.h */

/* ********************************************************************	*/
/*  Only difference from event.h is that we should add TARGET_RE_[5-9] and
     TARGET_RE_[5-9].POLAR (?) */
/* ********************************************************************	*/
/* READ IN event.h from reach here: */
/* ********************************************************************	*/
/* FILE event.h */

/* Stack entries consist of a time, an instructions & 3 values.
 * Entries are also called 'EVENTS'.
 */

/* TYPES */
# define	STACK_END		0	/* End			*/
# define	END_STACK		0

# define	EYE_SINE_H		212	/* Sinusoidal target (h)*/
# define	EYE_SINE_V		213	/* Sinusoidal target (v)*/
# define	EYE_STEP_RAMP		214	/* Jump back or forward	*/

# define	EYE_WINDOW		230	/* Window = _ X _	*/
# define	EYE_WINDOW_SHIFT	231	/* Eye Window += _ X _	*/
# define	LIMIT_DRIFT		232	/* Drift limit-tenths	*/
# define	EYE_WINDOW_CHANGE	234
# define	CHANGE_WINDOW_BY_EYE_PURSUIT 235 /* Base on pursue length*/

# define	STORE_EYE		240	/* Ordered as behavs are*/

# define	ARM_RELEASE		317	/* Obselete		*/
# define	ARM_RELEASE_OFF	        318	/* Obselete		*/
# define	BUTTON_ACQUIRE_AND	319
# define	BUTTON_ACQUIRE_OR	320
# define	ARM_PATTERN_ACQUIRE	325	/* Obselete		*/

# define	ARM_WINDOW		330
# define	ARM_WINDOW_SHIFT	331
# define	ARM_PURSUIT_GRACE	333	/* Tiny contact break ok*/
# define	ARM_WINDOW_CHANGE	334
# define	CHANGE_WINDOW_BY_ARM_PURSUIT 335 /* Based on arm movemnt*/
# define	ARM_TOUCH_WIDTH		336
# define	ARM_TOUCH_WIDTH_CHANGE	337

# define	STORE_ARM		340	/* Storage scope on	*/

# define	ACQUIRE			400
# define	ACQUIRE_ARM		300	/* Specialized acq	*/
# define	ACQUIRE_OFF		401
# define	TARGET_ON		402
# define	TARGET_SAC		403
# define	TARGET_OFF		408	/* Turn visual LEDs off	*/
# define	TARGET_DIM		409	/* % on			*/
# define	TARGET_BLANK		410	/* Blank/un acq target	*/
# define	TARGET_SINUSOID_SETUP	413	/* period, phase	*/
# define	TARGET_SINUSOID		414	/* targ, H or V, size	*/
# define	TARGET_PURSUIT		415	/* SmPurs: targ,h,v	*/
# define	TARGET_ON_POLAR		416	/* Targ on in r,theta	*/
# define	TARGET_SINE_H		420	/* Sinusoidal target (h)*/
# define	TARGET_SINE_V		421	/* Sinusoidal target (v)*/
# define        TARGET_WITH_ARM         423     /* Move with arm        */
# define        TARGET_WITH_ARM_OFFSET  424     /*   what it says       */
# define	TARGET_MOVIE		426
# define	TARGET_BITMAP		427
# define	TARGET_RSVP		428

/* NOTE: 43? events take effect only when target is redrawn */
# define	TARGET_SIZE		430	/* H x V pixels		*/
# define	TARGET_COLOR		431	/* From palette	of 16	*/
# define	TARGET_SHAPE		432	/* # sides, rotation	*/
# define	TARGET_REDRAW		433	/* Implement changes	*/
# define	TARGET_RGB		435	/* Set RGB colors	*/
# define	NEW_COLOR		135	/* Define a new color	*/
# define	NEW_BACKGROUND_COLOR	136

# define	TARGET_RE_0		440	/* Place re: targ 0	*/
# define	TARGET_RE_1		441	/* Place re: targ 1	*/
# define	TARGET_RE_2		442	/* Place re: targ 2	*/
# define	TARGET_RE_3		443	/* Place re: targ 3	*/
# define	TARGET_RE_4		444	/* Place re: targ 4	*/
# define	TARGET_RE_5		445	/* Place re: targ 4	*/
# define	TARGET_RE_6		446	/* Place re: targ 4	*/
# define	TARGET_RE_7		447	/* Place re: targ 4	*/
# define	TARGET_RE_8		448	/* Place re: targ 4	*/
# define	TARGET_SAC_POLAR	450	/* Sac 			*/
# define	TARGET_RE_0_POLAR	451	/* Place re: targ 0	*/
# define	TARGET_RE_1_POLAR	452	/* Place re: targ 1	*/
# define	TARGET_RE_2_POLAR	453	/* Place re: targ 2	*/
# define	TARGET_RE_3_POLAR	454	/* Place re: targ 3	*/
# define	TARGET_RE_4_POLAR	455	/* Place re: targ 4	*/
# define	TARGET_RE_5_POLAR	456	/* Place re: targ 4	*/
# define	TARGET_RE_6_POLAR	457	/* Place re: targ 4	*/
# define	TARGET_RE_7_POLAR	458	/* Place re: targ 4	*/
# define	TARGET_RE_8_POLAR	459	/* Place re: targ 4	*/
# define	TARGET_OFF_IN		460	/* Targ# off in ~ ms	*/
# define	TARGET_RAMP_INTENSITY	461	/* Targ# dims/brightens	*/

# define	TARGET_INTERIOR		 480	/* targ# becomes hollow	*/
# define	TARGET_INTERIOR_COMMANDS 481	/* Hollow: next ~3 lines*/ 

# define	LINK_CUE_TO_PURSUIT	610	/* Move cue in lockstep	*/

# define	TAPE			1	/* Record on/off	*/
# define	TAPE_ON			2
# define	TAPE_OFF		3

# define	DISPLAY			10	/* Chan_ in cell_ (col_)*/
# define	ALIGN			11	/*       time->_,scale=_*/
# define	ALIGN_SAC		12	/*   next sac->_,scale=_*/
# define	MARK_DISPLAY		13	/* Cell_:tic at E->time	*/
# define	SUMMARY			15	/* Cell_:sum figure	*/

# define	DELAY			20	/* Delay _ to _ ms (#lines)*/
# define	PAUSE			21	/* Wait this long	*/
# define	RESTART			22	/* Effects error type	*/
# define	START_AT		23	/* After ~ acq's, start	*/
# define	START_HERE		24	/* Henceforth, run err	*/
# define	NEXT_STACK		25	/* Next stack to run	*/
# define	ERROR_STACK		30	/* Run this stack on err*/
# define	ERROR_STACK_BEGIN	31	/*  Show where err was	*/
# define	CALL_STACK		33	/* Insert a stack here	*/
# define	PICK_TWO_COLUMNS	34	/* '*' ignores # done	*/
# define	DISPLAY_ERROR		36	/* Tell video to show er*/

# define	STORE_XY		43	/* Store on XY	*/
# define	STORE_SHOW_TARGET	44	/* Store on XY	*/
						/* See also 240, 340	*/

# define	REWARD			50	/* Juice		*/
# define	REWARD_OPTIONAL		51	/* No abort if off	*/
# define	REWARD_WHILE_ON		52	/* No abort if off	*/
# define	REWARD_SCHEDULE		53	/* Infrequent rewards	*/
# define	REWARD_OPTIONAL_OFF	54	/* Like 51, but turn off*/
# define	REWARD_INCREMENT	55	/* Enable/disable	*/
# define	REWARD_OPTIONAL_BUTTON_AND	56
# define	REWARD_OPTIONAL_BUTTON_OR	57
# define	REWARD_WHILE_ON_BUTTON_AND	58
# define	REWARD_WHILE_ON_BUTTON_OR	59

# define	CHAIR_TO		60	/* Go to position (hang)*/
# define	CHAIR_TO_RUNTIME	61	/* Set position & go on	*/
# define	CHAIR_AT		64	/* Set rate		*/

# define	TTL_LINE		70	/* Output line#_ state	*/
# define	LITE_FOR		71	/* Lites on ~ ms	*/
# define	TTL_ON			72
# define	TTL_OFF			73
# define	LITE_ON			74
# define	LITE_OFF		75
# define	V_SYNC			76	/* Set video sync on/off */
# define	TTL_LEAVE		77	/* No chg at end of trial*/
# define	STIMULATE		78	/* Set up a tone	 */
# define	TARGET_LEAVE		79	/* Display unchg'd in ITI*/
# define	STIM_AMPLITUDE		80	/* Stimulation amplitude */
# define	TRIAL_STAMP		90	/* Write trial # to plexn*/

#define		EYE_CALIB		130	/* Snapshot for coil cal*/

/* Rare stuff: */
#define		SET_GROUPING		810	/* Set grouping to ONE	*/
#define		SET_HDR_CLASS		811	/* Increment class #	*/
#define		SET_HDR_STACK		812	/* Increment stack #	*/

#define		MACRO_CALL		900	/* Call in -1 time	*/
#define		MACRO_END		901	/* Optional marker	*/
#define		MACRO_DATA		902	/* Optional added data	*/
#define		RUNTIME_MACRO		910	/* Call during run time	*/


/* PICK a value (from a range, etc).  CHANGE it by adding, multiplying or
 * dividing it by another number.  Then APPLY it by putting it into
 * the E->one, two or three parameter slot, having first added __ to it
 */
#define		SET_VALUE		1000	/* val# = ~ or lookup	*/
#define		SET_VALUE_FROM_RANGE	1001	/* val#, from,to	*/
#define		SET_VALUE_WITH_STEP	1002	/* val#, step, to	*/
#define		SET_UNIQUE_VALUE	1003	/* val#, vs_val#, to	*/
#define		SET_SAME_VALUE		1004	/* val#, vs_val#	*/
#define		GET_VALUE		1021	/* set val# = other line*/
#define		ADD_TO_VALUE		1024	/* value# += ~ 		*/
#define		MULTIPLY_VALUE		1025	/* value# *= ~/~	*/
#define		CHANGE_VALUE		1026	/* # value = val*~ + ~	*/
#define		APPLY_VALUE		1027	/* # to param~ of line+~*/
#define		VALUES_BEFORE_FLOW_CONTROL 1028	/* Usu do flow first	*/
#define		LIMIT_VALUE		1029	/* Set bounds on random */

/* STORE a value such as H&V target position, chair angle, etc, at a
 *       particular point in time (-1 or during run).
 *	Note: can use in conjunction with GET_VALUE
 */
#define		SAVE_VALUE		1030	/* 1:ID code; 2,3:values*/

#define	        SKIP_LOW_BOUND		1040
#define		SKIP_IF_CHAIR_AT	1040	/* ~ lines if chair == ~*/
#define		SKIP_IF_CHAIR_NOT_AT	1041	/*   chair units: deg/10*/
#define		SKIP_IF_COUNTDOWN	1045	/* ~ lines each ~ trials*/
#define		SKIP_IF_NO_COUNTDOWN	1046	/* Converse of previous	*/
#define		SKIP_IF_EQUAL		1047	/* Cmp value to lookup	*/
#define		SKIP_IF_NOT_EQUAL	1048	/* And do or skip lines	*/

#define		DO_IF_FIRST		1050	/* if trial == 1	*/
#define		DO_IF_TRIAL		1051	/* if trial == E->one	*/
#define		DO_IF_NOT_TRIAL		1052	/* if trial != E->one	*/
#define		DO_IF_PAST		1053	/* if trial > E->one	*/
#define		DO_IF_NOT_PAST		1054	/* if trial < E->one	*/
#define		DO_IF_LAST		1055	/* if trial == $	*/
#define		DO_IF_NOT_LAST		1056	/* if trial != $	*/

#define		DO_IF_CONSECUTIVE_SUCCESSES	1060	/* Consecutives	*/

#define	        SKIP_HIGH_BOUND		1080

#define	IS_SKIP_EVENT_TYPE(t) ((t)<=SKIP_HIGH_BOUND && (t)>=SKIP_LOW_BOUND)

/* Report errs relative to these events: */
#define INTERESTING_EVENT(type)  ((type < 1000) && (type >= 50))

#define MAX_STANDARD_COLORS	16	/* VGA 16 color pallette	*/
#define MAX_CUSTOM_COLORS	 6	/* User def'd (see display code)*/
/* ********************************************************************	*/
/*  End of event.h */
/* ********************************************************************	*/
