/* FILE deffs.h */

#include <stdio.h>
#include <math.h>
#include "anal.h"
/* clude "function.h"		 * All files see all public functions	*/
				/* Included AFTER (struct) typedefs	*/

#define sizeof(x)	((int) sizeof(x))
		/* defined as size_t?? - diff in intel vs AMD chip	*/

#define MAX_SPIKES	64000	/* for multiunit [RW]			*/
#define MAX_SWITCHES	 900
#define MAX_BUTTONS	 800
#define MAX_FRAMES	16500

#define TYPE		-1	/* Along with TIME,ONE,TWO,THREE	*/

typedef struct {
	unsigned short int time;
	short int h;
	short int v;
	} ARMDATA_OLD;

#define NEW_TOUCH 	01	/* Mask for header flags: include width?*/
#define DELTA_WRITE	02	/* Mask for header flags: delta analogs?*/
/* *******************************************************************	*/
/* ************ FROM reach's deffs.h: ********* */
/* *******************************************************************	*/
/*  CHANGES:
 *    int --> short  (except in INT definition; remains an unsigned int)
 *     Made 'times' and one or two 'values' unsigned!!!!
 *    exclude #include files	(at top and end of deffs.h)
 *    exclude global function definitions	(at end of deffs.h)
 *    exclude library function definitions	(at end of deffs.h)
 *    include "function.h" (just PAST deffs.h, at end)
 *    uncommment MAX_CHANNELS and set to 4
 *    changed FAIL from -9999 to -99999 !!
 *    Added 'REACH_FAIL'
 * *******************************************************************	*/
/* FILE deffs.h */
     /* See end of file for global includes */


						/* Function start/stop	*/
#  define	PRINT_DEBUGS	0		

#  define	MAX_CHANNELS   	4		/* In setup.i		*/
	/* NO: do it automatically, by requesting head recording	*/

#  define 	MAX_EVENTS	100		/* Maximum events/stack	*/
#  define 	MAX_STACKS	400		/* Max stored stacks	*/

#define EXTRA_TIME_ON_ERROR	250	/* ms to collect past error	*/

#  define	H_EYE			0	/* Channel order	*/
#  define	V_EYE			1
#  define	CHAIR_VELOCITY		2
#  define	CHAIR_POSITION		3

#  define	H_ARM			0
#  define	V_ARM			1

typedef unsigned int INT;

typedef struct {				/* Available to all!	*/
	unsigned short  time;
	short  type;
	short  one;
	short  two;
	short  three;
	} EVENT;

typedef struct {
	unsigned short int time;
	short int h;
	short int v;
	short int h_width;
	short int v_width;
	} ARMDATA;


typedef struct {
	unsigned short value;
	unsigned short time;
	} BUTTONS;


# define SCRATCH_STACK	0	/* Zero-th stack is for local edit	*/
# define GLOBAL_TABLE	0	/* All stacks access (scratch is local)	*/
# define HEADER_STACK	9999			/* Special symbol	*/


#  define	ESCAPE		32001		/* GetNumber() returns	*/
#  define	RETURN		32002
#  define	PUZZLED		32003

#  define	START		 0	/* 1st target not yet acquired	*/
#  define	IN_RUN		-1	/* RunStatus(run,event,hist).c	*/
#  define	SUCCESS	   	-2	/* Successful stack completion	*/
#  define	START_ERR	-3	/* Trial never really started	*/
#  define	TIMING_ERR	-4	/* Aborted because slow(no data)*/
#  define	POST_ERR_RUN	-5	/* Running after err (err stack)*/
#  define	WIGGLE_ERR	-6	/* Running after err (err stack)*/
#  define	MONK_ERR   	-9999	/* Trial ended on animal's err	*/
#  define	USER_ESC   	-9998	/* Trial ended on user request	*/
#  define	INTERTRIAL   	-9997	/* In inter-trial interval	*/
#  define  SUCCESS_BUT_MINIMAL_GRAPHICS -12 /* RunResult (for graph.c)	*/
#  define  INITIALIZE_STATUS	-13	/* For NextStack (used rarely)	*/

#  define	QUIT_CHAR	''
#  define	ESC_CHAR	''
#  define	RETURN_CHAR	015	/* Ascii value: carriage return	*/

#  define	SPECIAL_FORMAT	''	/* Within Event_Info->format	*/
#  define	SPECIAL_FORMAT_STRING	""

#  define	TIME		0	/* For StackExtract 'which'	*/
#  define	ONE		1
#  define	TWO		2
#  define	THREE		3
#  define	MINOR		1	/* Archaic form: should remove!	*/
#  define	VALUE		2
#  define	EXTRA		3

/* BEHAVIORS: */
#  define	ARM		(0)	/* Behavior (event.c, behav.c)	*/
#  define       EYE		(1)
#  define	MAX_WINDOWS	(2)
#  define	MOVE_ARM	(2)
#  define	MOVE_EYE	(3)
#  define	MAX_WINDOW_BEHAVS (4)
#  define	RELEASE_ARM	(4)
#  define	BUTTON_AND	(5)
#  define	BUTTON_OR	(6)
#  define	WIGGLE		(7)
#  define	MAX_BEHAV	(8)		/* Maximum # behav + 1	*/
#  define	OPTIONAL	32004			/* For behavior	*/

/* TARGETS: */
/* define	ARM		(0)	 * Behavior (event.c, behav.c)	*/
/* define       EYE		(1)					*/
#  define       EYE_AND_ARM	(2)
#  define	CUE_ARM		(3)
#  define	CUE_EYE		(3)
#  define	CUE_ANY		(3)
#  define	TARGET_0	(0)
#  define	TARGET_1	(1)
#  define	TARGET_2	(2)
#  define	TARGET_3	(3)
#  define	TARGET_4	(4)
	/* Flag locations to chg if use separate cue targets	*/
#  define	MAX_TARGETS	(10)

#  define	HORIZONTAL	(1)
#  define	VERTICAL	(0)

#  define	PURSUIT_RATE	200		/* Hz of update rate	*/

#  define	OFF		0	/* For do_event, behav, picture	*/
#  define	ON		1			/* LED states	*/

#  define	NORMAL		((char) 0007)/* BW monitor attributes*/
#  define       BLINK		((char) 0207)
#  define	REV_VIDEO	((char) 0160)
#  define       REV_BLINK	((char) 0360)
#  define	BOLD		((char) 0017)

/* TTL LINE CONSTANTS: OUTPUT */
#  define	TTL_CENTER_LASER_H	0		/* Setup 1 only	*/
#  define	TTL_CENTER_LASER_V	1
#  define       TTL_HOLD_LEFT_ARM       2
#  define	TTL_HOLD_RIGHT_ARM	3
#  define	TTL_LIGHTS		4
#  define	TTL_TURNTABLE_MODE	5
#  define	TTL_TURNTABLE_ENABLE	6
#  define	TTL_REWARD		7

#  define	TTL_SOUND		12



/* TTL LINE CONSTANTS: INPUT */
#  define	TTL_CENTER_ARM_H	(1<<0)
#  define	TTL_CENTER_ARM_V	(1<<1)
#  define	TTL_LEFT_ARM		(1<<2)
#  define	TTL_RIGHT_ARM		(1<<3)

/* MISC CONSTANTS: */

#  define	FAIL		-99999	/* Used especially by StackExt()*/
#  define	REACH_FAIL	-9999	/* Used especially by StackExt()*/
#  define	SKIP_TRIAL	-99998	/* Used by Set_AlignTime()	*/
#  define	YES		1
#  define	NO		0

#  define	VALID		YES
#  define	INVALID		-1
#  define	EMPTY		NO

#  define	CHANGE_FLAG	-99996

#  define	AVAILABLE_STACK_DISPLAY_TOP	 9	/* Line number	*/
#  define	HISTORY_LINES	2		/* Lines of errs to show*/

#  define       GET_ANY_COLUMN_FLAG	20	/* Added to TABLE_LOOKUP*/

#  define	ALREADY_CALIBRATED	-999

#  if PRINT_DEBUGS
#     define 	PRINT_DEBUG(string)	FastWarning(string)
#  else
#     define 	PRINT_DEBUG(string)
#  endif
/* *******************************************************************	*/
/* END OF reach's deffs.h */
/* *******************************************************************	*/
#include "function.h"		/* All files see all public functions	*/
