/* FILE coord */
     /* Set coordinates for each trial type	*/
/* ********************************************************************	*/

#include "deffs.h"
#include "config.h"

#define	DEBUG	0					/* 0, 1 or 2	*/

/*  PUBLIC:
 * Set_Dimensions_For_Coords	Called once to setup number rows, cols
 * Setup_Coords_For_TrialType	Called before plotting a trial or histogram
 * Test_Coords_For_TrialType	Boolean: returns -1 ?
 * RightEdgeCoord		Return value of right edge
 * LeftEdgeCoord		Return value of left edge
 * TopCoord			Given percent, return int representing coord
 */
/* ********************************************************************	*/


# define  PAGE_SIDE	200		/* Left & right page margins	*/
# define  PAGE_TOP	1600		/* On top of entire page	*/

# define  CELL_TOP	HEIGHT/10	/* On top of each cell		*/

static int rows=1, cols=1;		/* Of current page		*/
static int PageTop = PAGE_TOP;
static int PageSide = PAGE_SIDE;
static int CellLeft;			/* Space BETWEEN cells!		*/
/* ********************************************************************	*/

/* FUNCTION Set_Dimensions_For_Coords */
void Set_Dimensions_For_Coords(int row, int col) {

	rows = row;
	cols = col;

	if (cols-rows > 2)			/* Short wide figure	*/
	   PageTop = 2 * PAGE_TOP;		/*  Else tiny top	*/
	else if (rows < 3)			/* Short square figure	*/
	    PageTop = PAGE_TOP/2;		/*  Else huge top	*/
	else if (rows > 4)			/* Tall skinny figure	*/
	    PageTop = 2 * PAGE_TOP;		/*  Else tiny 'top'	*/
	else
	    PageTop = PAGE_TOP;
	/* PageTop = (cols-rows > 3) ? 2*PAGE_TOP : PAGE_TOP; OLD */

	if (PageTop > HEIGHT*rows/2) {		/* Header > 1/3	page?	*/
	    PageTop = HEIGHT*rows/2;
	    }

	CellLeft = HEIGHT/16;

	if (SHRINK_PAGE_BORDERS) {
	   PageTop  /= (SHRINK_PAGE_BORDERS==1) ? 4:SHRINK_PAGE_BORDERS;
	   PageSide = 0;
	   CellLeft /= (SHRINK_PAGE_BORDERS==1) ? 4:SHRINK_PAGE_BORDERS;
	   }

	if(DEBUG) fprintf(stderr, "Coord.c: %d col X %d rows, top = %d\n",
		col, row, PageTop);
	}
/* ********************************************************************	*/

/* FUNCTION TopCoord */
	 /* Scale percentage to true PAGE_TOP coordinates		*/
int TopCoord(int percent) { return( (PageTop * percent + 50) / 100); }
/* ********************************************************************	*/

/* FUNCTION Test_Coords_For_TrialType */
	 /* Return boolean for whether this figure exists or not	*/
int Test_Coords_For_TrialType(int type) {
	switch (type) {
	   case CURRENT_TRIAL:	
	      return((Get_TrialType_Info(Get_TrialType(), COL) != -1)
		  && (Get_TrialType_Info(Get_TrialType(), ROW) != -1));

	   case TITLE_SPACE:
	   case TOP_LEFT_CELL:
		return(1);

	   default:
	      return((Get_TrialType_Info(type, COL) != -1)
	          && (Get_TrialType_Info(type, ROW) != -1));
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Setup_Coords_For_TrialType */
	/* THIS IS THE ONLY PLACE space() IS EVER CALLED FROM!		*/
	/*  Except for Setup_For_Scale_Bar_Coord			*/
	/* Base coords on:
	 *	fig >=  0: fig
	 *      fig == -1: current trial
	 *	fig == -2: title space: x=0:n, y=0:PAGE_TOP
	 *	fig == -3: top left cell

	 * Sets up plot area Duration X HEIGHT; can ignore rest of page
	 * Units of HEIGHT are same as Duration:
	 *  if HEIGHT==2000, Duration=4000ms  ++->  height is 1/2 width
	 *
	 * RETURN -1 if specific fig isn't to be drawn!
	 */

int Setup_Coords_For_TrialType(int type) {
	int x,y;
	int add;


	switch (type) {
	   case TITLE_SPACE:
	   	x = 0;
	   	y = -rows;
		break;

	   case TOP_LEFT_CELL:		/* Usually for scale bars	*/
	   	x = 0;				/* Left-most cell	*/
	   	y = 1 - rows;			/* Top row		*/
		break;

	   case CURRENT_TRIAL:
	   	x =  1 - Get_TrialType_Info(Get_TrialType(), COL);
	   	y =  Get_TrialType_Info(Get_TrialType(), ROW) - rows;
		break;

	   default:				/* Use specified figure	*/
	   	x =  1 - Get_TrialType_Info(type, COL);
	   	y =  Get_TrialType_Info(type, ROW) - rows;
		if (DEBUG) fprintf(stderr,"%d: (%d,%d) --> (%d,%d)\n",
		   type, Get_TrialType_Info(type,COL),
			 Get_TrialType_Info(type,ROW), x,y);
	   }


	if ((x==(1- -1)) || (y== (-1 - rows)))	/* Was x or y "-1" ?	*/
	  return(-1);				/* Tell calling function*/


	if (rows==1 && cols==1)
	    add = 0;			/* Have used 200 in the past	*/

	space(x * (DurationTime() + CellLeft) - CellLeft - PageSide - add,
	      y * (HEIGHT + CELL_TOP) - add,
	     (x+cols) * (DurationTime() + CellLeft) - CellLeft + PageSide + add,
	     (y+rows) * (HEIGHT + CELL_TOP) + PageTop + add);

	if (DEBUG) {
	   int x1 = x  *  (DurationTime() + CellLeft)
			- CellLeft - PageSide;
	   int y1 = y  * (HEIGHT + CELL_TOP);
	   int x2 = (cols+x)* (DurationTime() +CellLeft) -CellLeft+PageSide;
	   int y2 = (rows+y) * (HEIGHT + CELL_TOP) + PageTop;

	   move(x1, y1);			/* Put a box round area	*/
	   cont(x1, y2);
	   cont(x2, y2);
	   cont(x2, y1);
	   cont(x1, y1);
	   fill(0);

	   if (type >= 0) {
	      fprintf(stderr, "type %2d: (%d,%d)", 
	         type, Get_TrialType_Info(type, COL),
		       Get_TrialType_Info(type, ROW));
	      if (DEBUG == 2)
	         fprintf(stderr, " -> (%d,%d) in (%d,%d)\n", x,y,cols,rows);
	      else
		 fprintf(stderr, "\n");
	   } else
	      fprintf(stderr, "    %2d -> (%d,%d)\n", type,x,y);
	   }
	return(0);
	}

/* ********************************************************************	*/

/* FUNCTION RightEdgeCoord */
/* FUNCTION LeftEdgeCoord */
	 /* Coord of right edge when in title space or on far left	*/
int RightEdgeCoord() {
	return(cols*(DurationTime()+CellLeft)-CellLeft);
	}
int LeftEdgeCoord() {
	return(-PageSide);
	}
/* ********************************************************************	*/
