/* FILE config.c */
     /* Reads user config values and exports them */

#  ifdef stoet
#define CONFIG_FILE_NAME "/home/stoet/.grab_config"
#  elif gaurav
#define CONFIG_FILE_NAME "/home/gaurav/.grab_config"
#  elif larry
#define CONFIG_FILE_NAME "/home/larry/.grab_config"
#  elif ben
#define CONFIG_FILE_NAME "/home/ben/.grab_config"
#  elif bonnie
#define CONFIG_FILE_NAME "/home/bonnie/.grab_config"
#  elif justin
#define CONFIG_FILE_NAME "/home/justin/.grab_config"
#  elif rob
#define CONFIG_FILE_NAME "/home/rob/.grab_config"
#  elif steve
#define CONFIG_FILE_NAME "/home/steve/.grab_config"
#  elif cunguo
#define CONFIG_FILE_NAME "/home/cunguo/.grab_config"
#  elif will
#define CONFIG_FILE_NAME "/home/will/.grab_config"
#  elif yuqing
#define CONFIG_FILE_NAME "/home/yuqing/.grab_config"
#  elif eric
#define CONFIG_FILE_NAME "/home/eric/.grab_config"
#  elif marcel	
#define CONFIG_FILE_NAME "/home/marcel/.grab_config"
#  elif jan	
#define CONFIG_FILE_NAME "/home/jan/.grab_config"
#  elif kaplan	
#define CONFIG_FILE_NAME "/home/kaplan/.grab_config"
#  elif matthew	
#define CONFIG_FILE_NAME "/home/matthew/.grab_config"
#  elif michael	
#define CONFIG_FILE_NAME "/home/michael/.grab_config"
#  elif afreen	
#define CONFIG_FILE_NAME "/home/afreen/.grab_config"
#  elif jingfeng	
#define CONFIG_FILE_NAME "/home/jingfeng/.grab_config"
#  elif ericm	
#define CONFIG_FILE_NAME "/home/ericm/.grab_config"
#  elif sreyas	
#define CONFIG_FILE_NAME "/home/sreyas/.grab_config"
#  elif cpapadim
#define CONFIG_FILE_NAME "/home/cpapadim/.grab_config"
#  elif chuck
#define CONFIG_FILE_NAME "/home/chuck/.grab_config"
#  elif wilbur
#define CONFIG_FILE_NAME "/home/wilbur/.grab_config"
#  elif kang
#define CONFIG_FILE_NAME "/home/kang/.grab_config"
#  else	
#define CONFIG_FILE_NAME "/home/larry/.grab_config"	     /* Default	*/
#  endif

/* ********************************************************************	*/
/*  Notes:
	    The order of the parameters in the data structure is critical!
	The exporting functions blindly assume they know where in the
	structure their parameter lives.  If you change the order, the
	wrong values will be blithely exported!!

	    The order of parameters in your .grab.config file may be
	important.  For example, the current version changes RASTER_TIC_HEIGHT
	and a couple other variables if EXPAND_TIME is set.  If RA.. comes
	_after_ EX.., than you will override the changes!

	    Parameters in config file are optional;  a config file could,
	for example, contain nothing but comments!  (Anything that does
	not begin "#define" is a comment.  #define only looks like the
	C version; in fact it is more and less rigid.  Less, because it
	doesn't have to start on the left column; more, because it
	accepts ONLY an integer as it's argument.  Parentheses or a
	decimal point will make it choke.
 * ********************************************************************	*
 *   To add a new parameter:
	 	1. Add line to Params data structure at bottom giving
	the ascii name of the parameter and the default value.  BE SURE
	NOT TO CHANGE THE ORDER OF THE EXISTING ENTRIES!
		2. Add an exporting function (to export the value)
	to the very bottom of this file.  Determine what index number
	to use by looking at the position of your entry in the structure.
	If it's the 20th entry, your function should export P[20].value.
		3. Add the function to config.h and to function.h
 * ********************************************************************	*/

#include <stdlib.h>					/* getenv()	*/
#include <string.h>					/* cmp, etc	*/
#include <stdio.h>
/* ********************************************************************	*/

/* PUBLIC:
 *    Read_User_Config_File		Read'm from a file in home directory
 *    function_PARAM_NAME		Export a particular parameter
 *    Print_Config_Parameters		Print out structure contents
 *    Set_Config_Parameter		Set an individual parameter
 		# Accessed by xyplot
 *
 * PRIVATE:
 */

int Set_Config_Parameter(char *name, int value);
/* ********************************************************************	*/

struct PARAMS {
	char *name;
	int value;
	} Params[] = {

  { "SHOW_ANALOG",		0 },	/* 0 Show analog trace? Pick 1:	*/
  { "SINGLE_ANALOG",		0 },	/* 1  Just 1 (leftmost) trace	*/
  { "FAST_FIGURE",		1 },	/* 2  Skip tics+trim; show 1 anlg */
  { "SEMI_FAST_FIGURE",		0 },	/* 3  Show tics+trim+anlg for ~	*/
  { "FULL_FIGURE",		0 },	/* 4 Show all tics+trim+traces	*/

  { "UNUSED",			1 },	/* 5 UNUSED			*/
  { "ZOOM_AD_RANGE_UNITS",	0 },	/* 6 Blow up AD range (-g)	*/
  { "SHOW_SINGLES",		0 },	/* 7 Plot if n==1 ? Usu is garbage*/
  { "DRAW_BOX",			0 },	/* 8 Around each trialtype	*/

  { "GRAPH_EYES",		1 },	/* 9 Eye: 0(no),1(H),2(V),3(H+V)*/
  { "GRAPH_ARMS",		1 },	/* 10 Arm channels: ditto	*/
  { "GRAPH_CHAIR",		3 },	/* 11 chair channels: ditto	*/

  { "FILTER_EYES",		0 },	/* 12 Filter the analog eye data*/

  { "RASTER_TIC_HEIGHT",	20 },	/* 13 Not well-behaved;leave at 20?*/

  { "STATS_ON_SUM_FIG",		0 },	/* 14 2: print out (1:show if -gG)*/

  { "EXPAND_TIME_AXIS",		0 },	/* 15 Spread out the time base	*/
  { "HEIGHT",			3000 },	/* 16 For aspect ratio		*/
  { "HISTO_OFFSET",		850 },	/* 17 Histogram starts here	*/

					/* Convert to float on export	*/
  { "REAL_BIN_SIZE",		64 },	/* 18 Histo appearance		*/
  { "ASH",			4 },	/* 19 Triangle kernel size	*/
  { "SMOOTH",			1 },	/* 20 Connect midpts? (Freq polygon) */

  { "P_CRITERIA",		5 },	/* 21 Used by reach macro files (%)*/
  { "PREF_MINUS_NULL",		0 },	/* 22 Used by reach macro files	*/

  { "SPECIAL_FIGURE_TITLES",	0 },	/* 23 Title above @ histo:default?    */

  { "ANALOG_GRAPH_DENSITY",	3 },	/* 24 Low pass averaging of eye traces*/

  { "OFFSET_V_EYE_TRACE",	0 },	/* 25 Offset v from h eye pos	*/

  { "SHRINK_PAGE_BORDERS",	0 },	/* 26 Reduce PAGE_TOP,PAGE_SIDE	*/

  { "ZOOM_AD_RANGE_BEHAV",	0 },	/* 27 Blow up AD range (-g1)	*/

  { "PICTURE_EVERY_TARGET",	1 },	/* 28 In sketch at top of cell	*/
  { "PICTURE_TARGET_0",		0 },	/* 29 Show target # 0		*/
  { "PICTURE_TARGET_1",		0 },	/* 30 Show target # 1		*/
  { "PICTURE_TARGET_2",		0 },	/* 31 Show target # 2		*/
  { "PICTURE_TARGET_3",		0 },	/* 32 Show target # 3		*/
  { "PICTURE_TARGET_4",		0 },	/* 33 Show target # 4		*/
  { "PICTURE_TARGET_5",		0 },	/* 34 Show target # 5		*/
  { "PICTURE_TARGET_6",		0 },	/* 35 Show target # 6		*/
  { "PICTURE_TARGET_7",		0 },	/* 36 Show target # 7		*/
  { "PICTURE_TARGET_8",		0 },	/* 37 Show target # 8		*/
  { "PICTURE_TARGET_9",		0 },	/* 38 Show target # 9		*/
  { "PICTURE_NONTARGET_BEHAVS",	1 },	/* 39 arm release, buttons, etc	*/
  { "PICTURE_TRIAL_COUNT",	100 },	/* 40 Number of trials to show	*/
  { "ALIGN_USING_ACQUIRE",	0 },	/* 41 time.c: sacs,arm by targ or acq?*/

  { "REMOVE_BLINKS",		0 },	/* 42 input.c: for ISCAN data	*/

  { "SMOOTH_SD",		28 },    /* 43 histo.c: smoothing	*/
  { "BIN_SIZE_MS",		10 },    /* 44 histo.c: smoothing	*/
  { "MACRO_APPENDS",      	 1 },    /* 45 macros:append | overwrite*/
  { "MACRO_NAME_UNITRUN",      	-1 },    /* 46 macros name construction	*/

  /* ADD NEW PARAMETERS ABOVE THIS LINE */
  { "",				0 }
};
/* ********************************************************************	*/

/* FUNCTION Read_User_Config_File */
void Read_User_Config_File() {
   FILE *in;
   char filename[80] = CONFIG_FILE_NAME;

   in = fopen(filename, "r");

   if (in == NULL)
      return;

   while (feof(in) == 0) {
      char name[82];
      int value;
      
      if (fscanf(in, "%s", name) != 1)		/* End of file?	*/
	 break;
      if (strcmp(name, "#define") != 0)
	 continue;
      if (fscanf(in, "%s %d", name, &value) != 2) {
	 fprintf(stderr,"Err in %s: define lacks name <%s> or value \n",
		filename, name);
	 continue;
	 }
      if (Set_Config_Parameter(name, value))	/* Error occur?	*/
	 fprintf(stderr, "Unidentified name in %s: <#define '%s' %d>\n",
		filename, name, value);
      }
   }
/* ********************************************************************	*/

/* FUNCTION Print_Config_Parameters */
void Print_Config_Parameters(char *OneOnly) {
      struct PARAMS *P = Params;
      int right = 1;

      if (*OneOnly != 0) {
         P--;
         while ((++P)->name[0])
            if (strcmp(P->name, OneOnly) == 0)
               break;
	 if (P->name == NULL)
	    fprintf(stderr, "Cannot find parameter %s\n", P->name);
	  else
	    fprintf(stdout, "%d\n", P->value);
	 return;
         }

      fprintf(stderr, "Parameters from %s:\n", CONFIG_FILE_NAME);
      while (P->name[0]) {
	 fprintf(stderr, " %-30s %-7d", P->name, P->value);
	 if (++right % 2)	/* One per line helps with some stuff	*/
	    fputc('\n', stderr);
	 P++;
	 }
      fputc('\n', stderr);
      }
/* ********************************************************************	*/

/* FUNCTION Set_Config_Parameter */
	 /* Change value of a parameter in the data structure	 */
int Set_Config_Parameter(char *name, int value) {
   struct PARAMS *P = Params;

      P--;
      while ((++P)->name[0])
	 if (strcmp(name, P->name) == 0) {
            P->value = value;
	    break;
	    }

      /* Special cases */
      if (P->name[0] == 0)
	 return(1);			/* Unknown parameter	*/

      if ((strcmp(name, "EXPAND_TIME_AXIS") == 0) && value) {
	 /* Special reconfig if expanding */
	 Set_Config_Parameter("HEIGHT",
	      Params[16].value/2);
	 Set_Config_Parameter("HISTO_OFFSET",
	      Params[17].value/2);
	 Set_Config_Parameter("RASTER_TIC_HEIGHT", 	/* Halve it	*/
	      Params[13].value/2);
         }

      return(0);			/* Known param		*/
   }
/* ********************************************************************	*/
/* ********************************************************************	*/
/* EXPORTING FUNCTIONS: */

int function_SHOW_ANALOG() {		return(Params[0].value); }
int function_SINGLE_ANALOG() {		return(Params[1].value); }
int function_FAST_FIGURE() {		return(Params[2].value); }
int function_SEMI_FAST_FIGURE() {	return(Params[3].value); }
int function_FULL_FIGURE() {		return(Params[4].value); }
int function_UNUSED5() {		return(Params[5].value); }
int function_ZOOM_AD_RANGE_UNITS() {	return(Params[6].value); }
int function_SHOW_SINGLES() {		return(Params[7].value); }
int function_DRAW_BOX() {		return(Params[8].value); }

int function_GRAPH_EYES() {		return(Params[9].value); }
int function_GRAPH_ARMS() {		return(Params[10].value); }
int function_GRAPH_CHAIR() {		return(Params[11].value); }

int function_FILTER_EYES() {		return(Params[12].value); }
int function_RASTER_TIC_HEIGHT() {	return(Params[13].value); }
int function_STATS_ON_SUM_FIG() {	return(Params[14].value); }
int function_EXPAND_TIME_AXIS() {	return(Params[15].value); }
int function_HEIGHT() {			return(Params[16].value); }
int function_HISTO_OFFSET() {		return(Params[17].value); }
int function_REAL_BIN_SIZE() {		return(Params[18].value); }
int function_ASH() {			return(Params[19].value); }
int function_SMOOTH() {			return(Params[20].value); }
float function_P_CRITERIA() {		return(Params[21].value/100.); }
int function_PREF_MINUS_NULL() {	return(Params[22].value); }
int function_SPECIAL_FIGURE_TITLES() {	return(Params[23].value); }
int function_ANALOG_GRAPH_DENSITY() {	return(Params[24].value); }
int function_OFFSET_V_EYE_TRACE() {	return(Params[25].value); }
int function_SHRINK_PAGE_BORDERS() {	return(Params[26].value); }
int function_ZOOM_AD_RANGE_BEHAV() {	return(Params[27].value); }

int function_PICTURE_EVERY_TARGET() {	return(Params[28].value); }
int function_PICTURE_TARGET_0() {	return(Params[29].value); }
int function_PICTURE_TARGET_1() {	return(Params[30].value); }
int function_PICTURE_TARGET_2() {	return(Params[31].value); }
int function_PICTURE_TARGET_3() {	return(Params[32].value); }
int function_PICTURE_TARGET_4() {	return(Params[33].value); }
int function_PICTURE_TARGET_5() {	return(Params[34].value); }
int function_PICTURE_TARGET_6() {	return(Params[35].value); }
int function_PICTURE_TARGET_7() {	return(Params[36].value); }
int function_PICTURE_TARGET_8() {	return(Params[37].value); }
int function_PICTURE_TARGET_9() {	return(Params[38].value); }
int function_PICTURE_NONTARGET_BEHAVS(){return(Params[39].value); }
int function_PICTURE_TRIAL_COUNT() {	return(Params[40].value); }
int function_ALIGN_USING_ACQUIRE() {	return(Params[41].value); }
int function_REMOVE_BLINKS() {		return(Params[42].value); }
int function_SMOOTH_SD() {		return(Params[43].value); }
int function_BIN_SIZE_MS() {		return(Params[44].value); }
int function_MACRO_APPENDS() {          return(Params[45].value); }
int function_MACRO_NAME_UNITRUN() {     return(Params[46].value); }
/* ********************************************************************	*/
