/* FILE button.c */
     /* Button push times (stand-alone switches, NOT the touch panel) */

#include "config.h"
#include "deffs.h"

/* PUBLIC:
 * PrintButtons
 * Get_Button_Time
 */
/* ********************************************************************	*/
extern BUTTONS Buttons[];

/* FUNCTION PrintButtons */
	 /* Print button # & time for i-th header	*/
void PrintButtons(int diag) {
	BUTTONS *ptr = Buttons;
	int buttons = ButtonCount_Header();
	int i;
	FILE *output = (diag) ? stderr : stdout;

	fprintf(output, "\n   %d buttons", buttons);
	fprintf(output, "\n         #    (bugfix)   value time (re:tape on)\n");

	for (i=0; i<buttons; i++, ptr++) {
	    fprintf(output, "\t%5d   %5d [%6o]   %4d ms (%4d)\n",
		 i, 
		    ptr->value, ptr->value,
		    ptr->time, ptr->time - SkipSpikeTime());
	    }
	}
/* ********************************************************************	*/

/* These are for 'extern' access, just in case you need to look at other
 * details of the Button event after Get_Button_Time returns the time	*/

int ButtonPattern = 0, ButtonPrevious = 0, ButtonNumber = 0;
/* ********************************************************************	*/

/* FUNCTION Get_Button_Time */
	 /* OnOff: find button depress or release 			*/
	 /* bit = -1 means any bit pattern				*/
	 /* occurrence other than 1 may not work with bit == -1		*/
	 /* occurence: Can use 0 or 1 to mean 'first'			*/
	 /* from: time re start of trial (NOT time re:tape_on)		*/
	 /* Returns raw times, without subtracting SkipSpikeTime	*/
	 /* Give only a single bit (or -1). If 2 bits change at 	*/
	 /*  once, ought to work, but hasn't been tested!		*/
int Get_Button_Time(int OnOff, int bit, int occurrence, int from,
	       					int InitialAlignment) {
	int buttons = ButtonCount_Header();
	int i=0;

        if (buttons == 0) {
	   ButtonNumber = ButtonPattern = ButtonPrevious = FAIL;
	   return(FAIL);
	   }

	if (bit != -1) {
	   int BitCount = 0;			/* Be sure just one bit	*/
	   int test = bit;
	   while (test > 0) {			/* Until no more bits:	*/
	     if (test & 01)			/* Test last bit	*/
	         BitCount++;			/* Tally a bit		*/
	     test >>= 1;			/* Shift over by one	*/
	     }
	   if (BitCount > 1)
	      Exit("Cannot pass me more than one bit!", "Get_Button_Time()");
	   }

        if (InitialAlignment)
	   Read_Skipped_Data();

	if (bit == -1) {			/* Any bit patt	*/
	   if (OnOff==ON && Buttons[0].time > from)
	      if (--occurrence <= 0) {
		 i = 0;				/* Insurance	*/
		 goto RETURN_BUTTON;			/* Button i=0	*/
	         }

	   for (i=0; i<buttons; i++) {
	     int new = Buttons[i].value - Buttons[i-1].value;

	     if (Buttons[i].time > from)
	      if ((OnOff==ON && (new > 0)) ||
	          (OnOff==OFF && (new < 0)))
	        if (--occurrence <= 0)
		   goto RETURN_BUTTON;			/* Button i	*/
	     }
	 } else {				/* Specific bit patt	*/
		/* At start, if ask for one bit, if it's on, return it	*/
		/* (But only if occurrence = 0; if >= 1, don't !!	*/
	   if (((Buttons[0].value & bit) == bit) &&
	       (OnOff==ON && Buttons[0].time > from))
	       if (--occurrence <= 0) {
		 i = 0;					/* Insurance	*/
		 goto RETURN_BUTTON;			/* Button i=0	*/
	         }

	   for (i=0; i<buttons; i++) {
	     int new = Buttons[i].value ^ Buttons[i-1].value;  /* changes*/
	     int bit_on = (Buttons[i].value & bit) > 0;	/* 1 if on, else 0*/

	     if (Buttons[i].time > from) {
	        if ((OnOff==bit_on) && (new & bit))
	          if (--occurrence <= 0)
		     goto RETURN_BUTTON;		/* Button i=0	*/
	        }
	     }
	  }
	ButtonNumber = ButtonPattern = ButtonPrevious = FAIL;
	return(FAIL);

        RETURN_BUTTON:
	ButtonNumber = i;
	ButtonPattern = Buttons[i].value;
	ButtonPrevious = Buttons[i-1].value;
	return(Buttons[i].time);
	}
/* ********************************************************************	*/
