/* FILE behav */
     /* Return eye position data in a given interval */
     /* Use interval flags:
      *		-ix:y		One interval, (x to y)
      *	 	-ix:y -Ia:b	Two intervals, (x to y) and (a to b)
      *		-ix:y -Ba	Interval (x to y) minus background a-(y-x) to a
      */

#include "deffs.h"
#include "ad.h"
/* ********************************************************************	*/
 /* PUBLIC
  * Get_EyePosition(time_from, time_to, &h, &v)
  * Get_ArmPosition(time_from, time_to, &h, &v)
  * Get_ArmWidth(time_from, time_to, &h, &v)
  * TimeNotRecorded		See if time is within data stream
  * TimeNotRecorded		Quiet: See if time is within data stream
  * PRIVATE
 * ********************************************************************	*/

/* FUNCTION Get_EyePosition */
	 /* Calc eye position (deg) over interval, re: ZeroTime */
	 /* Wants time re: alignment point (e.g., Get_Interval_Begin())	*/
	 /* *** If use EventExtract(), must subtract Get_AlignTime()***	*/
	 /* Exit with fatal error if out of bounds! (safety measure)	*/

void Get_EyePosition(int begin, int end, float *h, float *v) {
	extern short Data[MAX_FRAMES*MAX_CHANNELS];	/* Analog data	*/
	int channels = ChannelCount_Header();
	int count  = (end - begin) / MsPerFrame_Header() + 1;

	short *data = Data +
		(begin+Get_ZeroTime())/MsPerFrame_Header()* channels;

	int sum_H = 0;
	int sum_V = 0;
	int i;

	if (TimeNotRecorded(begin+Get_ZeroTime(), end+Get_ZeroTime()) == 1)
	   Exit("Change alignment and try again", "Get_EyePosition");

	for (i=0; i<count; i++) {
	    sum_H += *(data+H_EYE);
	    sum_V += *(data+V_EYE);
	    data += channels;
	    }

	*h = ADtoDEG(sum_H) / count;
	*v = ADtoDEG(sum_V) / count;
	}
/* ********************************************************************	*/

/* FUNCTION Get_ArmPosition */
	 /* Calc arm position (deg) over interval, re: ZeroTime */
	 /* Wants time re: alignment point (e.g., Get_Interval_Begin())	*/
	 /* *** If use EventExtract(), must subtract Get_AlignTime()***	*/
	 /* Exit with fatal error if out of bounds! (safety measure)	*/
	 /* If don't touch during whole interval, return NO_TOUCH	*/

void Get_ArmPosition(int begin, int end, float *h, float *v) {
	extern short Touch1[MAX_FRAMES*2];	/* Analog arm data	*/
	int count  = (end - begin) / MsPerFrame_Header() + 1;

	short *data = Touch1 +	/* Is "*2" because H and V?	*/
		(begin+Get_ZeroTime())/MsPerFrame_Header()*2;

	int sum_H = 0;
	int sum_V = 0;
	int n_H = 0;
	int n_V = 0;
	int i;

	if (TimeNotRecorded(begin+Get_ZeroTime(), end+Get_ZeroTime()) == 1)
	   Exit("Change alignment and try again", "Get_ArmPosition");

	for (i=0; i<count; i++) {
	    if (*(data+H_ARM) != NO_TOUCH) {
	       sum_H += *(data+H_ARM);
	       n_H++;
	       }
	    if (*(data+V_ARM) != NO_TOUCH) {
	       sum_V += *(data+V_ARM);
	       n_V++;
	       }
	    data += 2;
	    }

	if (n_H == 0 || n_V==0)
	   *h = *v = FAIL;
	else {
	   *h = ADtoDEG(sum_H) / n_H;
	   *v = ADtoDEG(sum_V) / n_V;
	   }
	}
/* ********************************************************************	*/

/* FUNCTION Get_ArmWidth */
	/* IDENTICAL TO Get_ArmPosit, except TouchWidth instead of Touch*/
	 /* Calc arm width (deg) over interval, re: ZeroTime */
	 /* Wants time re: alignment point (e.g., Get_Interval_Begin())	*/
	 /* *** If use EventExtract(), must subtract Get_AlignTime()***	*/
	 /* Exit with fatal error if out of bounds! (safety measure)	*/
	 /* If don't touch during whole interval, return NO_TOUCH	*/
void Get_ArmWidth(int begin, int end, float *h, float *v) {
	extern short TouchWidth1[MAX_FRAMES*2];	/* Analog arm data	*/
	int count  = (end - begin) / MsPerFrame_Header() + 1;

	short *data = TouchWidth1 +
		(begin+Get_ZeroTime())/MsPerFrame_Header()*2;

	int sum_H = 0;
	int sum_V = 0;
	int n_H = 0;
	int n_V = 0;
	int i;

	if (TimeNotRecorded(begin+Get_ZeroTime(), end+Get_ZeroTime()) == 1)
	   Exit("Change alignment and try again", "Get_ArmWidth");

	for (i=0; i<count; i++) {
	    if (*(data+H_ARM) != NO_TOUCH) {
	       sum_H += *(data+H_ARM);
	       n_H++;
	       }
	    if (*(data+V_ARM) != NO_TOUCH) {
	       sum_V += *(data+V_ARM);
	       n_V++;
	       }
	    data += 2;
	    }

	if (n_H == 0 || n_V==0)
	   *h = *v = FAIL;
	else {
	   *h = ADtoDEG(sum_H) / n_H;
	   *v = ADtoDEG(sum_V) / n_V;
	   }
	}
/* ********************************************************************	*/

/* FUNCTION TimeNotRecorded */
	 /* Check if have data for this time; if not, warn	*/
	 /* Times in actual data stream: 0 == 1st saved frame	*/
int TimeNotRecorded(int from, int to) {
	static int count = 0;
	int end = FrameCount_Header()*MsPerFrame_Header();
        
	if ((from < 0) || (to > end)) {
	  count++; 
	  if (count < 4 || (count%10 == 0)) {	/* Don't show all!	*/
	     char msg[120];
	     sprintf(msg,"Get_xxxPosition() outside of trial (%d:%d ms)",
		from, to);
	     if (to > end)
	        sprintf(msg, "%s <trial ends at %d>", msg, end);
	      else
	        sprintf(msg, "%s <trial starts at 0>", msg);
	     if (count >= 3)
		sprintf(msg, "%s (msg #%d)", msg, count);
	     sprintf(msg, "%s \n", msg);
	     Warning(msg);
	     }
	  if ((from < 0 && to < 10) || 	/* ENTIRE interval missing?	*/
	      (to > end && from > end-10))
	     return(1);

	  return(2);			/* PARTIAL interval missing	*/
	  }
	return(0);			/* Entire interval present	*/
	}
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION TimeRecorded */
	 /* REVERSE LOGIC, AND NO WARNING!			*/
	 /* Times in actual data stream: 0 == 1st saved frame	*/
int TimeRecorded(int from, int to) {
	int end = FrameCount_Header()*MsPerFrame_Header();

	return((from >= 0) && (to <= end));
	}
/* ********************************************************************	*/
