/* FILE batch */
     /* Interact with batch files */

#include "deffs.h"
#include <fcntl.h>					/* Open/close	*/
#include <string.h>					/* strcpy()	*/
#include <unistd.h>					/* lseek arg's	*/

static FILE *BatchFile = NULL;
static char  Batch_Name[80] = "FileList";		/* Default name	*/
/* ********************************************************************	*/

/* FUNCTION Is_Batch */
int Is_Batch() { return(BatchFile != NULL); }
/* ********************************************************************	*/

/* FUNCTION Open_BatchFile */
void Open_BatchFile() {
   BatchFile = fopen(Batch_Name, "r");
   if (BatchFile == NULL) {
      fprintf(stderr, "Listing file name: <%s>\n", Batch_Name);
      Exit("Couldn't open listing file!", "Open_BatchFile");
      }
   }
/* ********************************************************************	*/
#include <ctype.h>					/* isblank()	*/

/* FUNCTION Next_BatchFile_Entry */
	 /* Skip comment lines (start with '#')	*/
char *Next_BatchFile_Entry() {
   static char next[200];

   do {					/* Skip blank lines & comments	*/
      if (fgets(next, 199, BatchFile) == NULL){		/* Get next line*/
         fclose(BatchFile);
         return(NULL);
         }
    } while (next[0]=='#' || next[0]=='\n');	/* Newline or comment?	*/

   if (next[strlen(next)-1] == '\n') {		/* Strip off newline	*/
      next[strlen(next)-1] = 0;
      }
   return(next);
   }
/* ********************************************************************	*/

/* FUNCTION Set_BatchFile_Name */
	 /* Name of file that lists files to run; default is "FileList"	*/
void Set_BatchFile_Name(char *name) {
   strcpy(Batch_Name, name);
   }
/* ********************************************************************	*/
