/* FILE arm.c */
/*    Data from: resistive touch panel, separate 'touch' line, OR	*
 *    		 optical   touch panel, constructed at input		*/

#define MOVE_CRITERION	DEGtoAD(3) /* [3] Look for movement of ~ AD units*/
#define STOP_CRITERION	DEGtoAD(3) /* [3] Look for movement of ~ AD units*/
 /* DIAG: LHS 4-2008  Wasn't correcting for sampling rate, so was off in *
  *   the calculation of AD units; old 1.5 deg was REALLY 3.0 deg!	*/
 /* DIAG: Moved from 3 to 4 when added move find 1/2 or 1/3 of CRIT	*/
 /* Back to 3 -- not working */
#define FINE_MOVE_CRITERION	DEGtoAD(3)/3
#define FINE_STOP_CRITERION	DEGtoAD(3)/3

#define DEBUG	0

#include <stdlib.h>					/* abs()	*/
#include "config.h"
#include "deffs.h"

#include "ad.h"

/* PUBLIC:
 * PrintArm
 * Is_Arm_Touching		* Initial alignment (align.c) ONLY!	*
 * Get_Arm_Time
 * Get_Arm_Move_Time
 * Get_Arm_Stop_Time
 * Get_ArmPosition		* SEE behav.c !!	*
 *
 * PRIVATE:
 * ArmPosition			* Why?
 * ArmWidth			* Why?
 */
/* ********************************************************************	*/
extern ARMDATA ArmData1[];
extern ARMDATA ArmData2[];

/* FUNCTION PrintArm */
	 /* Print switch # & time for i-th header	*/
	 /* Use raw data (ArmData)			*/
void PrintArm(int board) {
	ARMDATA *ptr = (board==1) ? ArmData1 : ArmData2;
	int touches = TouchCount_Header(board);
	int i;

	fprintf(stdout, "\nTrial %d (%d) (stack.class %d.%d): %c%s%c (alignment time %d ms)\n",
		TrialNumber_Input(),
	        TrialNumber_Header(),
		StackNumber_Header(),
		TableNumber_Header(),
		'"', StackName_Header(), '"',
		SkipAnalogTime());

	if (board==2)
	   fprintf(stdout, " Board 2");
	fprintf(stdout, "   %d touches\t\t\t\t    width\n", touches);

	for (i=0; i<touches; i++, ptr++) {
	    if (ptr->h == NO_TOUCH)
	       fprintf(stdout, "\t%4d:  %4d ms     No touch\n", i, ptr->time);
	    else
	       fprintf(stdout, "\t%4d:  %4d ms  %4d %4d\t%4d  %4d\n",
	          i, ptr->time, ptr->h, ptr->v, ptr->h_width, ptr->v_width);
	    }
	}
/* ********************************************************************	*/
/* FUNCTION Is_Arm_Touching */
	 /* Initial alignment (align.c) ONLY -- else use Get_ArmPosition*/
	 /* Use raw data (ArmData)			*/
int Is_Arm_Touching(int time) {
	int touches = TouchCount_Header(1);
	int i = -1;

	if (time == FAIL)
	   return(FAIL);

	Read_Skipped_Data();			/* Read raw arm times	*/
						/* First 2 aren't real	*/
	while (++i < touches)
	   if (ArmData1[i].time > time)
	       break;

	if (i==0)
	   Exit("Call Larry! (need special case)", "if_arm_touching");
	return(ArmData1[i-1].h != NO_TOUCH && ArmData1[i-1].v != NO_TOUCH);

# ifdef PRE_6_20_2008
	if (i == 2) {			/* First real event 		*/
	   if (time <= 3)		/* Can't get reports < 3 ms	*/
	      return(ArmData1[2].time == 3 &&
		     ArmData1[2].h > 0 && ArmData1[2].v > 0);
		/* If touching at 3 ms, was touching from the start	*/
	   return(ArmData1[2].time >= time &&
		     ArmData1[2].h > 0 && ArmData1[2].v > 0);
           }
	return(ArmData1[i-1].h > 0 && ArmData1[i-1].v > 0);
# endif
	}
/* ********************************************************************	*/
#define TOUCHING(i)  	((InitialAlignment) ?				\
		  ArmData1[i].h > 0 && ArmData1[i].v > 0 :	\
		  ArmData1[i].h != NO_TOUCH && ArmData1[i].v != NO_TOUCH)
#define NOT_TOUCHING(i) ((InitialAlignment) ?				\
		  ArmData1[i].h <= 0 && ArmData1[i].v <= 0 :	\
		  ArmData1[i].h == NO_TOUCH && ArmData1[i].v == NO_TOUCH)

/* FUNCTION Get_Arm_Time */
	 /* OnOff: find button depress or release 			*/
	 /* forward: look forward/backward in time			*/
	 /* time to start looking (stack time, re:clock on, NOT tape_on)*/
	 /* IntialAlignment:	1 if time.c calls, else 0		*/
	 /* Use raw data (ArmData)			*/
int Get_Arm_Time(int OnOff, int forward, int time, int InitialAlignment) {
	int touches = TouchCount_Header(1);
	int i = -1;

	if (time == FAIL)
	   return(FAIL);

	if (InitialAlignment == 2)		/* Not using(LHS 9-07)?	*/
	   Exit("Restore this case or fix call!!", "Get_Arm_Move_Time");
	if (InitialAlignment) {			/* time.c calls		*/
	   Read_Skipped_Data();			/* Read arm times	*/
	   /* Why don't we force zero skip time in this case?  LHS 9-07	*/
	 } else					/* macro calls		*/
	   time -= SkipSpikeTime();	/* Shift to same frame as data	*/
	   	/* 'time' is a time read from the stack; ArmData1[].time
		                 is relative to the start of the trial	*/

	while (++i < touches)
	   if (ArmData1[i].time > time)
	       break;

	if (i >= touches) {
	   if (forward)
	      return(FAIL);			/* No touches past start*/
	   else /* backwards */
	      i--;				/* Don't use it!	*/
	   }


	/* Move until NOT touching */
	 /* If look back: if not touching, step back so time < request	*/
	 if (forward == OFF && OnOff == ON)
	    while (NOT_TOUCHING(i))
	       if (ArmData1[i].time > time)
	          i--;

	 while (TOUCHING(i))
	      if (forward) {
	         if (++i >= touches)
	            break;
	       } else if (--i < 0)
	            break;

	if ((forward==OFF && OnOff == OFF) || 	/* Want time of touch	*/
	    (forward==ON  && OnOff == ON)) {
	    while (NOT_TOUCHING(i))
	      if (forward) {
	         if (++i >= touches)
	            break;
	      } else if (--i < 0)
	            break;
	   }


	if (i >= touches)		/* Didn't find a touch		*/
	   return(FAIL);

	/* Used to be '!=' -- what's wrong? */
	if (InitialAlignment == 0)  	/* Shift back to stack time	*/
	   return(ArmData1[i].time + SkipSpikeTime());

	return(ArmData1[i].time);
	}
/* ********************************************************************	*/

static void ArmPosition(int begin, int end, int *H, int *V);

/* FUNCTION Get_Arm_Move_Time */
	 /* Find first move, or first release */
	 /* StartTime is a raw stack time (e.g., from StackExtract)	*/
	 /* Internally, StartTime is corrected to be relative to TAPE_ON*/
	 /* Return time is again a raw stack time			*/
	 /* Do NOT Use raw data - use COOKED - Get_ArmPosition()	*/
int Get_Arm_Move_Time(int StartTime, int InitialAlignment) {
	int TrialEndTime = FrameCount_Header() * MsPerFrame_Header();
	int StartH, StartV;
	int LaterH, LaterV;
	int i;
	int adjust = 0;
       
	if (StartTime == FAIL)
	   return(FAIL);

	if (InitialAlignment) {			/* time.c calls		*/
	   adjust = Get_TapeOnTime();
	   Force_Zero_SkipTime(ON + 1);
	   Read_Skipped_Data();			/* Read raw arm times	*/
	   Force_Zero_SkipTime(OFF);
	 } else {				/* macro calls		*/
	   adjust = SkipSpikeTime();
	   }
	StartTime -= adjust;

	if (StartTime < 50) {
	   if (InitialAlignment)
	      Exit("Align on earlier event", "Get_Arm_Move_Time");
	   else if (TrialEndTime <= SkipSpikeTime())
	      return(FAIL);
	   else
	      StartTime = 1;
	   }
	if (StartTime >= TrialEndTime) {
	   if (InitialAlignment)
	      Exit("Align on later event", "Get_Arm_Move_Time");
	   else {
	      Warning("Looking for a reach at the end of the trial\n");
	      return(FAIL);
	      }
	   }

	/* Get start position */
	ArmPosition(StartTime-200,StartTime, &StartH, &StartV);
	if (StartH == NO_TOUCH)
	   ArmPosition(StartTime-100,StartTime, &StartH, &StartV);
	if (StartH == NO_TOUCH) {
	   if (InitialAlignment)
	      Exit("Align on interval with touch", "Get_Arm_Move_Time");
	   else
	      return(FAIL);
	   }

	if (DEBUG)
	   fprintf(stderr, "DEBUG: Find move of %d AD from %d,%d (%d-%d ms)\n",
	   	MOVE_CRITERION, StartH, StartV, StartTime-200, StartTime);

	/* Look for first move > criterion */
	while (StartTime < TrialEndTime-101) {
	   ArmPosition(StartTime, StartTime+100, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > MOVE_CRITERION ||
	       abs(LaterV - StartV) > MOVE_CRITERION)
	      break;
	   StartTime += 50;
	   if (StartTime >= TrialEndTime-101)
	      return(FAIL);
	   }

	if (DEBUG)
	   fprintf(stderr, "DEBUG: Move w/in %d-%d ms (%d %d) (%s)\n",
		StartTime,StartTime+100, LaterH, LaterV,
	        (LaterH == NO_TOUCH) ? "No touch" :
	        (StartTime >= TrialEndTime-101) ? "None found" : "Moved");

	/* Refine the location */
	StartTime -= 100;			/*  Back up 2 steps	*/
	for (i=0; i<500; i+=10) {
	   ArmPosition(StartTime, StartTime+20, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > MOVE_CRITERION ||
	       abs(LaterV - StartV) > MOVE_CRITERION)
	      break;
	   StartTime += 10;
	   }
	if (DEBUG)
	   fprintf(stderr, "DEBUG: Move w/in %d-%d ms\n",
			   			StartTime,StartTime+20);

	/* Refine the location */
	StartTime -= 20;			/*  Back up 2 steps	*/
	for (i=0; i<100; i++) {
	   ArmPosition(StartTime, StartTime+4, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > MOVE_CRITERION ||
	       abs(LaterV - StartV) > MOVE_CRITERION)
	      break;
	   StartTime++;
	   }

	/* Now back up until you're ONE-THIRD as far from the start	*/
	for (i=0; i<50; i++) {
	   ArmPosition(StartTime, StartTime+4, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) < FINE_MOVE_CRITERION &&
	       abs(LaterV - StartV) < FINE_MOVE_CRITERION)
	      break;
	   StartTime--;
	   }

	if (DEBUG)
	   fprintf(stderr, "DEBUG: Move w/in %d-%d ms\n",
			   			StartTime,StartTime+4);
	StartTime += 2;			/* Middle of 5 ms intervals	*/
	
	if (StartTime > TrialEndTime-4) {
	   /* fprintf(stderr, "No arm movement - can't align\n"); */
	   return(FAIL);		/* Should have already caught	*/
	   }

	if (DEBUG)
	 if (LaterH == NO_TOUCH)
	   fprintf(stderr, "%d vs %d\n",	/* Should be the same	*/
		 StartTime+adjust, 
	         Get_Arm_Time(RELEASE,FORWARD,StartTime+adjust-500,0));

	return(StartTime + adjust);	/* Shift back to stack time	*/
	}
/* ********************************************************************	*/

/* FUNCTION Get_Arm_Stop_Time */
	 /* Find where arm slowed to a crawl, or hit screen		*/
	 /* Looks BACKWARD in time from 'end'				*/
	 /*  EndTime is a raw stack time (e.g., from StackExtract)	*/
	 /*  Internally, EndTime is corrected to be re: TAPE_ON	*/
	 /*  Return time is again a raw stack time			*/
int Get_Arm_Stop_Time(int EndTime, int InitialAlignment) {
	int TrialEndTime = FrameCount_Header() * MsPerFrame_Header();
	int StartH, StartV;
	int LaterH, LaterV;
	int adjust = 0;
	int i;
       
	if (EndTime == FAIL)
	   return(FAIL);

	if (InitialAlignment) {			/* time.c calls		*/
	   adjust = Get_TapeOnTime();
	   Force_Zero_SkipTime(ON + 1);		/* What's with the +1?	*/
	   Read_Skipped_Data();			/* Read raw arm times	*/
	   Force_Zero_SkipTime(OFF);
	 } else {				/* macro calls		*/
	   adjust = SkipSpikeTime();
	   }
	EndTime -= adjust;

	if (EndTime < 50) {
	   Warning("Get_Arm_Stop_Time:Align on later event");
	   return(FAIL);
	   }
	if (EndTime >= TrialEndTime-10)
	    EndTime  = TrialEndTime-11;

	/* Get start position */
	ArmPosition(EndTime-60,EndTime+60, &StartH, &StartV);
	if (StartH == NO_TOUCH)
	   ArmPosition(EndTime-30,EndTime+30, &StartH, &StartV);
	if (StartH == NO_TOUCH)
	   ArmPosition(EndTime-10,EndTime+10, &StartH, &StartV);
	if (StartH == NO_TOUCH) {
	   if (InitialAlignment)
	      Exit("Align on interval with touch", "Get_Arm_Stop_Time");
	   else
	      return(FAIL);
	 }

	/* Look for first move > criterion */
	while (EndTime > 0) {
	   ArmPosition(EndTime-100, EndTime, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > STOP_CRITERION ||
	       abs(LaterV - StartV) > STOP_CRITERION)
	      break;
	   EndTime -= 50;
	   }

	/* Refine the location */
	if (EndTime < TrialEndTime-12)
	    EndTime += 25;			/* 1/2 step forward	*/
	for (i=0; i<300; i+=10) {
	   ArmPosition(EndTime-20, EndTime, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > STOP_CRITERION ||
	       abs(LaterV - StartV) > STOP_CRITERION)
	      break;
	   EndTime -= 10;
	   }

	/* Refine the location */
	if (EndTime < TrialEndTime-12)
	    EndTime += 10;			/* 1 step forward	*/
	for (i=0; i<30; i++) {
	   ArmPosition(EndTime-4, EndTime, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) > STOP_CRITERION ||
	       abs(LaterV - StartV) > STOP_CRITERION)
	      break;
	   EndTime--;
	   }

	/* Now move up until you're ONE-THIRD as far from the start	*/
	for (i=0; i<50; i++) {
	   ArmPosition(EndTime-4, EndTime, &LaterH, &LaterV);
	   if (LaterH == NO_TOUCH)
	      break;
	   if (abs(LaterH - StartH) < FINE_STOP_CRITERION &&
	       abs(LaterV - StartV) < FINE_STOP_CRITERION)
	      break;
	   EndTime++;
	   }

	EndTime -= 2;			/* Use center of interval	*/

	if (EndTime <= 2)
	   return(SkipSpikeTime());

	if (EndTime >= TrialEndTime-5)
	 Warning("Get_Arm_Stop_Time():ends past trial end;align on later event\n");

	return(EndTime + adjust);	/* Shift back to stack time	*/
	}
/* ********************************************************************	*/

/* FUNCTION ArmPosition */
	 /* Returns NO_TOUCH if ANY sample is a no touch	*/
	/* (is that really the behavior we want??)		*/
static void ArmPosition(int begin, int end, int *H, int *V) {
	int i;
	int sumH=0, sumV = 0.;
	int MsPer = MsPerFrame_Header();
	extern short Touch1[MAX_FRAMES*2];
	short *DataPtr = Touch1;

	if (DEBUG >= 2)
	   fprintf(stderr, "  DEBUG: %d %d: ", begin, end);

	if (begin < 2)				/* Insurance	*/
	    begin = 2;
	if (end > FrameCount_Header() * MsPerFrame_Header() - 2)
	    end = FrameCount_Header() * MsPerFrame_Header() - 2;
	if (end <= begin) {
	    *H = *V = NO_TOUCH;
	    return;
	    }

	DataPtr += 2 * (begin/MsPer);
	for (i=0; i<(end-begin)/MsPer; i++) {
	   if (*(DataPtr + i*2 + H_ARM) == NO_TOUCH) {
	      *H = *V = NO_TOUCH;
	      return;
	      }
	   sumH += *(DataPtr + i*2 + H_ARM);
	   sumV += *(DataPtr + i*2 + V_ARM);
	   }
	*H = sumH / ((end-begin+MsPer/2)/MsPer);
	*V = sumV / ((end-begin+MsPer/2)/MsPer);

	if (DEBUG >= 2)
	   fprintf(stderr, " %d,%d\n", *H, *V);
	}
/* ********************************************************************	*/

#define WIDTH(i)  sqrt( ArmData1[(i)].h_width * ArmData1[(i)].h_width + \
			ArmData1[(i)].v_width * ArmData1[(i)].v_width)

int Arm_SlideStart, Arm_LiftOff, Arm_TouchDown, Arm_SlideEnd;

/* FUNCTION Get_Arm_Times */
	 /* For macro calls.  Finds arm movements (see above)		*/
	 /* ArmData.time is re: start of trial (stack time)		*/
	 /*  Receives & outputs times re: TAPE_ON? 			*/
	 /*  Complicated by trial-by-trial alignment			*/
int Get_Arm_Times(int time) {
	int touches = TouchCount_Header(1);
	int i = -1;
	int Subtle = 0;

	Arm_SlideStart = Arm_LiftOff = Arm_TouchDown = Arm_SlideEnd = FAIL;

	if (time == FAIL)
	   return(FAIL);

	time -= SkipSpikeTime();	/* Shift to same frame as data	*/
	   	/* 'time' is a time read from the stack; ArmData1[].time
		                 is relative to the start of the trial	*/

	while (++i < touches)
	   if (ArmData1[i].time > time)
	       break;
	if (i >= touches)
	   return(FAIL);			/* No touches past start*/

	/* Move until NOT touching OR until width drops OR until big delta*/
	 /* If look back: if not touching, step back so time < request	*/
	int i_start = i;
	int H_start = ArmData1[i].h;
	int V_start = ArmData1[i].v;
	int i_LiftOff;


	/* Find lift-off or sharp gradient	*/
	for ( ; i<touches; i++) {
	   if (DEBUG & 0)
	      fprintf(stderr, "%d: %d %d  %.1f\n", 
			       i,  ArmData1[i].h, ArmData1[i].v, WIDTH(i));
           if (ArmData1[i].h == NO_TOUCH)
	      break;
	   if (abs(H_start - ArmData1[i].h) > DEGtoAD(2))
	      break;
	   if (abs(V_start - ArmData1[i].v) > DEGtoAD(2))
	      break;
	   if (WIDTH(i) < 4.)
	      break;
	   }
	   
	if (i >= touches) {			/* Did not find a reach	*/
	 if (DEBUG) fprintf(stderr, "No reach found.  Smaller criteria:\n");
	 i = i_start;				/* Try again		*/
	 for ( ; i<touches; i++) {
	   if (sqrt((H_start - ArmData1[i].h) * (H_start - ArmData1[i].h) +
	            (V_start - ArmData1[i].v) * (V_start - ArmData1[i].v)) > 
			   DEGtoAD(1.3))
	      break;
	   if ((WIDTH(i_start) / WIDTH(i)) > 2.)
	      break;
	   }
	 } 

	if (i >= touches) {
	   if (DEBUG) fprintf(stderr, "No luck.  Bailing.\n");
	   return(FAIL);			/* No touches past start*/
	   }
	 Subtle = WIDTH(i);

	if (DEBUG)
	       fprintf(stderr, "Got it: %d (i=%d); Now look for touchdown:\n", 
		    					ArmData1[i].time,i);

	Arm_LiftOff = ArmData1[i].time + SkipSpikeTime();
	i_LiftOff = i;

	/* Now find touchdown */
	for (  ; i < touches; i++) {
	    if (DEBUG & 0)
	       fprintf(stderr, "%d: %d %d  %.1f\n", 
			       i,  ArmData1[i].h, ArmData1[i].v, WIDTH(i));
            if (ArmData1[i_LiftOff].h == NO_TOUCH) {
               if (ArmData1[i].h != NO_TOUCH)
		 break;
	     } else
               if (WIDTH(i) > (1.1 * (double)Subtle))
		  break;
	    }

	if (i==touches)
	    i--;					/* Last one	*/

	if (DEBUG)
	       fprintf(stderr, "Got it: %d (i=%d); Now end of slide:\n", 
		    					ArmData1[i].time,i);

	Arm_TouchDown = ArmData1[i].time + SkipSpikeTime();

	/* Now find end of slide */
	int prev_time = ArmData1[i].time;
	for (  ; i < touches; i++) {
	    if (DEBUG & 0)
	       fprintf(stderr, "%d: %d %d  %.1f\n", 
			       i,  ArmData1[i].h, ArmData1[i].v, WIDTH(i));
	    if ((ArmData1[i].time - prev_time) > 20)
	       break;
	    prev_time = ArmData1[1].time;
	    }
	    
	if (i==touches)
	   i--;						/* Last one	*/
	Arm_SlideEnd = ArmData1[i].time + SkipSpikeTime();
	if (DEBUG)
	       fprintf(stderr, "Got it: %d (i=%d); Start of slide:\n", 
		    					ArmData1[i].time,i);

	/* Finally, find start of slide */
	i = i_LiftOff;
	prev_time = ArmData1[i].time;
	for (  ; i > i_start; i--) {
	    if (DEBUG & 0)
	       fprintf(stderr, "%d: %d %d  %.1f\n", 
			       i,  ArmData1[i].h, ArmData1[i].v, WIDTH(i));
	    if ((prev_time - ArmData1[i].time) > 20)	/* Backing up so swapd*/
	       break;
	    prev_time = ArmData1[1].time;
	    }
	i++;

	Arm_SlideStart = ArmData1[i].time + SkipSpikeTime();
	
	if (DEBUG)
	       fprintf(stderr, "Got it: %d (i=%d); All done.\n", 
		    					ArmData1[i].time,i);

	return(0);
	}
/* ********************************************************************	*/
