/* FILE anal.h */
     /* Analysis specific constants: non-user changable */
     /* (deffs.h: identical to reach's copy.  Deffs for grab go here	*/

/* #define  VERSION		7293	Defined in Makefile (different)	*/
/* #define  MAX_FRAMES		16000 Already in deffs.h */
/* #define  MAX_SPIKES		3000 Already in deffs.h */
#define  MAX_STACKS_IN_FIG	18

#define  MAX_FIGS		500
#define  MAX_TYPES		MAX_FIGS	/* Usu types == figs	*/	
#define	 SUM_FIGS		2	/* Avg & (mean+-SE OR variance)	*/

/* ********************************************************************	*/

/* Sorted lists, and parameter for Get_Trial_Info(fig, STACK) */
#define BODY	0
#define WHERE	0		/* WHERE & BODY are synonomous	*/
#define ACCEL	1
#define TARG1	2
#define TARG2	3
#define TARG3	4
#define TABLE	5		/* Class & table are synonomous	*/
#define CLASS	5
#define STACK	6
#define CELL	7
#define VELOC	8
#define MAX_LISTS	9	/* Up to here, save all in sorted lists	*/

#define COL	9
#define ROW	10
#define NUMBER	11
#define ORDER	12		/* On what trial does trialtype 1st appear */

#define MAX_INFO	13

/* ********************************************************************	*/

/* Various tags used in program */

#define LAST_OCCURRENCE	99	/* EventExtract(,,LAST_OCCURRENCE);	*/

#define CURRENT_TRIAL	-1	/* Setup_Coords_For_TrialType();	*/
#define TITLE_SPACE	-2	/* Setup_Coords_For_TrialType();	*/
#define TOP_LEFT_CELL	-3	/* Setup_Coords_For_TrialType();	*/

#define RIGHT_TEXT_MARGIN  ((RightEdgeCoord() * 3) / 4)	/* Title text 	*/
#define CENTER_TEXT_MARGIN  (RightEdgeCoord() * 4 / 9)
#define LEFT_TEXT_MARGIN    (LeftEdgeCoord())

#define SKIP_DATA	1	/* Flags for Read_Next_Trial		*/
#define WITH_DATA	0

#define ADD_TITLE_CHAR	'+'	/* If 1st char of title, keep std title	*/

#define FORWARD		1	/* For Get_Arm/Sac_Time()		*/
#define BACKWARD	0
#define CONTACT		1
#define RELEASE		0

#define ANY_TARGET	-1	/* For EventExtract() functions		*/
#define ANY_BEHAVIOR	-1

#define NO_TOUCH	-10000		/* For Get_ArmPosition()	*/
/* *******************************************************************	*/
/* ********************************************************************	*/

/* Values of Output variable (main.c;passed as parameter to many others)*/

# define NO_OUTPUT		0
# define INDIVIDUAL_PLOTS	1
# define SUMMARY_PLOT		2	/* See below for specific type	*/
# define TEXT_MACRO		4		/* -o, ascii output	*/
# define GRAPHICS_MACRO		8		/* -o, graphics +/- text*/
# define SPECIAL_GRAPHICS_MACRO	16	/* -o, free-hand graphics	*/

# define STANDARD_SUM_PLOT	(SUMMARY_PLOT)
# define VARIANCE_SUM_PLOT	(SUMMARY_PLOT|32)
# define POLAR_SUM_PLOT		(SUMMARY_PLOT|64)

# define XY_INDIVIDUAL_PLOTS	(INDIVIDUAL_PLOTS|128)
/* ********************************************************************	*/
/* ********************************************************************	*/

/* Miniature functions: */

#define VAR(s,s2,n)	(fabs((s2)-(s)*((double)(s))/(n)) / ((n)-1))
#define SD(s, s2, n)	((float) sqrt(VAR(s,s2,n)))
#define SE(s, s2, n)	((float) sqrt(VAR(s,s2,n)/(n)))

#define Min(a,b)	( ((a) > (b)) ? (b) : (a) )
#define Max(a,b)	( ((a) > (b)) ? (a) : (b) )

