/* FILE align */
     /* Do trial alignment stuff */
/* ********************************************************************	*/

#include <string.h>					/* strcpy() etc	*/
#include <stdlib.h>					/* atoi()	*/
#include <ctype.h>					/* isupper()	*/
#include "config.h"
#include "deffs.h"
#include "event.h"

#define  DEBUG 			0	/* Usu 1; 2 is different!	*/

#define  SKIP_EARLY_SACCADES	0	/* 0|60: SearchTime += 60 ms	*/
#define  ACCEPT_EARLY_SACCADES	125	/* 25:(125) SearchTime -= 25 ms	*/
		/* Else can miss a (barely) anticipatory saccade */
/* ********************************************************************	*/
/* ********************************************************************	*/
/*
PUBLIC:
  AlignTime_String	      Return ptr to string describing alignment
  Get_AlignmentTime	      Return code used on command line to do alignment
  Set_Alignment_From_CmdLine  Cmd-line requests for alignment (override default)
  InitAlignTimes	      Called relatively late
  Init_Align		      Called early
  Get_AlignTime		Return stored AlignTime (trial-specific!)
  Set_AlignTime		TRIAL-SPECIFIC align time (shift to align this trial)

PRIVATE:
  GetTargetTime		Time of a particular target on or off
  GetBlankTime		Time of a particular target blank or unblank
  GetAlignVariables
  StoreAlignVariables
 */
/* ********************************************************************	*/
/* ********************************************************************	*/

#define MAX_TRIALS	35000
static int IndividualTrialAlignmentTime[MAX_TRIALS + 1];

static char AlignString[120] = "Acquire";  /* signifies event type	*/
static char SaveAlignment[80] = "None";	/* Holds commandline alignment	*/

static char AlignChar =      'a';	/* signifies event type		*/
static int  AlignTarget =     -1;	/* Targ or behav # (-1==any)	*/
static int  AlignOnOff =       1;	/* 1 or 0			*/
static int  AlignNumber =     99;	/* Occur # ('$' encoded as 99)	*/
static int  SearchDirection = FAIL;	/* Forward ('+') or back ('-')	*/
static char SearchFrom[20] =  "";	/* Targ/off Blank/off  Acquire	*/
static int  SearchFromOnOff = ON;  	/* For target&blank:on or off?	*/
static int  AlignOnEvent    =  1;	/* Or, align on a response	*/
static int  YouNameEvent    =  0;	/* 'y': your choice		*/
static int  AlignBitPattern = -1;	/* 'k' 'K'			*/

/* Can have up to 10 stack-specific alignments! */
#define MAX_ALIGNS	10		/* Stack-specific aligns	*/
static int  MultipleAlignCount = 0;	/* How many?			*/
static int  MultipleAlignStackMap[MAX_ALIGNS];	/* Stack->index map	*/
static char MultipleAlignChar[MAX_ALIGNS] =      { 'a'};
static int  MultipleAlignTarget[MAX_ALIGNS] =    {-1};
static int  MultipleAlignOnOff[MAX_ALIGNS] =     { 1};
static int  MultipleAlignNumber[MAX_ALIGNS] =    {99};
static int  MultipleSearchDirection[MAX_ALIGNS]= {FAIL};
static char MultipleSearchFrom[MAX_ALIGNS][20] = {""};
static int  MultipleSearchFromOnOff[MAX_ALIGNS]= {ON};
static int  MultipleAlignOnEvent[MAX_ALIGNS]   = { 1};
static int  MultipleAlignBitPattern[MAX_ALIGNS]   = { -1};


static int ExcludeTrialsWithAlignErrors = 0;	/* 2: use with -w flag	*/
	/* Usually, just fail.  But if very few, might want to just skip
	over them; use "-ax".  Or, if using -w flag, might want to exclude
	(i.e., skip over) anything that fails to align; especially useful
	for preprocessing "-w" file.  (Trials that fail to align are
	automatically skipped if you give the "-a" option along with the
	"-w" option.  A special value is used to tell Process_Errors()
	not to call Store_Skip(), since this may overflow Store_Skips()
	buffer and you don't need to store this information.		*/


static int GetTargetTime(int targnumber, int onoff, int occurrence);
static int GetBlankTime(int targnumber, int onoff, int occurrence);
static int GetTTLTime(int linenumber, int onoff, int occurrence);
static int ProcessAlignError(char *string);
static void GetAlignVariables();
static void StoreAlignVariables(int stack);
/* ********************************************************************	*/
/* *************  PUBLIC FUNCTIONS ************************************	*/
/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION Get_AlignmentTime */
	 /* Return command line (encoded) alignment string */
char *Get_AlignmentTime() { return(SaveAlignment); }
/* ********************************************************************	*/

/* FUNCTION Get_AlignTime */
	 /* Return TRIAL-SPECIFIC alignment times (ONLY for time.c)	*/
int Get_AlignTime() {
    return(IndividualTrialAlignmentTime[TrialNumber_Input()]);
    }
/* ********************************************************************	*/

/* FUNCTION AlignTime_String */
	 /* Return parsed alignment string */
char *AlignTime_String() {
   static char String[80];
   static char Number[10];

   GetAlignVariables();

   switch (AlignNumber) {
      case 1: strcpy(Number, "1st"); break;
      case 2: strcpy(Number, "2nd"); break;
      case 3: strcpy(Number, "3rd"); break;
      case 95: strcpy(Number, "N-4th"); break;
      case 96: strcpy(Number, "N-3th"); break;
      case 97: strcpy(Number, "N-2th"); break;
      case 98: strcpy(Number, "N-1th"); break;
      case 99: strcpy(Number, "Last"); break;
      default: sprintf(Number, "%d-th", AlignNumber); break;
      }

   if (AlignOnEvent) {
     sprintf(String, "Align on %s %s", Number, AlignString);
     if (AlignTarget != -1)
       if (AlignChar == 'A')
          strcat(String, " behavior ");
     sprintf(String, "%s %d", String, AlignTarget);
     if (AlignOnOff == OFF)
       strcat(String, " OFF");
   } else {
     sprintf(String, "Align on first %s", AlignString);
     if (AlignOnOff == OFF)
        switch (AlignChar) {		/* Off: general & special cases */
	   case 'S': strcat(String, " end");    break;   //* Saccades
	   case 'C': strcat(String, " release");break;   //* Contact(touch)
	   default:  strcat(String, " OFF");    break;   //* All else
	   }
     sprintf(String, "%s %s the %s ",
     	String, 
	(SearchDirection==FORWARD) ? "after" : "before",
	Number);
     if (AlignTarget != -1)
       sprintf(String, "%starget %d ", String, AlignTarget);
     if (SearchFrom[0] != 'T')
        strcat(String, SearchFrom);
     if (SearchFromOnOff == OFF)
        strcat(String, " off ");
     }
   return(String);
   }
/* ********************************************************************	*/

/* FUNCTION Set_Alignment_From_CmdLine */
	 /* Parse the alignment from cmdline -- set Align* variables	*/
void Set_Alignment_From_CmdLine(char *CmdLine) {
	int stack = 0;

	/* Because of -a#-- (different alignments for different stacks),
	 * we now have to re-initialize variables each time we call
	 * 'set align'.  (Pray this works!  LHS 5-15-02)
	 */
	AlignChar =      'a';	/* signifies event type		*/
	AlignTarget =     -1;	/* Targ or behav # (-1==any)	*/
	AlignOnOff =       1;	/* 1 or 0			*/
	AlignNumber =     99;	/* Occur # ('$' encoded as 99)	*/
	SearchDirection = FAIL;	/* Forward ('+') or back ('-')	*/
	SearchFrom[0] =  0;	/* Targ/off Blank/off  Acquire	*/
	SearchFromOnOff = ON;  	/* For target&blank:on or off?	*/
	AlignOnEvent    =  1;	/* Or, align on a response	*/
	AlignBitPattern = -1;

	if (DEBUG) fprintf(stderr, "Alignment string is %s\n", CmdLine);

	switch (*CmdLine) {	/* Special cases			*/
	   case 'X':		/* Default: EXIT on align err		*/
	   	ExcludeTrialsWithAlignErrors = 0;
		return;

	   case 'x':		/* Skip err trials (not recommended)	*/
		if (ExcludeTrialsWithAlignErrors != 2)
	            ExcludeTrialsWithAlignErrors = 1;
				/* Don't reset to 1 even if "-ax" option*/
		return;		/* 1 and 2 are very similar		*/

	   case '':		/* -w AND -a: don't write trials w/ err	*/
	   	ExcludeTrialsWithAlignErrors = 2;
  	        return;		/* 2 vs 1: Don't call Store_Skip()	*/
	   			
	   }

	if (strlen(CmdLine) > 80)
	   Exit("Increase SaveAlignment size", "Set_Alignment_From_CmdLine()");
	strcpy(SaveAlignment, CmdLine);

	if (*CmdLine == '#') {		/* Stack-specific alignment?	*/
	   CmdLine++;				/* Pass over '#'	*/
	   sscanf(CmdLine, "%d", &stack);	/* Get & store stack #	*/
	   while (isdigit(*CmdLine))		/* Pass over stack #	*/
	      CmdLine++;
	   }

	AlignChar  = *(CmdLine++);			/* 1 character	*/
	AlignOnOff = ! isupper(AlignChar);

	
	switch (AlignChar) {		/* Align on an event in the stack */
	   case 'a':  strcpy(AlignString, "ACQUIRE"); break;

	   case 'b':
	   case 'B':  strcpy(AlignString, "BLANK");   break;

	   case 'd':
	   case 'D':  strcpy(AlignString, "DELAY");   break;

	   case 'e':
	   case 'E':  strcpy(AlignString, "E-STIM");  break;

	   case 'G':  strcpy(AlignString, "BUTTON_ACQUIRE"); break;
	   case 'H':  strcpy(AlignString, "BUTTON_ACQUIRE_AND"); break;
	   case 'I':  strcpy(AlignString, "BUTTON_ACQUIRE_OR"); break;
	   /*case 'J':  strcpy(AlignString,"BUTTON_ACQUIRE_EXCLUSIVE");break;*/

	   case 'N':  strcpy(AlignString, "NEW_BACKGROUND_COLOR"); break;

	   case 'o':  strcpy(AlignString, "TTL ON"); break;
	   case 'O':  strcpy(AlignString, "TTL OFF"); break;

           case 'p':
	   case 'P':  strcpy(AlignString, "PURSUE");   break;

           case 'q':
	   case 'Q':  strcpy(AlignString, "BITMAP");   break;

           case 'u':  strcpy(AlignString, "REDRAW");   break;

	   case 'w':
	   case 'W':  strcpy(AlignString, "ROTATE");  break;

           case 'r':
	   case 'R':  strcpy(AlignString, "TAPE");   break;

           case 't':
	   case 'T':  strcpy(AlignString, "TARGET");   break;

           case 'y':
           case 'Y': {
		strcpy(AlignString, "You-name-it");
		if (isdigit(CmdLine[0])) {
	           YouNameEvent = atoi(CmdLine);	/* Read any #	*/
	           while (isdigit(*CmdLine))		/* Skip over it	*/
	            CmdLine++;
	         } else {
	           YouNameEvent = EventNameToNumber(CmdLine);
		   if (YouNameEvent == FAIL) {
		      fprintf(stderr, "Cannot find event %s", CmdLine);
	              Exit("Exiting", "Set_Alignment_From_CmdLine()");	
	              }
		   while (*CmdLine && *CmdLine != '.')
		      CmdLine++;
	           }
		break;
		}


	   default:   AlignOnEvent = 0;
	   }

	if (AlignOnEvent) {		/* NOT on a response		*/
	  if (DEBUG)
	     fprintf(stderr, "Align on %s event\n", AlignString);
	  if (*CmdLine == 't') {
	     CmdLine++;
	     goto GET_ALIGN_TARGET;
	     }
	  if (AlignChar == 'a' && *CmdLine == 'a') {
	     CmdLine++;			/* -aaa: align on acq behavior	*/
	     AlignChar = 'A';		/* Align on particular behavior */
	     goto GET_ALIGN_TARGET;	/* In this case, GET_A_BEHAVIOR	*/
	     }
	  goto GET_OCCURRENCE;
	  }

	/* GET_RESPONSE */
	switch (AlignChar) {		/* Align on animal's response	*/
           case 'c':
	   case 'C':  strcpy(AlignString, "Contact");   break;
	   case 'k':
	   case 'K':  strcpy(AlignString, "Key");	break;
	   case 'M':
	   case 'm':  strcpy(AlignString, "Move hand"); break;
	   case 's':
	   case 'S':  strcpy(AlignString, "Saccade");  break;
	   case 'v':  strcpy(AlignString, "Peak sac veloc"); break;
	   default: fprintf(stderr,
	   	       "unknown alignment <'%c'>\n", *(CmdLine-1));
		    Exit("", "Set_Alignment_From_CmdLine()");	
	   }
	

	if (DEBUG)
	   fprintf(stderr,"Align on %s (response)\n", AlignString);

	GET_SEARCH_FROM:
	switch (*(CmdLine++)) {		/* Response relative to what event?*/
	   case 'E':  SearchFromOnOff = OFF;
	   case 'e':  strcpy(SearchFrom, "E-Stimulate");
		      goto GET_OCCURRENCE;		/* No align target */
	   case 'T':  SearchFromOnOff = OFF;
	   case 't':  strcpy(SearchFrom, "Target"); break;
	   case 'B':  SearchFromOnOff = OFF;
	   case 'b':  strcpy(SearchFrom, "Blank"); break;
	   case 'O':  SearchFromOnOff = OFF;
	   case 'o':  strcpy(SearchFrom, "On/off TTL"); break;
	   case 'u':  strcpy(SearchFrom, "u:Redraw");
		      if (DEBUG)
	   		 fprintf(stderr,"Search from %s (%swards)\n",
	            	     SearchFrom, (SearchDirection) ? "for":"back");
		      goto GET_OCCURRENCE; /* No align target; # is occur */
	   case 'A':
	   case 'a':  strcpy(SearchFrom, "Acquire");
	   	      if (SearchDirection == FAIL)  /* Don't chg if set	*/
		          SearchDirection = BACKWARD;
	   	      break;
	   case '+':
		 SearchDirection = FORWARD;
		 goto GET_SEARCH_FROM;
	   case '-':
		 SearchDirection = BACKWARD;
		 goto GET_SEARCH_FROM;
	   default: 
	       CmdLine--;
	       if (isdigit(*CmdLine))		/* Assume align re: targ */
	          goto GET_OCCURRENCE;
	       if (*CmdLine=='.')
	          goto GET_OCCURRENCE;
	       Exit(
	   	"specify at which event to begin search for response",
		"Set_Alignment_From_CmdLine()");	
	   }
	if (SearchDirection == FAIL)		/* Never set?		*/
	    SearchDirection = FORWARD;		/* Default is forward	*/
	
	if (DEBUG)
	   fprintf(stderr,"Search from %s (%swards)\n",
	            SearchFrom, (SearchDirection) ? "for":"back");

	GET_ALIGN_TARGET:			/* Defaults to -1	*/
	if (*CmdLine == '.')			/* Use default	*/
	   goto GET_OCCURRENCE;
	if (!(isdigit(*CmdLine) || *CmdLine=='-'))
	   Exit("Target # or '.' must follow response type",
		  "Set_Alignment_From_CmdLine()");
	AlignTarget = atoi(CmdLine);
	while (isdigit(*CmdLine) || *CmdLine=='-') /* Move over it	*/
	   CmdLine++;				   /* Stop at end or '.'*/

	if (DEBUG)
	   fprintf(stderr,"Align on target %d\n", AlignTarget);

	GET_OCCURRENCE:
	if (*CmdLine == '.')
	   CmdLine++;
	
	switch (*CmdLine) {		/* Skip over separator	*/
	      case 0:	AlignNumber = 1;  break;	/* No number: 1	*/
	      case '$':	AlignNumber = LAST_OCCURRENCE;
	      		if (*(++CmdLine) == '-') {
			   AlignNumber += atoi(++CmdLine);
	                   while (isdigit(*CmdLine))
	                       CmdLine++;		/* Skip over it	*/
			   }
	      		break;
	      default:	
	        if (! isdigit(*CmdLine))
	           Exit("occurrence number must follow '.'",
		           "Set_Alignment_From_CmdLine()");	
	        AlignNumber = atoi(CmdLine);
	        while (isdigit(*CmdLine))
	          CmdLine++;		/* Skip over it	*/
	      } 

	if ((AlignChar=='K' || AlignChar=='k')) {
	   if (*(CmdLine) == '_') {
	      if (! isdigit(*++CmdLine))
	         Exit("bit pattern must follow '.'",
		           "Set_Alignment_From_CmdLine()");	
          AlignBitPattern = atoi(CmdLine);
	      while (isdigit(*CmdLine))
	          CmdLine++;		/* Skip over it	*/
	      }
	   }

	if (*CmdLine && *(++CmdLine))	/* Anything left? (should be \0)*/
	   fprintf(stderr, "Excess chars in align string (%s)\n",CmdLine);

#ifdef DIAG
	if (SearchFrom[0] == 'u')	/* Align on response based on redraw */
	   AlignNumber = (AlignTarget == -1) ? 1 : AlignTarget;
	   /* Totally baffled by this but no time to work it out! LHS 1-2008 */
	   /* But fails for -asu2! Why'd we need this? Commenting out LHS 5-09*/
#endif

	if (DEBUG)
	   fprintf(stderr,"Occur %d\n%s\n", AlignNumber, AlignString);

    	StoreAlignVariables(stack);
	}			
/* ********************************************************************	*/
/* ********************************************************************	*/
/* FUNCTION UseVSYNC */
	 /* If there's a vsync in stack, advance to V_SYNC off		*/
int UseVSYNC(int TargetTime) {
  int SyncTime;

  if (TargetTime == FAIL) return(FAIL);		/* Added 8-30-2007 by LHS */

  SyncTime = EventExtract(V_SYNC, TIME, 2);	/* V_SYNC off event	*/
  if (SyncTime == FAIL)				/* No v-sync?		*/
     return(TargetTime);
  if (SyncTime > TargetTime) {
     if (EventExtract(V_SYNC, TIME, 1) < TargetTime)
	return(SyncTime);
     else
        return(TargetTime);
     }

  SyncTime = EventExtract(V_SYNC, TIME, 4);	/* Repeat for 2nd sync	*/
  if (SyncTime == FAIL)
     return(TargetTime);
  if (SyncTime > TargetTime) {
     if (EventExtract(V_SYNC, TIME, 3) < TargetTime)
	return(SyncTime);
     else
        return(TargetTime);
     }

  if (EventExtract(V_SYNC, TIME, 6) != FAIL)
     fprintf(stderr, "EXTEND CODE TO HANDLE MORE VIDEO SYNCS!\n");
  return(TargetTime);
  }
/* ********************************************************************	*/

/* FUNCTION Set_AlignTime */
	 /* Trial SPECIFIC; set once for each trial and STORE	*/
int Set_AlignTime() {
  int temp = FAIL;			/* The time alignment time	*/
	 	/* Often, temp is first used to get occurrence #	*/

  int i = 0;
  int SearchTime = FAIL;
  int tape_on = 0;			/* Used if align on response	*/

  if (TrialNumber_Input() > MAX_TRIALS)
     Exit("Too many trials! See MAX_TRIALS in align.c", "Set_AlignTime()");

  if (IndividualTrialAlignmentTime[TrialNumber_Input()] != 0)
     Warning("Possible error in setting aligment time in Set_AlignTime()");

  GetAlignVariables();
  if (SearchFrom[0]) {
     if (DEBUG == 2)
       fprintf(stderr, "aligntarg is %d, searchfromonoff %d, number %d\n",
		       		AlignTarget,SearchFromOnOff,AlignNumber);

     switch (SearchFrom[0]) {	/* Align on response, re: an event?	*/
       case 'T':  
	SearchTime = UseVSYNC(
		      GetTargetTime(AlignTarget,SearchFromOnOff,AlignNumber));
	break;
       case 'B':
	SearchTime = UseVSYNC(
		      GetBlankTime(AlignTarget,SearchFromOnOff,AlignNumber));
	break;
       case 'E':
	SearchTime = EventExtract(STIMULATE, TIME, AlignNumber);
	if (SearchFromOnOff)
	   temp += EventExtract(STIMULATE, ONE, AlignNumber);
        break;
       case 'O':
	SearchTime = GetTTLTime(AlignTarget,SearchFromOnOff,AlignNumber);
	break;
       case 'u':
	SearchTime = UseVSYNC(EventExtract(TARGET_REDRAW, TIME, AlignNumber));
        break;
       case 'A':
	SearchTime = (AlignTarget == -1) ? /* 'any' target? Skip windowless */
		/* But breaks '$' searches, for some reason */
	 WindowAcquireEventExtract(TIME,AlignNumber) :	 /* With window	*/
	 AcquireEventExtract(ANY_BEHAVIOR,AlignTarget,TIME,AlignNumber);
	 /* FLIPPED 1st TWO ARGUMENTS: LHS 2-8-01 */
	break;
       }

     if (SearchTime == FAIL)
       return(ProcessAlignError("Couldn't find event to search from"));

     tape_on = EventExtract(TAPE_ON, TIME, 1);

     if (SearchTime >= tape_on + FrameCount_Header() * MsPerFrame_Header())
	return(ProcessAlignError("Search from event after trial ends"));
     if (SearchTime <= tape_on)
	return(ProcessAlignError("Search from event before trial starts"));
     }


  switch (AlignChar) {			/* First do events, then responses */

/* ALIGN ON AN EVENT */
  /* ACQUIRE */
     case 'A':					/* Acq specific behavior*/
	temp = AcquireEventExtract(AlignTarget, ANY_TARGET,TIME,AlignNumber);
	break;	/* AlignTarget actually holds behavior to align on	*/
     case 'a':					/* Acq specific target	*/
	temp = AcquireEventExtract(ANY_BEHAVIOR,AlignTarget,TIME,AlignNumber);
	break;

  /* BLANK */
     case 'B': case 'b':
	temp = UseVSYNC(GetBlankTime(AlignTarget, AlignOnOff, AlignNumber));
	break;

  /* DELAY */
     case 'D': case 'd':
	temp = EventExtract(DELAY, TIME, AlignNumber);
	if (AlignOnOff == 0)
	   temp += EventExtract(DELAY, TWO, AlignNumber);
	break;

  /* Electrical microstimulation */
     case 'e':
     case 'E':
     	temp = EventExtract(STIMULATE, TIME, AlignNumber);
	if (AlignChar == 'E')
	   temp += EventExtract(STIMULATE, ONE, AlignNumber);
	break;

  /* Get arm pattern acquire */
     case 'G':
	{ static int ButtonAcqTypes[] =
		{ BUTTON_ACQUIRE_AND, BUTTON_ACQUIRE_OR, 0 };
     	temp = MultiEventExtract(ButtonAcqTypes, TIME, AlignNumber);
	}
	break;
     case 'H':
     	temp = EventExtract(BUTTON_ACQUIRE_AND, TIME, AlignNumber);
	break;
     case 'I':
     	temp = EventExtract(BUTTON_ACQUIRE_OR, TIME, AlignNumber);
	break;

  /* Background color */
     case 'N':
     	temp = UseVSYNC(EventExtract(NEW_BACKGROUND_COLOR, TIME, AlignNumber));
	break;

  /* TTL_ON/OFF */
     case 'O': case 'o':
	temp = GetTTLTime(AlignTarget, AlignOnOff, AlignNumber);
	break;

     case 'Y': case 'y':
     	temp = EventExtract(YouNameEvent, TIME, AlignNumber);
	break;	/* Haven't implemented 'on' and 'off' (y vs Y)	*/

  /* PURSUE */
     case 'P': case 'p': {
	int count = (AlignNumber<LAST_OCCURRENCE) ? 0 : LAST_OCCURRENCE-1;
						/* Get occurrence #	*/
	i = count;
	while ((temp=EventExtract(TARGET_PURSUIT,ONE,++i)) != FAIL) {
	   if (AlignTarget!=-1 && temp!=AlignTarget)
	      continue;
	   if (AlignOnOff ==		/* true == TWO|THREE non-zero	*/
			   		/* The '||' coerces to T/F (0/1)*/
	 	(EventExtract(TARGET_PURSUIT,TWO,  i) ||
		 EventExtract(TARGET_PURSUIT,THREE,i)))
	      count++;
	   if (count == AlignNumber)
	      break;
	   }
	if (temp == FAIL)		/* Can't find requested occur #	*/
	   return(ProcessAlignError("Pursue alignment not found"));

	temp = EventExtract(TARGET_PURSUIT, TIME, i);
	break;
	}

  /* Bitmap */
     case 'Q':
     	temp = EventExtract(TARGET_BITMAP, TIME, AlignNumber);
	break;

  /* Redraw target (change color, size, shape) */
     case 'u':
     	temp = UseVSYNC(EventExtract(TARGET_REDRAW, TIME, AlignNumber));
	break;

  /* WHOLE BODY ROTATION */
     case 'W': case 'w': {
	int count = (AlignNumber<LAST_OCCURRENCE) ? 0 : LAST_OCCURRENCE-1;
						/* Get occurrence #	*/
	i = count;
	while ((temp=EventExtract(CHAIR_AT,ONE,++i)) != FAIL) {
	   if (AlignOnOff ==			/* true == non-zero	*/
	 	(EventExtract(CHAIR_AT,ONE,i) != 0))	/* Coerce to 0/1*/
	      count++;
	   if (count == AlignNumber)
	      break;
	   }
	if (temp == FAIL)		/* Can't find requested occur #	*/
	   return(ProcessAlignError("Whole-body rotation alignment not found"));

	temp = EventExtract(CHAIR_AT, TIME, i);
	break;
	}

  /* TARGET_ON/OFF */
     case 'T': case 't':
	temp = UseVSYNC(GetTargetTime(AlignTarget, AlignOnOff, AlignNumber));
	break;

  /* TAPE_ON/OFF */
     case 'R': case 'r':
	temp = (AlignOnOff) ? EventExtract(TAPE_ON,TIME,1) :
			      EventExtract(TAPE_OFF,TIME,1);
	break;


/* ALIGN ON A RESPONSE	*/

  /* Contact touch panel */
     case 'C': case 'c':
	Force_Zero_SkipTime(ON);
	if (SearchDirection == BACKWARD)
	   temp = Get_Arm_Time(AlignOnOff,BACKWARD,SearchTime, 1);
	 else {             /* FORWARD */	/* Can be tricky ...	*/
	   if (AlignOnOff == CONTACT) {		/* Look for next CONTACT*/
	      if (Is_Arm_Touching(SearchTime)) /* Look past next release*/
	          SearchTime = 20 + Get_Arm_Time(RELEASE,FORWARD,SearchTime, 1);
	      temp = Get_Arm_Time(CONTACT,FORWARD,SearchTime,1);
	   } else { 				/* Look for next RELEASE*/
	      if (Is_Arm_Touching(SearchTime)) /* Should be touching!	*/
	         temp = Get_Arm_Time(RELEASE,FORWARD,SearchTime, 1);
	       else /* Wierd! Maybe released too early?  Back up & look	*/
	         temp = Get_Arm_Time(RELEASE,FORWARD,SearchTime-50, 1);
	      } 
	 }
	Force_Zero_SkipTime(OFF);

	if (temp == FAIL &&			/* Didn't find it?	*/
	     !ExcludeTrialsWithAlignErrors) {	/* If so, process err	*/
	     temp = FrameCount_Header() * MsPerFrame_Header();	/* EOT	*/
     	     Warning("No such touch/release: align on EOT");
	     }
	break;

      /* Get button (key) acquire */
     case 'k':
     case 'K':
	Force_Zero_SkipTime(ON);
        temp = Get_Button_Time(AlignOnOff, AlignBitPattern, 1, SearchTime, 1);
		/* Used to subtract tape_on from SearchTime (LHS 9-07)	*/
/* AlignTarget and AlignNumber refer to the targ & occur # to search from
 * (e.g, 3rd occur of target 3 turning on).  Currently, there is no way to
 * specify the bit pattern (2nd argument) or the occurrence of that button
 * pattern (3rd argument).   LHS 2014-11-21: now -ak..._32 searches for bit
 * pattern '32'.
 */
	Force_Zero_SkipTime(OFF);
	break;


     case 'M':
        /* if (SearchFrom[0] != 'A')
	 Exit("To align on end of move, use acquire (-aMa1) ", "align");
	 */
     case 'm':
	/* NEITHER OF THESE WORK ALL THE TIME !!! */
	/* Something to do with indexing the array of touches incorrectly in
	 * arm.c::ArmPosition().  Can't quite work it out.	*/
	{ static int DIAG = 0;
	if (DIAG) {
	   fprintf(stderr, "-atm not guarenteed\n");   /*  LHS 4-2011 */
	   DIAG = 0;
	   }
	}
	temp = Get_Arm_Move_Time(SearchTime, 1);
	if (AlignOnOff == OFF)
	   temp = Get_Arm_Stop_Time(temp+200, 1);
	break; 


     case 'S': case 's':
        if (SKIP_EARLY_SACCADES && SearchDirection == FORWARD)
	    SearchTime += SKIP_EARLY_SACCADES;	/* Skip early saccades	*/
        if (ACCEPT_EARLY_SACCADES && SearchDirection == FORWARD)
	    SearchTime -= abs(ACCEPT_EARLY_SACCADES);/* Take early sacs	*/
	temp=Get_Saccade_Time(AlignOnOff,SearchDirection,SearchTime-tape_on,1);
	break;		/* (begin or end?, forward or back, search from, 1) */

     case 'v':
        if (SKIP_EARLY_SACCADES && SearchDirection == FORWARD)
	    SearchTime += SKIP_EARLY_SACCADES;	/* Skip early saccades	*/
        if (ACCEPT_EARLY_SACCADES && SearchDirection == FORWARD)
	    SearchTime -= abs(ACCEPT_EARLY_SACCADES);/* Take early sacs	*/
	temp = Get_Saccade_Peak_Velocity(SearchDirection,SearchTime-tape_on,1);
	break;
     }

   if (temp == FAIL)		/* Error or unknown request	*/
      return(ProcessAlignError("Alignment failed or not written"));
   if (((short)temp) <= 0)
      Exit("Asking for alignment before start of trial", "Set_AlignTime");
   if (((short)temp) >= EventExtract(END_STACK, TIME, 1))
      Exit("Asking for alignment after end of trial", "Set_AlignTime");
   IndividualTrialAlignmentTime[TrialNumber_Input()] = temp;
   return(temp);
   }
/* ********************************************************************	*/

/* FUNCTION ProcessAlignError */
	 /* Error in getting alignment: bail out or skip trial	*/
static int ProcessAlignError(char *string) {
       if (ExcludeTrialsWithAlignErrors) {
          int trial = TrialNumber_Input();

	  fprintf(stderr, "Skipping trial %d", trial);
	  if (ExcludeTrialsWithAlignErrors == 1) {	/* NOT if == 2	*/
             Store_Skip((char)'t', trial, trial); /* Not needed when -w	*/
	     fprintf(stderr, " (bad alignment)\n");
	   } else if (ExcludeTrialsWithAlignErrors == 2)   /* For -w:	*/
	     fprintf(stderr, " (missing alignment event/response)\n");
       } else {
         fprintf(stderr,
            "Err in align: %c (%s %s) occurrence %d of target %d %s [%s]\n",
	     AlignChar, AlignString, 
	     (AlignOnOff)?"on":"off",
	     AlignNumber,
	     AlignTarget,
	     SearchFrom,
	     (SearchFromOnOff)?"on":"off");
	 Exit(string, "Set_AlignTime");
	 }
       return(SKIP_TRIAL);
       }
/* ********************************************************************	*/

/* FUNCTION InitAlignTimes */
	 /* Initialize so can check for double hits!	*/
void InitAlignTimes() {
	int i = MAX_TRIALS + 1;

	while (--i >= 0)
	   IndividualTrialAlignmentTime[i] = 0;
	}
/* ********************************************************************	*/

/* FUNCTION Init_Align*/
	 /* For batch files: have to clear out align each time	*/
void Init_Align() {
       int i;

       MultipleAlignCount = 0;
       for (i=0; i<MAX_ALIGNS; i++) {
	  MultipleAlignStackMap[i] = 0;
	  MultipleAlignChar[i] =       'a';
	  MultipleAlignTarget[i] =    -1;
	  MultipleAlignOnOff[i] =      1;
	  MultipleAlignNumber[i] =    99;
	  MultipleSearchDirection[i]= FAIL;
          strcpy(MultipleSearchFrom[i], ""); 
	  MultipleSearchFromOnOff[i]= ON;
	  MultipleAlignOnEvent[i]   =  1;
	  MultipleAlignBitPattern[i]   =  -1;
	  }
       InitAlignTimes();		/* Added 09-14-07 by LHS	*/
	}
/* ********************************************************************	*/

/* FUNCTION GetTargetTime */
	 /* Find time a particular target goes on or off	*/
static int GetTargetTime(int targnumber, int onoff, int occurrence) {
	return((onoff) ? 
	         TargetEventExtract(targnumber, TIME, occurrence) :
	         TargetOffEventExtract(targnumber, TIME, occurrence));
	}
/* ********************************************************************	*/

/* FUNCTION GetBlankTime */
	 /* Find time a particular target blanks or unblanks	*/
static int GetBlankTime(int targnumber, int onoff, int occurrence) {
	int count = (occurrence<LAST_OCCURRENCE) ? 0 : LAST_OCCURRENCE-1;
	int i = count;
	int temp;

	while ((temp=EventExtract(TARGET_BLANK, TWO, ++i)) != FAIL)
	  if (temp == onoff)				/* On or off?	*/
	    if (targnumber == -1 ||			/* Any targ?	*/
	           (EventExtract(TARGET_BLANK,ONE,i) == targnumber))
	      if (++count == occurrence)		/* Right #?	*/
	         break;
	if (temp == FAIL)
           return(FAIL);
	   /* Old version (changed 08-30-2007 by LHS):
	    *  Exit("Requested BLANK not found", "align.c, GetBlankTime");
	    */

	return(EventExtract(TARGET_BLANK,TIME,i));
	}
/* ********************************************************************	*/

/* FUNCTION GetTTLTime */
	 /* NOTE: does not handle TTL_LINE events! */
static int GetTTLTime(int linenumber, int onoff, int occurrence) {
	int count = (occurrence<LAST_OCCURRENCE) ? 0 : LAST_OCCURRENCE-1;
	int i = count;
	int temp;
	int Type = (onoff) ? TTL_ON : TTL_OFF;

	if (EventExtract(TTL_LINE, ONE, 1) != FAIL)
	   fprintf(stderr, "Warning: alignment ignores TTL_LINE events!\n");

	while ((temp=EventExtract(Type, ONE, ++i)) != FAIL)
	   if ((linenumber == -1) || (temp == linenumber))
	     if (++count == occurrence)		/* Right #?	*/
	        break;
	if (temp == FAIL)
	   return(ProcessAlignError("Requested TTL event not found"));

	return(EventExtract(Type,TIME,i));
	}
/* ********************************************************************	*/

/* FUNCTION GetAlignVariables */
static void GetAlignVariables() {
   int StackMapIndex = 0;		/* Default: 1st entry		*/

   if (MultipleAlignCount > 0) {
      int stack = StackNumber_Header();
      int i;

      for (i=0; i<MultipleAlignCount; i++)
       if (stack == MultipleAlignStackMap[i+1]) {
	  StackMapIndex = i+1;
	  break;
	  }
      /* If not found, StackMapIndex is 0, the default	*/
      }

   strcpy(SearchFrom, MultipleSearchFrom[StackMapIndex]); 
   SearchDirection = MultipleSearchDirection[StackMapIndex];   
   SearchFromOnOff = MultipleSearchFromOnOff[StackMapIndex];   
   AlignTarget = MultipleAlignTarget[StackMapIndex];   
   AlignNumber = MultipleAlignNumber[StackMapIndex];   
   AlignChar = MultipleAlignChar[StackMapIndex];   
   AlignOnOff = MultipleAlignOnOff[StackMapIndex];   
   AlignBitPattern = MultipleAlignBitPattern[StackMapIndex];   
   }
/* ********************************************************************	*/

/* FUNCTION StoreAlignVariables */
static void StoreAlignVariables(int stack) {
   int StackMapIndex = 0;		/* Default: 1st entry		*/

   if (stack==0)
      StackMapIndex = 0;
   else {
      MultipleAlignCount++;
      if (MultipleAlignCount >= MAX_ALIGNS)
         Exit("Too many separate stack alignments requested",
	     "StoreAlignVariables, align.c");
      StackMapIndex = MultipleAlignCount;
      MultipleAlignStackMap[StackMapIndex] = stack;
      }

   strcpy(MultipleSearchFrom[StackMapIndex], SearchFrom);
   MultipleSearchDirection[StackMapIndex] = SearchDirection;
   MultipleSearchFromOnOff[StackMapIndex] = SearchFromOnOff;
   MultipleAlignTarget[StackMapIndex] = AlignTarget;
   MultipleAlignNumber[StackMapIndex] = AlignNumber;
   MultipleAlignChar[StackMapIndex] = AlignChar;
   MultipleAlignOnOff[StackMapIndex] = AlignOnOff;
   MultipleAlignBitPattern[StackMapIndex] = AlignBitPattern;
   }
/* ********************************************************************	*/

