/* FILE _macros/stimulate/printstim.c */

#include "../Deffs.h"


#define DEBUG		    0	

#define	MEASURE_SACCADE	    1	/* 1: find saccade and measure metrics?	*/
				/* 0:  measure avg eyepos in interval	*/
#define CMDLINE_THRESHOLD   2	/* use -d to specify theshold?		*/

/* ********************************************************************	*/
     /* Stim macro: print stim bits
      *		    count of EYE positions in specified interval
      *		    eye position on "out" trials
      *		    landing outside of specificed threshold (using '-d')
      *		    plus measured eyepos/saccade metrics for "out" trials
      *		    sorted by stack and class */

     /* File name: StimCount#.run#
      * For each type:
      *  stack class bits #trials_out #trials_total h_pos v-pos */

 /* ******************************************************************* */

void Print_Stim121() {
	int Types   = Count_TrialTypes();
	int type;
	FILE *file;
   	char Name[80];
	int s,c;
	int Threshold;

	float Sum_H_Eye[MAX_TYPES];
	float Sum_V_Eye[MAX_TYPES];

	int Sum_EyeOut[MAX_TYPES];
	int Count_Eye[MAX_TYPES];
	int Stim_Bits[MAX_TYPES];
	int Stim_Period[MAX_TYPES];

	for (type=0; type<Types; type++) {
	   Sum_H_Eye[type] =
	   Sum_V_Eye[type] = 0.0;
	   Sum_EyeOut[type] =
	   Count_Eye[type] = 0;
	   Stim_Bits[type] = 
	   Stim_Period[type] = FAIL;
	   }

#if CMDLINE_THRESHOLD
	Threshold = Get_dataValue_From_CmdLine(); 
		    /* integer degree threshold */
		    /* minimum saccade distance OR eye position (for X and Y separately)*/
#else
	Threshold = 1;
#endif

#if DEBUG
   	fprintf(stderr, "Using threshold of %d degrees\n",Threshold);
#endif
	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "StimCount_s%d.%d",
		UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   float X,Y;
	   int type = Get_TrialType();
	   int bits = EventExtract(80, 1, 1);	/* parameter 1=bits   */
						/* occurence 1=first  */
	   int period = EventExtract(78, 2, 1); /* parameter 2=period */
						/* occurence 1=first  */
#if MEASURE_SACCADE
	   extern float SacPosition_H, SacPosition_V;

	   int GoTime = Interval_To_Stack_Time(0);    /* gets align time*/
	   					/* Get sac start data 	*/
	   int sac_start = Get_Saccade_Time(1, 1, GoTime, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;
	   					/* Get sac end data 	*/
	   int sac_end = Get_Saccade_Time(0, 1, GoTime, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;		

#if DEBUG
	   fprintf(stderr,"Start H %f V %f\nEnd H %f V %f\n",
		   Start_H,Start_V,End_H,End_V);
#endif
	   if (sac_start == 22222) fprintf(stderr, "Dummy - ignore!");

	   if (sac_end != FAIL) {
		 X = End_H - Start_H;
		 Y = End_V - Start_V;
	   } else {
		 X = 0; Y = 0;			/* didn't find a saccade!*/
	   }
#if DEBUG
	   fprintf(stderr,"Diff H %f V %f\n",
		   X,Y);
#endif
#else
	   float X2=0.0, Y2=0.0;
	   Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1), &X, &Y);
	   /* subtract second interval position (if set):	    */
	   if (Get_Interval_Begin(2) != Get_Interval_End(2)) {
		  Get_EyePosition(Get_Interval_Begin(2), Get_Interval_End(2), &X2, &Y2);
		  X -= X2;
		  Y -= Y2;
		  }
#endif
	   /* add to sum, count if position is outside threshold:   */
	   if ( (X > Threshold) || (X < -Threshold) || 
		(Y < -Threshold) || (Y > Threshold) ) {
	       Sum_H_Eye[type]  += X;
	       Sum_V_Eye[type]  += Y;
	       Sum_EyeOut[type]++;
	   }

	   Count_Eye[type]++;

	   if (Stim_Bits[type] == FAIL) {
	       Stim_Bits[type] = bits;  /* set this type's bit value if we haven't already */
	   } else {
	       if (bits != Stim_Bits[type]) {
		   Exit("Stim bits not constant for a given class!",
	                "_macro/stimulate/printstim.c:Print_Stim121()");
	                 /* Could happen if we change class:bit lookup during run */
	       }
	   }

	   if (Stim_Period[type] == FAIL) {
	       Stim_Period[type] = period;  /* set this type's bit value if we haven't already */
	   } else {
	       if (period != Stim_Period[type]) {
		   Exit("Stim frequency not constant for a given class!",
	                "_macro/stimulate/printstim.c:Print_Stim121()");
	                 /* Could happen if we change class:freq lookup during run */
	       }
	    }
	}

	for (s=0; s<List_Length(STACK); s++) {
	  for (c=0; c<List_Length(CLASS); c++) {
	    int i = Get_StackClass_TrialType(
		List_Element(s,STACK), List_Element(c,CLASS));
	    if (i == FAIL)
	       continue;
	    fprintf(file, " %d.%d %d %d %d %d %d %d %6.2f %6.2f\n",
		UnitNumber_Header(),
		RunNumber_Header(),
		List_Element(s,STACK),
		List_Element(c,CLASS),
		Stim_Bits[i],
		Stim_Period[i],
		Sum_EyeOut[i],
		Count_Eye[i],
		Sum_H_Eye[i]/Sum_EyeOut[i], 
		Sum_V_Eye[i]/Sum_EyeOut[i]); 
	   }
	}
	fclose(file);
}

/* ********************************************************************	*/

