/* FILE _macros/stimulate/printbehav.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Generic macro: print EYE and ARM positions in specified interval,
	sorted by stack and class */
     /* File name: BehavMean_unit#.run#
      * For each type:
      *  stack class eye-h sem 		eye-v sem 
      *  	     start-target-h	start-target-v
      *  	     end-target-h	end-target-v
      *  	     #trials */

/* ********************************************************************	*/
/* ********************************************************************	*/

void Print_Behav120() {
	int Types   = Count_TrialTypes();
	int type;
	FILE *file;
   	char Name[80];
	int s,c;

	float Sum_H_Eye[MAX_TYPES];
	float Sum_V_Eye[MAX_TYPES];

	float Sum2_H_Eye[MAX_TYPES];
	float Sum2_V_Eye[MAX_TYPES];

	int Count_Eye[MAX_TYPES];

	int TargHStart[MAX_TYPES], TargVStart[MAX_TYPES];
	int TargHEnd[MAX_TYPES], TargVEnd[MAX_TYPES];

	for (type=0; type<Types; type++) {
	   Sum_H_Eye[type] =
	   Sum_V_Eye[type] =
	   Sum2_H_Eye[type] =
	   Sum2_V_Eye[type] = 0.0;
	   Count_Eye[type] = 0;
	   }

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "BehavMean_%d.%d",
		UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   float X,Y;
	   float X2=0.0, Y2=0.0;

	   int type = Get_TrialType();

	   Get_EyePosition(Get_Interval_Begin(1), Get_Interval_End(1), &X, &Y);

	   if (Get_Interval_Begin(2) != Get_Interval_End(2)) {
	      Get_EyePosition(Get_Interval_Begin(2),
	      		      Get_Interval_End(2), &X2, &Y2);
	      X -= X2;
	      Y -= Y2;
	      }

	   Sum_H_Eye[type]  += X;
	   Sum_V_Eye[type]  += Y;
	   Sum2_H_Eye[type] += X*X;
	   Sum2_V_Eye[type] += Y*Y;
	   Count_Eye[type]++;

	   TargHStart[type] = AnyTargetEventExtract(TWO, 1);
	   TargVStart[type] = AnyTargetEventExtract(THREE, 1);

	   TargHEnd[type] = AnyTargetEventExtract(TWO, 2);
	   TargVEnd[type] = AnyTargetEventExtract(THREE, 2);
	   }

	 for (s=0; s<List_Length(STACK); s++)
	  for (c=0; c<List_Length(CLASS); c++) {
	    int i = Get_StackClass_TrialType(
		List_Element(s,STACK), List_Element(c,CLASS));
	    if (i == FAIL)
	       continue;
	    fprintf(file, "%d %d %d %6.2f %6.2f %6.2f%6.2f %d %d %d %d %d\n",
		UnitNumber_Header(),
		List_Element(s,STACK),
		List_Element(c,CLASS),
		Sum_H_Eye[i]/Count_Eye[i], 
		SE( Sum_H_Eye[i], Sum2_H_Eye[i], Count_Eye[i]),
		Sum_V_Eye[i]/Count_Eye[i],
		SE( Sum_V_Eye[i], Sum2_V_Eye[i], Count_Eye[i]),
		TargHStart[i], TargVStart[i], TargHEnd[i], TargVEnd[i],
		Count_Eye[i]);
	    }
	fclose(file);
	}
/* ********************************************************************	*/
