/* FILE _macros/stimulate/movement_times.c */
     /* modelled on Macros 63 (modelled on 86), 64 */
/* ********************************************************************	*/

#include "../Deffs.h"
#include "../../event.h"
/* ********************************************************************	*/

/* FUNCTION Movement_Times123() */
void Movement_Times123() {
	FILE *file;
	char Name[80];
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 0;		/* Just find big ones	*/

	Rewind_InputFile();

	sprintf(Name, "Movements_%d.%d",
		UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Write_SacDurations86()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   /* int trial = TrialNumber_Header();		* Trial #	*/
	   int GoTime = Interval_To_Stack_Time(0);	/* 'Go' signal	*/

	   					/* Get sac start data 	*/
	   int sac_start = Get_Saccade_Time(1, 1, GoTime-50, 0);
	   float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	   float Start_V = SacPosition_V;
	   					/* Get sac end data 	*/
	   int sac_end = Get_Saccade_Time(0, 1, GoTime-50, 0);
	   float End_H = SacPosition_H;		/* Set by Get_Sac_Time	*/
	   float End_V = SacPosition_V;		/* Now set peakvel vars:*/
	   int peaktime;
	   	/* Unsed variable, but need call to set peak velocity	*/

	   if (sac_end != FAIL)
	      peaktime = Get_Saccade_Peak_Velocity(1, GoTime-50, 0);
	   else {
	      SacPeakVelocity_H = SacPeakVelocity_V = 0.;
	      sac_end = sac_start = FAIL + GoTime;
	      }


	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
							/* UNUSED by RW */
	       }	/* Problem: trial # ambiguous if run # changes	*/

	   fprintf(file, "%d %d %d %d %d %.2f %.2f %.2f %.2f %d\n",
		 TrialNumber_Input(),
		 UnitNumber_Header(),
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 sac_end - sac_start,			/* Sac duration	*/
		 End_H-Start_H,				/* Sac amplitude*/
		 End_V-Start_V,
		 SacPeakVelocity_H,			/* Sac velocity	*/
		 SacPeakVelocity_V,
		 sac_start - GoTime); 			/* Sac latency	*/
	}
	
	fclose(file);
	}
/* ********************************************************************	*/
