/* FILE _macros/stimulate/interval.c */
/* ********************************************************************	*/

/* based on _macros/interval.c */

#include "../Deffs.h"

/* ********************************************************************	*/
     /* Stack name: unit#.run#
      * First line:
      * unit run begin.time end.time begin2 end2 #.stacks #.classes #.trials
      * Then (for each class):
		 unit, stack, class, trialcount, then
		 	spikes/trial, padded with NA to some maximum.
     */

/* ********************************************************************	*/
#define PAD_TO_MAXIMUM	16		/* Always give this many trials	*/

void Interval127() {
	int Types   = Count_TrialTypes();
	int i;
	int j;
	FILE *file;
   	char Name[60];

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "Spikes_%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }
	for (i=0; i<Types; i++) {
	    int count = Get_Interval_Count(i,1);
	    int *data = Get_Interval_Data(i,1);
	    fprintf(file, "%d %d %d %3d %2d ",
   		UnitNumber_Header(),
		Get_TrialType_Info(i,STACK),
		Get_TrialType_Info(i,CLASS),
					/* would rather give Targ X, Targ Y	*/ 
		Get_Interval_Begin(1),		
					/* would rather change interval internally */
		count);


	    if (PAD_TO_MAXIMUM && count > PAD_TO_MAXIMUM) {
		fprintf(stderr, "Too many trials (%d); truncating to %d\n",
			count, PAD_TO_MAXIMUM);
	        count = PAD_TO_MAXIMUM;
		}
	
	    /* Now print spikes in interval for each trial	*/
	    for (j=0; j<count; j++)
	       fprintf(file, " %d", *(data+j));
	    if (PAD_TO_MAXIMUM)
	       while (j++ < PAD_TO_MAXIMUM)
	          fprintf(file, " NA");
		 
	    fprintf(file, "\n");
	    }

	fclose(file);
	}

/* ********************************************************************	*/
/* FUNCTION Print_Spikes128() */
void Print_Spikes128() {
	FILE *file;
   	char Name[80];

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "Spikes_%d.%d", UnitNumber_Header(), RunNumber_Header());
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "Write_OutputFiles0()");
      	   }

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   extern int Spikes_In_Interval(int interval);
	   fprintf(file, "%d %d %d %d %d %d %d\n",
		   TrialNumber_Input(),
		   UnitNumber_Header(),
		   StackNumber_Header() ,
		   TableNumber_Header() ,
		   Get_Interval_Begin(1),	    
		   /* Interval Length, in ms: */
		   Get_Interval_End(1) - Get_Interval_Begin(1),
		   Spikes_In_Interval(1)) ;
	   }
	fclose(file);
	}

/* ********************************************************************	*/
