/* FILE _macros/stimulate/getbestclass.c */
/* ********************************************************************	*/

#include "../Deffs.h"


#define	DEBUG	0

/* ********************************************************************	*/

static int FindNullClass(int oppclass, int Stack);
static int SearchClass(int stack, int class, int test);
static int Fine_Opposite_Class(int best, int stack);
/* ********************************************************************	*/

/* FUNCTION GetBestClass125() */
	 /* Write unit#, best and null class numbers to a stderr */
	 /* based on jeff's GetBestClass105() */
void GetBestClass125() {
	int BestDirection;
	int NullDirection = FAIL;
	int StackNumber[80];			/* Stacks of interest	*/
		/* Could just use List_Elements(STACK), but extra stacks
		   might be inadvertantly included */
	int StackCount;				/* # interesting stacks	*/
	int i;

	Rewind_InputFile();		/* For consistent unit,run#	*/

	for (i=0; i<List_Length(STACK); i++)	/* Get array of stack #s*/
	   StackNumber[i] = List_Element(i,STACK);
	StackCount = List_Length(STACK);	/* Count the stacks	*/

	/* Find best & null directions, & associated trial types */
	if (List_Length(CLASS) == 1)
	   BestDirection = List_Element(0,CLASS);
	 else
	   BestDirection = Find_Best_Direction_In_Averaged_Stacks(
	   					StackNumber, StackCount);
        if (BestDirection != FAIL) {
	    if (StackCount > 1)
	       Exit("Can only find null class with single stack!",
	       "_macro/stimulate/getbestclass.c:GetBestClass125()");
		/* Implementation for multiple stacks not coded yet */
	    else
		/* coding scheme depends on stack (8 or 16 directions)*/
	    NullDirection = FindNullClass(Fine_Opposite_Class(BestDirection,
					  StackNumber[0]),
					  StackNumber[0]);
	} else {
	    NullDirection = FAIL;
	}
	/* Old Output: "sUUU.R PREF NULL"			 */
	/* New Output: "UUU PREF NULL"	[12/14/03]		 */
        /* fprintf(stderr, "s%d.%d %d %d\n", UnitNumber_Header(),*/
	/*				 RunNumber_Header(),	 */
	/*				 BestDirection,		 */
	/*				 NullDirection);	 */
	fprintf(stderr, "%d %d %d\n", UnitNumber_Header(),
		        		 BestDirection,
					 NullDirection);
	}
/* ********************************************************************	*/

/* FUNCTION FindNullClass(oppclass,Stack) */
        /* search for an existing null class based on a seed direction */
static int FindNullClass(int oppclass, int Stack) {
    int NullDirection;		    
    int SEARCH_CASES = 5;
    int i;
    int testclass;
    int testtype;

    for (i=0;i<SEARCH_CASES;i++) {
	testclass = SearchClass(Stack, oppclass,i);
#if DEBUG
    fprintf(stderr,"testing class %d stack %d\n",testclass,Stack); 
#endif
	testtype = Get_StackClass_TrialType(Stack, testclass);
#if DEBUG
    fprintf(stderr,"Do we have %d ? %d\n",testclass,testtype); 
#endif
	if (testtype != FAIL) {             /* Does class exist? */
	    NullDirection = testclass;	    /* then we're done */
	    break;
	} else {
	    NullDirection = FAIL;	    /* not found */
	    continue;			    /* keep looking */
	}
    }
    return(NullDirection);
}
/* ********************************************************************	*/

/* FUNCTION SearchClass(class,test) */
        /* returns test class based on original class and search modifier*/
static int SearchClass(int stack, int class, int test) {
    int mod;
    if (stack == 1) {
	fprintf(stderr,"Warning: testing stack 1 (possible -ms)!\n"); 
	fprintf(stderr,
"You may encounter errors in _macro/stimulate/getbestclass.c:SearchClass()\n");
	}

   if ((stack >= 20) && (stack <=30)) {
    switch(test) {
	case 0: mod = 0; break;
	case 1: mod = 1; break;
	case 2: mod = -1; break;
	case 3: mod = 2; break;
	case 4: mod = -2; break;
	default: mod = FAIL;
    }
       return(1 + ((class+mod) % 16));
   } else {
    switch(test) {
	case 0: mod = 0; break;
	case 1: mod = 8; break;
	case 2: mod = 16; break;
	case 3: mod = 1; break;
	case 4: mod = -1; break;
	default: mod = FAIL;
    }
       return(1 + ((class+mod) % 8));
   }

}
    
int Fine_Opposite_Class(int best, int stack) {
       if ((stack >= 20) && (stack <= 30)) {
       return(1 + ((best+7) % 16));
       } else { 
       return(1 + ((best+3) % 8));
       }
   }
