/* FILE _macros/basic.c */

#include "../Deffs.h"
#include "../../event.h"

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION RewardBasics30 */
	 /* unit run trial choice history targ-h targ-v rwd	*/
void RewardBasics30() {
	FILE *file;
	char Name[80];

	Rewind_InputFile();		/* For consistent unit,run#	*/
	sprintf(Name, "RR%d.%d", UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file == NULL) {
	   fprintf(stderr, "Err opening %s\n", Name);
	   Exit("", "RewardBasics30");
	   }
	
	fprintf(file, "unit run trial choice history targ-h targ-v reward\n");


	while (Read_Next_Trial(WITH_DATA)) {
	   int history = EventExtract(RUNTIME_MACRO, TWO, 1);
	   int reward = EventExtract(REWARD, THREE, 1);

	   if (reward == FAIL)
	       reward = 0;

	   fprintf(file, "%4d %3d %5d     %2d %3d     %3.0f %3.0f    %3d\n",
		   UnitNumber_Header() ,
		   RunNumber_Header() ,
		   TrialNumber_Header(),
		   (reward==0) ? -1 : (history > 0),
		   (reward==0) ?  0 :  history,
		   rint(EventExtract(TARGET_RE_0_POLAR, TWO,   2+(history<0))/10.),
		   rint(EventExtract(TARGET_RE_0_POLAR, THREE, 2+(history<0))/10.),
		   -reward);
	   }
	fclose(file);
	}
/* ********************************************************************	*/
