/* FILE _macros/basic.c */

#include "../Deffs.h"
#include "../../deffs.h"
#include "../../event.h"

/* FUNCTIONS *
   RewardBasics30()
   CodeByPrevAndCurrentClass31()
   */

/* ********************************************************************	*/
/* ********************************************************************	*/

extern int RunStatus_Header();

/* FUNCTION RewardBasics30 */
	 /* unit run trial choice history targ-h targ-v rwd	*/
void RewardBasics30() {
	FILE *file;
	char Name[80];

	Rewind_InputFile();		/* For consistent unit,run#	*/
	sprintf(Name, "RR%d.%d", UnitNumber_Header(), RunNumber_Header());
	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file == NULL) {
	   fprintf(stderr, "Err opening %s\n", Name);
	   Exit("", "RewardBasics30");
	   }
	
	fprintf(file, "unit run trial targ2angle targ2ecc targ3angle targ3ecc meanreward target reward stack block target_soa class\n");

	while (Read_Next_Trial(SKIP_DATA)) {
	//   fprintf(stderr, "status = %d\n", RunStatus_Header()); int reward = 1;  
	int block = -1;
	int meanreward = -1;
	int target = -1;
	int reward = -1;
	int targ2angle = -1;
	int targ3angle = -1;
	int targ2ecc = -1;
	int targ3ecc = -1;
	int target_soa = -1; /* which target chosen in the SOA task */

	meanreward = EventExtract(RUNTIME_MACRO, THREE, 2); //in the eqrewAndSOA task, parameters are written in the second macro; the earlier tasks (reward, eqrew, randrew) write parameters to the first macro
   	target = EventExtract(RUNTIME_MACRO, TWO, 2);
   	block = EventExtract(RUNTIME_MACRO, ONE, 2);

   	target_soa = EventExtract(ACQUIRE, TWO, 4);
   	//target_soa = 1;
	
	if (RunStatus_Header() == START_ERR) {
	   reward = 1; /* no start error */
	}
	else
	{
	   if (target > 0) {
	   	targ2angle = rint(EventExtract(TARGET_RE_2_POLAR, THREE, 1)/10.);
	   	targ3angle = rint(EventExtract(TARGET_RE_2_POLAR, THREE, 2)/10.);
	   	targ2ecc = rint(EventExtract(TARGET_RE_2_POLAR, TWO, 1)/10.);
	   	targ3ecc = rint(EventExtract(TARGET_RE_2_POLAR, TWO, 2)/10.);
        	}
	   else
	   {
	  	targ2angle = -1;
	   	targ3angle = -1;
	   	targ2ecc = -1;
	   	targ3ecc = -1;
        	}

		reward = EventExtract(REWARD, THREE, 1); /* reward saved as negative */
		if (reward == FAIL) reward = 0; /* error after no start (not accurate reach/saccade) */
	}

	   fprintf(file, "%4d %3d %3d %5d %1d %3d %3d %3d %3d %3d %3d %3d %1d %2d\n",
		   UnitNumber_Header(),
		   RunNumber_Header(),
		   TrialNumber_Header(),
		   targ2angle,
		   targ2ecc,
		   targ3angle,
		   targ3ecc,
		   meanreward,
		   target,
		   -reward,
		   StackNumber_Header(),
		   block,
		   target_soa,
		   TableNumber_Header() );

	   		
	   }
	fclose(file);
	}
/* ********************************************************************	*/
static int prev_trialnumber = 0;
static int prev_class = 0;

/* FUNCTION CodeByPrevAndCurrentClass31()  */
	 /* CALL ONLY WITH "-w" -- AND DO NOT CALL WITH MULTIPLE FILES	*/
void CodeByPrevAndCurrentClass31() {
	int class = TableNumber_Header();

	if (TrialNumber_Header() == prev_trialnumber + 1)
	    Set_ClassNumber_Header(class + prev_class * 100);
	prev_trialnumber = TrialNumber_Header();
	prev_class = class;
	}
/* ********************************************************************	*/
