/* FILE write_sac.c */
     /* Macros 110, 111 */
/* ********************************************************************	*/

#define START_CRITERION	5.	/* Fixation window at sac start time	*/

#include "../Deffs.h"
#include "../../event.h"
#include <string.h>
/* ********************************************************************	*/
static void Write_SacEndpts110_or_111(int macro);

/* FUNCTION Write_SacEndpts110 */
void Write_SacEndpts110() {
   Write_SacEndpts110_or_111(110);
   }
void Write_SacEndpts111() {
   Write_SacEndpts110_or_111(111);
   }
void Write_SacEndpts1110() {
   Write_SacEndpts110_or_111(1110);
   }
/* ********************************************************************	*/

static void Write_SacEndpts110_or_111(int macro) {
	FILE *file;
	char Name[80];
	int begin = Get_Interval_Begin(1);
	int end = Get_Interval_End(1);
	int  RunNumber;		/* Run number may change	*/
	int  SequentialRun = 0;	/* Count runs, chg TrialNumber to reflect */
	int  Delete = Get_dataValue_From_CmdLine();
	int  DeleteCount = 0;
	extern int Get_AlignTime();
	int  Relative = macro > 500;
	float Relative_h, Relative_v;

	macro = macro%1000;

	Rewind_InputFile();
	sprintf(Name, "SacMeans.s%d.%d.out",
				UnitNumber_Header(), RunNumber_Header());
	if (macro==111) {
	   char ARM[] = ".arm";
	   strcat(Name, ARM);
	   }

	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
	if (file==NULL) {
		fprintf(stderr, "Err opening %s", Name);
		Exit("", "Write_SacEndpts()");
		}

	Read_Next_Trial(SKIP_DATA);		/* Get 1st header	*/
	RunNumber = RunNumber_Header();		/* Same thru-out file?	*/
	Rewind_InputFile();			/* Back to start	*/

	while (Read_Next_Trial(WITH_DATA)) {
	   int trial = TrialNumber_Header();		/* Trial #	*/
	   float h,v;	
	   int TargStartH, TargStartV;

	   if (RunNumber != RunNumber_Header()) {	/* New run??	*/
	       RunNumber =  RunNumber_Header();		/* Remember it	*/
	       SequentialRun++;				/* And tally it	*/
	       }	/* Problem: trial # ambiguous if run # changes	*/

	   TargStartH = EventExtract(TARGET_ON, TWO, 1);
	   if (TargStartH == -9999)
	       TargStartH = TargStartV = 0;
	    else
	       TargStartV = EventExtract(TARGET_ON, THREE, 1);

	   /* Check for premature saccades.  Usually aren't accepted by
	    * reach, but if they are, let's root them out. */
	   if (macro==111)		/* Get start eye or arm posit	*/
	      Get_ArmPosition(-250, -150, &h, &v);
	   else if (macro==110)
	      Get_EyePosition(-250, -150, &h, &v);

	   Relative_h = h;		/* Save for later		*/
	   Relative_v = v;

	   if ((fabs(h - TargStartH/10) > START_CRITERION) ||
	       (fabs(v - TargStartV/10) > START_CRITERION)) {
	     if (Delete) {
	         DeleteCount++;
		 goto NEXT;
	      } else
             fprintf(stderr, 
	       "%d: Premature movement, trial %d (%.0f x %0.f from fixation)\n\
	       Delete by re-running with '-d1' on the commandline\n",
	        TrialNumber_Input(), trial,
		fabs(h - TargStartH/10), fabs(v-TargStartV/10));
	     }
	   /* End of check.  Will overwrite h & v	*/

	   /* Check for premature acquires */
	   if (Get_AlignTime()-EventExtract(ACQUIRE,TIME,LAST_OCCURRENCE)>100) {
	     if (Delete) {
	         DeleteCount++;
		 goto NEXT;
	      } else
             fprintf(stderr, 
	       "%d: Premature acquire, trial %d (%d ms)\n\
	       Delete by re-running with '-d1' on the commandline\n",
	        TrialNumber_Input(), trial,
	        Get_AlignTime()-EventExtract(ACQUIRE,TIME,LAST_OCCURRENCE));
	     }
	   /* End of check.  */

	   if (macro==111)
	      Get_ArmPosition(begin, end, &h, &v);
	   else
	      Get_EyePosition(begin, end, &h, &v);

	   if (Relative) {	/* Look at change in eye pos, not abs end */
	      h = h - Relative_h;
	      v = v - Relative_v;
	      }

	   h -= TargStartH/10.;		/* Adjust for starting	*/
	   v -= TargStartV/10.;		/*  location		*/


	   fprintf(file, "%d %d %d %.2f %.2f ",
		 trial + SequentialRun * 10000,	/* Make trial# unambig	*/
	   	 StackNumber_Header(),
		 TableNumber_Header(),
		 h,v);

	   {
	   int event = TARGET_ON_POLAR;		/* Target event		*/
	   int occur = 1;			/* Which occurence #?	*/

	   if (EventExtract(TARGET_ON_POLAR,TWO,1) == FAIL) {
	      if (EventExtract(TARGET_RE_1,TWO,1) != FAIL)
	         event = TARGET_RE_1;
 	       else if (EventExtract(TARGET_ON,TWO,2) != FAIL) {
	         event = TARGET_ON;
		 occur = 2;
	       } else
	         fprintf(stderr, "Can't find target location!\n");
	      }
	   fprintf(file, "%.1f %.1f",
		 (EventExtract(event,TWO,occur)-TargStartH)/10.,
		 (EventExtract(event,THREE,occur)-TargStartV)/10.);
	   }

	   if (EventExtract(TARGET_BLANK,TIME,2) == FAIL)
	      fprintf(file, " %d",	/* Fixation off minus cue off	*/
		 EventExtract(TARGET_OFF, TIME, 1) -	/* 1st targ off	*/
		 EventExtract(TARGET_BLANK, TIME, 1));	/* 1st t blank'd*/
	     else
	      fprintf(file, " %d",	/* Fixation blank minus cue off	*/
		 EventExtract(TARGET_BLANK, TIME, 2) -	/* 1st tg blank	*/
		 EventExtract(TARGET_BLANK, TIME, 1));	/* 2nd blank	*/

	NEXT:
	   fprintf(file, "\n");		/* Blank line to indicate deleted*/
	   }
	
	if (Delete & DeleteCount)
	   fprintf(stderr, "Deleted %d trials - premature move or acquire\n",
	   	DeleteCount);
	fclose(file);
	}
/* ********************************************************************	*/
