/* FILE _macros/write_times.c */

#include "../../deffs.h"
#include "../Deffs.h"
#define int short
#include "../../head.h" /* Direct access to header for time-stamps	*/
#undef int
#include "../../event.h"

/* FUNCTIONS:
   Write_Times400	Start times of each trial
   Write_Times_tpj401	Times of trial start, sync pulses, button presses
   CueTarg_Times405	Cue & targ times, re: start of run
   Targ_Times_tpj406	event file w/ targ time, targ type, targ dur
   MR_Event_File408	generic eventfile generator, returns:
   	RunStart
	FirstSyncPulse
	LastSyncPulse
   	trialstart(abs)  targettime(abs)  stacknumber  tablenumber  targetnumber  targetdisplaytime(.3f) trialnumber  s_or_f
   PSEvents_409		Like 408, but records target and eye positions
 */
/* ********************************************************************	*/

/* FUNCTION Write_Times400 */
        /*writes times of trial starts, sync pulses, button presses*/
void Write_Times400() {

     char syncpulse_name[80], trial_name[80], rt_name[80];
     char trial_status[80];
     FILE *trials, *syncpulses, *reactiontimes;
     int RunStart;                 /*In ms */
     int PulseStart;               /*In ms */
	     
  if (RunStatus_Header() == -2)
      sprintf(trial_status, "s");
  else
      sprintf(trial_status, "f");

  sprintf(syncpulse_name, "syncpulsetimes.%s%d.%d",
          trial_status, UnitNumber_Header(), RunNumber_Header());

  sprintf(rt_name, "reactiontimes.%s%d.%d",
          trial_status, UnitNumber_Header(), RunNumber_Header());

  sprintf(trial_name, "trialtimes.%s%d.%d",
          trial_status, UnitNumber_Header(), RunNumber_Header());
  
  trials = fopen(trial_name, "w");
  syncpulses = fopen(syncpulse_name, "w");
  reactiontimes = fopen(rt_name, "w");

  if (trials == NULL || syncpulses == NULL || reactiontimes == NULL)
    Exit ("File TrialTrimes or SyncPulseTimes or ReactionTimes could not be opened", "WriteTimes");

  Rewind_InputFile();
  
  Read_Next_Trial(WITH_DATA);                                   /* Get 1st trial*/
  RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60
                + h.time.second) + h.time_hsecond * 10;
                        /* Hundredths times ten */
  PulseStart = Get_Button_Time(OFF, 1, 1, 0, 0);        /*1st sync pulse*/

  /* fprintf(trials, "First pulse: %d\nTrials:\n", PulseStart);
                took out to make line cnt = trials cnt */

  do {
      int occur = 1;
      int time;
      int releasetime;
      int acquiretime;
      
      int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 + h.time.second) + 10*h.time_hsecond;
	     /* I believe that this isn't necessary.  It's basically SkipAnalogTime(),
	      *    and that's already taken into account when you get button times */
                     /*  + EventExtract(TAPE_ON, TIME, 1); */
			     
      fprintf(trials, "%d\n",
          1000 * (h.time.hour * 3600 + h.time.minute * 60 + h.time.second) + h.time_hsecond * 10 - RunStart);

       do {
         time = Get_Button_Time(OFF,1,occur++,0,0);
         if (time != 0 && time != FAIL)
            fprintf(syncpulses, "%7d %8d\n", time,time+TrialStart-RunStart-PulseStart);
       } while (time != FAIL);
       
       if (StackNumber_Header() == 200) {
	  int TargThree = TargetEventExtract(3, TIME, 1);
	  int TargTwo = TargetEventExtract(2, TIME, 1);
	  releasetime = Get_Button_Time(ON,36,1,0,0);
	  if (releasetime != 0 && releasetime != FAIL)
	     fprintf(reactiontimes, "%.3f %3f 0 %3f", TargTwo/1000., TargThree/1000., (releasetime-TargThree)/1000.);
       }

       if (StackNumber_Header() == 202) {
	  int TargThree = TargetEventExtract(3, TIME, 1);
	  int TargTwo = TargetEventExtract(2, TIME, 1);
	  acquiretime = WindowAcquireEventExtract(TIME, 2);
	  if (acquiretime != 0 && acquiretime != FAIL)
	     fprintf(reactiontimes, "%3f %3f 2 %3f", TargTwo/1000., TargThree/1000., (acquiretime-TargThree)/1000.);
       }
   } while (Read_Next_Trial(WITH_DATA));

  fclose(reactiontimes);
  fclose(trials);
  fclose(syncpulses);
}

	 
/* ********************************************************************	*/
/* FUNCTION Write_Times_tpj401 */
        /*writes times of trial starts, sync pulses, button presses*/
void Write_Times_tpj401() {

  char syncpulse_name[80], trial_name[80], button_name[80];
  char trial_status[80];
  FILE *trials, *syncpulses, *buttons;
  int RunStart;                 /*In ms */
  int PulseStart;               /*In ms */

  if (RunStatus_Header() == -2)
     sprintf(trial_status, "s");
  else
     sprintf(trial_status, "f");

  sprintf(syncpulse_name, "syncpulsetimes.%s%d.%d",
          trial_status, UnitNumber_Header(), RunNumber_Header());

   sprintf(button_name, "buttons.%s%d.%d",
             trial_status, UnitNumber_Header(), RunNumber_Header());

  sprintf(trial_name, "trialtimes.%s%d.%d",
        trial_status, UnitNumber_Header(), RunNumber_Header());

  trials = fopen(trial_name, "w");
  syncpulses = fopen(syncpulse_name, "w");
  buttons = fopen(button_name, "w");

  if (trials == NULL || syncpulses == NULL || buttons == NULL)
    Exit ("File TrialTrimes or SyncPulseTimes or Buttons could not be opened", "WriteTimes");

  Rewind_InputFile();

  Read_Next_Trial(WITH_DATA);                                   /* Get 1st trial*/
  RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60
                + h.time.second) + h.time_hsecond * 10;
                        /* Hundredths times ten */
  PulseStart = Get_Button_Time(OFF, 1, 1, 0, 0);        /*1st sync pulse*/

  /* fprintf(trials, "First pulse: %d\nTrials:\n", PulseStart);
                took out to make line cnt = trials cnt */
  do {
      int occur = 1;
      int time;
      int btime;

      int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 + h.time.second) + 10*h.time_hsecond;
/* I believe that this isn't necessary.  It's basically SkipAnalogTime(),
   and that's already taken into account when you get button times */
                 /*  + EventExtract(TAPE_ON, TIME, 1); */


      fprintf(trials, "%d\n",
          1000 * (h.time.hour * 3600 + h.time.minute * 60 + h.time.second) + h.time_hsecond * 10 - RunStart);

       do {
         time = Get_Button_Time(OFF,1,occur++,0,0);
         if (time != 0 && time != FAIL)
            fprintf(syncpulses, "%7d %8d %8d\n", time,time+TrialStart-RunStart-PulseStart, (time+TrialStart-RunStart-PulseStart)/2500);
       } while (time != FAIL);

//       do {
          btime = Get_Button_Time(ON,2,1,0,0);
          if (btime != 0 && btime != FAIL)
            fprintf(buttons, "2 %7d %8d\n", btime,btime+TrialStart-RunStart-PulseStart);
//       } while (btime != FAIL);

//       do {
          btime = Get_Button_Time(ON,4,1,0,0);
          if (btime != 0 && btime != FAIL)
            fprintf(buttons, "4 %7d %8d\n", btime,btime+TrialStart-RunStart-PulseStart);
//       } while (btime != FAIL);

   } while (Read_Next_Trial(WITH_DATA));

  fclose(buttons);
  fclose(trials);
  fclose(syncpulses);
}

/* ******************************************************************** */
/* Syncpulses, trial times, and buttons for monkey fMR (tr=2000) */
/* FUNCTION Write_Times_monk402 */
void Write_Times_monk402() {

  char syncpulse_name[80], trial_name[80], button_name[80];
  char trial_status[80];
  FILE *trials, *syncpulses, *buttons;
  int RunStart;                 /*In ms */
  int PulseStart;               /*In ms */

  if (RunStatus_Header() == -2)
     sprintf(trial_status, "s");
  else
     sprintf(trial_status, "f");

  sprintf(syncpulse_name, "syncpulsetimes.%s%d.%d",
          trial_status, UnitNumber_Header(), RunNumber_Header());

   sprintf(button_name, "buttons.%s%d.%d",
             trial_status, UnitNumber_Header(), RunNumber_Header());

  sprintf(trial_name, "trialtimes.%s%d.%d",
        trial_status, UnitNumber_Header(), RunNumber_Header());

  trials = fopen(trial_name, "w");
  syncpulses = fopen(syncpulse_name, "w");
  buttons = fopen(button_name, "w");

  if (trials == NULL || syncpulses == NULL || buttons == NULL)
    Exit ("File TrialTrimes or SyncPulseTimes or Buttons could not be opened", "WriteTimes");

  Rewind_InputFile();

  Read_Next_Trial(WITH_DATA);                                   /* Get 1st trial*/
  RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60
                + h.time.second) + h.time_hsecond * 10;
                        /* Hundredths times ten */
  PulseStart = Get_Button_Time(OFF, 1, 1, 0, 0);        /*1st sync pulse*/

  /* fprintf(trials, "First pulse: %d\nTrials:\n", PulseStart);
                took out to make line cnt = trials cnt */
  do {
      int occur = 1;
      int time;
      int btime;

      int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 + h.time.second) + 10*h.time_hsecond;
/* I believe that this isn't necessary.  It's basically SkipAnalogTime(),
   and that's already taken into account when you get button times */
                 /*  + EventExtract(TAPE_ON, TIME, 1); */

      fprintf(trials, "%d\n",
          1000 * (h.time.hour * 3600 + h.time.minute * 60 + h.time.second) + h.time_hsecond * 10 - RunStart);

       do {
         time = Get_Button_Time(OFF,1,occur++,0,0);
         if (time != 0 && time != FAIL)
            fprintf(syncpulses, "%7d %8d %8d\n", time,time+TrialStart-RunStart-PulseStart, (time+TrialStart-RunStart-PulseStart)/2000);
       } while (time != FAIL);

//       do {
          btime = Get_Button_Time(ON,2,1,0,0);
          if (btime != 0 && btime != FAIL)
            fprintf(buttons, "2 %7d %8d\n", btime,btime+TrialStart-RunStart-PulseStart);
//       } while (btime != FAIL);

//       do {
          btime = Get_Button_Time(ON,4,1,0,0);
          if (btime != 0 && btime != FAIL)
            fprintf(buttons, "4 %7d %8d\n", btime,btime+TrialStart-RunStart-PulseStart);
//       } while (btime != FAIL);

   } while (Read_Next_Trial(WITH_DATA));

  fclose(buttons);
  fclose(trials);
  fclose(syncpulses);
}

/* ******************************************************************** */
/* Times (re: start of run) of cue & target in cue-targ trials	*/
/* FUNCTION CueTarg_Times405 */
void CueTarg_Times405() {
	FILE *within, *between;
	char within_name[80], between_name[80];
	char trial_status[80];
	int RunStart;

	if (RunStatus_Header() == -2) 
           sprintf(trial_status, "s");
	  else 
	   sprintf(trial_status, "f");
	  
	
	sprintf(within_name, "within.%s%d.%d", 
		trial_status, UnitNumber_Header(), RunNumber_Header());

	sprintf(between_name, "between.%s%d.%d", 
		trial_status, UnitNumber_Header(), RunNumber_Header());
	
	within = fopen(within_name, "w");
	between = fopen(between_name, "w");
  
	if (within == NULL)
		Exit ("File within.event_file could not be opened", 
			"CueTarg_Times405");
	if (between == NULL)
		Exit ("File between.event_file could not be opened", 
			"CueTarg_Times405");

	Rewind_InputFile();
	Read_Next_Trial(WITH_DATA);	/* Get first trial	*/

  /* Get start time of file */
  	RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60 
		+ h.time.second) + h.time_hsecond * 10;		
			/* Hundredths times ten	*/
  	RunStart += Get_Button_Time(OFF, 1, 1, 0, 0);	/*1st sync pulse*/
	/* Bit 1 off: 1st occur after -30 s of TAPE_ON (init = 0)	*/


	if (EventExtract(RESTART, TIME, 1) != FAIL) 
		{		 /* Resets int.c time!	*/
		fprintf(stderr,  
		"RESTART in stack -> times are wrong\n");
		fprintf(within,  
		"RESTART in stack -> times are wrong\n");
     		fprintf(between, 
		"RESTART in stack -> times are wrong\n");
     		}

  	do {
     	int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 + 
     	h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
							/* modify so have ms */
     	int TargTwo   = TargetEventExtract(2, TIME, 1);
     	int TargThree = TargetEventExtract(3, TIME, 1);

     	int cuetime  = TargetOffEventExtract(2, TIME, 1) - TargTwo;
     	int targtime = TargetOffEventExtract(3, TIME, 1) - TargThree;
     	int targ_code = -1;
	int cue_code = -1;

#    ifdef EXAMPLES
#      define Frame(time) Get_Button_Time(OFF,1,1,time-1000,0)
/*	TrialStart - RunStart	 Start of trial (ms) re: run	*/
/*	TargTwo			 Cue (ms re: start)		*/
/*	TargThree		Target (ms re: start) 		*/	
/*	Frame(TargThree)	  MR frame after targ (ms)	*/
#    endif


	if (StackNumber_Header() % 2) {	
				/* Odd stack#: cue-only trial	*/
    	fprintf(within, "%.3f %d %.3f\n",
		(TrialStart - RunStart + TargTwo)/1000.,
		(StackNumber_Header()==201) ? 0:1,
		cuetime/1000.); /*  cue arm/eye re: run */
    	fprintf(between, "%.3f %d %.3f\n",
		(TrialStart - RunStart + TargTwo)/1000.,
		(StackNumber_Header()==201) ? 0:1,
		cuetime/1000.);  /* cue arm/eye re: run */
	} else {
	if (StackNumber_Header() == 200 && TableNumber_Header() <= 3)
	{
	   	targ_code = 2;
		cue_code = 0;
	}
	else if (StackNumber_Header() == 200 && TableNumber_Header() >3)
	{
		targ_code = 3;
		cue_code = 0;
	}
	else if (StackNumber_Header() == 202 && TableNumber_Header() <=3)
	{
		targ_code = 4;
		cue_code = 1;
	}
	else if (StackNumber_Header() == 202 && TableNumber_Header() > 3)
	{
	 	targ_code = 5;
		cue_code = 1;
	}
	
	fprintf(within, "%.3f %d %.3f\n%.3f %d %.3f\n",
		(TrialStart - RunStart + TargTwo) / 1000.0,  /* cue re: run */
		cue_code,
		cuetime/1000.,
		(TrialStart - RunStart + TargThree)/1000.0,  /*target re: run*/
		targ_code,
		targtime/1000.);

	fprintf(between, "%.3f %d %.3f\n",
		(TrialStart - RunStart + TargTwo) / 1000.0,  /* cue re: run */
		targ_code,
		cuetime/1000.);
	}
   } while (Read_Next_Trial(WITH_DATA));

fclose(within);
fclose(between);
}
/* ********************************************************************	*/

/* Times (re: start of run) of target in targ trials    */
/* FUNCTION Targ_Times_tpj406 */
void Targ_Times_tpj406() {
        FILE *event;
        char event_name[80];
        char trial_status[80];
        int RunStart;

        if (RunStatus_Header() == -2)
           sprintf(trial_status, "s");
        else
           sprintf(trial_status, "f");


        sprintf(event_name, "event.%s%d.%d",
                trial_status, UnitNumber_Header(), RunNumber_Header());

        event = fopen(event_name, "w");

        if (event == NULL)
                Exit ("Event file could not be opened",
                        "Targ_Times_tpj406");

        Rewind_InputFile();
        Read_Next_Trial(WITH_DATA);     /* Get first trial      */

  /* Get start time of file */
        RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60
                + h.time.second) + h.time_hsecond * 10;
                        /* Hundredths times ten */
        RunStart += Get_Button_Time(OFF, 1, 1, 0, 0);   /*1st sync pulse*/
        /* Bit 1 off: 1st occur after -30 s of TAPE_ON (init = 0)       */


        if (EventExtract(RESTART, TIME, 1) != FAIL)
                {                /* Resets int.c time!  */
                fprintf(stderr,
                "RESTART in stack -> times are wrong\n");
                fprintf(event,
                "RESTART in stack -> times are wrong\n");
                }

        do {
        int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
        h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
                                                        /* modify so have ms */
        int Targ   = TargetEventExtract(2, TIME, 1);

        int targtime  = TargetOffEventExtract(2, TIME, 1) - Targ;

	int buttontype;
	if (Get_Button_Time(ON,2,1,0,0) != FAIL)
	   buttontype=2;
	else if (Get_Button_Time(ON,4,1,0,0) != FAIL)
	   buttontype=4;
	else 
	   buttontype=0;
	
	if (StackNumber_Header() > 100)
	{
        	fprintf(event, "%d %d %.3f %d \n",
                	(TrialStart - RunStart + Targ)/2500,
                	StackNumber_Header()           	/*110-160=l, 210-260=r*/
                	+ TableNumber_Header(),         /*1-6 for shape/color combos*/
                	targtime/1000., 		/*  cue arm/eye re: run */
			buttontype);  			/* 2=targ 4=notarg 0=nobutt*/
        }
	if (StackNumber_Header() < 100)
	{
	   	fprintf(event, "%d %d %.3f %d \n",
		      (TrialStart - RunStart + Targ)/2500,
		      (StackNumber_Header()*10)            /*all center targets*/
		      + TableNumber_Header(),         /*1-6 for shape/color combos*/
		      targtime/1000.,                 /*  cue arm/eye re: run */
		      buttontype);                    /* 2=targ 4=notarg 0=nobutt*/
	}
  } while (Read_Next_Trial(WITH_DATA));

fclose(event);
}
/* ******************************************************************** */

/* Times (re: start of run) of target in targ trials    */
/* FUNCTION Targ_Times_monk407 */
void Targ_Times_monk407() {
        FILE *event;
        FILE *timing;
	char event_name[80];
        char trial_status[80];
        char timing_name[80];
	int RunStart;
//	int SyncTime;
	
        if (RunStatus_Header() == -2)
           sprintf(trial_status, "s");
        else
           sprintf(trial_status, "f");

        sprintf(event_name, "event.%s%d.%d",
                trial_status, UnitNumber_Header(), RunNumber_Header());
	sprintf(timing_name, "timing.%s%d.%d",
		trial_status, UnitNumber_Header(), RunNumber_Header());
	
	
        event = fopen(event_name, "w");
	timing = fopen(timing_name, "w");

        if (event == NULL)
            Exit ("Event file could not be opened", "Targ_Times_monk407"); 
	if (timing == NULL)
            Exit ("Timing file could not be opened", "Targ_Times_monk407");
	
        Rewind_InputFile();
        Read_Next_Trial(WITH_DATA);     /* Get first trial      */

	
  	/* Get start time of file */
        RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60 +
            h.time.second) + h.time_hsecond * 10; /* Hundredths times ten */

	/* Get first sync pulse (bit 1 off)			*/
//	while ((SyncTime=Get_Button_Time(OFF, 1, 1, 0, 0)) == FAIL) 
//          if (Read_Next_Trial(WITH_DATA) == 0)
//	  {
//	     fclose(event);
//	     fclose(timing);
//	     return;   	/* Get next trial	*/
//	  }
	
	
//        if (SyncTime == FAIL)
//           fprintf(stderr, "Can't find first sync pulse--Targ_Times_monk407\n");
        if (EventExtract(RESTART, TIME, 1) != FAIL)
           fprintf(stderr, "RESTART in stack: times are wrong--Targ_Times_monk407\n");

	
//	RunStart += SyncTime;                   /* Add to start time    */
	
        Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) 
	{
          int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
          h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
                                                        /* modify so have ms */
          int Targ   = TargetEventExtract(0, TIME, 1);

          int targtime  = TargetOffEventExtract(0, TIME, 1) - Targ;

   
          fprintf(event, "%.3f %d %.3f \n",
		(TrialStart - RunStart + Targ)/1000.,
                TableNumber_Header(),         /*0-8 for each direction*/
                targtime/1000.); 		/* length of time target is on screen */
	  fprintf(timing, "%3f %3f %3f %3f \n",
		 TrialStart/1000.,
		 RunStart/1000.,
		 Targ/1000.,
		 (TrialStart - RunStart + Targ)/1000.);
	}

fclose(event);
fclose(timing);
}
/* ******************************************************************** */

/* MR Event File generator; abs times */

/* outputs:  trialstart(abs)  targettime(abs)  stacknumber  tablenumber  targetnumber  targetdisplaytime(.3f) trialnumber  s_or_f */

/* FUNCTION MR_Event_File408 */
void MR_Event_File408() {
        FILE *event;
	char event_name[80];
        char trial_status[80];
	int RunStart;
	int SyncTime;
	int pulse;
	int LastSyncTime;
	int LastGoodSyncTime;
	int SyncTrialTime;
	
        if (RunStatus_Header() == -2)
           sprintf(trial_status, "s");
        else
           sprintf(trial_status, "f");

        sprintf(event_name, "event.%s%d.%d",
                trial_status, UnitNumber_Header(), RunNumber_Header());
		
        event = fopen(event_name, "w");

        if (event == NULL)
            Exit ("Event file could not be opened", "Event_File_Abs_Time408"); 
	
        Rewind_InputFile();
        Read_Next_Trial(WITH_DATA);     /* Get first trial      */

  	/* Get start time of file */
        RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60 +
            h.time.second) + h.time_hsecond * 10; /* Hundredths times ten */

	/* Get first sync pulse (bit 1 off)			*/
	while ((SyncTrialTime=Get_Button_Time(OFF, 1, 1, 0, 0)) == FAIL)
	{
          	if (Read_Next_Trial(WITH_DATA) == 0)
	  	{
	     		return;   	/* Get next trial	*/
	  	}
	}

        if (SyncTrialTime == FAIL)
           fprintf(stderr, "Can't find first sync pulse--Event_File_Abs_Time408");
        if (EventExtract(RESTART, TIME, 1) != FAIL)
           fprintf(stderr, "RESTART in stack: times are wrong--Event_File_Abs_Time408");

	int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
	   h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
	
	SyncTime=SyncTrialTime+TrialStart;

	/*Get last sync pulse (bit 1 off)*/
	LastGoodSyncTime=-9999;
	
	do
	{
	  	pulse = 1;
		TrialStart=1000*(h.time.hour*3600 + h.time.minute*60 +
	             h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
		while ((LastSyncTime=Get_Button_Time(OFF, 1, pulse, 0, 0)) != FAIL)
			{
		        pulse++;
			LastGoodSyncTime = LastSyncTime+TrialStart;
			}
	}
	while (Read_Next_Trial(WITH_DATA) != 0);
	
	/*Print start of run, 1st pulse, and last pulse times*/	
	fprintf(event, "%d RunStart %s\n%d FirstSyncPulse %d %s\n%d LastSyncPulse %d %s\n",
	                       RunStart,              /*beginning of run, abs. time*/
			       trial_status,
			       SyncTime,   /*abs time of first recorded sync pulse*/
			       SyncTime-RunStart,
			       trial_status,
			       LastGoodSyncTime,
			       LastGoodSyncTime-RunStart,
			       trial_status);

	/*start looping through trials and writing event times and types*/   
        Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) 
	{
          TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
          h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
                                                        /* modify so have ms */

	  int TargOnTime;
	  int TargOffTime;
	  int TTLOnTime;
	  int TTLOffTime;
	  
	  char eventtype[80];
	  char rewardname[80];
	  
//	  int targnum=1;	/*the code for which tpye of event*/
//	  int targoffnum=2;
//	  int buttonnum=3;
	 
	  /*target on times*/
	  int marker=1;
	  while ((TargOnTime=AnyTargetEventExtract(TIME, marker)) != FAIL)
	  {
		sprintf(eventtype, "TargOn");
          	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
			TrialStart,			/*time of trial start*/
			(TargOnTime+TrialStart),		/*time of targ*/
        	       	StackNumber_Header(),
			TableNumber_Header(),
			eventtype,			/*type of event*/
			AnyTargetEventExtract(ONE, marker),
			marker,		/* target event # */
			TrialNumber_Header(),		/* which trial (check for sorting) */
			trial_status,
		   	AnyTargetEventExtract(TYPE, marker),
			AnyTargetEventExtract(TWO, marker),
			AnyTargetEventExtract(THREE, marker)); 		/* success or fail? */
		marker++;
	  }
	 
	  /*target off times*/
	  marker=1;
	  while ((TargOffTime=AnyTargetOffEventExtract(TIME, marker)) != FAIL)
	  {
		sprintf(eventtype, "TargOff");
          	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
			TrialStart,			/*time of trial start*/
			(TargOffTime+TrialStart),		/*time of targoff*/
        	       	StackNumber_Header(),
			TableNumber_Header(),
			eventtype,			/*type of event*/
        	       	AnyTargetOffEventExtract(ONE, marker),			 /* which target */
			marker,		/* target event # */
			TrialNumber_Header(),		/* which trial (check for sorting) */
			trial_status,			/* success or fail? */
			AnyTargetOffEventExtract(TYPE, marker),
			AnyTargetOffEventExtract(TWO, marker),
			AnyTargetOffEventExtract(THREE, marker)); 		
		marker++;
	  }
	
	  /*reward start and duration times*/
	  int rewardstarttime;
	  static int rewardtype[] = {50,51,52,53,54,55,56,57,58,59,0}; /* Must terminate with 0	*/
	      marker=1;

	  while ((rewardstarttime=MultiEventExtract(rewardtype,TIME, marker)) != FAIL) {
			sprintf(rewardname, "Rwd");
        	  	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
				TrialStart,			/*time of trial start*/
				(rewardstarttime+TrialStart),		/*time of reward on*/
        		       	StackNumber_Header(),
				TableNumber_Header(),
				rewardname,			/* names event as reward */
	 	 		MultiEventExtract(rewardtype, ONE, marker),
				marker,					/* which occurence */
				TrialNumber_Header(),	/* which trial (check for sorting) */
				trial_status,				/* success or fail? */
	 	 		MultiEventExtract(rewardtype, TYPE, marker),
				MultiEventExtract(rewardtype, TWO, marker),
				MultiEventExtract(rewardtype, THREE, marker));   /*duration of reward*/
			marker++;
	  	 }
	  
	  /*button on times*/  
	  int buttonbits[]={1,2,4,8,16,32,64,128};  /*button 1 is the sync pulse*/
	  int whichbutton=0;
	  while (whichbutton < sizeof(buttonbits)/sizeof(int)) {
	  	marker=1;
	     	while ((TTLOnTime=Get_Button_Time(ON,buttonbits[whichbutton],marker,0,0)) != FAIL)  /* looks for TTL ON */
	  	{
		   	sprintf(eventtype, "TTLOn");
          		fprintf(event, "%d %d %d %d %s %d %d %d %s\n",
				TrialStart,			/*time of trial start*/
				(TTLOnTime+TrialStart),		/*time of button*/
        	       		StackNumber_Header(),
				TableNumber_Header(),
				eventtype,			/* type of event */
        	       		buttonbits[whichbutton],			 /* TTL number */
				marker,		/* target event # */
				TrialNumber_Header(),		/* which trial (check for sorting) */
				trial_status); 		/* success or fail? */
			marker++;
	       	}
		whichbutton++;
	  }

	  /*button off times*/
	  whichbutton=0;		/*button 1 is the sync pulse*/
	  while (whichbutton <= 7)
	  {
	  	marker=1;
	     	while ((TTLOffTime=Get_Button_Time(OFF,buttonbits[whichbutton],marker,0,0)) != FAIL)  /* looks for TTL OFF */
	  	{
		   	sprintf(eventtype, "TTLOff");
          		fprintf(event, "%d %d %d %d %s %d %d %d %s\n",
				TrialStart,			/*time of trial start*/
				(TTLOffTime+TrialStart),		/*time of button*/
        	       		StackNumber_Header(),
				TableNumber_Header(),
				eventtype,			/* type of event */
        	       		buttonbits[whichbutton],			 /* TTL number */
				marker,		/* target event # */
				TrialNumber_Header(),		/* which trial (check for sorting) */
				trial_status); 		/* success or fail? */
			marker++;
	       	}
		whichbutton++;
	  }

	}
fclose(event);
}

/* ******************************************************************** */
/* FUNCTION PSEvents_409 */
	/* NOTE TO GAURAV: 							*/
	/* ErrType_Header():  Type of error (eye, arm, wiggle, button_and, etc */
	/* Status_Header(): using it now, but can get more info from it (start vs run-time err)	*/
	/* (Punish_Header(): punish durations (0=run, 1=start; wiggle not available)	*/
void PSEvents_409 () {
        FILE *event;
	char event_name[80];
        char trial_status[80];
	int RunStart;
	int SyncTime;
	int pulse;
	int LastSyncTime;
	int LastGoodSyncTime;
	int SyncTrialTime;
	
        if (RunStatus_Header() == -2)
           sprintf(trial_status, "s");
        else
           sprintf(trial_status, "f");

        sprintf(event_name, "event.%s%d.%d",
                trial_status, UnitNumber_Header(), RunNumber_Header());
		
        event = fopen(event_name, "w");

        if (event == NULL)
            Exit ("Event file could not be opened", "Event_File_Abs_Time408"); 
	
        Rewind_InputFile();
        Read_Next_Trial(WITH_DATA);     /* Get first trial      */

  	/* Get start time of file */
        RunStart = 1000 * (h.time.hour * 3600 + h.time.minute * 60 +
            h.time.second) + h.time_hsecond * 10; /* Hundredths times ten */

	/* Get first sync pulse (bit 1 off)			*/
	while ((SyncTrialTime=Get_Button_Time(OFF, 1, 1, 0, 0)) == FAIL)
          	if (Read_Next_Trial(WITH_DATA) == 0)
	     		return;   	/* Get next trial	*/

        if (SyncTrialTime == FAIL)
           fprintf(stderr, "Can't find first sync pulse--Event_File_Abs_Time408");
        if (EventExtract(RESTART, TIME, 1) != FAIL)
           fprintf(stderr, "RESTART in stack: times are wrong--Event_File_Abs_Time408");

	int TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
	   h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
	
	SyncTime=SyncTrialTime+TrialStart;

	/*Get last sync pulse (bit 1 off)*/
	LastGoodSyncTime=-9999;
	
	do
	{
	  	pulse = 1;
		TrialStart=1000*(h.time.hour*3600 + h.time.minute*60 +
	             h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
		while ((LastSyncTime=Get_Button_Time(OFF, 1, pulse, 0, 0)) != FAIL)
			{
		        pulse++;
			LastGoodSyncTime = LastSyncTime+TrialStart;
			}
	}
	while (Read_Next_Trial(WITH_DATA) != 0);
	
	/*Print start of run, 1st pulse, and last pulse times*/	
	fprintf(event, "%d RunStart %s\n%d FirstSyncPulse %d %s\n%d LastSyncPulse %d %s\n",
	                       RunStart,              /*beginning of run, abs. time*/
			       trial_status,
			       SyncTime,   /*abs time of first recorded sync pulse*/
			       SyncTime-RunStart,
			       trial_status,
			       LastGoodSyncTime,
			       LastGoodSyncTime-RunStart,
			       trial_status);

	/*start looping through trials and writing event times and types*/   
        Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) 
	{
          TrialStart = 1000*(h.time.hour*3600 + h.time.minute*60 +
          h.time.second) + 10*h.time_hsecond + EventExtract(TAPE_ON, TIME, 1);
                                                        /* modify so have ms */

	  int TargOnTime;
	  int TargOffTime;
	  int TTLOnTime;
	  int TTLOffTime;
	  
	  char eventtype[80];
	  char rewardname[80];
	  char bmpname[80];
	  char rsvpname[80];
	  
//	  int targnum=1;	/*the code for which tpye of event*/
//	  int targoffnum=2;
//	  int buttonnum=3;
	 
	  /*target on times*/
	  int marker=1;
	  while ((TargOnTime=AnyTargetEventExtract(TIME, marker)) != FAIL)
	  {
		sprintf(eventtype, "TargOn");
          	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
			TrialStart,			/*time of trial start*/
			(TargOnTime+TrialStart),		/*time of targ*/
        	       	StackNumber_Header(),
			TableNumber_Header(),
			eventtype,			/*type of event*/
			AnyTargetEventExtract(ONE, marker),
			marker,		/* target event # */
			TrialNumber_Header(),		/* which trial (check for sorting) */
			trial_status,
		   	AnyTargetEventExtract(TYPE, marker),
			AnyTargetEventExtract(TWO, marker),
			AnyTargetEventExtract(THREE, marker)); 		/* success or fail? */
		marker++;
	  }
	 
	  /*target off times*/
	  marker=1;
	  while ((TargOffTime=AnyTargetOffEventExtract(TIME, marker)) != FAIL)
	  {
		sprintf(eventtype, "TargOff");
          	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
			TrialStart,			/*time of trial start*/
			(TargOffTime+TrialStart),		/*time of targoff*/
        	       	StackNumber_Header(),
			TableNumber_Header(),
			eventtype,			/*type of event*/
        	       	AnyTargetOffEventExtract(ONE, marker),			 /* which target */
			marker,		/* target event # */
			TrialNumber_Header(),		/* which trial (check for sorting) */
			trial_status,			/* success or fail? */
			AnyTargetOffEventExtract(TYPE, marker),
			AnyTargetOffEventExtract(TWO, marker),
			AnyTargetOffEventExtract(THREE, marker)); 		
		marker++;
	  }

          /*bmp presentation times*/
          int bmptime;
              marker=1;

          while ((bmptime=EventExtract(427, TIME, marker)) != FAIL) {
                        sprintf(bmpname, "Bitmap");
                        fprintf(event, "%d %d %d %d %s %d %d %d %s %d\n",
                                TrialStart,                     /*time of trial start*/
                                (bmptime+TrialStart),           /*time of bmp on*/
                                StackNumber_Header(),
                                TableNumber_Header(),
                                bmpname,                        /* names event as bmp */
                                EventExtract(427, ONE, marker), /*which target*/
                                marker,                                 /* which occurence */
                                TrialNumber_Header(),   /* which trial (check for sorting) */
                                trial_status,                           /* success or fail? */
                                EventExtract(427, TWO, marker));   /*which bmp*/
                        marker++;
                 }

          /*rsvp start/stop times*/
          int rsvptime;
              marker=1;

          while ((rsvptime=EventExtract(428,TIME, marker)) != FAIL) {
                        sprintf(rsvpname, "RSVP");
                        fprintf(event, "%d %d %d %d %s %d %d %d %s\n",
                                TrialStart,                     /*time of trial start*/
                                (rsvptime+TrialStart),           /*time of bmp on*/
                                StackNumber_Header(),
                                TableNumber_Header(),
                                rsvpname,                        /* names event as bmp */
                                EventExtract(428, ONE, marker), /*on or off?*/
                                marker,                                 /* which occurence */
                                TrialNumber_Header(),   /* which trial (check for sorting) */
                                trial_status);                           /* success or fail? */
                        marker++;
                 }


	  /*reward start and duration times*/
	  int rewardstarttime;
	  static int rewardtype[] = {50,51,52,53,54,55,56,57,58,59, 0};	/* Must be 0 terminated */
	      marker=1;

	  while ((rewardstarttime=MultiEventExtract(rewardtype,TIME, marker)) != FAIL) {
			sprintf(rewardname, "Rwd");
        	  	fprintf(event, "%d %d %d %d %s %d %d %d %s %d %d %d\n",
				TrialStart,			/*time of trial start*/
				(rewardstarttime+TrialStart),		/*time of reward on*/
        		       	StackNumber_Header(),
				TableNumber_Header(),
				rewardname,			/* names event as reward */
	 	 		MultiEventExtract(rewardtype, ONE, marker),
				marker,					/* which occurence */
				TrialNumber_Header(),	/* which trial (check for sorting) */
				trial_status,				/* success or fail? */
	 	 		MultiEventExtract(rewardtype, TYPE, marker),
				MultiEventExtract(rewardtype, TWO, marker),
				MultiEventExtract(rewardtype, THREE, marker));   /*duration of reward*/
			marker++;
	  	 }
	  
	  /*button on times*/  
	  int buttonbits[]={1,2,4,8,16,32,64,128};  /*button 1 is the sync pulse*/
	  int whichbutton=0;
	  while (whichbutton < sizeof(buttonbits)/sizeof(int)) {
	  	marker=1;
	     	while ((TTLOnTime=Get_Button_Time(ON,buttonbits[whichbutton],marker,0,0)) != FAIL)  /* looks for TTL ON */
	  	{
		   	sprintf(eventtype, "TTLOn");
          		fprintf(event, "%d %d %d %d %s %d %d %d %s\n",
				TrialStart,			/*time of trial start*/
				(TTLOnTime+TrialStart),		/*time of button*/
        	       		StackNumber_Header(),
				TableNumber_Header(),
				eventtype,			/* type of event */
        	       		buttonbits[whichbutton],			 /* TTL number */
				marker,		/* target event # */
				TrialNumber_Header(),		/* which trial (check for sorting) */
				trial_status); 		/* success or fail? */
			marker++;
	       	}
		whichbutton++;
	  }

	  /*button off times*/
	  whichbutton=0;		/*button 1 is the sync pulse*/
	  while (whichbutton < sizeof(buttonbits)/sizeof(int)) {
	  	marker=1;
	     	while ((TTLOffTime=Get_Button_Time(OFF,buttonbits[whichbutton],marker,0,0)) != FAIL)  /* looks for TTL OFF */
	  	{
		   	sprintf(eventtype, "TTLOff");
          		fprintf(event, "%d %d %d %d %s %d %d %d %s\n",
				TrialStart,			/*time of trial start*/
				(TTLOffTime+TrialStart),		/*time of button*/
        	       		StackNumber_Header(),
				TableNumber_Header(),
				eventtype,			/* type of event */
        	       		buttonbits[whichbutton],			 /* TTL number */
				marker,		/* target event # */
				TrialNumber_Header(),		/* which trial (check for sorting) */
				trial_status); 		/* success or fail? */
			marker++;
	       	}
		whichbutton++;
	  }
	  
	  /*punish type, start, and duration times*/
	/* NOTE TO GAURAV: 							*/
	/* ErrType_Header():  Type of error (eye, arm, wiggle, button_and, etc */
	/* Status_Header(): using it now, but can get more info from it (start vs run-time err)	*/
	/* (Punish_Header(): punish durations (0=run, 1=start; wiggle not available)	*/
	 int punishstatus = RunStatus_Header();
	 if (punishstatus != -2) {
	 
	  sprintf(eventtype, "Punish");

	  int punishtype;
	  if (punishstatus == -9999)
	     punishtype=0;
	  else
	     punishtype=1;
	 
          fprintf(event, "%d %d %d %d %s %d %d %d %s %d\n",
		TrialStart,			/*time of trial start*/
		(EventExtractErrorBegin()+TrialStart),		/*starting time of punish*/
        	StackNumber_Header(),
		TableNumber_Header(),
		eventtype,			/* names event as punish */
	 	ErrType_Header(),		/* what caused the error? (eye, button, etc) */
		punishtype,		/* what type of punish (run=0, start=1) */
		TrialNumber_Header(),	/* which trial (check for sorting) */
		trial_status,				/* success or fail? */
		Punish_Header(punishtype) );   /*duration of punish*/
	}
	  
	  /*saccade times*/  
	extern float SacPeakVelocity_H, SacPeakVelocity_V;
	extern float SacPosition_H, SacPosition_V;

	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 1;		/* Find *all* saccades!	*/


	   /* int trial = TrialNumber_Header();		* Trial #	*/
	   int time = EventExtract(TAPE_ON, TIME, 1) + 5;
	   int sac_start = -FAIL * 2;
	   int none = 1;

	   while ((sac_start = Get_Saccade_Time(1,1,time,0)) != FAIL) {
	    float Start_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	    float Start_V = SacPosition_V;
	   					/* Get sac end data 	*/
	    int sac_end = Get_Saccade_Time(0, 1, time, 0);
	    float End_H = SacPosition_H;	/* Set by Get_Sac_Time	*/
	    float End_V = SacPosition_V;	/* Now set peakvel vars:*/

	    Get_Saccade_Peak_Velocity(1, time, 0);
	   	/* Unsed return value; sets peak velocity	*/
	   					/* Get limb data	*/

		sprintf(eventtype, "Saccade");
          	fprintf(event, "%d %d %d %d %s %.1f %.1f %d %s %.1f %.1f \n",
			TrialStart,			/*time of trial start*/
			sac_start - Interval_To_Stack_Time(0) + TrialStart,		/*time of targ*/
        	       	StackNumber_Header(),
			TableNumber_Header(),
			eventtype,			/*type of event*/
		 	End_H-Start_H,				/* Sac amplitude*/
		 	End_V-Start_V,
			TrialNumber_Header(),		/* which trial (check for sorting) */
			trial_status,
		 	SacPeakVelocity_H,			/* Sac velocity	*/
		 	SacPeakVelocity_V);
	   
	   time = sac_end + 50;
	   none = 0;
	   }
	}

fclose(event);
}
/* ******************************************************************** */
