/* FILE _macros/mr/strabismus.c */

#include "../Deffs.h"
#include "../../deffs.h"
#include "../../event.h"

#define VERBOSE	0

/* FUNCTIONS:
 * Strabismus440	Important info (event times), 1 line per trial
 */
/* ********************************************************************	*/
#include "string.h"

/* FUNCTION Strabismus440 */
        /* Data for strabismus trials */
void Strabismus440() {
  FILE *file;
  char  string[180];
  int   InvertedSync = 1;
  int   FirstPulse;
  int   LastPulse = 0;
  int   RunStart = 0;
  int   TimeSlip = 0;
  int   TargetOn = 0;

  Rewind_InputFile();				/* Insurance		*/

  if (strcmp(Get_AlignmentTime(), "r") != 0)
     Exit("Must call this macro with '-ar' on command line", "Macro 431");

  sprintf(string, "events.%d.%d",
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(string, (MACRO_APPENDS)?"a":"w");
  if (file == NULL)
     Exit ("'Start' file could not be opened", "macro 431"); 
  while (Read_Next_Trial(WITH_DATA)) {
     int TrialStart = (int) (Time_From_Header() * 1000) - TimeSlip;
     int next;

     FirstPulse = (InvertedSync) ?
	    Get_Button_Time(OFF, 1, 1, 0, 0) :	/* Inverted logic: low?	*/
	    Get_Button_Time(ON,  1, 1, 0, 0);	/* Look for + pulse	*/
     if (FirstPulse == FAIL)
	Exit("He's dead, Jim (no pulse)", "Macro 440");
     FirstPulse += TrialStart;

     if (TrialNumber_Input() == 1) {
        RunStart = FirstPulse;
      } else {
	int delta = (FirstPulse - RunStart) % 3000;
         /* For unclear reasons, the DOS clock loses time.  Use pulses
	  * as a reliable clock - adjust start time of each trial	*/

	if (delta > 100 && delta < 2900) {
	   sprintf(string, "Big gap: %d ms\t", delta);
	   Warning(string);
	   }
	if (delta > 1500)
	    delta -= 3000;
	if (VERBOSE)
	  fprintf(stderr,"First pulse at %4.3f s;",(FirstPulse-RunStart)/1000.);
	TimeSlip += delta;		/* Add lost time		*/
	FirstPulse -= delta;
	TrialStart -= delta;
	if (VERBOSE)
	   fprintf(stderr, " slip is %d so actually %4.3f\n",
			TimeSlip, (FirstPulse-RunStart)/1000.);
        }

     next = 0;
     while ((next = ((InvertedSync) ?
	       Get_Button_Time(OFF, 1, 1, next, 0) :
	       Get_Button_Time(ON,  1, 1, next, 0))) != FAIL) {
	LastPulse = next;
	if (VERBOSE)
           fprintf(stderr, "      %d: %5.3f\n", 
		   	TrialNumber_Input(), (next+TrialStart-RunStart)/1000.);
	}
     LastPulse += TrialStart - RunStart;
     if (TargetOn == 1 && (EventExtract(TARGET_ON, TIME, 1) == FAIL))
        TargetOn = 0;
     else if (TargetOn==0 && (EventExtract(TARGET_ON, TIME, 1) != FAIL)) {
	int Map[] = { 6, -1,  -2, 0, -4, -5, 1, 2, 3, 4, 5 };
	int TargetTime = EventExtract(TARGET_ON, TIME, 1);
	double exp2(double x);

	if (TargetTime == (int)(exp2(16.) - 1))
	    TargetTime = -1;
        TargetOn = 1;
        fprintf(file, "%8.1f %d 45.0\n",
	    (TargetTime + TrialStart - RunStart)/1000.,
	    Map[EventExtract(TARGET_MOVIE, TWO, 1)]); /* Map to 0:4 */
	if (VERBOSE)
           fprintf(stderr, "      *** %.1f %d 45.0 ***\n",
	      (TargetTime + TrialStart - RunStart)/1000.,
	      Map[EventExtract(TARGET_MOVIE, TWO, 1)]); /* Map to 0:4 */
	}
     }
  fprintf(stderr, "Last pulse at %4.3f s (%.1f frames)\n",
				LastPulse/1000., LastPulse/3000.);
  fclose(file);
}
/* ******************************************************************** */
