/* FILE _macros/mr/sort.c */
     /* Sort by position & direction of saccade or pursuit	*/

/* #include "../Deffs.h"				 * Use deffs.h	*/
#include "../../deffs.h"				/* ARMDATA	*/
#include "../../event.h"
/* ********************************************************************	*/

#define CHANGE_STACK_TOO   0
#define DIRECTION_ONLY     1

/* FUNCTION Sort420 */
	 /* Sort by position and direction; call with "-w" flag */
	/* Saccades: from 1st to 2nd 'TARGET_ON'		*/
	/* Pursuit:  from 1st TARGET ON, 'Sinusoid' values	*/
void Sort420() {
	static struct {		/* Set the 1's place 		*/
	    int h, v;
	    } Positions[100];
	static int positions = 0;

	int V_sine = EventExtract(TARGET_SINUSOID, THREE, 1);
	int H_sine = EventExtract(TARGET_SINUSOID, THREE, 2);
	int sine_sign = EventExtract(TARGET_SINUSOID, TWO, 1);

	int start_h = EventExtract(TARGET_ON, TWO, 1);
	int start_v = EventExtract(TARGET_ON, THREE, 1);
	int end_h = EventExtract(TARGET_ON, TWO, 2);
	int end_v = EventExtract(TARGET_ON, THREE, 2);

	int position;
	int direction;
	int i = -1;

	extern void Set_ClassNumber_Header();

	if (sine_sign != 0) {		/* Did you get the order right?	*/	
	   V_sine = EventExtract(TARGET_SINUSOID, THREE, 2);
	   H_sine = EventExtract(TARGET_SINUSOID, THREE, 1);
	   }

	if (sine_sign != FAIL) {		/* Map direction to 1:4	*/
	   direction = 1+ (H_sine > 0) + 2 * (V_sine > 0);
	   if (H_sine == 0 && V_sine == 0)	/* 0: no pursuit (fix)	*/
	      direction = 0;
	 } else {
	   direction = 1+ ((end_h - start_h) > 0) + 2 * ((end_v - start_v)>2);
	   if (end_h-start_h == 0 && end_v-start_v == 0)	/* fix	*/
	      direction = 0;
	   }


	while (++i < positions && i < 100)	/* Map 0:n (unsorted)	*/
	   if (start_h == Positions[i].h && start_v == Positions[i].v)
	      break;

	position = i;
	if (position == positions) {
	   Positions[i].h = start_h;
	   Positions[i].v = start_v;
	   positions++;
	   }
	   
#if CHANGE_STACK_TOO
	Set_ClassNumber_Header(1+position);
	Increment_StackNumber_In_Header((sine_sign) ? -direction : direction);
#elif DIRECTION_ONLY
	Set_ClassNumber_Header(1+direction);
#else
	Set_ClassNumber_Header(1+position + 100*direction);

#endif
	}
/* ********************************************************************	*/
