/* FILE _macros/mr/memsac201.c */

#include "../../deffs.h"
#include "../../event.h"

/* Stacks  2:		start scan		*
 *        20:		ITI			*
 *        22:		 3 s memory		*
 *        23:		 6 s memory		*
 *        24:		12 s memory		*
 *        25:		21 s memory		*
 *        26-29:	27 s memory		*
 */

/* FUNCTIONS:
 * RunStartTime450	Time of 1st sync pulse (macro # swapped vs 430/1!)
 * MemoryEvents451	Important info (event times), 1 line per trial
 * MemoryEvents452	Event times, 1 line per event
 */
/* ********************************************************************	*/
#include "string.h"

# define DEBUG	0
# define POS_PULSE_DURATION 516

#define Round(x)   (round((double)x*100.)/100.)
/* ms -> s and round to 1 or 2 significant figures */
#define Round1(x)   (((int)x==FAIL)? 0:(round((double)x/100.)/10.))
#define Round2(x)   (((int)x==FAIL)? 0:(round((double)x/10.)/100.))

/* FUNCTION RunStartTime450 */
	 /* Write run start time to a file */
void RunStartTime450() {
  FILE *file;
  char file_name[80];
  int  FirstPulseInRun = -1;

  Rewind_InputFile();				/* Insurance		*/
  if ((Read_Next_Trial(WITH_DATA) == 0) && (RunStatus_Header() == SUCCESS))
     Exit("Empty file??", "Macro 450");

  if (StackNumber_Header() != 2)
     Exit("First trial is not 'start scan' !", "Macro 450");

  FirstPulseInRun = Get_Button_Time(ON, 4, 1, 0, 0);
  if (FirstPulseInRun + 60 < EventExtract(BUTTON_ACQUIRE_AND, TIME, 2))
     Exit("Turned on scanner too early!", "Macro 450");
     /* +40: takes ACQUIRE a bit to register the behavior */
     
  if (FirstPulseInRun == FAIL)
     Exit("No positive-going pulse in 'start scan'!", "Macro 450");

  if (Get_Button_Time(ON,4,2,0,0) != FAIL)		/* A 2nd pulse?	*/
     Exit("More than one pulse in 'start scan' trial", "Macro 450");

  sprintf(file_name, "begin.%d.%d",
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(file_name, "a");
  if (file == NULL)
     Exit ("'Start' file could not be opened", "macro 450"); 

  fprintf(file, "%8.3f\n", /* File start time + 1st sync time (in s)	*/
	Time_From_Header() + FirstPulseInRun/1000.);
  fclose(file);				/* Pulse goes LOW 	*/
  }
/* ********************************************************************	*/

/* FUNCTION MemoryEvents451 */
        /* Writes time & location of target, saccades, etc 		*/
	/* grab -aR -xs2 -i0:0 -o451 files */
	/*  stack 2 is too short; align on end so get as much post-sac
	 *  data as possible; disable intervals (avoid warnings)
	 */
void MemoryEvents451() {
  FILE *file;
  char file_name[80];
  int FirstPulse = Get_Button_Time(OFF, 4, 1, 0, 0);	/* Not really!	*/
  				/* We skip the first trial, usually	*/
  	/* Advantage of 'off' vs 'on' - won't return "start of trial",
	 * which 'ON' would do, if it started on.
	 */

  if (strcmp(Get_AlignmentTime(), "R") != 0)
     Exit("Call this macro with '-aR'", "Macro 451");

  Rewind_InputFile();				/* Insurance		*/
  sprintf(file_name, "event.%c%d.%d",
		(RunStatus_Header() == SUCCESS) ? 's' : 'f',
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(file_name, "w");
  if (file == NULL)
     Exit ("Event file could not be opened", "macro 450"); 

  fprintf(file, 
"Unit Run Trial # Start(s) 1st-pulse  H    V    Targ    H    V    Fix-off  H    V    Sac    H       V     2nd-sac    H      V      3rd-sac   H      V      Unblank   H      V       Error\n");


  while (Read_Next_Trial(WITH_DATA)) {
     int TrialStartTime = (int) 1000*Time_From_Header(); /* float -> int */

     int TargetFlashTime = TargetEventExtract(3, TIME, 1); /* Targ #3,1st*/

     extern int Get_Saccade_Limited, Get_Saccade_Stringent;
     int FixOffTime = FAIL;
     int SacTime = FAIL;
     int SecondSacTime = FAIL;
     int ThirdSacTime = FAIL;
     int UnblankTime = FAIL;

     float FixPos_H = 0, FixPos_V = 0,
	   EyePos_H=0, EyePos_V=0, FinalEyePos_H=0, FinalEyePos_V=0,
	   SecondEyePos_H=0, SecondEyePos_V=0,
	   ThirdEyePos_H=0, ThirdEyePos_V=0;

     int NextPulse;
     int occur = 0;

     if (DEBUG) {
	while ((NextPulse = Get_Button_Time(OFF,4,++occur,0,0)) != FAIL)
         fprintf(stderr, "%8.3f\n", Time_From_Header() + NextPulse/1000.);
	 }

     if ((Get_ZeroTime() < 100) && (RunStatus_Header() == SUCCESS))
        Exit("Skip stack 2 (and any other short stacks)", "Macro 451");

     while ((NextPulse = Get_Button_Time(OFF,4,++occur,0,0)) != FAIL)
        if ((NextPulse - FirstPulse) % 3 > 250)
           fprintf(stderr, "%d ms error\n", (NextPulse - FirstPulse) % 3);
				
     if (TargetFlashTime == FAIL)	/* No target: ITI or err	*/
	goto PRINT;
     /* ***************************************************************	*/

     { int i = 0;			/* GET UNBLANK & FIX TIMES	*/
       while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 3 &&	/* Target 3?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 0) {	/* UN-blank?	*/
           UnblankTime = EventExtract(TARGET_BLANK, TIME, i);
	   break;
	   }
       i = 0;
       while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 1 &&	/* Target 1?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 1) {	/* blank?	*/
           FixOffTime = EventExtract(TARGET_BLANK, TIME, i);
	   break;
	   }
       }
     if ((FixOffTime == FAIL) ||
	 (FixOffTime > TargetOffEventExtract(1, TIME, 1)))
        FixOffTime = TargetOffEventExtract(1, TIME, 1);	/* targ 1, 1st	*/

     if ((UnblankTime == FAIL || FixOffTime == FAIL) && 
	 (EventExtract(ERROR_STACK_BEGIN, TIME, 1) == FAIL))
	   Warning("Can remove this (never happens, right?)");

     /* ***************************************************************	*/
     /* Check that we got data 150:450 ms after fixation off:		*/
     if (FixOffTime != FAIL &&
         !TimeRecorded(FixOffTime+150-Get_AlignTime()+Get_ZeroTime(),
     	    	       FixOffTime+450-Get_AlignTime()+Get_ZeroTime()))
	 fprintf(stderr, "Did not record long enough!\n");

     if (FixOffTime != FAIL &&
	   TimeRecorded(FixOffTime-1000-Get_AlignTime()+Get_ZeroTime(),
		   	FixOffTime     -Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(FixOffTime-1000-Get_AlignTime(),
			FixOffTime     -Get_AlignTime(),
			&FixPos_H, &FixPos_V);
     /* ***************************************************************	*/
		     
     Get_Saccade_Limited = 0;		/* GET SACCADE TIME		*/
     Get_Saccade_Stringent = 0;

     SacTime           = Get_Saccade_Time(1,1,FixOffTime,0);
     if (SacTime != FAIL)
         SecondSacTime = Get_Saccade_Time(1,1,SacTime+100,0);
     if (SecondSacTime != FAIL)
         ThirdSacTime  = Get_Saccade_Time(1,1,SecondSacTime+100,0);
     /* ***************************************************************	*/
	
     if (SacTime != FAIL && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SacTime+50- Get_AlignTime(), 
			SacTime+150-Get_AlignTime(), 
				&EyePos_H, &EyePos_V);

     if (SecondSacTime != 0 && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SecondSacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SecondSacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SecondSacTime+50- Get_AlignTime(), 
			SecondSacTime+150-Get_AlignTime(), 
				&SecondEyePos_H, &SecondEyePos_V);

     if (ThirdSacTime != 0 && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(ThirdSacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		ThirdSacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(ThirdSacTime+50- Get_AlignTime(), 
			ThirdSacTime+150-Get_AlignTime(), 
				&ThirdEyePos_H, &ThirdEyePos_V);

     if (UnblankTime != FAIL &&
	   TimeRecorded(UnblankTime- 50 -Get_AlignTime()+Get_ZeroTime(),
	    		UnblankTime+ 50 -Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(UnblankTime- 50- Get_AlignTime(),
			UnblankTime+ 50 -Get_AlignTime(), 
		     	&FinalEyePos_H, &FinalEyePos_V);
     /* ***************************************************************	*/
     PRINT:

     fprintf(file, 				/* Print out the data	*/
   "%4d %2d %4d %3d %8.1f %8.2f %4.1f %4.1f %6.2f %5.1f %5.1f %7.2f %4.1f %4.1f %6.2f %6.1f %6.1f %8.2f  %6.1f %6.1f  %8.2f %6.1f %6.1f  %8.2f %6.1f %6.1f %8.1f\n", 
    	UnitNumber_Header(),
	RunNumber_Header(),
	TrialNumber_Header(),
	TrialNumber_Input(),
	Round1(TrialStartTime),
        Round2(Get_Button_Time(ON,4,1,		/* Button goes hi (sync)*/
		EventExtract(BUTTON_ACQUIRE_AND,TIME,1),0)),
		/* Start looking after 1st aq, which is 'button low'	*/

	/* Fixation target */
	TargetEventExtract(1, TWO, 1)/10.,
	TargetEventExtract(1, THREE, 1)/10.,

        Round2(TargetFlashTime),	/* Target time & target coords	*/
        (TargetFlashTime==FAIL) ? 0 : TargetEventExtract(3, TWO, 1)/10.,
        (TargetFlashTime==FAIL) ? 0 : TargetEventExtract(3, THREE, 1)/10.,

	Round2(FixOffTime),
	/* Fixation position */
	Round(FixPos_H), Round(FixPos_V),

	Round2(SacTime),
	Round(EyePos_H),
	Round(EyePos_V),

	Round2(SecondSacTime),
	Round(SecondEyePos_H),
	Round(SecondEyePos_V),

	Round2(ThirdSacTime),
	Round(ThirdEyePos_H),
	Round(ThirdEyePos_V),

	Round2(UnblankTime),
	Round(FinalEyePos_H),
	Round(FinalEyePos_V),

	Round1(EventExtract(ERROR_STACK_BEGIN, TIME, 1))
	//(EventExtract(ERROR_STACK_BEGIN, TIME, 1) == FAIL) ?  0 :
	//    Round1(EventExtract(ERROR_STACK_BEGIN, TIME, 1))
	);
	}
fclose(file);
}
/* ******************************************************************** */

/* FUNCTION MemoryEvents452 */
        /* One line per event, one file per run			*/
	/* grab -aR -i0:0 -o452 files */
void MemoryEvents452() {
  FILE *file;
  char file_name[80];
  int Fail = RunStatus_Header() != SUCCESS;
  int StartTime = 0;			/* Start time, ms from midnight	*/
  int i;
  static int NumberToTime[] = { 3, 3, 6, 12, 21, 27, 27, 27, 27 };

  if (strcmp(Get_AlignmentTime(), "R") != 0)
     Exit("Call this macro with '-aR'", "Macro 452");

  if (Fail) {
      sprintf(file_name, "linebyline.s%d.%d",
	       	UnitNumber_Header(), RunNumber_Header());
      file = fopen(file_name, "r");
      if (file == NULL)
	 fprintf(stderr, "MUST FIRST RUN SUCCESS FILE!\n");
      fscanf(file, "%d", &StartTime);
      if (StartTime <= 0)
	 fprintf(stderr, "Start time may not be set properly! (%d.%d)\n",
	       	UnitNumber_Header(), RunNumber_Header());
      } 

  sprintf(file_name, "linebyline.%c%d.%d",
		(RunStatus_Header() == SUCCESS) ? 's' : 'f',
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(file_name, "w");
  if (file == NULL)
     Exit ("Event file could not be opened", "macro 452"); 

  Rewind_InputFile();				/* Insurance		*/

  if (RunStatus_Header() == SUCCESS) {
     Read_Next_Trial(WITH_DATA);
     if (StackNumber_Header() != 2) {		/* Missing!		*/
	if ((UnitNumber_Header() == 115) & (RunNumber_Header() == 3))
	   StartTime = 1000 * Time_From_Header() + 3200;
	else
	if ((UnitNumber_Header() == 115) & (RunNumber_Header() == 4))
	   StartTime = 1000 * Time_From_Header() + 1750;
	else
	if ((UnitNumber_Header() == 118) & (RunNumber_Header() == 2))
	   StartTime = 1000 * Time_From_Header() + 9454;
	else
	if ((UnitNumber_Header() == 118) & (RunNumber_Header() == 4))
	   StartTime = 1000 * Time_From_Header() + 4212;
	else {
	   fprintf(stderr, "Missing start scan trial - FIX THIS!\n");
	   StartTime = 1000 * Time_From_Header();	/* Guess at it	*/
	   }
        Rewind_InputFile();
        fprintf(file, "%d Run_start approximately\n", StartTime);
      } else {
        StartTime = 1000 * Time_From_Header() + Get_Button_Time(ON, 4,1,0,0);
        fprintf(file, "%d Run_start\n", StartTime);
        }
     }


  while (Read_Next_Trial(WITH_DATA)) {

   int TrialStart = 1000 * Time_From_Header() - StartTime;
   int FixOffTime = FAIL;

   switch (StackNumber_Header()) {
    case 2:
      if (RunStatus_Header() == SUCCESS)
         fprintf(stderr, "DIAG: found second 'Start scan' (stack 2)\n");
      /* If a failure trial, just ignore it -- started scanner late	*/
      /* StartTime = TrialStart + Get_Button_Time(ON, 4,1,0,0); */
      /* fprintf(file, "%d Run_start\n", StartTime); */
      break;

    case 20:
      fprintf(file, "%d ITI_start\n", TrialStart);
      if (EventExtract(ACQUIRE, TIME, 2) != FAIL)
          fprintf(file, "%d ITI_fixate\n", TrialStart +
		      	EventExtract(ACQUIRE, TIME, 2));
	  /* Time from wiggle acquire (after eye acquire)	*/
      if (Fail)
          fprintf(file, "%d ITI_abort\n",  TrialStart +
			EventExtract(ERROR_STACK_BEGIN, TIME, 1));
      break;

    default:

      if (TargetEventExtract(3, TIME, 1) != FAIL)
        fprintf(file, "%d Mem_TargetOn  %d  %.1f  %.1f  %d\n",
       	   TrialStart + TargetEventExtract(3, TIME, 1),	/* Targ #3,1st*/
	   Fail==0, 
	   TargetEventExtract(3,TWO,  1)/10.- TargetEventExtract(1,TWO,  1)/10.,
	   TargetEventExtract(3,THREE,1)/10.- TargetEventExtract(1,THREE,1)/10.,
	   NumberToTime[StackNumber_Header() - 21]);

      for (i=1; i<10; i++)
        if (EventExtract(TARGET_BLANK, ONE, i) == 1 &&	/* Target 1?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 1) {	/* blank?	*/
           FixOffTime = EventExtract(TARGET_BLANK, TIME, i);
	   break;
	   }

      if ((FixOffTime == FAIL) ||
 	  (FixOffTime > TargetOffEventExtract(1, TIME, 1)))
         FixOffTime = TargetOffEventExtract(1, TIME, 1); /* targ 1, 1st	*/

      if (FixOffTime != FAIL) {
        fprintf(file, "%d Mem_FixOff  %d\n", 
	   TrialStart + FixOffTime,
	   TrialNumber_Header());
       /*(EventExtract(REWARD,TIME,1)==FAIL)?0:-EventExtract(REWARD,THREE,1));*/
	}

      if (Fail)
          fprintf(file, "%d Mem_FixAbort\n",  TrialStart +
			EventExtract(ERROR_STACK_BEGIN, TIME, 1));
     }
    }
    fclose(file);
   }
/* *******************************************************************	*/

/* FUNCTION MemoryAccuracy453 */
        /* One line per event, one file per run			*/
	/* grab -aTt1 -i0:0 -o453 files */
void MemoryAccuracy453() {
  FILE *file;
  char file_name[80];
  int i;

  sprintf(file_name, "accuracy.%c%d.%d",
		(RunStatus_Header() == SUCCESS) ? 's' : 'f',
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(file_name, "w");
  if (file == NULL)
     Exit ("Event file could not be opened", "macro 453"); 

  Rewind_InputFile();				/* Insurance		*/

  while (Read_Next_Trial(WITH_DATA)) {
   int FixOffTime = FAIL;
   float pre_h, h1, h2, h3, h4 = FAIL, h5 = FAIL, pre_v, v1, v2, v3, v4 = FAIL, v5 = FAIL;
   int sac_time;

   if (StackNumber_Header() == 2 || StackNumber_Header() == 20)
      continue;

   for (i=1; i<10; i++)
     if (EventExtract(TARGET_BLANK, ONE, i) == 1 &&	/* Target 1?	*/
	  EventExtract(TARGET_BLANK, TWO, i) == 1) {	/* blank?	*/
        FixOffTime = EventExtract(TARGET_BLANK, TIME, i);
	break;
	}
   
   if (FixOffTime == FAIL)
       FixOffTime = EventExtract(TARGET_OFF, TIME, 1);

   sac_time = Get_Saccade_Time(0, 1, FixOffTime, 0);	/* Find end	*/

   /* if (TimeNotRecorded(begin+Get_ZeroTime(), end+Get_ZeroTime() */

   Get_EyePosition(Stack_To_Interval_Time(FixOffTime-1000),
		   Stack_To_Interval_Time(FixOffTime    ), &pre_h, &pre_v);
   Get_EyePosition(Stack_To_Interval_Time(FixOffTime+300),
		   Stack_To_Interval_Time(FixOffTime+400), &h1, &v1);
   Get_EyePosition(Stack_To_Interval_Time(FixOffTime+500),
		   Stack_To_Interval_Time(FixOffTime+600), &h2, &v2);
   Get_EyePosition(Stack_To_Interval_Time(FixOffTime+700),
		   Stack_To_Interval_Time(FixOffTime+800), &h3, &v3);
   if (sac_time != FAIL && EventExtract(TAPE_OFF,TIME,1) > sac_time+150)
      Get_EyePosition(Stack_To_Interval_Time(sac_time+50),
		      Stack_To_Interval_Time(sac_time+150), &h4, &v4);
   if (sac_time != FAIL && EventExtract(TAPE_OFF,TIME,1) > sac_time+350)
      Get_EyePosition(Stack_To_Interval_Time(sac_time+250),
		      Stack_To_Interval_Time(sac_time+350), &h5, &v5);

   fprintf(file, 
"%d  %.1f %.1f %.2f %.2f   %d   %.1f %.1f  %.2f %.2f  %.2f %.2f  %.2f %.2f  %.2f %.2f  %.2f %.2f\n",
	TrialNumber_Header(),

	TargetEventExtract(1,TWO,  1)/10.,	/* Fixation target	*/
	TargetEventExtract(1,THREE,1)/10.,
	pre_h,pre_v, 				/* Fixation eye position*/

	(sac_time != FAIL) ?  sac_time - FixOffTime : -99999,

	TargetEventExtract(3,TWO  ,1)/10.,	/* Target		*/
	TargetEventExtract(3,THREE,1)/10.,
	h1,v1, h2,v2, h3,v3,  h4,v4, h5,v5);	/* Target eye position	*/
     }
   fclose(file);
   }
/* ******************************************************************** */
