/* FILE _macros/mr/memorysaccades.c */

#include "../../deffs.h"
#include "../../event.h"
#include "../Deffs.h"
#include <string.h>

/* FUNCTIONS:
 * MemorySaccades430	Important info (event times), 1 line per trial
 * RunStartTime431	Time of first sync pulse in file, in ms from midnight
 * EventFileForMemory432 Build event file (not used)
 */
/* ********************************************************************	*/

/* FUNCTION RunStartTime431 */
        /* Writes start time of the run: call with "-X1"		*/
void RunStartTime431() {
  FILE *file;
  char file_name[80];
  int  FirstPulse = FAIL;
  int  SpecialCase1 = 	/* Inverted logic on MR pulse, bay 2 pre 6-6-08	*/
	   Year_From_Header() < 2008 ||			/* Any pre 2008 */
	   (			/* OR non-human, pre 6-6-2008 (ie,bay 2)*/
   	   !((MonkChar_Header() == 'H' || MonkChar_Header() == 'h')) &&
	    (Month_From_Header() < 7 || 
	      (Month_From_Header()==7 && Day_From_Header() < 7)));

  Rewind_InputFile();				/* Insurance		*/

  if (strcmp(Get_AlignmentTime(), "r") != 0)
     Exit("Must call this macro with '-ar' on command line", "Macro 431");

   /* Rarely, we lose button push data (probably only in the earliest data
    * collection). Check if first BUTTON_ACQUIRE happens much earlier than
    * the first pulse.  If so, use button acquire time rather than pulse time
    * */

  while (FirstPulse == FAIL) {
    int FirstAcquire;

    if (Read_Next_Trial(WITH_DATA) == 0)
	return;					/* End of file		*/
    if (TrialNumber_Input() > 4)
	return;					/* Looked far enough	*/
    FirstPulse = (SpecialCase1) ?
	    Get_Button_Time(OFF, 1, 1, 0, 0) :	/* Inverted logic: low?	*/
	    Get_Button_Time(ON,  1, 1, 0, 0);	/* Look for + pulse	*/

    FirstAcquire = EventExtract(BUTTON_ACQUIRE_AND, TIME, 2);

    if ((FirstAcquire != FAIL) && 
	     ((FirstPulse == FAIL) || (FirstAcquire + 10 < FirstPulse))) {
	fprintf(stderr, "*** Missed the first pulse (%d %d)!  (file %c%d.%d.%d [%d])\n", 
			FirstAcquire, FirstPulse,
			(RunStatus_Header() == SUCCESS) ? 's' : 'f',
			UnitNumber_Header(), RunNumber_Header(),
			TrialNumber_Header(), TrialNumber_Input());
	FirstPulse = FirstAcquire;
        }	/* In human data prior to 6-6-2008, this happens because */
    }	/* we were looking for the wrong polarity pulse - ignore it.	*/

  if (FirstPulse == FAIL)			/* Didn't find it	*/
     return;

  sprintf(file_name, "start.%d.%d",
	       	UnitNumber_Header(), RunNumber_Header());
  file = fopen(file_name, (MACRO_APPENDS)?"a":"w");
  if (file == NULL)
     Exit ("'Start' file could not be opened", "macro 431"); 

  fprintf(file, "%8.3f\n", /* File start time + 1st sync time (in s):	*/
	Time_From_Header() + FirstPulse/1000.);
  fclose(file);
  }
/* ********************************************************************	*/
# define TIME_SLIP	0
	/* Try to correct for timing errors? Or are they non-existent?	*/

/* FUNCTION MemorySaccades430 */
        /*writes time & location of target, saccades, etc 		*/
	/* If human data (stack 16), then use unblank time for 2nd sac	*/
void MemorySaccades430() {
  FILE *file;
  char file_name[80];
  /* int  DataWritten = (FrameCount_Header() != 0); */
# if TIME_SLIP
  int  FirstPulseInRun = -1;
  int  AdjustTime = 0;
  int  FRAME_TIME = (MonkChar_Header() == 'H' || MonkChar_Header() == 'h') ?
	  	2500 : 3000;	/* Humans: Tr = 2.5 s; monkeys: 3.0 s	*/
# endif

  Rewind_InputFile();
  if (Read_Next_Trial(SKIP_DATA) == 0)
  /* if ((StackNumber_Header() == 0) && RunNumber_Header()==0) */
     return;			/* None of requested stack or empty file*/

  sprintf(file_name, "event.%c%d.%d.%d",
		(RunStatus_Header() == SUCCESS) ? 's' : 'f',
	       	UnitNumber_Header(), RunNumber_Header(),
		StackNumber_Header());
  file = fopen(file_name, (MACRO_APPENDS)?"a":"w");
  if (file == NULL)
     Exit ("Event file could not be opened", "macro 430"); 

  fprintf(file, 
"Sbj Run Trial # Start(s) H   V     H    V    Targ   H    V   Fix-off Saccade 2nd-sac Unblank  H      V    2nd-H  2nd-V  Final-H    V      Error\n");

  Rewind_InputFile();
  while (Read_Next_Trial(WITH_DATA)) {
     /*  (DataWritten)? WITH_DATA:SKIP_DATA - may have to return to this */
     int TrialStartTime = (int) 1000*Time_From_Header(); /* float -> int */

     int TargetTime = TargetEventExtract(3, TIME, 1);

     extern int Get_Saccade_Limited, Get_Saccade_Stringent;
     int AcqTime;
     int FixOffTime = FAIL;
     int SacTime = FAIL;
     int SecondSacTime = 0;
     int UnblankTime = FAIL;

     float FixPos_H = -99, FixPos_V = -99,
	   EyePos_H=-99, EyePos_V=-99, FinalEyePos_H=-99, FinalEyePos_V=-99,
	   SecondEyePos_H=-99, SecondEyePos_V=-99;


#if TIME_SLIP
     int FirstPulse = Get_Button_Time(OFF, 1, 1, 0, 0);
     	Warning this has not been updated to take SPECIAL_CASE into account
     int TimeSlip;

     /* DOS clock is good to only 1/18 s, so there's jitter.  Fix this by
      * using the pulses as a more reliable clock.  Problem: we don't
      * record pulses during punish intervals.
      */
     /* Adjust TrialStartTime by AdjustTime to correct for this	*/
     if (FirstPulse != FAIL) {
        if (FirstPulseInRun == -1)
            FirstPulseInRun = TrialStartTime + FirstPulse;

        TimeSlip = (TrialStartTime-AdjustTime+FirstPulse-FirstPulseInRun)
	     		% FRAME_TIME;
	fprintf(stderr, "DIAG: slip is %d -> %d\n",
              TrialStartTime-AdjustTime+FirstPulse-FirstPulseInRun,
	      TimeSlip);

        if (TimeSlip < FRAME_TIME/2)	/* Pulse registered too late	*/
	   AdjustTime += TimeSlip;		/* Tally our lateness	*/
        else
	   AdjustTime += TimeSlip-FRAME_TIME;  /* Pulse too early-backup*/
        }
     TrialStartTime -= AdjustTime;	/* Pulse was late, so back up	*/
     /* End of time-correcting code */
#endif

     if (EventExtract(RESTART, TIME, 1) != FAIL)	/* Check!	*/
        Exit("RESTART in stack: times will be wrong", "mr macro");

     if (TargetTime == FAIL) {				/* No target!!	*/
        fprintf(file, 
          "%3d %2d %3d %3d %8.3f  -99  -99  -99  -99  -99999  -99  -99  -99999  -99999 -99999 -99999   -99 -99   -99 -99  -99 -99  %8.3f\n", 
    	   UnitNumber_Header(),
	   RunNumber_Header(),
	   TrialNumber_Header(),
	   TrialNumber_Input(),		/* Used to number from 1	*/
	   TrialStartTime/1000.,
	   (EventExtract(ERROR_STACK_BEGIN, TIME, 1) == FAIL) ?  FAIL :
	    EventExtract(ERROR_STACK_BEGIN, TIME, 1)/1000.);
	continue;
	}
     /* ***************************************************************	*/

     { int i = 0;			/* GET UNBLANK & FIX TIMES	*/
     while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 3 &&	/* Target 3?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 0)	/* UN-blank?	*/
           UnblankTime = EventExtract(TARGET_BLANK, TIME, i);
     i = 0;
     while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 1 &&	/* Target 1?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 1)	/* Blank?	*/
           FixOffTime = EventExtract(TARGET_BLANK, TIME, i);
     if (FixOffTime == FAIL) {	/* Old: turns off rather than blanking	*/
        i = 0;
        while (++i < 3)
          if (EventExtract(TARGET_OFF, ONE, i) == 1)   /* Target 1?	*/
             FixOffTime = EventExtract(TARGET_OFF, TIME, i);
        }
     }
     					/* HRF stack: no unblanks 	*/
     if (UnblankTime == FAIL && 
	 EventExtract(ERROR_STACK_BEGIN, TIME, 1) == FAIL) {
	FixOffTime = TargetTime;	/* Fix doesn't blank, either	*/
	if (StackNumber_Header() != 20 && (RunStatus_Header() == SUCCESS))
	   Warning("Is this right??? (should only be on HRF stack\n");
        }
     /* ***************************************************************	*/
     if (FixOffTime != FAIL &&
	   TimeRecorded(FixOffTime-1000-Get_AlignTime()+Get_ZeroTime(),
		   	FixOffTime     -Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(FixOffTime-1000-Get_AlignTime(),
			FixOffTime     -Get_AlignTime(),
			&FixPos_H, &FixPos_V);
     /* ***************************************************************	*/
		     
     Get_Saccade_Limited = 0;		/* GET SACCADE TIME		*/
     Get_Saccade_Stringent = 0;

     if (TimeRecorded(FixOffTime+150-Get_AlignTime()+Get_ZeroTime(),
	    	      FixOffTime+450-Get_AlignTime()+Get_ZeroTime())) {
        SacTime = Get_Saccade_Time(1,1,FixOffTime,0);
        
	/* Check if there was substantial movement	*/
        if (StackNumber_Header() != 19 &&
	    SacTime != FAIL &&
	    TimeRecorded(SacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SacTime+150-Get_AlignTime()+Get_ZeroTime())) {
             Get_EyePosition(SacTime+50- Get_AlignTime(), 
			SacTime+150-Get_AlignTime(), 
				&EyePos_H, &EyePos_V);
	   /* Check for little movement; try again ?	*/
           if ( sqrt(pow(EyePos_H-FixPos_H,2) + pow(EyePos_V-FixPos_V,2)) < 6)
              SacTime = Get_Saccade_Time(1,1,SacTime+100,0);
	   }


 	if (StackNumber_Header() == 16)		/* Human: bad data	*/
	   SecondSacTime = UnblankTime;		/*  Use unblank time	*/
	else if (StackNumber_Header() == 19)	/* Human: no unblanking!*/
	   SecondSacTime = 0;	  		/*  So no 2nd sac	*/
	else if (SacTime < (UnblankTime-500))
		/* 2nd sac WAY b4 unblank -- >= 2009 psychophys data	*/
           SecondSacTime = FixOffTime + 500;	/* We wait a long time!	*/
	else if (SacTime < UnblankTime) {	/* 2nd sac b4 unblank?	*/
           SecondSacTime = Get_Saccade_Time(1,0, UnblankTime, 0);
	   if (SacTime == FAIL || 	/* If no 1st, 2nd is pointless!	*/
	       SecondSacTime == FAIL ||	/* No 2nd: use '0' not FAIL	*/
	       SecondSacTime < SacTime+20) /* Preceeds 1st - ignore!	*/
              SecondSacTime = 0;
	   }
        }
     /* ***************************************************************	*/
	
     if (StackNumber_Header() == 19) {
        if (SacTime != FAIL && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SacTime+300- Get_AlignTime()+Get_ZeroTime(),
	    		SacTime+450-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SacTime+300- Get_AlignTime(), 
			SacTime+450-Get_AlignTime(), 
				&EyePos_H, &EyePos_V);
     } else
     if (SacTime != FAIL && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SacTime+50- Get_AlignTime(), 
			SacTime+150-Get_AlignTime(), 
				&EyePos_H, &EyePos_V);

     if (SecondSacTime != 0 && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SecondSacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SecondSacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SecondSacTime+50- Get_AlignTime(), 
			SecondSacTime+150-Get_AlignTime(), 
				&SecondEyePos_H, &SecondEyePos_V);

     AcqTime = EventExtract(ACQUIRE, TIME, LAST_OCCURRENCE); /* Final	*/
     /* Expect this to be AFTER the unblank.  If not, somethings odd.
      * In MR data, we used UnblankTime; in psychophys (MUCH earlier), we
      * should use the saccade after the final unblank. */
     if (AcqTime < UnblankTime - 400)	/* Acq is long before blank?	*/
           AcqTime = Get_Saccade_Time(1,1,UnblankTime,0) + 100;
	   	/* Psychophyics: use sac after final unblank instead	*/
      else if (AcqTime < UnblankTime)	/* Acq is a little before blank?*/
	 AcqTime = UnblankTime;		/* Use the unblank time instead	*/
      		/* MR: not sure why this occurs; can remove it??	*/


     if (AcqTime != FAIL &&
	   TimeRecorded(AcqTime+50 -Get_AlignTime()+Get_ZeroTime(),
	    		AcqTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(AcqTime+50- Get_AlignTime(),
			AcqTime+150-Get_AlignTime(), 
		     	&FinalEyePos_H, &FinalEyePos_V);

     /* ***************************************************************	*/

     fprintf(file, 				/* Print out the data	*/
   "%3d %2d %3d %3d %8.3f %3.1f %3.1f %5.1f %5.1f  %8.3f %4.1f %4.1f  %8.3f %8.3f %8.3f %8.3f  %6.2f %6.2f   %6.2f %6.2f  %6.2f %6.2f %8.3f\n", 
    	UnitNumber_Header(),
	RunNumber_Header(),
	TrialNumber_Header(),
	TrialNumber_Input(),
	TrialStartTime/1000.,

	/* Fixation target */
	TargetEventExtract(1, TWO, 1)/10.,
	TargetEventExtract(1, THREE, 1)/10.,

	/* Fixation position */
	FixPos_H, FixPos_V,

        (TargetTime==FAIL) ? FAIL : TargetTime/1000.,
        TargetEventExtract(3, TWO, 1)/10.,	/* 1st targ X coord	*/
        TargetEventExtract(3, THREE, 1)/10.,	/* Targ Y coord		*/

	FixOffTime/1000.,
	SacTime/1000.,
	SecondSacTime/1000.,
	UnblankTime/1000.,

	EyePos_H,
	EyePos_V,

	SecondEyePos_H,
	SecondEyePos_V,

	FinalEyePos_H,
	FinalEyePos_V,

	(EventExtract(ERROR_STACK_BEGIN, TIME, 1) == FAIL) ?  FAIL :
	    EventExtract(ERROR_STACK_BEGIN, TIME, 1)/1000.
	);
	}
fclose(file);
}
/* ******************************************************************** */

/* FUNCTION EventFileForMemory432 */
        /*writes time & location of target, saccades, etc 		*/
void EventFileForMemory432() {
  FILE *file;
  char file_name[80];
  int  DataWritten = (FrameCount_Header() > 0);

  char start_name[80];
  FILE *start_file;
  int  RunStartTime;

  Rewind_InputFile();
  if (Read_Next_Trial(SKIP_DATA) == 0)
  /* if ((StackNumber_Header() == 0) && RunNumber_Header()==0) */
     return;			/* None of requested stack or empty file*/

  sprintf(file_name, "Event.%c%d.%d.%d",
		(RunStatus_Header() == SUCCESS) ? 's' : 'f',
	       	UnitNumber_Header(), RunNumber_Header(),
		StackNumber_Header());
  file = fopen(file_name, (MACRO_APPENDS)?"a":"w");
  if (file == NULL)
     Exit ("Event file could not be opened", "macro 430"); 
	
  sprintf(start_name, "start.%d.%d",
	       	UnitNumber_Header(), RunNumber_Header());
  start_file = fopen(start_name, "r");
  if (start_file == NULL)
     Exit ("Start file could not be opened", "macro 430"); 
  fscanf(start_file, "%d", &RunStartTime);
  /* MUST HAVE PICKED THE CORRECT START TIME!! */

  Rewind_InputFile();
  while (Read_Next_Trial((DataWritten)? WITH_DATA:SKIP_DATA)) {
     int TrialStartTime =  (int) 1000 * Time_From_Header();

     int TargetTime = TargetEventExtract(3, TIME, 1);

     if (EventExtract(RESTART, TIME, 1) != FAIL)	/* Check!	*/
        Exit("RESTART in stack: times will be wrong", "mr macro");

     if (TargetTime == FAIL) {				/* No target!!	*/
	fprintf(file, "%.1f 1 1.0\n", (TrialStartTime - RunStartTime)/1000.);
	continue;
	}

        if (TargetTime != FAIL)
	   fprintf(file, "%.1f %d 1.0\n", 
			   (TargetTime - RunStartTime + TrialStartTime)/1000.,
			   2	);	/* Replace with side */
	}
fclose(file);
}
/* ******************************************************************** */
/* ********************************************************************	*/

/* FUNCTION MemorySaccades433 */
        /* report RT, error, etc */
void MemorySaccades433() {
  int  DataWritten = (FrameCount_Header() > 0);

  Rewind_InputFile();
  if (Read_Next_Trial(SKIP_DATA) == 0)
     return;

  fprintf(stderr, "        RT (vis?)   err final\n");
  Rewind_InputFile();
  while (Read_Next_Trial((DataWritten)? WITH_DATA:SKIP_DATA)) {
     int TargetTime = TargetEventExtract(3, TIME, 1);

     extern int Get_Saccade_Limited, Get_Saccade_Stringent;
     int AcqTime;
     int FixOffTime = FAIL;
     int SacTime = FAIL;
     int UnblankTime = FAIL;

     float EyePos_H=-99, EyePos_V=-99, FinalEyePos_H=-99, FinalEyePos_V=-99;

     if (TargetTime == FAIL) {				/* No target!!	*/
	fprintf(stderr, "%3d (%3d): no target; error at %d\n",
		TrialNumber_Header(),
		TrialNumber_Input(),
	    	EventExtract(ERROR_STACK_BEGIN, TIME, 1));
	continue;
	}

     /* ***************************************************************	*/

     { int i = 0;			/* GET UNBLANK & FIX TIMES	*/
     while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 3 &&	/* Target 3?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 0)	/* UN-blank?	*/
           UnblankTime = EventExtract(TARGET_BLANK, TIME, i);
     i = 0;
     while (++i < 10)
        if (EventExtract(TARGET_BLANK, ONE, i) == 1 &&	/* Target 1?	*/
	    EventExtract(TARGET_BLANK, TWO, i) == 1)	/* Blank?	*/
           FixOffTime = EventExtract(TARGET_BLANK, TIME, i);
     }
     /* ***************************************************************	*/

     Get_Saccade_Limited = 1;		/* GET SACCADE TIME		*/
     Get_Saccade_Stringent = 0;
     				/* 2nd to last acq - not the corrective	*/
     AcqTime = EventExtract(ACQUIRE, TIME, LAST_OCCURRENCE+1);

     if (EventExtract(ACQUIRE,THREE,LAST_OCCURRENCE+1) < 80)
	     		/* Bad window - thought he'd already acquired	*/
	   AcqTime += 300;	/* Start searching from 300 ms later	*/

     if (TimeRecorded(AcqTime-150-Get_AlignTime()+Get_ZeroTime(),
	    	      AcqTime+150-Get_AlignTime()+Get_ZeroTime()))
        SacTime = Get_Saccade_Time(1,1,FixOffTime,0); /* End of mem sac	*/
			/* Search BACKWARDS from 2nd to last acquire	*/
     /* ***************************************************************	*/

     if (SacTime != FAIL && 			/* GET EYE POSITIONS	*/
	   TimeRecorded(SacTime+50- Get_AlignTime()+Get_ZeroTime(),
	    		SacTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(SacTime+50- Get_AlignTime(), 
			SacTime+150-Get_AlignTime(), 
				&EyePos_H, &EyePos_V);

     AcqTime = EventExtract(ACQUIRE, TIME, LAST_OCCURRENCE); /* Final	*/
     if (AcqTime != FAIL &&
	   TimeRecorded(AcqTime+50 -Get_AlignTime()+Get_ZeroTime(),
	    		AcqTime+150-Get_AlignTime()+Get_ZeroTime()))
        Get_EyePosition(AcqTime+50- Get_AlignTime(),
			AcqTime+150-Get_AlignTime(), 
		     	&FinalEyePos_H, &FinalEyePos_V);
     /* ***************************************************************	*/
#    define square(x) ((x)*(x))

     fprintf(stderr, "%3d  %6d  %d  %5.1f %5.1f\n",
	TrialNumber_Input(),
	(SacTime == FAIL) ? -1 :
	 ((SacTime < UnblankTime) ? 
	  		SacTime - FixOffTime : SacTime - UnblankTime),
	 (SacTime < UnblankTime) ? 0 : 1,

	(EyePos_H == -99) ? 0. :
	 sqrt(
          square(TargetEventExtract(3, TWO, 1)/10. - EyePos_H) +
          square(TargetEventExtract(3, THREE, 1)/10. - EyePos_V)),

	(FinalEyePos_H == -99) ? 0. :
	 sqrt(
          square(TargetEventExtract(3, TWO, 1)/10. - FinalEyePos_H) +
          square(TargetEventExtract(3, THREE, 1)/10. - FinalEyePos_V))
	);
	}
}
/* ******************************************************************** */
