/* FILE events.c */
     /* Report times of events, more or less generically	*/
	/* Not yet in use */

#include "../Deffs.h"
#include "../../deffs.h"
#include <string.h>					/* strlen()	*/
#include "../../event.h"
/* ********************************************************************	*/

/* FUNCTION Blink410  */
	 /* Spit out blink times (re: the event in "-T")	*/
void Blink410() {
	FILE *file;
	char FileName[80];

	sprintf(FileName, "EventExtract.out");
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file", "Blink410()");

	Rewind_InputFile();
	while (Read_Next_Trial(WITH_DATA)) {
           int Base = EventExtract(
			   EventNameToNumber(Get_Title_From_CmdLine()),
			   TIME, 1);
	   extern BUTTONS Buttons[];
	   int buttons = ButtonCount_Header();
	   int i;

	   if (Buttons[0].value & 64)	/* Don't expect; but tell us!	*/
	       fprintf(file, "1000000 ");

	   for (i=1; i<buttons; i++)
	       if ((Buttons[i].value & 64) &&
		  !(Buttons[i-1].value & 64))
		  fprintf(file, "%d ", Buttons[i].time - Base);
	   }
	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Saccade411  */
	 /* Spit out saccade times (re: the event in "-T")	*/
void Saccade411() {
	FILE *file;
	char FileName[80];
	extern int Get_Saccade_Limited;
	extern int Get_Saccade_Stringent;

	sprintf(FileName, "EventExtract.out");
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file", "Saccade411()");

	Get_Saccade_Limited = 0;		/* Don't stop looking!	*/
	Get_Saccade_Stringent = 1;		/* Find *all* saccades!	*/
	Rewind_InputFile();

	while (Read_Next_Trial(WITH_DATA)) {
	   int time = EventExtract(TAPE_ON, TIME, 1) + 5;
	   int sac_start;

	   int Base = EventExtract(
		          EventNameToNumber(Get_Title_From_CmdLine()),
			  TIME, 1);

	   while ((sac_start = Get_Saccade_Time(1,1,time,0)) != FAIL) {
	        fprintf(file, "%d ", sac_start - Base);
	        time = Get_Saccade_Time(0,1,time,0) + 50; /* sac end+50	*/
		}
	   }
        fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION Pulse412  */
	 /* Spit out frame times (re: the event in "-T", & absolute)	*/
	/* Probably should pass it a line number and make it generic!	*/
	/* This is used with "frames.r" to count MR frames in the data	*/
void Pulse412() {
	FILE *file;
	char FileName[80];
	int  BaseEvent = -1;

	/* Bay 2 used inverted pulses (1->0 at start of frame) from 0 AD
	 * thru 2008-6-6.  Bay 3 used correct pulses.
	 * We didn't use Bay 3 until May 2008.
	 */

	int  SpecialCase1 =  /* Inverted logic on MR pulse, bay 2 pre 6-6-08 */
	   Year_From_Header() < 2008 ||			/* Pre 2008 or	*/
	   (			/* Not a human and older than 6-6-2008	*/
   	   !((MonkChar_Header() == 'H' || MonkChar_Header() == 'h')) &&
	    (Month_From_Header() < 7 || 
	      (Month_From_Header()==7 && Day_From_Header() < 7)));

	sprintf(FileName, "EventExtract.out");
	file = fopen(FileName, (MACRO_APPENDS)?"a":"w");

	if (file==NULL)
	   Exit("Err opening output file", "Blink412()");

	if (strlen(Get_Title_From_CmdLine()))
	   BaseEvent = EventNameToNumber(Get_Title_From_CmdLine());
	
	if (BaseEvent == FAIL)
	   Exit("Err finding base event", "Blink412()");

	if (ftell(file) == 0)
	   fprintf(file,
	          "event code run unit trial# seq  ms re: base   trial\n");

	Rewind_InputFile();

	if (UnitNumber_Header() > 0)	/* Any data recorded?	*/
	  fprintf(file, "%-8s  1   %3d  %3d  %3d  %3d       %8d     %8.3f\n",
			"Start",
			UnitNumber_Header(),
			RunNumber_Header(),
			TrialNumber_Header(),
			TrialNumber_Input(),
			RunStatus_Header() == SUCCESS,	/* -2 == success */
			Time_From_Header());

	while (Read_Next_Trial(WITH_DATA)) {
           int BaseTime = (BaseEvent == -1) ? 0 :
		          EventExtract(
			   EventNameToNumber(Get_Title_From_CmdLine()),
			   TIME, 1);
	   extern BUTTONS Buttons[];
	   int buttons = ButtonCount_Header();
	   int i;

	   for (i=1; i<buttons; i++)
	       if ((SpecialCase1) ?   /* Inverted logic: look for 1->0	*/
		     (Buttons[i-1].value & 01) && !(Buttons[i].value & 01) :
		     (Buttons[i].value & 01) && !(Buttons[i-1].value & 01))
	          fprintf(file,
			"%-8s  3   %3d  %3d  %3d  %3d       %8.3f   %8.3f\n",
			"Pulse",
			UnitNumber_Header(),
			RunNumber_Header(),
			TrialNumber_Header(),
			TrialNumber_Input(),
		  	(Buttons[i].time - BaseTime)/1000.,
		  	 Buttons[i].time/1000. + Time_From_Header()
			);
		  /* '3' is a numeric code for mr pulse	*/
	   }
	fclose(file);
	}
/* ********************************************************************	*/
