/* FILE _macros/memory/times.c */

#include "../Deffs.h"
#include "../../event.h"
#include <stdlib.h>					/* system()	*/

#define	LengthLong	15000		/* Write all to this length	*/
#define	DEBUG		0

/* ********************************************************************	*/
/* ********************************************************************	*/

static int Preferred(int PrefDirection) {
	 /* Accept only the actual class */
    int PrefTolerance = Get_oValue(1, 't', 30);

    int fixH = TargetEventExtract(1, TWO, 1);	/* First target #1 event*/
    int fixV = TargetEventExtract(1, THREE, 1);
    int sacH = TargetEventExtract(2, TWO, 1);	/* First target #2 event*/
    int sacV = TargetEventExtract(2, THREE, 1);

    float angle = atan2((double)sacV-fixV, (double) sacH-fixH);
    angle = angle * 360 / (2 * 3.1415);		/* rads -> deg		*/

    angle -= PrefDirection;

    while (angle > 180.)
        angle -= 360.;
    while (angle < -180.)
        angle += 360.;

    return(fabs(angle) <= PrefTolerance);   /* Less than tol from pref? */
    }
/* ********************************************************************	*/
/* FUNCTION Null */
	 /* Exclude any within 3 classes of preferred*/
static int Null(int PrefDirection) {
    int NullTolerance = Get_oValue(1, 'T', 90);

    int fixH = TargetEventExtract(1, TWO, 1);	/* First target #1 event*/
    int fixV = TargetEventExtract(1, THREE, 1);
    int sacH = TargetEventExtract(2, TWO, 1);	/* First target #2 event*/
    int sacV = TargetEventExtract(2, THREE, 1);
	    				
    float angle = atan2((double)sacV-fixV, (double) sacH-fixH);
    angle = angle * 360 / (2 * 3.1415);		/* rads -> deg		*/

    angle -= PrefDirection;

    while (angle > 180.)
        angle -= 360.;
    while (angle < -180.)
        angle += 360.;

    return(fabs(angle) > NullTolerance);    /* More than tol from pref?	*/
    }
/* ********************************************************************	*/

/* FUNCTION MemoryTimes42() */
	 /* Must align on target onset!
	  * -ob: binsize in ms
	  * -oo: offset in ms until start of first bin
	  * -op: p value (e.g., 95 means 95% chance of exceeding null)
	  * -od: pref direction in degrees
	  * -ot: tolerance: pref is "-op" +/- this many deg OR LESS
	  * -oT: alternate tolerance for null; "-op" +/- MORE THAN this
	  */
void MemoryTimes42() {
	FILE *file = fopen("macro42_R_input", "w");
	int TrialCountsNull = 0; 	/* Null trials			*/
	int SpikeCountsNull[1000];	/* counts per bin, all nulls	*/
	int SpikeCountsPref[1000];	/* counts per bin, one pref	*/
	int SpikeCountsCrit[1000];	/* # spikes for 'on'		*/
	int BinSize = Get_oValue(1, 'b', 2000);
	int Duration;
	int ZeroTime = Get_ZeroTime();
	int CheckStack = StackNumber_Header();
  	int i, j;
	char Name[80];
        int PrefDirection = Get_oValue(1, 'd', 1);	/* from call	*/

	{
	FILE *R_out = fopen("macro43_R_output", "r");
	static float FitDirection, FitSignif;

   	if (R_out==NULL) {
      	   fprintf(stderr, "Err opening R output file 43 for reading");
      	   Exit("", "Tuning42()");
      	   }
	fscanf(R_out, "%f %f", &FitDirection, &FitSignif);
	fclose(R_out);

	if (FitDirection < 0)
	    FitDirection += 2*3.14159;		/* Go from 0 to 2 pi	*/
	if (FitSignif < .15) {			/* NOTE THE CRITERION!!	*/
           if (!DEBUG)
	      fprintf(stderr, "Moving pref direction from %d to %d\n",
			   PrefDirection, (int)(0.5+57.3*FitDirection));
	   PrefDirection = (int) (0.5+57.3*FitDirection);
	 } else if (!DEBUG)
	      fprintf(stderr, "Bad fit\n");
	}

	Rewind_InputFile();		/* For consistent unit,run#	*/

	BinSize /= 8;	/* Offset by 1/8th width: need 8 times bins	*/

	Duration = EventExtract(TARGET_BLANK, TIME, 2) - ZeroTime;
	if (Duration > 14000)
	    Duration = 15000;
	 else if (Duration > 7000)
	    Duration = 7500;
	 else
	    Duration = 5000;

       	ZeroTime += Get_oValue(1, 'o', 0);	/* Add an offset?	*/

   	if (file==NULL) {
      	   fprintf(stderr, "Err opening tempfile");
      	   Exit("", "MemoryTimes42()");
      	   }

	if (DEBUG)
	   fprintf(stderr, "Null classes are: ");

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
  	   extern short Spikes[];
  	   int SpikeCount = SpikeCount_Header(-1);
  	   short *spikes  = Spikes;

	   if (StackNumber_Header() != CheckStack)
	      Exit("Can only have one stack (-Xs#)", "MemoryTimes42()");

	   if (!Null(PrefDirection))
	      continue;
	   if (DEBUG)
	      fprintf(stderr, "%d ", TableNumber_Header());

	   TrialCountsNull++;

	   i = 0;
           while (i++ < SpikeCount)	/* Find first spike after targ	*/
	       if ((int) *(spikes++) >= ZeroTime)
	          break;
	   i--;
	   spikes--;			/* Back up so use this spike	*/

           while (i++ < SpikeCount) {
	       int bin = ((int) *(spikes++) - ZeroTime)/BinSize;

	       if (bin >= Duration/BinSize)
		  break;

	       (*(SpikeCountsNull + bin))++;		/* Tally ho!	*/
	       }
	   }
	       
      	fprintf(file, "%d\n", Get_oValue(1, 'p', 99));
      	fprintf(file, "%d\n", TrialCountsNull);
	for (i=0; i<LengthLong/BinSize; i++)
      	   fprintf(file, "%d ", SpikeCountsNull[i]);
	fclose(file);

	system("R --vanilla -q --slave < /data/code/grab/2009.washu/_macros/memory/R_code.r > macro42_R_output");
	file = fopen("macro42_R_output", "r");	
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening output file");
      	   Exit("", "MemoryTimes42()");
      	   }

	/* LengthLong: use max memory duration, so all the same length	*/
	for (i=0; i<LengthLong/BinSize; i++)
	    fscanf(file, "%d", SpikeCountsCrit+i);

	Rewind_InputFile();		/* For consistent unit,run#	*/

	sprintf(Name, "Times.%d.%d.%d", 
			UnitNumber_Header(),
			RunNumber_Header(),
			Get_UnitChannel_Header());
	file = fopen(Name, "a");

	if (DEBUG)
	   fprintf(stderr, "\nPref are: ");
	/* Loop thru data again: */
	while (Read_Next_Trial(WITH_DATA)) {
  	   extern short Spikes[];
  	   int SpikeCount = SpikeCount_Header(-1);
  	   short *spikes  = Spikes;

	   if (!Preferred(PrefDirection))
	      continue;
	   if (DEBUG)
	      fprintf(stderr, "%d ", TableNumber_Header());

	   for (i=0; i<Duration/BinSize; i++)
	      SpikeCountsPref[i] = 0;		/* Zero out the data	*/

	   i = 0;
           while (i++ < SpikeCount)		/* Find first spike ...	*/
	       if ((int) *(spikes++) >= ZeroTime) /* after target onset	*/
	          break;
	   i--;
	   spikes--;				/* Back up, use 1st spk	*/

           while (i++ < SpikeCount) {
	       int bin = ((int) *(spikes++) - ZeroTime)/BinSize;

	       if (bin >= Duration/BinSize)
		  break;

	       (*(SpikeCountsPref + 1 + bin))++;	/* Tally ho!	*/
	       }

	   fprintf(file, "%d ", Duration);		/* Duration	*/

	   /* We group by 8, so lose last 7 -- cannot use them 		*/
	   for (i=0; i<Duration/BinSize-7; i++) {	/* First 'on'	*/
	       int SumOf8Bins = 0;
	       for (j=0; j<8; j++)
		   SumOf8Bins += SpikeCountsPref[i+j];
	       fprintf(file, "%d ", 
	         (SumOf8Bins >= SpikeCountsCrit[i]) ? 1 : 0);
	       }
	   while (i++ < (LengthLong/BinSize)-7)
	       fprintf(file, "2 ");
	   fprintf(file, "\n");
	   }

	if (DEBUG)
	   fprintf(stderr, "\n");
	fclose(file);
	system("rm macro42_R_input macro42_R_output");	/* clean-up	*/
	}
/* ********************************************************************	*/

/* FUNCTION GetTuning43() */
	 /* Writes two floats to a file: angle and signif */
void GetTuning43() {
	FILE *file = fopen("macro43_R_input", "w");
        extern int Spikes_In_Interval(int interval);

	Rewind_InputFile();		/* For consistent unit,run#	*/

   	if (file==NULL) {
      	   fprintf(stderr, "Err opening tempfile");
      	   Exit("", "Tuning43()");
      	   }

        while (Read_Next_Trial(WITH_DATA)) {
	   int fixH = TargetEventExtract(1, TWO, 1);	/* 1st target #1 event*/
	   int fixV = TargetEventExtract(1, THREE, 1);
	   int sacH = TargetEventExtract(2, TWO, 1);	/* 1st target #2 event*/
	   int sacV = TargetEventExtract(2, THREE, 1);
	   fprintf(file, "%.2f %d\n",
    		atan2((double)sacV-fixV, (double) sacH-fixH),
		Spikes_In_Interval(1));
	   }
	fclose(file);
	Rewind_InputFile();		/* For consistent unit,run#	*/
	       
	system("R --vanilla -q --slave < /data/code/grab/2009.washu/_macros/memory/R_code43.r > macro43_R_output");

	system("rm macro43_R_input");		/* clean-up	*/
	/* system("rm macro43_R_output");		* clean-up	*/
	}
/* ********************************************************************	*/
