/* FILE _macros/memory/sort.c */

#include "../Deffs.h"
#include "../../event.h"
#include <stdlib.h>

/* ********************************************************************	*/

/* FUNCTION SortByTarget44 */
         /* Change class number and rewrite (use only with -w- flag)	*/
         /* Unlike other macros, already in Read_Next_Trial() iteration	*/
	 /* Recode class numbers based on target angle			*/
void SortByTarget44() {
   int TargetNth = Get_oValue(1,'t',1);		/* Nth target to appear	*/
   int FixateNth = Get_oValue(1,'f',0);		/* Start (fix) target	*/
   int TargetID  = Get_oValue(1,'T',-1);	/*  of target# == this	*/
   int FixateID  = Get_oValue(1,'F',0);
   int Classes   = Get_oValue(1,'C',8);		/* Default: 8 classes	*/
   int CenterDirection = Get_oValue(1,'c',0);		/* Default: 8 classes	*/

   int h = TargetEventExtract(TargetID, TWO,   TargetNth);
   int v = TargetEventExtract(TargetID, THREE, TargetNth);

   if (FixateNth || FixateID) {
      if (FixateNth == 0)
          FixateNth = 1;
      if (FixateID == 0)
          FixateID = -1;
      h -= TargetEventExtract(FixateID, TWO,   FixateNth);
      v -= TargetEventExtract(FixateID, THREE, FixateNth);
      }

   Set_ClassNumber_Header(
           ((int) round(((atan2(v,h)                /* Angle: -pi to pi */
            - (CenterDirection / 10 * 3.14159 / 180))    /* Center on given direciton */
            / (2*3.14159)) * Classes * -1)          /* Bin classes, going CW */
            + 2 * Classes) % Classes                /* Wrap to 0 to CLASSES-1 */
           + 1);                                    /* Shift range to 1:CLASSES */

   }
/* ********************************************************************	*/
