/* FILE _macros/memory/extract.c */

#include "../Deffs.h"
#include "../../event.h"

#define DEBUG 0

/* ********************************************************************	*/
/* ********************************************************************	*/

/* FUNCTION MemoryExtract40() */
void MemoryExtract40() {
	FILE *file;
	char Name[80];
	int  PrevPostTrialTime = 0;

	Rewind_InputFile();		/* For consistent unit,run#	*/
   	sprintf(Name, "MemoryTiming.out");
   	file = fopen(Name, (MACRO_APPENDS)?"a":"w");
   	if (file==NULL) {
      	   fprintf(stderr, "Err opening %s", Name);
      	   Exit("", "MemoryExtract40()");
      	   }

	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   int TargetTime = AnyTargetEventExtract(TIME, 2);
	   int GoCue = EventExtract(TARGET_BLANK, TIME, 1);
	   int EndTrial = EventExtract(END_STACK, TIME, 1);

	   int TargetNumber = AnyTargetEventExtract(ONE, 2);
	   int BlankTargetNumber = EventExtract(TARGET_BLANK, ONE, 1);

	   if (TargetTime == FAIL || GoCue == FAIL || EndTrial == FAIL) {
      	      fprintf(stderr,"Item not found");
      	      Exit("", "MemoryExtract40()");
      	      }

	   if (TargetNumber == BlankTargetNumber)
	      GoCue = EventExtract(TARGET_BLANK, TIME, 2);
				
	   fprintf(file, "%d %d %d %d   %d  %d\n", 
		UnitNumber_Header(),
		RunNumber_Header(), 
		TrialNumber_Header(),
		TrialNumber_Input(), 
		GoCue - TargetTime,
		TargetTime + PrevPostTrialTime);

	   PrevPostTrialTime = EndTrial - GoCue;
	   }

	fclose(file);
	}
/* ********************************************************************	*/

/* FUNCTION MemoryOnOff41() */
	 /* Criterion rate on -or, criterion time interval on -ot	*/
void MemoryOnOff41() {
	FILE *file;
	int  Criterion = Get_oValue(1, 'r', 40);	 /* -or (sp/s)	*/
	int  Interval  = Get_oValue(1, 't', 100);	 /* -ot (ms)	*/
	int  StepSize  = Get_oValue(1, 's', 100);	 /* -os (ms)	*/

	Rewind_InputFile();		/* For consistent unit,run#	*/

   	file = Open_Macro_Output("MemoryOnOff", 1);

	fprintf(file, "%d %d   %d %d %d\n", 
		UnitNumber_Header(),
		RunNumber_Header(), 
		Criterion,
		Interval,
		StepSize);

	Criterion *= (Interval/1000.); /* Convert from sp/s to spikes*/


	/* Loop thru data: */
	while (Read_Next_Trial(WITH_DATA)) {
	   int TargetTime = AnyTargetEventExtract(TIME, 2);
	   int GoCue = EventExtract(TARGET_BLANK, TIME, 1);
	   int EndTrial = EventExtract(END_STACK, TIME, 1);

	   int TargetNumber = AnyTargetEventExtract(ONE, 2);
	   int BlankTargetNumber = EventExtract(TARGET_BLANK, ONE, 1);

           extern short Spikes[];
	   int SpikeCount = SpikeCount_Header(-1);  /* -1: selected channel */
	   short *spike_end = Spikes + SpikeCount;
	   short *spike_start = Spikes;

	   int time_start;

	   if (TargetTime == FAIL || GoCue == FAIL || EndTrial == FAIL) {
      	      fprintf(stderr,"Item not found");
      	      Exit("", "MemoryExtract40()");
      	      }

	   if (TargetNumber == BlankTargetNumber)
	      GoCue = EventExtract(TARGET_BLANK, TIME, 2);

	   fprintf(file, "%d %d  ", 
		TrialNumber_Header(),
		TrialNumber_Input());

	   /* Look between TargetTime and GoCue for stretches of firing
	    * rate that exceed Criterion */
	   for (time_start = TargetTime; 
		time_start < GoCue - Interval;
		time_start += StepSize) {	/* Every StepSize ms	*/

		int time_end = time_start + Interval;
		int count = 0;
	        short *spikes = spike_start;	/* Efficient: start here*/

		while (spikes <= spike_end) {	/* Stop at last spike	*/
		    if (*spikes > time_end)	/* Stop if spiketime is	*/
		        break;	/* beyond the end of current interval	*/
		    if (*spikes >= time_start) {/* Within the interval?	*/
		       count++;			/* Tally it		*/
		       if (count == 1)		/* First one?		*/
			  spike_start = spikes; /* Efficient to save it	*/
		       }
		    spikes++;			/* Go to next spike	*/
		    }
	       if (count > Criterion)
	          fprintf(file, "%d ", time_start-TargetTime);
#	       if (DEBUG)
	          fprintf(file, "%d:%d ", time_start-TargetTime, count);
#	       endif
 
	       }
	   fprintf(file, "\n");			/* End of trial		*/
	   }

	fclose(file);
	}
/* ********************************************************************	*/
/* ********************************************************************	*/
