# R_code43.r

#   Fit a von Mises to synthesized data; compare to a flat line; show fits

options(echo=F)
options(warn=1)		# Print them all!

data <- matrix(scan("macro43_R_input", quiet=T), ncol=2, byrow=T)
angle = data[,1]
rate  = data[,2]

options(show.error.messages = F)

fit0 = try(nls(
  formula = rate ~ base + peak * cos(angle - mid),
  lower=c(0,0,-100),
  algorithm="port",
  start=list(base=10,peak=10,mid=0)
  ))

CosinePref = ifelse(class(fit0) == "try-error", 0, coef(fit0)[3])

fit1 = try(nls(
  formula = rate ~ base + peak * 
  			exp(k*cos(angle-mid))/(2*pi*besselI(k,0)),
  lower=c(0,0,0,-100),
  algorithm="port",
  start=list(base=10,peak=10,k=1,mid=CosinePref)
  ))

# if (class(fit1) == "try-error") {
#     cat("Angles:", round(angle*57.3), "\n")
#     cat("Rates:",  rate, "\n")
#     }

fit2 = try(nls(
  formula = rate ~ base,
  start=list(base=12)
  ))

options(show.error.messages = T)

# print(coef(summary(fit1)))
# print(anova(fit1, fit2))

cat(
    ifelse(class(fit1)=="try-error", -9999, coef(fit1)[4]),
    ifelse(class(fit1)=="try-error" |
	   class(fit2)=="try-error", 10, anova(fit1,fit2)[[6]][2]),
    "\n")
