# R_code.r

# Tricky part: divide bins in 8ths, have to combine them here

options(echo=F)
options(warn=1)		# Print them all!


#  Code to do poisson on/off determination

# What p-value to use?  (convert percent to fraction)
P.value  <- scan("macro42_R_input", quiet=T, skip=0, nlines=1) / 100

# How many trials?
Trials <- scan("macro42_R_input", quiet=T, skip=1, nlines=1)

# How many spikes in each bin?
Spikes <- scan("macro42_R_input", quiet=T, skip=2)

Criterion = rep(NA, length(Spikes))

for (i in 1:(length(Spikes)-7))	 # Group by 8's, so lose last 7
   if (Trials) {
      # if (sum(Spikes[i:(i+8)]) > 10000 || sum(Spikes[i:(i+8)]) < 0) {
      #     warning("Spike overflow!\n")
      # 	  }
      cat(qpois(P.value, sum(Spikes[i:(i+8)])/Trials), " ")
    } else
      cat("-2 ")		# no data
    # Compute based on the sum of 8 adjacent bins
cat("\n")
