function [stamps, start_time, trial_type, stack, class] = read_trial_file(trial_file)
%Load Data from grab-generated trial file.
%
%   Input: 
%       trial_file = file with data for each trial.
%
%   Output:	
%       stamps =  trial stamp for each trial
%		start_time = start time for each trial
%		trial_type = trial type for each trial, e.g. class/stack)
%       stack = stack number for each trial
%       class = class number for each trial
%

fid = fopen(char(trial_file));
TrialData = textscan(fid,'%f %f %f %f %f', 'HeaderLines', 1);
fclose(fid);

stamps = TrialData{1};
start_time = TrialData{2};
trial_type = TrialData{3};
stack = TrialData{4};
class = TrialData{5};
