function [Params] = read_params(suffix);
% Reads parameters passed by grab
%

param_file = ['Parameters', suffix];
if ~isfile(param_file)
    error('Params file does not exist!!')
end

fid = fopen(param_file);
data_lines = textscan(fid,'%s','Delimiter','\n');
fclose(fid);
if numel(data_lines{1}) ~= 3
    error('Expecting 3 lines in Parameters.temp!!');
end

Params.command_line   = data_lines{1}{1};
Params.data_directory = data_lines{1}{2};
Params.params_str     = data_lines{1}{3};
Params.trial_file     = ['TrialData', suffix];
Params.spike_file     = ['SpikeData', suffix];

param_vals             = textscan(Params.params_str, '%f');
Params.version         = param_vals{1}(1);
Params.interval_start  = param_vals{1}(2);
Params.interval_end    = param_vals{1}(3);
Params.time_interval   = Params.interval_end - Params.interval_start + 1;
Params.time_1          = param_vals{1}(4);
Params.time_2          = param_vals{1}(5);
Params.filter          = param_vals{1}(6);
Params.electrode_1     = param_vals{1}(7);
Params.electrode_2     = param_vals{1}(8);
Params.freq_start_1    = param_vals{1}(9);
Params.freq_end_1      = param_vals{1}(10);
Params.freq_step_1     = param_vals{1}(11);
Params.alpha_plex      = param_vals{1}(12);
Params.hemisphere      = param_vals{1}(13);
Params.freq_start_2    = param_vals{1}(14);
Params.freq_end_2      = param_vals{1}(15);
Params.freq_step_2     = param_vals{1}(16);
Params.remove_mean     = param_vals{1}(17);
Params.thin_spikes     = param_vals{1}(18);
Params.n_spike_limit   = param_vals{1}(19);
Params.seed_rng        = param_vals{1}(20);
Params.chronux         = param_vals{1}(21);

% Sanity checks
if Params.filter ~= 0
    error('FILTER value (-ol) is not zero. This should not happen!');
end
if not(any(Params.remove_mean == [0, 1]))
    error('REMOVE MEAN value (-oe) is not 0 or 1. This should not happen!');
    % TODO: Consider if we want to re-implement other cases.
    %   Case 2: Return just the evoked (by trial type).
    %   Case 3: Remove evoked by trial type.
end

