function phasePairLFP(suffix)
% Phase Pair LFP:
%	LFP-LFP Pairwise Phase Consistency
%  

    % Read parameters
    Params = read_params(suffix);
    freq = Params.freq_start_1 : Params.freq_step_1 : Params.freq_end_1;
    time_window = Params.time_1;
    time_step = time_window / 4;
    TW = Params.freq_start_2 / 10;
    n_tapers = floor(2 * TW - 1);
    
    % Load lfp data.
    [lfps_1, fs, trial_type] =  ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1, [],    ...
                      Params.remove_mean);
    lfps_2 = load_lfps(Params.data_directory, Params.command_line,   ...
                       Params.trial_file, Params.time_interval,      ...
                       Params.alpha_plex, Params.electrode_2, [],     ...
                       Params.remove_mean);

    % Get all trial types and trial counts for each type.
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % fieldtrip implementation (added by JK) - 2021-02-28
    if contains(Params.command_line, '-oC-2') %'-oC-2' flag means fieldtrip implementation
	addpath('/data/code/grab/2018/_macros/lfp/packages/fieldtrip-20200310');
        % Setting up cfg 
        % Using scripts from example in fieldtrip to set up cfg:
	for i_type = 1:numel(type_list)
	cur_type = type_list(i_type); % current type

        %simcfg.ntrials     = size(trial_type(trial_type==cur_stack),1); % number of trials
	cur_trials = find(trial_type==cur_type);
	
	%setting up simcfg
        simcfg             = [];
	simcfg.ntrials     = numel(cur_trials); % number of trials
        simcfg.triallength = size(lfps_1,2)/1000; % time in seconds
        simcfg.fsample     = 1000; % 1000 Hz
        simcfg.nsignal     = 2;
        simcfg.method      = 'ar';
        %mu                 = 0.5;
        absnoise           = [1 1];
        simcfg.params(:,:,1) = [1 0;
                                0 1];
        simcfg.noisecov      = diag(absnoise.^2);
        cur_data = ft_connectivitysimulation(simcfg);
        cur_lfps_1 = lfps_1(cur_trials,:);
        cur_lfps_2 = lfps_2(cur_trials,:);
        for trial_ind = 1:numel(cur_trials)
            cur_data.trial{trial_ind}(1,:) = cur_lfps_1(trial_ind,:);
            cur_data.trial{trial_ind}(2,:) = cur_lfps_2(trial_ind,:);
        end
        
	% setting up freq variable (frequency analysis)
        freq                   = [];
        freq.freqcfg           = [];
        freq.freqcfg.method    = 'mtmfft';
        freq.freqcfg.output    = 'fourier';
        freq.freqcfg.tapsmofrq = 2;
        freqdata1           = ft_freqanalysis(freq.freqcfg, cur_data);
        
	% setting up ppc_cfg
	ppc_cfg =[];
        ppc_cfg.method = 'ppc';
        
        ppc_data =[];
        ppc_data.ppc_reg = ft_connectivityanalysis(ppc_cfg, freqdata1);
        ppc_val=ppc_data.ppc_reg.ppcspctrm(1,2,:);
	ppc_val=ppc_val(:);
	
	freq_out{i_type} = ppc_data.ppc_reg.freq(1:150);
	ppc_out{i_type} = ppc_val(1:150);
	end
   
       	% Output data
       	fid = fopen(['data', suffix], 'w');
    	fprintf(fid, '%s\n', char(Params.command_line));
    	fprintf(fid, '%s\n', Params.data_directory);
   	fprintf(fid, '%s\n', Params.params_str);
    	fprintf(fid, '%s\n', sprintf('%d ', n_trials));
        fprintf(fid, '%s\n', sprintf('%g ', freq_out{1}(:)));
        for i_type = 1:numel(type_list)
		    fprintf(fid, '%s\n',    ...
                    sprintf('%1.10f ', ppc_out{i_type}(:)));

	end 

    else
    % Spectra, cross-spectra, and phase differences
    S1 = mt_dtft_gram(lfps_1, fs, time_window, time_step, freq, TW, n_tapers);
    S2 = mt_dtft_gram(lfps_2, fs, time_window, time_step, freq, TW, n_tapers);
    S12 = mean(S1 .* conj(S2), 4);
    phase_diff = angle(S12);

    for i_type = 1:numel(type_list)
        these_phase_diff = phase_diff(trial_type == type_list(i_type), :, :);
        ppc_vals(i_type, :, :) = 1 - var(cos(these_phase_diff), [], 1)  ...
                                   - var(sin(these_phase_diff), [], 1);
        % Equation from supplement of Kornblith et al. 2016 
        %   (doi: 10.1093/cercor/bhv182).
    end

    % Output data
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%s\n', sprintf('%d ', n_trials));
	for i_type = 1:size(ppc_vals, 1)
		for i_freq = 1:size(ppc_vals, 2)
			fprintf(fid, '%s\n', sprintf('%g ', ppc_vals(i_type, i_freq, :)));
		end
	end
    end
	fclose(fid);

end
