function grangerLFP(suffix)
% LFP COHERENCE - Compute LFP-LFP coherence for given time and 
%       frequency values.
%

    % CDH - added this so it does nothing.
    % return

    % Read parameters
    Params = read_params(suffix);
    freq = Params.freq_start_1 : Params.freq_step_1 : Params.freq_end_1;
    time_window = Params.time_1;
    time_step = time_window / 4;
    TW = Params.freq_start_2 / 10;
    n_tapers = floor(2 * TW - 1);

    % Load lfp data
     %[lfps_1, fs, trial_type] =  ... 
     [lfps_1, fs, trial_type, ~, class] =  ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1, [],    ...
                      Params.remove_mean);
    lfps_2 = load_lfps(Params.data_directory, Params.command_line,  ...
                       Params.trial_file, Params.time_interval,     ...
                       Params.alpha_plex, Params.electrode_2, [],   ...
                       Params.remove_mean);
 	
%	keyboard;	       
	
	% flip trial orders of lfps_1, lfps_2, and trial_type
   	%save('olddata.mat');
   	flip_trials = 0;
	if flip_trials
	lfps_1 = flipud(lfps_1); trial_type = flipud(trial_type);
   	lfps_2 = flipud(lfps_2);
	end
	%save('newdata.mat');
	
	%-os2: shuffle trial_type (stack numbers)
	if contains(Params.command_line,'-os2')
	%shuffle_trial_type = 0;
	%if shuffle_trial_type
	rng('shuffle');
	trial_type = trial_type(randperm(numel(trial_type)));
	end

	%-os4: shuffle reach trials only
	if contains(Params.command_line,'-os4')
	rng('shuffle');
	reach_trials_ind = find(trial_type~=62);
	shuffle_reach_trials_ind = reach_trials_ind(randperm(numel(reach_trials_ind)));
	trial_type(trial_type~=62)=trial_type(shuffle_reach_trials_ind);
	end

	%flip time of each trial
	flip_time = 0;
	if flip_time
    	lfps_1 = fliplr(lfps_1); lfps_2 = fliplr(lfps_2);
    	end
    	
	% Get all trial types (they are stack numbers for now)
    	type_list = unique(trial_type);
	class_list = unique(class);

        %-os5: In each stack, shuffle classes
	if contains(Params.command_line,'-os5')
	for i_type = 1:numel(type_list)
		cur_stack = type_list(i_type); % current stack
		cur_stack_trials_ind = find((trial_type==cur_stack));
		% shuffle classes that belong to the current stack
		rng('shuffle');
		shuffle_cur_stack_trials_ind = cur_stack_trials_ind(randperm(numel(cur_stack_trials_ind)));
		class(cur_stack_trials_ind) = class(shuffle_cur_stack_trials_ind); % shuffle classes
	end
	end

	%-os6: shuffle classes (without looking at stack numbers)
	if contains(Params.command_line,'-os6')
	rng('shuffle');
	class = class(randperm(numel(class)));
	end

	% re-assign trial_type so that it will be unique values for each stack and class	
	trial_type_counter = 1;
	for i_type =1:numel(type_list)
		cur_stack = type_list(i_type); % current stack
		cur_stack_unique_classes = unique(class(trial_type==cur_stack));
		for class_type = 1:numel(cur_stack_unique_classes)
		trial_type(trial_type==cur_stack&class==(cur_stack_unique_classes(class_type)))=trial_type_counter;
		trial_type_counter = trial_type_counter+1;
		end
	end

    	
	% -os7: collapse stacks and compute Granger by each class
	if contains(Params.command_line,'-os7')
	trial_type = class; % if -os7, stacks are meaningless, so trial_type is defined by class
	end
    
	% Get all trial types and trial counts for each type.
    	type_list = unique(trial_type);
	n_trials = arrayfun(@(x) sum(trial_type == x), type_list);
	
    % TODO: Need to add lines to truncate trials; 
    % currently it just says it's truncating and doing nothing
    % Remove excess trials if some trial type has more than others.
%     if max(n_trials) ~= min(n_trials)
%         disp(sprintf('Truncating trial count from max of %u to %u', ...
%                      max(n_trials), min(n_trials)));
%         return
%     end

    % Lines for Chronux (commented out)
    % Generate spectral estimates
%    if Params.chronux == 1
%
%        addpath(genpath(['/data/code/grab/2018/_macros/lfp/chronux_2_12/',  ...
%                         'spectral_analysis']))

        % Set up chronux parameters, which use sec and Hz for all values.
%        movingwin = [time_window, time_step] / 1e3;
%        Params_Chronux.tapers = [TW, n_tapers];
%        Params_Chronux.Fs = fs * 1e3;
%        Params_Chronux.fpass = freq([1, end]);
%        Params_Chronux.trialave = 1;

        % Compute average by trial type.
%        for i_type = 1:numel(type_list)
%            is_type = trial_type == type_list(i_type);
%            [C, phi, ~, ~, ~, ~, freq_out] =    ...
%                    cohgramc(lfps_1(is_type, :).', lfps_2(is_type, :).',    ...
%                             movingwin, Params_Chronux);
%            coh_mag(i_type, :, :) = C.';    % Type x Freq x Time
%            coh_angle(i_type, :, :) = phi.';
%        end

%    else

        
        % adding lines for granger LFP using fieldtrip
        addpath('/data/code/grab/2018/_macros/lfp/packages/fieldtrip-20200310');

        % Setting up cfg 
        % Using scripts from example in fieldtrip to set up cfg:
	% http://www.fieldtriptoolbox.org/example/connectivity_conditional_granger/

        
        % Compute granger causality by trial type.	
        for i_type = 1:numel(type_list)
       	cur_type = type_list(i_type); % current type

	simcfg             = []; 
        %simcfg.ntrials     = size(trial_type(trial_type==cur_stack),1); % number of trials
        
        cur_trials = find(trial_type==cur_type);
        %cur_classes = class(trial_type==cur_stack);
	
	half_trials = 0; % 1: use only half trials 0: use all trials
        if half_trials
            cur_trials = cur_trials(1:round(numel(cur_trials)/2));
        else
        end
	% -os3: shuffle_trials within each stack
	%shuffle_trials = 0; % 1: shuffle trials 0: don't shuffle trials
	if contains(Params.command_line,'-os3')
	%if shuffle_trials
	    rng('shuffle');   % LHS 2020-09-20 -- matlab is idiotic
	    cur_trials_1 = cur_trials(randperm(numel(cur_trials)));
	    cur_trials_2 = cur_trials(randperm(numel(cur_trials)));
	end
        
	% TO BE UPDATED
	%-os7: shuffle classes and merge them into Right and Left
	%if contains(Params.command_line,'-os7')
	%rng('shuffle');
	%cur_classes = cur_classes(randperm(numel(cur_classes)));
	%right_classes = 	
	%-os8: shuffle classes and merge them into Up and Down
	%elseif contains(Params.command_line,'-os8')
	%rng('shuffle');
	%cur_classes = cur_classes(randperm(numel(cur_classes)));
	%else
	%end

	simcfg.ntrials     = numel(cur_trials); % number of trials

	simcfg.triallength = size(lfps_1,2)/1000; % time in seconds
        simcfg.fsample     = 1000; % 1000 Hz
        simcfg.nsignal     = 2;
        simcfg.method      = 'ar';
           
        %mu                 = 0.5;
        absnoise           = [1 1];
        simcfg.params(:,:,1) = [1 0;
                                0 1];
        simcfg.noisecov      = diag(absnoise.^2);
        
        cur_data = ft_connectivitysimulation(simcfg);
        %cur_lfps_1 = lfps_1(trial_type==cur_stack,:);
        %cur_lfps_2 = lfps_2(trial_type==cur_stack,:);
        cur_lfps_1 = lfps_1(cur_trials,:);
        cur_lfps_2 = lfps_2(cur_trials,:);
	
	
	if contains(Params.command_line,'-os3')
	%if shuffle_trials 
	cur_lfps_1 = lfps_1(cur_trials_1,:);
	cur_lfps_2 = lfps_2(cur_trials_2,:);
	end
	% replace cur_data.trial with current dataset
        %for trial_ind = 1:size(trial_type(trial_type==cur_stack),1)
        %    cur_data.trial{trial_ind}(1,:) = cur_lfps_1(trial_ind,:);
        %    cur_data.trial{trial_ind}(2,:) = cur_lfps_2(trial_ind,:);
        %end
	for trial_ind = 1:numel(cur_trials)
            cur_data.trial{trial_ind}(1,:) = cur_lfps_1(trial_ind,:);
            cur_data.trial{trial_ind}(2,:) = cur_lfps_2(trial_ind,:);
        end

        % data: .trial .time .label 
        
        
        % setting up freq variable (frequency analysis)
        freq                   = [];
        freq.freqcfg           = [];
        freq.freqcfg.method    = 'mtmfft';
        freq.freqcfg.output    = 'fourier';
        freq.freqcfg.tapsmofrq = 2;
        freqdata1           = ft_freqanalysis(freq.freqcfg, cur_data);
        %freqdata2           = ft_freqanalysis(freq.freqcfg, data2);
        
        % setting up 'grangercfg' variable (granger)
        grangercfg = [];
        grangercfg.method  = 'granger';
        grangercfg.granger.conditional = 'no';
        grangercfg.granger.sfmethod = 'bivariate';
        
        gdata = [];
        gdata.g1_bivar_reg      = ft_connectivityanalysis(grangercfg, freqdata1);
        %gdata.g2_bivar_reg      = ft_connectivityanalysis(grangercfg, freqdata2);
	granger_out{i_type} = gdata.g1_bivar_reg.grangerspctrm(1,1:150); % cur_lfps_1 --> cur_lfps_2
        %granger_out2 = gdata.g1_bivar_reg.grangerspctrm(2,:);
        % frequency to print out
	freq_out{i_type} = gdata.g1_bivar_reg.freq(1:150);
	end

	% lines for plotting (testing)
        % figure; hold on;
        % plot(gdata.g1_bivar_reg.freq(1,1:150), ...
        %    gdata.g1_bivar_reg.grangerspctrm(1,1:150),'b');
        % xlabel('Freq (Hz)'); ylabel ('GC'); ylim([0 0.45]);
	% saveas(gcf,'cur_granger_fig.pdf');
	 %keyboard;        

	% Lines for in-house lfp-lfp coherence; commented out
	% Spectra
%        S1 = mt_dtft_gram(lfps_1, fs, time_window, time_step, freq, TW,     ...
%                          n_tapers);
%        S2 = mt_dtft_gram(lfps_2, fs, time_window, time_step, freq, TW,     ...
%                          n_tapers);
%        freq_out = freq;

        % Cross- and auto-spectra.
%        S12 = mean(S1 .* conj(S2), 4);
%        S11 = mean(abs(S1) .^ 2, 4);
%        S22 = mean(abs(S2) .^ 2, 4);

        % Average by trial type
%        for i_type = 1:numel(type_list)
%            is_type = trial_type == type_list(i_type);
%            for i_freq = 1:numel(freq_out)
%                S12_mean = mean(S12(is_type, i_freq, :), 1);
%                S11_mean = mean(S11(is_type, i_freq, :), 1);
%                S22_mean = mean(S22(is_type, i_freq, :), 1);
%                coh(i_type, i_freq, :) = S12_mean   ...
%                                         ./ sqrt(S11_mean .* S22_mean);
%            end
%        end

        % Break down into magnitude and angle
%        coh_mag = abs(coh);
%        coh_angle = angle(coh);
%    end

    % Output data
    fid = fopen(['data', suffix], 'w');
    fprintf(fid, '%s\n', char(Params.command_line));
    fprintf(fid, '%s\n', Params.data_directory);
    fprintf(fid, '%s\n', Params.params_str);
    fprintf(fid, '%s\n', sprintf('%d ', n_trials));
    %for i_type = 1:numel(type_list)
    for i_type = 1 %printing only the first line (because all freq outputs are same)
    	fprintf(fid, '%s\n', sprintf('%g ', freq_out{i_type}(:)));
    %keyboard;
    end
    %for i_type = 1:size(coh_mag, 1)
    for i_type = 1:numel(type_list)
	    %for i_freq = 1:size(coh_mag, 2)
            
            fprintf(fid, '%s\n',    ...
                    sprintf('%1.10f ', granger_out{i_type}(:)));


            %for cohLFP (commented out)		    
            %fprintf(fid, '%s\n',    ...
            %        sprintf('%1.10f ', coh_mag(i_type, i_freq, :)));
            %fprintf(fid, '%s\n',    ...
            %        sprintf('%3.5f ', rad2deg(coh_angle(i_type, i_freq, :))));
            %end
    end
    fclose(fid);
    %keyboard;
end
