% LFP SINGLE TRIAL POWER
function powerTrialsLFP(suffix)
%
%


% Turn off warnings
%warning off all

% Import Parameters
Params = readParams(suffix);

% Parse relevant params
freqArray  = Params.freqStart1:Params.freqStep1:Params.freqEnd1;
timeWindow = double(Params.time1);
timeStep   = timeWindow/4; 
evoked     = Params.evoked;
TW         = Params.freqStart2 / 10;

% Read data
[lfpTrials,fsLfp,trialType,~,trialNum] = ...
        readAndProcessLFPData(Params.datadirectory,Params.commandline{1},   ...
                              Params.trialfile,Params.timeInterval,         ...
                              Params.alphaPlex,Params.electrode1);

% Get all trial types and count nTrials
typelist = unique(trialType);
for iType = 1:length(typelist)
    nTrials(iType) = sum(trialType==typelist(iType));
end

% Handle stimulus locked response
[lfpTrials,trialType] = lfpLockedAndInduced(lfpTrials,trialType,evoked);

% Compute power spectrum, then average power per spectrum
specgram    = specgramMtm(lfpTrials,fsLfp*1e3,timeWindow,timeStep,freqArray, ...
                          'pow',TW);
powerTrials = mean(mean(specgram,3),2); 

%%%% DATA OUTPUT %%%%
fid = fopen(['data', suffix],'w');
fprintf(fid,'%s\n',char(Params.commandline{1}));
fprintf(fid,'%s\n',Params.datadirectory);
fprintf(fid,'%s\n',Params.paramsstr);
fprintf(fid,'\n');
for iTrial = 1:length(powerTrials)
    fprintf(fid,'%d %d %f\n',trialNum(iTrial), trialType(iTrial), ...
            powerTrials(iTrial));
end
