function powTraceLFP(suffix)
% LFP POWER - BURSTS
%   Find bursts in power.
%       Criteria:  Must exceed 2 sd of trial mean for 3+ cycles.
%       Burst def: Half-max to half-max.
%

% AUTHOR: Charles D Holmes
% EMAIL:  chuck@eye-hand.wustl.edu
%

% Turn off warnings
%warning off all

% Import Parameters
Params = readParams(suffix);

% Parse relevant params
freqArray  = Params.freqStart1:Params.freqStep1:Params.freqEnd1;
timeWindow = Params.time1;
timeStep   = Params.time2; 
evoked     = Params.evoked;
TW         = Params.freqStart2 / 10;

% Read data
[lfpTrials,fsLfp,trialType,~,trialNum] = ...
        readAndProcessLFPData(Params.datadirectory,Params.commandline{1},   ...
                              Params.trialfile,Params.timeInterval,         ...
                              Params.alphaPlex,Params.electrode1);

% Get all trial types and count nTrials
typelist = unique(trialType);
for iType = 1:length(typelist)
    nTrials(iType) = sum(trialType==typelist(iType));
end

% Handle stimulus locked response
[lfpTrials,trialType] = lfpLockedAndInduced(lfpTrials,trialType,evoked);

% Compute power spectrum, then average power per spectrum
spec = specgramMtm(lfpTrials,fsLfp*1e3,timeWindow,timeStep,freqArray,'pow',TW);
pow  = permute(sum(spec,2),[3,1,2]); % Time x Trial


%%%% DATA OUTPUT %%%%
fid = fopen(['data', suffix],'w');
fprintf(fid,'%s\n',char(Params.commandline{1}));
fprintf(fid,'%s\n',Params.datadirectory);
fprintf(fid,'%s\n',Params.paramsstr);
fprintf(fid,'%s\n',sprintf('%d ',nTrials));
fprintf(fid,'\n');
for iTrial = 1:size(pow,2)
    fprintf(fid,'%u\n',trialType(iTrial));
    fprintf(fid,'%s\n',sprintf('%e ',pow(:,iTrial)));
end
fclose(fid);
