function coupleLFP(suffix)
% Phase Amplitude Coupling LFP
%

    % Import Parameters from temp file
    Params = read_params(suffix);
    pass_band_1 = [Params.freq_start_1, Params.freq_end_1, Params.freq_step_1];
    pass_band_2 = [Params.freq_start_2, Params.freq_end_2, Params.freq_step_2];

    % Read lfp data
    [lfps_1, fs, trial_type] =  ...
            load_lfps(Params.data_directory, Params.command_line,   ...
                      Params.trial_file, Params.time_interval,      ...
                      Params.alpha_plex, Params.electrode_1, pass_band_1);
    lfps_2 = load_lfps(Params.data_directory, Params.command_line,  ...
                       Params.trial_file, Params.time_interval,     ...
                       Params.alpha_plex, Params.electrode_2, pass_band_2);

    % Get all trial types and trial counts for each type.
    type_list = unique(trial_type);
    n_trials = arrayfun(@(x) sum(trial_type == x), type_list);

    % Handle alignment locked response
    if Params.evoked ~= 1
        disp('WARNING: Not using LFPs minus evoked (using other method).');
    end
    trial_type_orig = trial_type;
    [lfps_1, trial_type] = handle_evoked(lfps_1, trial_type_orig,   ...
                                         Params.evoked);
    lfps_2 = handle_evoked(lfps_2, trial_type_orig, Params.evoked);

    % Compute hilbert transforms. Get angle of first lfp and magnitude 
    %   of second lfp.
    phase_1 = angle(hilbert(lfps_1.').');
    mag_2 = abs(hilbert(lfps_1.').');

    %for i_trial = 1:size(lfps_1, 1)
    %    lfp_mag_1 = hilbert(lfps_1(i_trial, :));
    %    lfp_mag_2 = hilbert(lfps_2(i_trial, :));
    %end


    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % Get mean vector length. Signal is defined by the amplitude of the second 
    %   signal and the phase of the first signal.
    signalArray = ampArray .* exp(1i*phaseArray);
    for iType = 1:length(typelist)
        typeMatch = typelist==typelist(iType);
        meanVector(iType) = mean(mean(signalArray(typeMatch,:),2),1);
        meanPower(iType) = mean(mean(ampArray(typeMatch,:),2),1);
    end
    couplingVal = meanVector ./ meanPower;

    % Permutation test
    meanVectorPerm = NaN(length(typelist),100);
    for iPerm = 1:100
        permIdx         = randperm(size(lfpAligned1,1));
        phaseArrayPerm  = phaseArray(permIdx,:);
        signalArrayPerm = ampArray .* exp(1i*phaseArrayPerm);
        for iType = 1:length(typelist)
            typeMatch = typelist==typelist(iType);
            meanVectorPerm(iType,iPerm) = mean(mean(signalArrayPerm(typeMatch,:),2),1);
        end
    end

    for iType = 1:length(typelist)
        couplingValPerm(iType,:) = meanVectorPerm(iType,:) / meanPower(iType);
        pPermTest(iType)         = mean(abs(couplingValPerm(iType,:)) > abs(couplingVal(iType)));
    end


    %%%%%%%%%%%%%%%%
    %  Data Output %
    %%%%%%%%%%%%%%%%

    % Write file
    fid = fopen(['data', suffix],'w');
    fprintf(fid, '%s\n', char(Params.commandline{1}));
    fprintf(fid,'%s\n',Params.datadirectory);
    fprintf(fid,'%s\n',Params.paramsstr);
    fprintf(fid,'%s\n',sprintf('%d ',typelist));
    fprintf(fid,'%s\n',sprintf('%d ',N));
    fprintf(fid,[sprintf('%e ',couplingVal),'\n']);
    fprintf(fid,[sprintf('%e ',pPermTest),'\n']);
    fclose(fid);

end
